/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.data;

import com.jetbrains.nodejs.run.profile.heap.V8CachingReader;
import com.jetbrains.nodejs.run.profile.heap.data.Presentable;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapNodeType;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class Aggregate
implements Externalizable,
Presentable {
    private int myId;
    private long myClassIdx;
    private int myDistance;
    private long mySelfSize;
    private long myRetained;
    private int myCnt;
    private V8HeapNodeType myType;

    public Aggregate() {
    }

    public Aggregate(int id, long classIdx, int distance, long selfSize, V8HeapNodeType type) {
        this.myId = id;
        this.myClassIdx = classIdx;
        this.myDistance = distance;
        this.mySelfSize = selfSize;
        this.myType = type;
        this.myRetained = 0L;
        this.myCnt = 1;
    }

    public int getId() {
        return this.myId;
    }

    public long getClassIdx() {
        return this.myClassIdx;
    }

    public int getDistance() {
        return this.myDistance;
    }

    public long getSelfSize() {
        return this.mySelfSize;
    }

    public V8HeapNodeType getType() {
        return this.myType;
    }

    public void setDistance(int distance) {
        this.myDistance = distance;
    }

    public void addSize(long size) {
        this.mySelfSize += size;
        ++this.myCnt;
    }

    public void addRetained(long size) {
        this.myRetained += size;
    }

    public int getCnt() {
        return this.myCnt;
    }

    public long getRetained() {
        return this.myRetained;
    }

    @Override
    @Nls
    public String getPresentation(@NotNull V8CachingReader reader) {
        if (reader == null) {
            Aggregate.$$$reportNull$$$0(0);
        }
        return Aggregate.getClassNameByClassIdx(reader, this.myClassIdx);
    }

    @Nls
    public static String getClassNameByClassIdx(@NotNull V8CachingReader reader, long classIndex) {
        if (reader == null) {
            Aggregate.$$$reportNull$$$0(1);
        }
        if (classIndex >= 0L) {
            return reader.getString(classIndex);
        }
        return "(" + V8HeapNodeType.getByNumber((int)(-classIndex) - 1).getName() + ")";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.myId);
        out.writeLong(this.myClassIdx);
        out.writeInt(this.myDistance);
        out.writeLong(this.mySelfSize);
        out.writeLong(this.myRetained);
        out.writeInt(this.myCnt);
        out.writeUTF(this.myType.name());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.myId = in.readInt();
        this.myClassIdx = in.readLong();
        this.myDistance = in.readInt();
        this.mySelfSize = in.readLong();
        this.myRetained = in.readLong();
        this.myCnt = in.readInt();
        try {
            this.myType = V8HeapNodeType.valueOf(in.readUTF());
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "reader";
        objectArray2[1] = "com/jetbrains/nodejs/run/profile/heap/data/Aggregate";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getPresentation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getClassNameByClassIdx";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

