/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.googleai;

import dev.langchain4j.Experimental;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.chat.listener.ChatModelErrorContext;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.listener.ChatModelRequest;
import dev.langchain4j.model.chat.listener.ChatModelRequestContext;
import dev.langchain4j.model.chat.listener.ChatModelResponse;
import dev.langchain4j.model.chat.listener.ChatModelResponseContext;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.chat.request.ResponseFormatType;
import dev.langchain4j.model.chat.request.json.JsonEnumSchema;
import dev.langchain4j.model.googleai.FunctionMapper;
import dev.langchain4j.model.googleai.GeminiContent;
import dev.langchain4j.model.googleai.GeminiFunctionCallingConfig;
import dev.langchain4j.model.googleai.GeminiGenerateContentRequest;
import dev.langchain4j.model.googleai.GeminiGenerationConfig;
import dev.langchain4j.model.googleai.GeminiRole;
import dev.langchain4j.model.googleai.GeminiSafetySetting;
import dev.langchain4j.model.googleai.GeminiSchema;
import dev.langchain4j.model.googleai.GeminiService;
import dev.langchain4j.model.googleai.GeminiToolConfig;
import dev.langchain4j.model.googleai.PartsAndContentsMapper;
import dev.langchain4j.model.googleai.SchemaMapper;
import dev.langchain4j.model.output.Response;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
abstract class BaseGeminiChatModel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseGeminiChatModel.class);
    protected final GeminiService geminiService;
    protected final String apiKey;
    protected final String modelName;
    protected final Double temperature;
    protected final Integer topK;
    protected final Double topP;
    protected final Integer maxOutputTokens;
    protected final List<String> stopSequences;
    protected final ResponseFormat responseFormat;
    protected final GeminiFunctionCallingConfig toolConfig;
    protected final boolean allowCodeExecution;
    protected final boolean includeCodeExecutionOutput;
    protected final List<GeminiSafetySetting> safetySettings;
    protected final List<ChatModelListener> listeners;
    protected final Integer maxRetries;

    protected BaseGeminiChatModel(String apiKey, String modelName, Double temperature, Integer topK, Double topP, Integer maxOutputTokens, Duration timeout, ResponseFormat responseFormat, List<String> stopSequences, GeminiFunctionCallingConfig toolConfig, Boolean allowCodeExecution, Boolean includeCodeExecutionOutput, Boolean logRequestsAndResponses, List<GeminiSafetySetting> safetySettings, List<ChatModelListener> listeners, Integer maxRetries) {
        this.apiKey = ValidationUtils.ensureNotBlank(apiKey, "apiKey");
        this.modelName = ValidationUtils.ensureNotBlank(modelName, "modelName");
        this.temperature = temperature;
        this.topK = topK;
        this.topP = topP;
        this.maxOutputTokens = maxOutputTokens;
        this.stopSequences = Utils.getOrDefault(stopSequences, Collections.emptyList());
        this.toolConfig = toolConfig;
        this.allowCodeExecution = Utils.getOrDefault(allowCodeExecution, false);
        this.includeCodeExecutionOutput = Utils.getOrDefault(includeCodeExecutionOutput, false);
        this.safetySettings = Utils.copyIfNotNull(safetySettings);
        this.responseFormat = responseFormat;
        this.listeners = listeners == null ? Collections.emptyList() : new ArrayList<ChatModelListener>(listeners);
        this.maxRetries = Utils.getOrDefault(maxRetries, 3);
        this.geminiService = new GeminiService(Utils.getOrDefault(logRequestsAndResponses, false) != false ? log : null, Utils.getOrDefault(timeout, Duration.ofSeconds(60L)));
    }

    protected GeminiGenerateContentRequest createGenerateContentRequest(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications, ResponseFormat responseFormat, ChatRequestParameters requestParameters) {
        GeminiContent systemInstruction = new GeminiContent(GeminiRole.MODEL.toString());
        List<GeminiContent> geminiContentList = PartsAndContentsMapper.fromMessageToGContent(messages, systemInstruction);
        GeminiSchema schema = null;
        if (responseFormat != null && responseFormat.jsonSchema() != null) {
            schema = SchemaMapper.fromJsonSchemaToGSchema(responseFormat.jsonSchema());
        }
        return GeminiGenerateContentRequest.builder().contents(geminiContentList).systemInstruction(!systemInstruction.getParts().isEmpty() ? systemInstruction : null).generationConfig(GeminiGenerationConfig.builder().candidateCount(1).maxOutputTokens(Utils.getOrDefault(requestParameters.maxOutputTokens(), this.maxOutputTokens)).responseMimeType(BaseGeminiChatModel.computeMimeType(responseFormat)).responseSchema(schema).stopSequences(Utils.getOrDefault(requestParameters.stopSequences(), this.stopSequences)).temperature(Utils.getOrDefault(requestParameters.temperature(), this.temperature)).topK(Utils.getOrDefault(requestParameters.topK(), this.topK)).topP(Utils.getOrDefault(requestParameters.topP(), this.topP)).build()).safetySettings(this.safetySettings).tools(FunctionMapper.fromToolSepcsToGTool(toolSpecifications, this.allowCodeExecution)).toolConfig(new GeminiToolConfig(this.toolConfig)).build();
    }

    protected ChatModelRequest createChatModelRequest(String modelName, List<ChatMessage> messages, List<ToolSpecification> toolSpecifications, ChatRequestParameters requestParameters) {
        return ChatModelRequest.builder().model(Utils.getOrDefault(modelName, this.modelName)).temperature(Utils.getOrDefault(requestParameters.temperature(), this.temperature)).topP(Utils.getOrDefault(requestParameters.topP(), this.topP)).maxTokens(Utils.getOrDefault(requestParameters.maxOutputTokens(), this.maxOutputTokens)).messages(messages).toolSpecifications(toolSpecifications).build();
    }

    protected static String computeMimeType(ResponseFormat responseFormat) {
        if (responseFormat == null || ResponseFormatType.TEXT.equals((Object)responseFormat.type())) {
            return "text/plain";
        }
        if (ResponseFormatType.JSON.equals((Object)responseFormat.type()) && responseFormat.jsonSchema() != null && responseFormat.jsonSchema().rootElement() != null && responseFormat.jsonSchema().rootElement() instanceof JsonEnumSchema) {
            return "text/x.enum";
        }
        return "application/json";
    }

    protected void notifyListenersOnRequest(ChatModelRequestContext context) {
        this.listeners.forEach(listener -> {
            try {
                listener.onRequest(context);
            }
            catch (Exception e) {
                log.warn("Exception while calling model listener (onRequest)", e);
            }
        });
    }

    protected void notifyListenersOnResponse(Response<AiMessage> response, ChatModelRequest request, ConcurrentHashMap<Object, Object> attributes) {
        ChatModelResponse chatModelResponse = ChatModelResponse.builder().model(request.model()).tokenUsage(response.tokenUsage()).finishReason(response.finishReason()).aiMessage(response.content()).build();
        ChatModelResponseContext context = new ChatModelResponseContext(chatModelResponse, request, attributes);
        this.listeners.forEach(listener -> {
            try {
                listener.onResponse(context);
            }
            catch (Exception e) {
                log.warn("Exception while calling model listener (onResponse)", e);
            }
        });
    }

    protected void notifyListenersOnError(Exception exception, ChatModelRequest request, ConcurrentHashMap<Object, Object> attributes) {
        this.listeners.forEach(listener -> {
            try {
                ChatModelErrorContext context = new ChatModelErrorContext(exception, request, null, attributes);
                listener.onError(context);
            }
            catch (Exception e) {
                log.warn("Exception while calling model listener (onError)", e);
            }
        });
    }
}

