/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.googleai;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.langchain4j.model.googleai.GeminiCountTokensRequest;
import dev.langchain4j.model.googleai.GeminiCountTokensResponse;
import dev.langchain4j.model.googleai.GeminiGenerateContentRequest;
import dev.langchain4j.model.googleai.GeminiGenerateContentResponse;
import dev.langchain4j.model.googleai.GoogleAiBatchEmbeddingRequest;
import dev.langchain4j.model.googleai.GoogleAiBatchEmbeddingResponse;
import dev.langchain4j.model.googleai.GoogleAiEmbeddingRequest;
import dev.langchain4j.model.googleai.GoogleAiEmbeddingResponse;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;

class GeminiService {
    private static final String GEMINI_AI_ENDPOINT = "https://generativelanguage.googleapis.com/v1beta";
    private static final String API_KEY_HEADER_NAME = "x-goog-api-key";
    private final HttpClient httpClient;
    private final Gson gson;
    private final Logger logger;

    GeminiService(Logger logger, Duration timeout) {
        this.logger = logger;
        this.gson = new GsonBuilder().setPrettyPrinting().create();
        this.httpClient = HttpClient.newBuilder().connectTimeout(timeout).build();
    }

    GeminiGenerateContentResponse generateContent(String modelName, String apiKey, GeminiGenerateContentRequest request) {
        String url = String.format("%s/models/%s:generateContent", GEMINI_AI_ENDPOINT, modelName);
        return this.sendRequest(url, apiKey, request, GeminiGenerateContentResponse.class);
    }

    GeminiCountTokensResponse countTokens(String modelName, String apiKey, GeminiCountTokensRequest request) {
        String url = String.format("%s/models/%s:countTokens", GEMINI_AI_ENDPOINT, modelName);
        return this.sendRequest(url, apiKey, request, GeminiCountTokensResponse.class);
    }

    GoogleAiEmbeddingResponse embed(String modelName, String apiKey, GoogleAiEmbeddingRequest request) {
        String url = String.format("%s/models/%s:embedContent", GEMINI_AI_ENDPOINT, modelName);
        return this.sendRequest(url, apiKey, request, GoogleAiEmbeddingResponse.class);
    }

    GoogleAiBatchEmbeddingResponse batchEmbed(String modelName, String apiKey, GoogleAiBatchEmbeddingRequest request) {
        String url = String.format("%s/models/%s:batchEmbedContents", GEMINI_AI_ENDPOINT, modelName);
        return this.sendRequest(url, apiKey, request, GoogleAiBatchEmbeddingResponse.class);
    }

    Stream<GeminiGenerateContentResponse> generateContentStream(String modelName, String apiKey, GeminiGenerateContentRequest request) {
        String url = String.format("%s/models/%s:streamGenerateContent?alt=sse", GEMINI_AI_ENDPOINT, modelName);
        return this.streamRequest(url, apiKey, request, GeminiGenerateContentResponse.class);
    }

    private <T> T sendRequest(String url, String apiKey, Object requestBody, Class<T> responseType) {
        String jsonBody = this.gson.toJson(requestBody);
        HttpRequest request = this.buildHttpRequest(url, apiKey, jsonBody);
        this.logRequest(jsonBody);
        try {
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() >= 300) {
                throw new RuntimeException(String.format("HTTP error (%d): %s", response.statusCode(), response.body()));
            }
            this.logResponse(response.body());
            return this.gson.fromJson(response.body(), responseType);
        }
        catch (IOException e) {
            throw new RuntimeException("An error occurred while sending the request", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Sending the request was interrupted", e);
        }
    }

    private <T> Stream<T> streamRequest(String url, String apiKey, Object requestBody, Class<T> responseType) {
        String jsonBody = this.gson.toJson(requestBody);
        HttpRequest httpRequest = this.buildHttpRequest(url, apiKey, jsonBody);
        this.logRequest(jsonBody);
        try {
            HttpResponse<Stream<String>> httpResponse = this.httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofLines());
            if (httpResponse.statusCode() >= 300) {
                String errorBody = httpResponse.body().collect(Collectors.joining("\n"));
                throw new RuntimeException(String.format("HTTP error (%d): %s", httpResponse.statusCode(), errorBody));
            }
            Stream<Object> responseStream = httpResponse.body().filter(line -> line.startsWith("data: ")).map(line -> line.substring(6)).map(jsonString -> this.gson.fromJson((String)jsonString, responseType));
            if (this.logger != null) {
                responseStream = responseStream.peek(response -> this.logger.debug("Partial response from Gemini:\n{}", response));
            }
            return responseStream;
        }
        catch (IOException e) {
            throw new RuntimeException("An error occurred while streaming the request", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Streaming the request was interrupted", e);
        }
    }

    private HttpRequest buildHttpRequest(String url, String apiKey, String jsonBody) {
        return HttpRequest.newBuilder().uri(URI.create(url)).header("Content-Type", "application/json").header("User-Agent", "LangChain4j").header(API_KEY_HEADER_NAME, apiKey).POST(HttpRequest.BodyPublishers.ofString(jsonBody)).build();
    }

    private void logRequest(String jsonBody) {
        if (this.logger != null) {
            this.logger.debug("Sending request to Gemini:\n{}", (Object)jsonBody);
        }
    }

    private void logResponse(String responseBody) {
        if (this.logger != null) {
            this.logger.debug("Response from Gemini:\n{}", (Object)responseBody);
        }
    }
}

