/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java;

import com.intellij.diagnostic.CoreAttachmentFactory;
import com.intellij.ide.structureView.impl.java.PropertyGroup;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.ui.icons.RowIcon;
import com.intellij.uml.java.JavaUmlElementManager;
import com.intellij.uml.java.utils.UmlKotlinUtils;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaProperty
extends LightElement
implements PsiNamedElement {
    @Nullable
    private final PsiMethod myGetter;
    @Nullable
    private final PsiMethod mySetter;
    @Nullable
    private final PsiField myField;
    @NotNull
    @NlsSafe
    private final String myName;
    @NotNull
    private final PsiType myType;
    @NotNull
    private final Icon myIcon;
    @PsiModifier.ModifierConstant
    private static final @NonNls String @NotNull [] ALL_VISIBILITY_MODIFIERS = new String[]{"private", "packageLocal", "protected", "public"};

    private JavaProperty(@NotNull PsiMethod getterElseSetter, @Nullable PsiMethod getter, @Nullable PsiMethod setter, @Nullable PsiField field) {
        if (getterElseSetter == null) {
            JavaProperty.$$$reportNull$$$0(0);
        }
        super(getterElseSetter.getManager(), getterElseSetter.getLanguage());
        this.myGetter = getter;
        this.mySetter = setter;
        this.myField = field;
        this.myName = field != null ? JavaProperty.getPropertyName((PsiMember)field) : JavaProperty.getPropertyName((PsiMember)getterElseSetter);
        this.myType = Objects.requireNonNull(PropertyUtilBase.getPropertyType((PsiMember)getterElseSetter));
        this.myIcon = this.computeIcon();
    }

    @Nullable
    private static PsiField findField(@NotNull PsiMethod getterElseSetter) {
        if (getterElseSetter == null) {
            JavaProperty.$$$reportNull$$$0(1);
        }
        PsiClass owner = getterElseSetter.getContainingClass();
        String name = JavaProperty.getPropertyName((PsiMember)getterElseSetter);
        return owner != null ? PropertyUtilBase.findPropertyField((PsiClass)owner, (String)name, (boolean)getterElseSetter.getModifierList().hasModifierProperty("static")) : null;
    }

    private JavaProperty(@Nullable PsiMethod getter, @Nullable PsiMethod setter) {
        this(Objects.requireNonNullElse(getter, setter), getter, setter, JavaProperty.findField(Objects.requireNonNullElse(getter, setter)));
    }

    private JavaProperty(@Nullable PsiMethod getter, @Nullable PsiMethod setter, @Nullable PsiField field) {
        this(Objects.requireNonNullElse(getter, setter), getter, setter, field);
    }

    private JavaProperty(@NotNull PsiField field) {
        if (field == null) {
            JavaProperty.$$$reportNull$$$0(2);
        }
        super(field.getManager(), field.getLanguage());
        this.myField = field;
        this.mySetter = PropertyUtilBase.findSetterForField((PsiField)field);
        this.myGetter = PropertyUtilBase.findGetterForField((PsiField)field);
        this.myName = JavaProperty.getPropertyName((PsiMember)field);
        this.myType = this.myField.getType();
        this.myIcon = this.computeIcon();
    }

    @NotNull
    private static String getPropertyName(@NotNull PsiMember psiMember) {
        String name;
        if (psiMember == null) {
            JavaProperty.$$$reportNull$$$0(3);
        }
        if ((name = PropertyUtilBase.getPropertyName((PsiMember)psiMember)) == null) {
            Logger.getInstance(JavaProperty.class).error("The method is not getter nor setter", new Attachment[]{CoreAttachmentFactory.createAttachment((VirtualFile)psiMember.getContainingFile().getVirtualFile())});
            name = "ERROR_NAME";
        }
        String string = name;
        if (string == null) {
            JavaProperty.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static List<JavaProperty> getAllPropertiesAmong(PsiMethod @NotNull [] methods, PsiField @NotNull [] fields) {
        if (methods == null) {
            JavaProperty.$$$reportNull$$$0(5);
        }
        if (fields == null) {
            JavaProperty.$$$reportNull$$$0(6);
        }
        Pair accessors = PropertyUtilBase.getAllAccessors((boolean)true, (boolean)true, (boolean)true, (String[])ALL_VISIBILITY_MODIFIERS, (PsiMethod[])methods);
        Map getters = (Map)accessors.getFirst();
        Map setters = (Map)accessors.getSecond();
        HashSet allNames = new HashSet();
        allNames.addAll(getters.keySet());
        allNames.addAll(setters.keySet());
        HashMap<String, PsiField> propertyNameToField = new HashMap<String, PsiField>();
        for (PsiField field : fields) {
            propertyNameToField.put(PropertyUtilBase.suggestPropertyName((PsiField)field), field);
        }
        ArrayList<JavaProperty> properties = new ArrayList<JavaProperty>();
        for (String propertyName : allNames) {
            properties.add(new JavaProperty((PsiMethod)getters.get(propertyName), (PsiMethod)setters.get(propertyName), (PsiField)propertyNameToField.get(propertyName)));
        }
        ArrayList<JavaProperty> arrayList = properties;
        if (arrayList == null) {
            JavaProperty.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Nullable
    public static JavaProperty create(@NotNull PsiMethod accessor) {
        String propertyName;
        PsiClass containingClass;
        if (accessor == null) {
            JavaProperty.$$$reportNull$$$0(8);
        }
        if ((containingClass = accessor.getContainingClass()) != null && (propertyName = PropertyUtilBase.getPropertyName((PsiMethod)accessor)) != null) {
            PsiMethod getter = (PsiMethod)ContainerUtil.getFirstItem((List)PropertyUtilBase.getGetters((PsiClass)containingClass, (String)propertyName, (boolean)true, (String[])ALL_VISIBILITY_MODIFIERS));
            PsiMethod setter = (PsiMethod)ContainerUtil.getFirstItem((List)PropertyUtilBase.getSetters((PsiClass)containingClass, (String)propertyName, (boolean)true, (String[])ALL_VISIBILITY_MODIFIERS));
            if (getter != null || setter != null) {
                return new JavaProperty(getter, setter);
            }
        }
        return null;
    }

    @Nullable
    public static JavaProperty create(@NotNull PsiField field, boolean onlyIfAccessorsPresent) {
        if (field == null) {
            JavaProperty.$$$reportNull$$$0(9);
        }
        if (!onlyIfAccessorsPresent) {
            return new JavaProperty(field);
        }
        PsiMethod getter = PropertyUtilBase.findGetterForField((PsiField)field);
        PsiMethod method = getter != null ? getter : PropertyUtilBase.findSetterForField((PsiField)field);
        return method != null ? JavaProperty.create(method) : null;
    }

    @NotNull
    private Icon computeIcon() {
        boolean doShowStatic;
        PsiMember notNullComponent = this.getNotNullComponent();
        boolean bl = doShowStatic = notNullComponent.hasModifierProperty("static") && !UmlKotlinUtils.isFromKotlin((PsiElement)notNullComponent);
        Icon baseIcon = this.myGetter != null ? (this.mySetter != null ? (doShowStatic ? PropertyGroup.PROPERTY_READ_WRITE_STATIC_ICON : PropertyGroup.PROPERTY_READ_WRITE_ICON) : (doShowStatic ? PropertyGroup.PROPERTY_READ_STATIC_ICON : PropertyGroup.PROPERTY_READ_ICON)) : (this.mySetter != null ? (doShowStatic ? PropertyGroup.PROPERTY_WRITE_STATIC_ICON : PropertyGroup.PROPERTY_WRITE_ICON) : PropertyGroup.PROPERTY_READ_WRITE_ICON);
        com.intellij.ui.RowIcon result = new com.intellij.ui.RowIcon(2);
        result.setIcon(baseIcon, 0);
        JavaUmlElementManager.IconManager.setVisibilityIcon((PsiModifierListOwner)notNullComponent, (RowIcon)result, 1);
        com.intellij.ui.RowIcon rowIcon = result;
        if (rowIcon == null) {
            JavaProperty.$$$reportNull$$$0(10);
        }
        return rowIcon;
    }

    @Nullable
    public PsiMethod getGetterElseSetter() {
        return this.myGetter != null ? this.myGetter : this.mySetter;
    }

    @NotNull
    public PsiMember getNotNullComponent() {
        PsiMember psiMember = (PsiMember)Objects.requireNonNull(this.myGetter != null ? this.myGetter : (this.mySetter != null ? this.mySetter : this.myField));
        if (psiMember == null) {
            JavaProperty.$$$reportNull$$$0(11);
        }
        return psiMember;
    }

    @Nullable
    public PsiMethod getGetter() {
        return this.myGetter;
    }

    @Nullable
    public PsiMethod getSetter() {
        return this.mySetter;
    }

    @Nullable
    public PsiField getField() {
        return this.myField;
    }

    @NlsSafe
    @NotNull
    public String getName() {
        PsiMethod getterElseSetter = this.getGetterElseSetter();
        if (getterElseSetter != null && UmlKotlinUtils.isInternal(getterElseSetter)) {
            String name = StringUtil.substringBefore((String)this.myName, (String)"$");
            assert (name != null);
            String string = name;
            if (string == null) {
                JavaProperty.$$$reportNull$$$0(12);
            }
            return string;
        }
        String string = this.myName;
        if (string == null) {
            JavaProperty.$$$reportNull$$$0(13);
        }
        return string;
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            JavaProperty.$$$reportNull$$$0(14);
        }
        throw new UnsupportedOperationException("setName() is not supported for non-physical elements");
    }

    @NotNull
    public PsiType getType() {
        PsiType psiType = this.myType;
        if (psiType == null) {
            JavaProperty.$$$reportNull$$$0(15);
        }
        return psiType;
    }

    @NotNull
    public Icon getIcon(int flags) {
        Icon icon = this.myIcon;
        if (icon == null) {
            JavaProperty.$$$reportNull$$$0(16);
        }
        return icon;
    }

    public void navigate(boolean requestFocus) {
        this.getNotNullComponent().navigate(requestFocus);
    }

    public boolean canNavigate() {
        return this.getNotNullComponent().canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.getNotNullComponent().canNavigateToSource();
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement psiElement = this.getNotNullComponent().getNavigationElement();
        if (psiElement == null) {
            JavaProperty.$$$reportNull$$$0(17);
        }
        return psiElement;
    }

    public void setNavigationElement(@NotNull PsiElement navigationElement) {
        if (navigationElement == null) {
            JavaProperty.$$$reportNull$$$0(18);
        }
        throw new UnsupportedOperationException("setNsetNavigationElementame() is not supported for non-physical elements");
    }

    public PsiFile getContainingFile() {
        return this.getNotNullComponent().getContainingFile();
    }

    public PsiReference getReference() {
        return this.getNotNullComponent().getReference();
    }

    public PsiReference @NotNull [] getReferences() {
        PsiReference[] psiReferenceArray = this.getNotNullComponent().getReferences();
        if (psiReferenceArray == null) {
            JavaProperty.$$$reportNull$$$0(19);
        }
        return psiReferenceArray;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        JavaProperty property = (JavaProperty)((Object)o);
        if (!Objects.equals(this.myName, property.myName)) {
            return false;
        }
        return Objects.equals(this.myType, property.myType);
    }

    public int hashCode() {
        int result = this.myName.hashCode();
        result = 31 * result + this.myType.hashCode();
        return result;
    }

    public String toString() {
        return "JavaProperty{myName='" + this.myName + "'}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7, 10, 11, 12, 13, 15, 16, 17, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getterElseSetter";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMember";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/java/JavaProperty";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigationElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/java/JavaProperty";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPropertiesAmong";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "computeIcon";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotNullComponent";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findField";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyName";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAllPropertiesAmong";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setNavigationElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 7, 10, 11, 12, 13, 15, 16, 17, 19 -> new IllegalStateException(string);
        };
    }
}

