/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.javascript.debugger.ChromeEvaluator;
import com.intellij.javascript.debugger.SegmentList;
import com.intellij.javascript.debugger.scripts.VmScriptFile;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.xdebugger.XSourcePosition;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateResult;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.VariableViewKt;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.Value;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0011J(\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ \u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010\u0019\u001a\u00020\u000b2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/javascript/debugger/GlobalEvaluator;", "Lcom/intellij/javascript/debugger/ChromeEvaluator;", "viewSupport", "Lorg/jetbrains/debugger/DebuggerViewSupport;", "vmConnection", "Lorg/jetbrains/debugger/connection/VmConnection;", "<init>", "(Lorg/jetbrains/debugger/DebuggerViewSupport;Lorg/jetbrains/debugger/connection/VmConnection;)V", "values", "Lcom/intellij/javascript/debugger/SegmentList$SegmentListWithData;", "Lkotlin/Pair;", "", "Lorg/jetbrains/debugger/values/ObjectValue;", "getValues", "()Lcom/intellij/javascript/debugger/SegmentList$SegmentListWithData;", "valuesDocument", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/openapi/editor/Document;", "isDocumentForEvaluation", "", "document", "printAndStoreValueToInspect", "", "value", "Lorg/jetbrains/debugger/values/Value;", "expression", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "consoleView", "Lcom/intellij/execution/ui/ConsoleView;", "evaluate", "Lorg/jetbrains/concurrency/Promise;", "Lorg/jetbrains/debugger/EvaluateResult;", "expressionPosition", "Lcom/intellij/xdebugger/XSourcePosition;", "intellij.javascript.debugger"})
@SourceDebugExtension(value={"SMAP\nGlobalEvaluator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GlobalEvaluator.kt\ncom/intellij/javascript/debugger/GlobalEvaluator\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n14#2:74\n1#3:75\n*S KotlinDebug\n*F\n+ 1 GlobalEvaluator.kt\ncom/intellij/javascript/debugger/GlobalEvaluator\n*L\n50#1:74\n*E\n"})
public final class GlobalEvaluator
extends ChromeEvaluator {
    @NotNull
    private final DebuggerViewSupport viewSupport;
    @NotNull
    private final VmConnection<?> vmConnection;
    @NotNull
    private final SegmentList.SegmentListWithData<Pair<String, ObjectValue>> values;
    @NotNull
    private final AtomicReference<Document> valuesDocument;

    public GlobalEvaluator(final @NotNull DebuggerViewSupport viewSupport, final @NotNull VmConnection<?> vmConnection) {
        Intrinsics.checkNotNullParameter((Object)viewSupport, (String)"viewSupport");
        Intrinsics.checkNotNullParameter(vmConnection, (String)"vmConnection");
        super(new VariableContext(){

            @Override
            public EvaluateContext getEvaluateContext() {
                Vm vm = vmConnection.getVm();
                Vm vm2 = vm;
                if (vm2 == null || (vm2 = vm2.getEvaluateContext()) == null) {
                    Object object = vm;
                    throw new IllegalStateException("global evaluation context is null, vm " + vm + ", vm class " + (object != null && (object = object.getClass()) != null ? ((Class)object).getName() : null));
                }
                return vm2;
            }

            @Override
            public boolean watchableAsEvaluationExpression() {
                return false;
            }

            @Override
            public DebuggerViewSupport getViewSupport() {
                return viewSupport;
            }

            @Override
            public Vm getVm() {
                return vmConnection.getVm();
            }
        });
        this.viewSupport = viewSupport;
        this.vmConnection = vmConnection;
        this.values = new SegmentList.SegmentListWithData();
        this.valuesDocument = new AtomicReference<Object>(null);
    }

    @NotNull
    public final SegmentList.SegmentListWithData<Pair<String, ObjectValue>> getValues() {
        return this.values;
    }

    public final boolean isDocumentForEvaluation(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        return Intrinsics.areEqual((Object)document, (Object)this.valuesDocument.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void printAndStoreValueToInspect(@NotNull Value value, @Nullable String expression, @NotNull ConsoleViewContentType contentType, @NotNull ConsoleView consoleView) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Intrinsics.checkNotNullParameter((Object)consoleView, (String)"consoleView");
        String valueString = null;
        if (value instanceof ObjectValue) {
            DocumentEx consoleViewDocument;
            valueString = VariableViewKt.getObjectValueDescription((ObjectValue)value);
            LanguageConsoleImpl languageConsoleImpl = consoleView instanceof LanguageConsoleImpl ? (LanguageConsoleImpl)consoleView : null;
            DocumentEx documentEx = languageConsoleImpl != null && (languageConsoleImpl = languageConsoleImpl.getHistoryViewer()) != null ? languageConsoleImpl.getDocument() : (consoleViewDocument = null);
            if (!this.valuesDocument.compareAndSet(null, (Document)consoleViewDocument)) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(GlobalEvaluator.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.assertTrue(Intrinsics.areEqual((Object)this.valuesDocument.get(), (Object)consoleViewDocument));
            }
            SegmentList.SegmentListWithData<Pair<String, ObjectValue>> segmentListWithData = this.values;
            synchronized (segmentListWithData) {
                boolean bl = false;
                int startOffset = consoleView.getContentSize();
                String string = expression;
                if (string == null) {
                    string = valueString;
                }
                this.values.add((Pair<String, ObjectValue>)new Pair((Object)string, (Object)value), startOffset, startOffset + valueString.length());
                Unit unit = Unit.INSTANCE;
            }
        } else {
            String string = value.getValueString();
            Intrinsics.checkNotNull((Object)string);
            valueString = string;
        }
        consoleView.print(valueString, contentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected Promise<EvaluateResult> evaluate(@NotNull String expression, @Nullable XSourcePosition expressionPosition) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        if (expressionPosition != null && expressionPosition.getFile() instanceof LightVirtualFile && !(expressionPosition.getFile() instanceof VmScriptFile)) {
            ObjectValue $i$a$-synchronized-GlobalEvaluator$evaluate$22;
            SegmentList.SegmentListWithData<Pair<String, ObjectValue>> segmentListWithData = this.values;
            synchronized (segmentListWithData) {
                boolean $i$a$-synchronized-GlobalEvaluator$evaluate$22 = false;
                Pair<String, ObjectValue> pair = this.values.getValueByOffset(expressionPosition.getOffset());
                $i$a$-synchronized-GlobalEvaluator$evaluate$22 = pair != null ? (ObjectValue)pair.getSecond() : null;
            }
            ObjectValue objectValue = $i$a$-synchronized-GlobalEvaluator$evaluate$22;
            if (objectValue != null) {
                ObjectValue it = objectValue;
                boolean bl = false;
                return Promises.resolvedPromise((Object)new EvaluateResult((Value)it, false, 2, null));
            }
        }
        return super.evaluate(expression, expressionPosition);
    }
}

