/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.ConfigUrlOverrider;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.DataSourceSessionTemplate;
import com.intellij.database.dataSource.DataSourceSshTunnelConfiguration;
import com.intellij.database.dataSource.DataSourceSslConfiguration;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.SchemaControl;
import com.intellij.database.dataSource.srcStorage.DbSrcModelStorageService;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.properties.Level;
import com.intellij.database.model.serialization.ModelSerializerKt;
import com.intellij.database.run.actions.TxIsolation;
import com.intellij.database.util.InternedJDomReader;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.text.StringKt;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import com.intellij.util.ui.classpath.SimpleClasspathElementFactory;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.copy.HierarchicalStreamCopier;
import com.thoughtworks.xstream.io.xml.CompactWriter;
import com.thoughtworks.xstream.io.xml.JDomWriter;
import com.thoughtworks.xstream.io.xml.XppReader;
import io.github.xstream.mxparser.MXParser;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jdom.Attribute;
import org.jdom.DefaultJDOMFactory;
import org.jdom.Element;
import org.jdom.JDOMFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xmlpull.v1.XmlPullParser;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002QRB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J*\u0010\u0012\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J*\u0010\u0013\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J,\u0010\u0014\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J&\u0010\u0019\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0014\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0016H\u0002J\u001e\u0010\u001c\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002J&\u0010 \u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010#\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020%H\u0002J$\u0010&\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0016H\u0002J,\u0010(\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010*\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020,H\u0002J\u0018\u0010-\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020,H\u0002J$\u0010.\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010/\u001a\u0004\u0018\u00010\u00052\b\u00100\u001a\u0004\u0018\u00010\u0005H\u0007JB\u0010.\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010/\u001a\u0004\u0018\u00010\u00052\b\u00101\u001a\u0004\u0018\u00010\u00052\b\u00102\u001a\u0004\u0018\u00010\u00052\b\u00103\u001a\u0004\u0018\u00010\u00052\b\u00104\u001a\u0004\u0018\u00010\u0005H\u0002J \u00105\u001a\u00020\r2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u00106\u001a\u000207J \u00108\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u00109\u001a\u00020\r2\u0006\u0010:\u001a\u00020\rJ\u0018\u0010;\u001a\u00020<2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rJ \u0010=\u001a\u00020\r2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010>\u001a\u00020\u00052\u0006\u00106\u001a\u000207J\"\u0010?\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010@\u001a\u00020AH\u0007J*\u0010?\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010@\u001a\u00020B2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J*\u0010C\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010@\u001a\u00020B2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J*\u0010D\u001a\u0002072\u0006\u0010\f\u001a\u00020\r2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010E\u001a\u00020B2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J&\u0010F\u001a\b\u0012\u0004\u0012\u00020\"0\u001e2\u0006\u0010E\u001a\u00020B2\u0006\u0010G\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010H\u001a\u00020\t2\u0006\u0010E\u001a\u00020B2\u0006\u0010$\u001a\u00020%H\u0002J\u001e\u0010I\u001a\u00020\t2\u0006\u0010E\u001a\u00020B2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0JH\u0002J\u0010\u0010K\u001a\u00020,2\u0006\u0010@\u001a\u00020BH\u0002J.\u0010L\u001a\u00020\t2\u0006\u0010E\u001a\u00020B2\u0014\u0010M\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050N2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001c\u0010O\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00162\u0006\u0010E\u001a\u00020BH\u0002J\u0012\u0010P\u001a\u00020\u00182\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Lcom/intellij/database/dataSource/LocalDataSourceSerialization;", "", "<init>", "()V", "ELEMENT_NAME", "", "LIBRARIES_ELEMENT_NAME", "LIBRARY_ELEMENT_NAME", "serialize", "", "project", "Lcom/intellij/openapi/project/Project;", "ds", "Lcom/intellij/database/dataSource/LocalDataSource;", "serializer", "Lcom/thoughtworks/xstream/io/HierarchicalStreamWriter;", "mode", "Lcom/intellij/database/dataSource/LocalDataSourceSerialization$SaveMode;", "serializeHeader", "serializeHeaderInner", "serializeAdditionalProperties", "additionalProperties", "", "pathMacroManager", "Lcom/intellij/openapi/components/PathMacroSubstitutor;", "serializeLinkedDataSources", "linkedDataSourceIds", "Lcom/intellij/database/util/ObjectPath;", "serializeBeforeTasks", "beforeTasks", "", "Lcom/intellij/database/dataSource/LocalDataSource$BeforeTask;", "serializeSessionTemplates", "sessionTemplates", "Lcom/intellij/database/dataSource/DataSourceSessionTemplate;", "serializeUrlOverrider", "urlOverrider", "Lcom/intellij/database/dataSource/ConfigUrlOverrider;", "serializeLayoutConfigurations", "configurations", "serializeProperties", "env", "serializeElementInner", "rt", "Lorg/jdom/Element;", "serializeElement", "writeTag", "name", "value", "a1", "v1", "a2", "v2", "copyBySettings", "temporary", "", "copyBySettingsTo", "from", "to", "serializedSettings", "Ljava/lang/StringBuffer;", "createDataSourceFromSettings", "settings", "deserialize", "reader", "Ljava/io/Reader;", "Lcom/thoughtworks/xstream/io/HierarchicalStreamReader;", "deserializeInner", "deserializeHeaderInnerTag", "xmlReader", "deserializeSessionTemplates", "dataSource", "deserializeUrlOverrider", "deserializeBeforeTasks", "", "deserializeElement", "deserializeProperties", "properties", "", "deserializeLayoutConfigurations", "getPathMacroManager", "SaveMode", "NoopSubstitutor", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nLocalDataSourceSerialization.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalDataSourceSerialization.kt\ncom/intellij/database/dataSource/LocalDataSourceSerialization\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,735:1\n1#2:736\n106#3:737\n78#3,22:738\n106#3:760\n78#3,22:761\n*S KotlinDebug\n*F\n+ 1 LocalDataSourceSerialization.kt\ncom/intellij/database/dataSource/LocalDataSourceSerialization\n*L\n348#1:737\n348#1:738,22\n704#1:760\n704#1:761,22\n*E\n"})
public final class LocalDataSourceSerialization {
    @NotNull
    public static final LocalDataSourceSerialization INSTANCE = new LocalDataSourceSerialization();
    @NotNull
    public static final String ELEMENT_NAME = "data-source";
    @NotNull
    private static final String LIBRARIES_ELEMENT_NAME = "libraries";
    @NotNull
    private static final String LIBRARY_ELEMENT_NAME = "library";

    private LocalDataSourceSerialization() {
    }

    @JvmStatic
    public static final void serialize(@Nullable Project project, @NotNull LocalDataSource ds, @NotNull HierarchicalStreamWriter serializer2, @NotNull SaveMode mode) {
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        Intrinsics.checkNotNullParameter((Object)serializer2, (String)"serializer");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        serializer2.startNode(ELEMENT_NAME);
        INSTANCE.serializeHeader(project, ds, serializer2, mode);
        if (mode.includeSchema()) {
            DasModel dasModel = ds.getModel();
            Intrinsics.checkNotNullExpressionValue((Object)dasModel, (String)"getModel(...)");
            ModelSerializerKt.serialize(dasModel, serializer2, ds.getIntrospectionScope());
        }
        serializer2.endNode();
        serializer2.flush();
    }

    private final void serializeHeader(Project project, LocalDataSource ds, HierarchicalStreamWriter serializer2, SaveMode mode) {
        if (mode.includeConfig()) {
            serializer2.addAttribute("source", ds.getSourceName());
        }
        serializer2.addAttribute("name", ds.getName());
        if (mode.includeConfig()) {
            if (ds.isReadOnly()) {
                serializer2.addAttribute("read-only", String.valueOf(ds.isReadOnly()));
            }
            if (!ds.shouldCheckOutdated()) {
                serializer2.addAttribute("check-outdated", String.valueOf(ds.shouldCheckOutdated()));
            }
            if (!ds.shouldTrackNamespaces()) {
                serializer2.addAttribute("track-namespaces", String.valueOf(ds.shouldTrackNamespaces()));
            }
            if (ds.isSingleConnection()) {
                serializer2.addAttribute("single-connection", String.valueOf(ds.isSingleConnection()));
            }
            if (StringUtil.isNotEmpty((String)ds.getGroupName())) {
                serializer2.addAttribute("group", ds.getGroupName());
            }
        }
        serializer2.addAttribute("uuid", ds.getUniqueId());
        if (mode.includeDatabaseInfo()) {
            LocalDataSource.getInfoInner(ds).serializeDatabaseInfo(serializer2);
        }
        this.serializeHeaderInner(ds, project, serializer2, mode);
    }

    private final void serializeHeaderInner(LocalDataSource ds, Project project, HierarchicalStreamWriter serializer2, SaveMode mode) {
        PathMacroSubstitutor pathMacroManager = this.getPathMacroManager(project);
        DatabaseDriver driver = ds.getDatabaseDriver();
        if (mode.includeConfig()) {
            String url;
            String driverClass;
            SchemaControl schemaControl;
            int isolation;
            String driverRef = ds.getDriverRef();
            if (driver != null && !Intrinsics.areEqual((Object)driver.getId(), (Object)ds.getDriverClass()) || driver == null && driverRef != null) {
                DatabaseDriver databaseDriver = driver;
                LocalDataSourceSerialization.writeTag(serializer2, "driver-ref", databaseDriver == null ? driverRef : databaseDriver.getId());
            }
            if (ds.isAutoSynchronize()) {
                LocalDataSourceSerialization.writeTag(serializer2, "synchronize", "true");
            }
            if (ds.isImported()) {
                LocalDataSourceSerialization.writeTag(serializer2, "imported", "true");
            }
            if (ds.isConfiguredByUrl()) {
                LocalDataSourceSerialization.writeTag(serializer2, "configured-by-url", "true");
            }
            if (!StringUtil.isEmpty((String)ds.getComment())) {
                LocalDataSourceSerialization.writeTag(serializer2, "remarks", ds.getComment());
            }
            if (!ds.isAutoCommit()) {
                LocalDataSourceSerialization.writeTag(serializer2, "auto-commit", "false");
            }
            if ((isolation = ds.getTxIsolation()) != TxIsolation.DEFAULT.getIsolation()) {
                LocalDataSourceSerialization.writeTag(serializer2, "isolation", String.valueOf(isolation));
            }
            if ((schemaControl = ds.getSchemaControlOrtNull()) != null && schemaControl != DatabaseDriver.OPTION_SCHEMA_CONTROL.get(driver)) {
                LocalDataSourceSerialization.writeTag(serializer2, "schema-control", schemaControl.name());
            }
            if (!ds.isRewriteBounds()) {
                LocalDataSourceSerialization.writeTag(serializer2, "rewrite-bounds", "false");
            }
            if (StringUtil.isNotEmpty((String)(driverClass = ds.getDriverClass()))) {
                LocalDataSourceSerialization.writeTag(serializer2, "jdbc-driver", driverClass);
            }
            if (StringUtil.isNotEmpty((String)(url = ds.getUrl()))) {
                LocalDataSourceSerialization.writeTag(serializer2, "jdbc-url", pathMacroManager.collapsePathsRecursively(url));
            }
            LinkedHashMap<String, String> additionalProperties = new LinkedHashMap<String, String>(LocalDataSource.getAdditionalPropertiesMap(ds));
            additionalProperties.remove("user");
            additionalProperties.remove("storage");
            this.serializeAdditionalProperties(serializer2, (Map<String, String>)additionalProperties, pathMacroManager);
        }
        if (mode.includeLocalConfig()) {
            DBIntrospectionOptions.SourceLoading sourceLoading;
            Level introspectionLevel;
            Couple<String> fakeCurrentSchema;
            LocalDataSourceSerialization.writeTag(serializer2, "secret-storage", ds.getPasswordStorage().serialize());
            String string = ds.getAuthProviderId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAuthProviderId(...)");
            String authProviderId = string;
            if (authProviderId != "user-pass") {
                LocalDataSourceSerialization.writeTag(serializer2, "auth-provider", authProviderId);
            }
            String string2 = ds.getUsername();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUsername(...)");
            String username = string2;
            if (StringUtil.isNotEmpty((String)username)) {
                LocalDataSourceSerialization.writeTag(serializer2, "user-name", username);
            }
            if ((fakeCurrentSchema = ds.getFakeCurrentSchema()) != null) {
                this.writeTag(serializer2, "fake-current-schema", "db", (String)fakeCurrentSchema.first, "sc", (String)fakeCurrentSchema.second);
            }
            LocalDataSourceSerialization $this$serializeHeaderInner_u24lambda_u240 = this;
            boolean bl = false;
            serializer2.startNode("schema-mapping");
            ds.getSchemaMapping().serialize(serializer2);
            serializer2.endNode();
            Map<ObjectPath, String> map = ds.getLinkedDataSourceIds();
            Intrinsics.checkNotNullExpressionValue(map, (String)"getLinkedDataSourceIds(...)");
            this.serializeLinkedDataSources(serializer2, map);
            String objectPattern = ds.getObjectPattern();
            if (StringUtil.isNotEmpty((String)objectPattern)) {
                LocalDataSourceSerialization.writeTag(serializer2, "table-pattern", objectPattern);
            }
            if (ds.useJdbcIntrospector()) {
                LocalDataSourceSerialization.writeTag(serializer2, "legacy-introspector", "true");
            }
            if ((introspectionLevel = ds.getIntrospectionLevel()) != null) {
                LocalDataSourceSerialization.writeTag(serializer2, "introspection-level", String.valueOf(introspectionLevel.level));
            }
            if ((sourceLoading = ds.getSourceLoadingOrNull()) != null && sourceLoading != DatabaseDriver.OPTION_SOURCE_LOADING.get(driver)) {
                LocalDataSourceSerialization.writeTag(serializer2, "load-sources", StringUtil.toLowerCase((String)sourceLoading.name()));
            }
            String string3 = ds.getIntrospectorSessionId();
            if (string3 != null) {
                String it = string3;
                boolean bl2 = false;
                LocalDataSourceSerialization.writeTag(serializer2, "introspector-session-template", it);
            }
            List<LocalDataSource.BeforeTask> list = ds.getBeforeTasks();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getBeforeTasks(...)");
            this.serializeBeforeTasks(serializer2, list);
            List<DataSourceSessionTemplate> list2 = ds.getSessionTemplates();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getSessionTemplates(...)");
            this.serializeSessionTemplates(serializer2, list2, pathMacroManager);
        }
        if (mode.includeConfig()) {
            String codeStyleName;
            String timeZone;
            CharSequence valueAtt;
            int autoCloseTimeout;
            int keepAliveTimeout;
            String initScript;
            String workingDir;
            String vmOptions = ds.getVmOptions();
            if (StringUtil.isNotEmpty((String)vmOptions)) {
                LocalDataSourceSerialization.writeTag(serializer2, "vm-options", pathMacroManager.collapsePath(vmOptions));
            }
            if ((workingDir = ds.getWorkingDir()) != null) {
                LocalDataSourceSerialization.writeTag(serializer2, "working-dir", pathMacroManager.collapsePath(workingDir));
            }
            Map<String, String> map = ds.getVmEnv();
            Intrinsics.checkNotNullExpressionValue(map, (String)"getVmEnv(...)");
            Map<String, String> vmEnv = map;
            if (!vmEnv.isEmpty()) {
                serializer2.startNode("vm-env");
                this.serializeProperties(serializer2, vmEnv, pathMacroManager);
                serializer2.endNode();
            }
            Map<String, String> map2 = ds.getDriverProperties();
            Intrinsics.checkNotNullExpressionValue(map2, (String)"getDriverProperties(...)");
            Map<String, String> driverProperties = map2;
            if (!driverProperties.isEmpty()) {
                serializer2.startNode("driver-properties");
                this.serializeProperties(serializer2, driverProperties, pathMacroManager);
                serializer2.endNode();
            }
            if (StringUtil.isNotEmpty((String)(initScript = ds.getInitScript()))) {
                LocalDataSourceSerialization.writeTag(serializer2, "init-script", initScript);
            }
            boolean customKATimeout = (keepAliveTimeout = ds.getKeepAliveTimeout()) != 60;
            boolean keepAlive = ds.isKeepAlive();
            if (keepAlive || customKATimeout) {
                String enabledAtt = keepAlive ? "enable" : null;
                String valueAtt2 = customKATimeout ? "timeout" : null;
                this.writeTag(serializer2, "keep-alive", enabledAtt, String.valueOf(keepAlive), valueAtt2, String.valueOf(keepAliveTimeout));
            }
            boolean customACTimeout = (autoCloseTimeout = ds.getAutoCloseTimeout()) != 300;
            boolean autoClose = ds.isAutoClose();
            if (autoClose || customACTimeout) {
                String enabledAtt = autoClose ? "enable" : null;
                valueAtt = customACTimeout ? "timeout" : null;
                this.writeTag(serializer2, "auto-close", enabledAtt, String.valueOf(autoClose), (String)valueAtt, String.valueOf(autoCloseTimeout));
            }
            if (!((valueAtt = (CharSequence)(timeZone = ds.getTimeZone())) == null || StringsKt.isBlank((CharSequence)valueAtt))) {
                LocalDataSourceSerialization.writeTag(serializer2, "time-zone", timeZone);
            }
            if (StringUtil.isNotEmpty((String)(codeStyleName = ds.getCodeStyleName())) && !Intrinsics.areEqual((Object)"Default", (Object)codeStyleName)) {
                LocalDataSourceSerialization.writeTag(serializer2, "code-style-scheme-name", codeStyleName);
            }
            Map<String, String> map3 = ds.getLayoutConfigurations();
            Intrinsics.checkNotNullExpressionValue(map3, (String)"getLayoutConfigurations(...)");
            Map<String, String> layoutConfigurations = map3;
            if (!layoutConfigurations.isEmpty()) {
                this.serializeLayoutConfigurations(serializer2, layoutConfigurations);
            }
            List<SimpleClasspathElement> list = ds.getOwnClasspath();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getOwnClasspath(...)");
            List<SimpleClasspathElement> classpathElements = list;
            if (!((Collection)classpathElements).isEmpty()) {
                serializer2.startNode(LIBRARIES_ELEMENT_NAME);
                for (SimpleClasspathElement classpathElement : classpathElements) {
                    Element element = new Element(LIBRARY_ELEMENT_NAME);
                    try {
                        classpathElement.serialize(element);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    pathMacroManager.collapsePaths(element);
                    new HierarchicalStreamCopier().copy((HierarchicalStreamReader)new InternedJDomReader(element), serializer2);
                }
                serializer2.endNode();
            }
        }
        if (mode.includeLocalConfig()) {
            DataSourceSslConfiguration sslCfg;
            DataSourceSshTunnelConfiguration sshConfiguration = ds.getSshConfiguration();
            if (sshConfiguration != null && !sshConfiguration.isEmpty()) {
                sshConfiguration.serialize(project, serializer2);
            }
            if ((sslCfg = ds.getSslCfg()) != null && !sslCfg.isEmpty()) {
                sslCfg.serialize(serializer2);
            }
        }
    }

    private final void serializeAdditionalProperties(HierarchicalStreamWriter serializer2, Map<String, String> additionalProperties, PathMacroSubstitutor pathMacroManager) {
        if (!additionalProperties.isEmpty()) {
            serializer2.startNode("jdbc-additional-properties");
            this.serializeProperties(serializer2, additionalProperties, pathMacroManager);
            serializer2.endNode();
        }
    }

    private final void serializeLinkedDataSources(HierarchicalStreamWriter serializer2, Map<ObjectPath, String> linkedDataSourceIds) {
        if (!linkedDataSourceIds.isEmpty()) {
            serializer2.startNode("linked-data-sources");
            for (Map.Entry<ObjectPath, String> entry : linkedDataSourceIds.entrySet()) {
                String linkedId;
                ObjectPath path = entry.getKey();
                String value = entry.getValue();
                if (value == null) continue;
                serializer2.startNode("linked-data-source");
                serializer2.addAttribute("path", path.serialize());
                serializer2.addAttribute("linked-id", linkedId);
                serializer2.endNode();
            }
            serializer2.endNode();
        }
    }

    private final void serializeBeforeTasks(HierarchicalStreamWriter serializer2, List<? extends LocalDataSource.BeforeTask> beforeTasks) {
        if (beforeTasks.isEmpty()) {
            return;
        }
        serializer2.startNode("before");
        for (LocalDataSource.BeforeTask beforeTask : beforeTasks) {
            serializer2.startNode("task");
            serializer2.addAttribute("id", beforeTask.providerId);
            Element element = beforeTask.serialized;
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"serialized");
            this.serializeElementInner(serializer2, element);
            serializer2.endNode();
        }
        serializer2.endNode();
    }

    private final void serializeSessionTemplates(HierarchicalStreamWriter serializer2, List<? extends DataSourceSessionTemplate> sessionTemplates, PathMacroSubstitutor pathMacroManager) {
        if (sessionTemplates.isEmpty()) {
            return;
        }
        serializer2.startNode("session-templates");
        for (DataSourceSessionTemplate dataSourceSessionTemplate : sessionTemplates) {
            String string;
            serializer2.startNode("template");
            serializer2.addAttribute("id", dataSourceSessionTemplate.getTemplateId());
            serializer2.addAttribute("name", dataSourceSessionTemplate.getTemplateName());
            Boolean bl = dataSourceSessionTemplate.getReadonlyOverride();
            if (bl != null) {
                boolean it = bl;
                boolean bl2 = false;
                serializer2.addAttribute("read-only", String.valueOf(it));
            }
            ConfigUrlOverrider configUrlOverrider = dataSourceSessionTemplate.getUrlOverrider();
            Object it = configUrlOverrider;
            boolean bl3 = false;
            if ((((ConfigUrlOverrider)it).isOverriden() ? configUrlOverrider : null) != null) {
                ConfigUrlOverrider urlOverrider;
                urlOverrider = urlOverrider;
                boolean bl4 = false;
                INSTANCE.serializeUrlOverrider(serializer2, urlOverrider);
            }
            String string2 = dataSourceSessionTemplate.getAuthProviderIdOverride();
            if (string2 != null) {
                it = string2;
                boolean bl5 = false;
                serializer2.addAttribute("auth-provider", (String)it);
            }
            if ((string = dataSourceSessionTemplate.getInitScript()) != null) {
                String string3;
                String it2 = string3 = string;
                boolean bl6 = false;
                string = !Intrinsics.areEqual((Object)it2, (Object)dataSourceSessionTemplate.getDataSource().getInitScript()) ? string3 : null;
                if (string != null) {
                    String it3 = string;
                    boolean bl7 = false;
                    LocalDataSourceSerialization.writeTag(serializer2, "init-script", it3);
                }
            }
            Map<String, String> map = dataSourceSessionTemplate.myAdditionalProperties;
            Intrinsics.checkNotNullExpressionValue(map, (String)"myAdditionalProperties");
            this.serializeAdditionalProperties(serializer2, map, pathMacroManager);
            serializer2.endNode();
        }
        serializer2.endNode();
    }

    private final void serializeUrlOverrider(HierarchicalStreamWriter serializer2, ConfigUrlOverrider urlOverrider) {
        serializer2.startNode("url");
        for (Map.Entry<String, String> entry : urlOverrider.getParams()) {
            String n = entry.getKey();
            String v = entry.getValue();
            serializer2.startNode("param");
            serializer2.addAttribute("name", n);
            serializer2.addAttribute("value", v);
            serializer2.endNode();
        }
        serializer2.endNode();
    }

    private final void serializeLayoutConfigurations(HierarchicalStreamWriter serializer2, Map<String, String> configurations) {
        serializer2.startNode("layout-configurations");
        for (Map.Entry<String, String> entry : configurations.entrySet()) {
            String[] lines;
            String key2 = entry.getKey();
            String value = entry.getValue();
            serializer2.startNode("namespace");
            serializer2.addAttribute("name", key2);
            Intrinsics.checkNotNullExpressionValue((Object)StringUtil.splitByLines((String)value), (String)"splitByLines(...)");
            for (String line : lines) {
                String s;
                Intrinsics.checkNotNull((Object)line);
                String $this$trim$iv = line;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = $this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                if (((CharSequence)(s = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString())).length() == 0) continue;
                LocalDataSourceSerialization.writeTag(serializer2, "line", s);
            }
            serializer2.endNode();
        }
        serializer2.endNode();
    }

    private final void serializeProperties(HierarchicalStreamWriter serializer2, Map<String, String> env, PathMacroSubstitutor pathMacroManager) {
        for (Map.Entry<String, String> e : env.entrySet()) {
            String value = pathMacroManager.collapsePathsRecursively(e.getValue());
            this.writeTag(serializer2, "property", "name", e.getKey(), "value", value);
        }
    }

    private final void serializeElementInner(HierarchicalStreamWriter serializer2, Element rt) {
        for (Attribute attribute : rt.getAttributes()) {
            serializer2.addAttribute(attribute.getName(), attribute.getValue());
        }
        for (Element child : rt.getChildren()) {
            Intrinsics.checkNotNull((Object)child);
            this.serializeElement(serializer2, child);
        }
    }

    private final void serializeElement(HierarchicalStreamWriter serializer2, Element rt) {
        serializer2.startNode(rt.getName());
        this.serializeElementInner(serializer2, rt);
        serializer2.endNode();
    }

    @JvmStatic
    public static final void writeTag(@NotNull HierarchicalStreamWriter serializer2, @Nullable String name2, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)serializer2, (String)"serializer");
        if (StringUtil.isEmpty((String)value)) {
            return;
        }
        serializer2.startNode(name2);
        serializer2.setValue(value);
        serializer2.endNode();
    }

    private final void writeTag(HierarchicalStreamWriter serializer2, String name2, String a1, String v1, String a2, String v2) {
        serializer2.startNode(name2);
        if (a1 != null && StringUtil.isNotEmpty((String)v1)) {
            serializer2.addAttribute(a1, v1);
        }
        if (a2 != null && StringUtil.isNotEmpty((String)v2)) {
            serializer2.addAttribute(a2, v2);
        }
        serializer2.endNode();
    }

    @NotNull
    public final LocalDataSource copyBySettings(@Nullable Project project, @NotNull LocalDataSource ds, boolean temporary) {
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        String string = this.serializedSettings(project, ds).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return this.createDataSourceFromSettings(project, string, temporary);
    }

    public final void copyBySettingsTo(@Nullable Project project, @NotNull LocalDataSource from, @NotNull LocalDataSource to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Element root = new Element("settings");
        LocalDataSourceSerialization.serialize(project, from, (HierarchicalStreamWriter)new JDomWriter(root), SaveMode.WITHOUT_SCHEMA);
        InternedJDomReader reader = new InternedJDomReader(root);
        reader.moveDown();
        LocalDataSourceSerialization.deserialize(project, to, (HierarchicalStreamReader)reader, SaveMode.ALL);
    }

    @NotNull
    public final StringBuffer serializedSettings(@Nullable Project project, @NotNull LocalDataSource ds) {
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        StringWriter writer = new StringWriter();
        CompactWriter serializer2 = new CompactWriter((Writer)writer);
        LocalDataSourceSerialization.serialize(project, ds, (HierarchicalStreamWriter)serializer2, SaveMode.WITHOUT_SCHEMA);
        serializer2.close();
        StringBuffer stringBuffer = writer.getBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)stringBuffer, (String)"getBuffer(...)");
        return stringBuffer;
    }

    @NotNull
    public final LocalDataSource createDataSourceFromSettings(@Nullable Project project, @NotNull String settings, boolean temporary) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        LocalDataSource clone = new LocalDataSource();
        LocalDataSourceSerialization.deserialize(project, clone, new StringReader(settings));
        if (temporary) {
            clone.myTemporary = true;
        } else {
            clone.setUniqueId(null);
        }
        return clone;
    }

    @JvmStatic
    public static final void deserialize(@Nullable Project project, @NotNull LocalDataSource ds, @NotNull Reader reader) {
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        XppReader xppReader = new XppReader(reader, (XmlPullParser)new MXParser());
        LocalDataSourceSerialization.deserialize(project, ds, (HierarchicalStreamReader)xppReader, SaveMode.ALL);
    }

    @JvmStatic
    public static final void deserialize(@Nullable Project project, @NotNull LocalDataSource ds, @NotNull HierarchicalStreamReader reader, @NotNull SaveMode mode) {
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        if (mode.includeConfig()) {
            ds.setDriverClass(null);
            ds.setWorkingDir(null);
        }
        INSTANCE.deserializeInner(project, ds, reader, mode);
    }

    private final void deserializeInner(Project project, LocalDataSource ds, HierarchicalStreamReader reader, SaveMode mode) {
        if (Intrinsics.areEqual((Object)reader.getNodeName(), (Object)ELEMENT_NAME) || mode == SaveMode.ALL && Intrinsics.areEqual((Object)"dataSource", (Object)reader.getNodeName())) {
            String string = reader.getAttribute("name");
            if (string == null) {
                string = "";
            }
            String newName = string;
            String newGroupName = StringKt.nullize((String)reader.getAttribute("group"), (boolean)true);
            String newUniqueId = StringKt.nullize((String)reader.getAttribute("uuid"), (boolean)true);
            ds.modify(() -> LocalDataSourceSerialization.deserializeInner$lambda$9(ds, newName, mode, reader, newGroupName, newUniqueId));
            BasicModModel model = null;
            if (mode.includeDatabaseInfo()) {
                LocalDataSource.getInfoInner(ds).deserializeDatabaseInfo(reader, true);
            }
            while (reader.hasMoreChildren()) {
                boolean ok;
                reader.moveDown();
                String nodeName = reader.getNodeName();
                boolean bl = ok = mode.includeDatabaseInfo() && LocalDataSource.getInfoInner(ds).deserializeDatabaseInfo(reader);
                if (!ok) {
                    ok = this.deserializeHeaderInnerTag(ds, project, reader, mode);
                }
                if (!ok && mode.includeSchema() && Intrinsics.areEqual((Object)nodeName, (Object)"database-model")) {
                    ModelFactory modelFactory = DbSrcModelStorageService.getInstance().createFactory(project, ds.getUniqueId());
                    Intrinsics.checkNotNullExpressionValue((Object)modelFactory, (String)"createFactory(...)");
                    model = ModelSerializerKt.deserialize(reader, modelFactory, ds.getName());
                }
                reader.moveUp();
            }
            if (mode.includeSchema() && model != null) {
                ds.setModel(model);
            }
        }
        String url = ds.getUrl();
        if (Intrinsics.areEqual((Object)ds.getDriverRef(), (Object)"sqlserver.jtds") && url != null && StringsKt.contains$default((CharSequence)url, (CharSequence)"<pipe name>", (boolean)false, (int)2, null)) {
            ds.setDriverRef("sqlserver.localdb.jtds");
        }
    }

    private final boolean deserializeHeaderInnerTag(LocalDataSource ds, Project project, HierarchicalStreamReader xmlReader, SaveMode mode) {
        String nodeName;
        if (!mode.includeConfig() && !mode.includeLocalConfig()) {
            return false;
        }
        if (project != null && project.isDisposed()) {
            throw new ProcessCanceledException();
        }
        PathMacroSubstitutor pathMacroManager = this.getPathMacroManager(project);
        DataSourceSchemaMapping dataSourceSchemaMapping = ds.getSchemaMapping();
        Intrinsics.checkNotNullExpressionValue((Object)dataSourceSchemaMapping, (String)"getSchemaMapping(...)");
        DataSourceSchemaMapping schemaMapping = dataSourceSchemaMapping;
        String string = xmlReader.getNodeName();
        if (string == null) {
            return false;
        }
        switch (nodeName = string) {
            case "libraries": {
                ds.setClasspathElements(null);
                while (xmlReader.hasMoreChildren()) {
                    xmlReader.moveDown();
                    if (Intrinsics.areEqual((Object)LIBRARY_ELEMENT_NAME, (Object)xmlReader.getNodeName())) {
                        JDomWriter writer = new JDomWriter((JDOMFactory)new DefaultJDOMFactory());
                        new HierarchicalStreamCopier().copy(xmlReader, (HierarchicalStreamWriter)writer);
                        List list = writer.getTopLevelNodes();
                        Object object = list != null ? CollectionsKt.first((List)list) : null;
                        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jdom.Element");
                        Element element = (Element)object;
                        pathMacroManager.expandPaths(element);
                        ds.addClasspathElements(SimpleClasspathElementFactory.createElements((Project)project, (Element)element));
                    }
                    xmlReader.moveUp();
                }
                Object object = Unit.INSTANCE;
                break;
            }
            case "explain-plan-config": {
                Object object = Unit.INSTANCE;
                break;
            }
            case "driver-ref": {
                ds.setDriverRef(xmlReader.getValue());
                Object object = Unit.INSTANCE;
                break;
            }
            case "synchronize": {
                ds.setAutoSynchronize(Boolean.parseBoolean(xmlReader.getValue()));
                Object object = Unit.INSTANCE;
                break;
            }
            case "imported": {
                ds.setImported(Boolean.parseBoolean(xmlReader.getValue()));
                Object object = Unit.INSTANCE;
                break;
            }
            case "configured-by-url": {
                ds.setConfiguredByUrl(Boolean.parseBoolean(xmlReader.getValue()));
                Object object = Unit.INSTANCE;
                break;
            }
            case "remarks": {
                ds.setComment(xmlReader.getValue());
                Object object = Unit.INSTANCE;
                break;
            }
            case "auto-commit": {
                ds.setAutoCommit(Boolean.parseBoolean(xmlReader.getValue()));
                Object object = Unit.INSTANCE;
                break;
            }
            case "isolation": {
                String string2 = xmlReader.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
                ds.setTxIsolation(Integer.parseInt(string2));
                Object object = Unit.INSTANCE;
                break;
            }
            case "schema-control": {
                String string3 = xmlReader.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getValue(...)");
                ds.setSchemaControl(SchemaControl.valueOf(string3));
                Object object = Unit.INSTANCE;
                break;
            }
            case "rewrite-bounds": {
                ds.setRewriteBounds(Boolean.parseBoolean(xmlReader.getValue()));
                Object object = Unit.INSTANCE;
                break;
            }
            case "auth-required": {
                ds.setAuthProviderId("no-auth");
                Object object = Unit.INSTANCE;
                break;
            }
            case "domain-auth": {
                ds.setAuthProviderId("ms-sso");
                Object object = Unit.INSTANCE;
                break;
            }
            case "auth-provider": {
                ds.setAuthProviderId(xmlReader.getValue());
                Object object = Unit.INSTANCE;
                break;
            }
            case "first-sync": {
                Object object = Unit.INSTANCE;
                break;
            }
            case "jdbc-driver": {
                ds.setDriverClass(xmlReader.getValue());
                Object object = Unit.INSTANCE;
                break;
            }
            case "jdbc-url": {
                ds.setUrl(pathMacroManager.expandPath(xmlReader.getValue()));
                Object object = Unit.INSTANCE;
                break;
            }
            case "jdbc-additional-properties": {
                Map<String, String> map = LocalDataSource.getAdditionalPropertiesMap(ds);
                Intrinsics.checkNotNullExpressionValue(map, (String)"getAdditionalPropertiesMap(...)");
                this.deserializeProperties(xmlReader, map, pathMacroManager);
                Object object = Unit.INSTANCE;
                break;
            }
            case "secret-storage": {
                ds.setPasswordStorage(LocalDataSource.Storage.deserialize(xmlReader.getValue()));
                Object object = Unit.INSTANCE;
                break;
            }
            case "user-name": {
                ds.setUsername(xmlReader.getValue());
                Object object = Unit.INSTANCE;
                break;
            }
            case "schema-pattern": {
                ds.getSchemaMapping().setIntrospectionScope(TreePatternUtils.patternFromPattern(ds.getDbms(), xmlReader.getValue()));
                Object object = Unit.INSTANCE;
                break;
            }
            case "default-schemas": {
                Object object = Unit.INSTANCE;
                break;
            }
            case "introspection-scope": {
                schemaMapping.setIntrospectionScope(TreePatternUtils.importPattern(ds.getDbms(), xmlReader.getValue()));
                Object object = Unit.INSTANCE;
                break;
            }
            case "resolve-scope": {
                Object object = Unit.INSTANCE;
                break;
            }
            case "introspection-schemas": {
                schemaMapping.setIntrospectionScope(TreePatternUtils.importPattern(ds.getDbms(), xmlReader.getValue()));
                Object object = Unit.INSTANCE;
                break;
            }
            case "schema-mapping": {
                schemaMapping.deserialize(xmlReader);
                Object object = Unit.INSTANCE;
                break;
            }
            case "unqualified-resolve-schemas": {
                Object object = Unit.INSTANCE;
                break;
            }
            case "fake-current-schema": {
                ds.setFakeCurrentSchema((Couple<String>)Couple.of((Object)xmlReader.getAttribute("db"), (Object)xmlReader.getAttribute("sc")));
                Object object = Unit.INSTANCE;
                break;
            }
            case "table-pattern": {
                ds.setObjectPattern(xmlReader.getValue());
                Object object = Unit.INSTANCE;
                break;
            }
            case "legacy-introspector": {
                ds.setUseJdbcIntrospector(Intrinsics.areEqual((Object)"true", (Object)xmlReader.getValue()));
                Object object = Unit.INSTANCE;
                break;
            }
            case "introspection-level": {
                ds.setIntrospectionLevel(Level.of(xmlReader.getValue()));
                Object object = Unit.INSTANCE;
                break;
            }
            case "load-sources": {
                String string4 = StringUtil.toUpperCase((String)xmlReader.getValue());
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toUpperCase(...)");
                ds.setSourceLoading(DBIntrospectionOptions.SourceLoading.valueOf(string4));
                Object object = Unit.INSTANCE;
                break;
            }
            case "introspector-session-template": {
                ds.setIntrospectorSessionId(xmlReader.getValue());
                Object object = Unit.INSTANCE;
                break;
            }
            case "before": {
                List<LocalDataSource.BeforeTask> element;
                List<LocalDataSource.BeforeTask> $this$deserializeHeaderInnerTag_u24lambda_u2410 = element = ds.getBeforeTasks();
                boolean bl = false;
                $this$deserializeHeaderInnerTag_u24lambda_u2410.clear();
                Intrinsics.checkNotNull($this$deserializeHeaderInnerTag_u24lambda_u2410);
                INSTANCE.deserializeBeforeTasks(xmlReader, $this$deserializeHeaderInnerTag_u24lambda_u2410);
                List<LocalDataSource.BeforeTask> list = element;
                Object object = list;
                Intrinsics.checkNotNullExpressionValue(list, (String)"apply(...)");
                break;
            }
            case "session-templates": {
                ds.setSessionTemplates(this.deserializeSessionTemplates(xmlReader, ds, pathMacroManager));
                Object object = Unit.INSTANCE;
                break;
            }
            case "default-dialect": {
                Object object = Unit.INSTANCE;
                break;
            }
            case "linked-data-sources": {
                Map<ObjectPath, String> map = ds.getLinkedDataSourceIds();
                Intrinsics.checkNotNullExpressionValue(map, (String)"getLinkedDataSourceIds(...)");
                Map<ObjectPath, String> linkedDataSourceIds = map;
                linkedDataSourceIds.clear();
                while (xmlReader.hasMoreChildren()) {
                    xmlReader.moveDown();
                    if (Intrinsics.areEqual((Object)"linked-data-source", (Object)xmlReader.getNodeName())) {
                        String path = xmlReader.getAttribute("path");
                        String linkedId = xmlReader.getAttribute("linked-id");
                        if (path != null && linkedId != null) {
                            linkedDataSourceIds.put(ObjectPath.deserialize(path), linkedId);
                        }
                    }
                    xmlReader.moveUp();
                }
                Object object = Unit.INSTANCE;
                break;
            }
            case "vm-options": {
                ds.setVmOptions(pathMacroManager.expandPath(xmlReader.getValue()));
                Object object = Unit.INSTANCE;
                break;
            }
            case "working-dir": {
                ds.setWorkingDir(pathMacroManager.expandPath(xmlReader.getValue()));
                Object object = Unit.INSTANCE;
                break;
            }
            case "init-script": {
                ds.setInitScript(xmlReader.getValue());
                Object object = Unit.INSTANCE;
                break;
            }
            case "keep-alive": {
                ds.setKeepAlive(Boolean.parseBoolean(xmlReader.getAttribute("enable")));
                ds.setKeepAliveTimeout(StringUtil.parseInt((String)xmlReader.getAttribute("timeout"), (int)60));
                Object object = Unit.INSTANCE;
                break;
            }
            case "time-zone": {
                ds.setTimeZone(xmlReader.getValue());
                Object object = Unit.INSTANCE;
                break;
            }
            case "auto-close": {
                Boolean bl = Boolean.valueOf(xmlReader.getAttribute("enable"));
                Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"valueOf(...)");
                ds.setAutoClose(bl);
                ds.setAutoCloseTimeout(StringUtil.parseInt((String)xmlReader.getAttribute("timeout"), (int)300));
                Object object = Unit.INSTANCE;
                break;
            }
            case "code-style-scheme-name": {
                ds.setCodeStyleName(xmlReader.getValue());
                Object object = Unit.INSTANCE;
                break;
            }
            case "layout-configurations": {
                ds.setLayoutConfigurations(this.deserializeLayoutConfigurations(xmlReader));
                Object object = Unit.INSTANCE;
                break;
            }
            case "driver-properties": {
                Map<String, String> map = ds.getDriverProperties();
                Intrinsics.checkNotNullExpressionValue(map, (String)"getDriverProperties(...)");
                this.deserializeProperties(xmlReader, map, pathMacroManager);
                Object object = Unit.INSTANCE;
                break;
            }
            case "vm-env": {
                Map<String, String> map = ds.getVmEnv();
                Intrinsics.checkNotNullExpressionValue(map, (String)"getVmEnv(...)");
                this.deserializeProperties(xmlReader, map, pathMacroManager);
                Object object = Unit.INSTANCE;
                break;
            }
            case "ssh-properties": {
                ds.setSshConfiguration(DataSourceSshTunnelConfiguration.deserialize(project, xmlReader, ds));
                Object object = Unit.INSTANCE;
                break;
            }
            case "ssl-config": {
                ds.setSslCfg(DataSourceSslConfiguration.deserialize(xmlReader));
                Object object = Unit.INSTANCE;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private final List<DataSourceSessionTemplate> deserializeSessionTemplates(HierarchicalStreamReader xmlReader, LocalDataSource dataSource, PathMacroSubstitutor pathMacroManager) {
        templates = new ArrayList<DataSourceSessionTemplate>();
        while (xmlReader.hasMoreChildren()) {
            block11: {
                xmlReader.moveDown();
                if (!Intrinsics.areEqual((Object)"template", (Object)xmlReader.getNodeName())) break block11;
                id = xmlReader.getAttribute("id");
                name = xmlReader.getAttribute("name");
                readOnly = xmlReader.getAttribute("read-only");
                authProvider = xmlReader.getAttribute("auth-provider");
                template = new DataSourceSessionTemplate(dataSource, id);
                v0 = name;
                if (v0 == null) {
                    v0 = "";
                }
                template.setTemplateName(v0);
                v1 = template;
                if (readOnly != null) {
                    var13_13 = v1;
                    $i$a$-let-LocalDataSourceSerialization$deserializeSessionTemplates$1 = false;
                    v2 = Intrinsics.areEqual((Object)it, (Object)"true");
                    v1 = var13_13;
                } else {
                    v2 = null;
                }
                v1.setReadonlyOverride(v2);
                template.setAuthProviderIdOverride(authProvider);
                template.getUrlOverrider().clear();
                while (xmlReader.hasMoreChildren()) {
                    block12: {
                        block13: {
                            xmlReader.moveDown();
                            var10_10 = xmlReader.getNodeName();
                            if (var10_10 == null) break block12;
                            switch (var10_10.hashCode()) {
                                case 30671912: {
                                    if (var10_10.equals("init-script")) break;
                                    ** break;
                                }
                                case 116079: {
                                    if (!var10_10.equals("url")) {
                                        ** break;
                                    }
                                    break block13;
                                }
                                case 378041671: {
                                    if (!var10_10.equals("jdbc-additional-properties")) ** break;
                                    v3 = template.myAdditionalProperties;
                                    Intrinsics.checkNotNullExpressionValue(v3, (String)"myAdditionalProperties");
                                    this.deserializeProperties(xmlReader, v3, pathMacroManager);
                                    ** break;
                                }
                            }
                            template.setInitScript(xmlReader.getValue());
                            ** break;
                        }
                        v4 = template.getUrlOverrider();
                        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getUrlOverrider(...)");
                        this.deserializeUrlOverrider(xmlReader, v4);
                    }
                    xmlReader.moveUp();
                }
                templates.add(template);
            }
            xmlReader.moveUp();
        }
        return templates;
    }

    private final void deserializeUrlOverrider(HierarchicalStreamReader xmlReader, ConfigUrlOverrider urlOverrider) {
        while (xmlReader.hasMoreChildren()) {
            xmlReader.moveDown();
            if (Intrinsics.areEqual((Object)xmlReader.getNodeName(), (Object)"param")) {
                String name2 = xmlReader.getAttribute("name");
                String value = xmlReader.getAttribute("value");
                if (name2 != null && value != null) {
                    urlOverrider.setParam(name2, value);
                }
            }
            xmlReader.moveUp();
        }
    }

    private final void deserializeBeforeTasks(HierarchicalStreamReader xmlReader, List<LocalDataSource.BeforeTask> beforeTasks) {
        while (xmlReader.hasMoreChildren()) {
            xmlReader.moveDown();
            if (Intrinsics.areEqual((Object)"task", (Object)xmlReader.getNodeName())) {
                String id = xmlReader.getAttribute("id");
                Element rt = this.deserializeElement(xmlReader);
                rt.removeAttribute("id");
                beforeTasks.add(new LocalDataSource.BeforeTask(id, rt));
            }
            xmlReader.moveUp();
        }
    }

    private final Element deserializeElement(HierarchicalStreamReader reader) {
        Element res = new Element(reader.getNodeName());
        int e = reader.getAttributeCount();
        for (int i2 = 0; i2 < e; ++i2) {
            res.setAttribute(reader.getAttributeName(i2), reader.getAttribute(i2));
        }
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            res.addContent(this.deserializeElement(reader));
            reader.moveUp();
        }
        return res;
    }

    private final void deserializeProperties(HierarchicalStreamReader xmlReader, Map<String, String> properties2, PathMacroSubstitutor pathMacroManager) {
        while (xmlReader.hasMoreChildren()) {
            xmlReader.moveDown();
            if (Intrinsics.areEqual((Object)xmlReader.getNodeName(), (Object)"property")) {
                String value = pathMacroManager.expandPath(xmlReader.getAttribute("value"));
                properties2.put(xmlReader.getAttribute("name"), value);
            }
            xmlReader.moveUp();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> deserializeLayoutConfigurations(HierarchicalStreamReader xmlReader) {
        Map configurations = new HashMap();
        while (xmlReader.hasMoreChildren()) {
            String name2;
            CharSequence charSequence;
            xmlReader.moveDown();
            if (Intrinsics.areEqual((Object)xmlReader.getNodeName(), (Object)"namespace") && !((charSequence = (CharSequence)(name2 = xmlReader.getAttribute("name"))) == null || charSequence.length() == 0)) {
                String configurationText;
                ArrayList<String> lines = new ArrayList<String>();
                while (xmlReader.hasMoreChildren()) {
                    String s;
                    xmlReader.moveDown();
                    if (Intrinsics.areEqual((Object)xmlReader.getNodeName(), (Object)"line") && Strings.isNotEmpty((String)(s = xmlReader.getValue()))) {
                        void $this$trim$iv;
                        Intrinsics.checkNotNull((Object)s);
                        String string = s;
                        ArrayList<String> arrayList = lines;
                        boolean $i$f$trim = false;
                        CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                        boolean $i$f$trim2 = false;
                        int startIndex$iv$iv = 0;
                        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                        boolean startFound$iv$iv = false;
                        while (startIndex$iv$iv <= endIndex$iv$iv) {
                            boolean match$iv$iv;
                            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                            char it = $this$trim$iv$iv.charAt(index$iv$iv);
                            boolean bl = false;
                            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                            if (!startFound$iv$iv) {
                                if (!match$iv$iv) {
                                    startFound$iv$iv = true;
                                    continue;
                                }
                                ++startIndex$iv$iv;
                                continue;
                            }
                            if (!match$iv$iv) break;
                            --endIndex$iv$iv;
                        }
                        arrayList.add(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
                    }
                    xmlReader.moveUp();
                }
                Intrinsics.checkNotNullExpressionValue((Object)Strings.join((Collection)lines, (String)"\n"), (String)"join(...)");
                configurations.put(name2, configurationText);
            }
            xmlReader.moveUp();
        }
        return configurations;
    }

    private final PathMacroSubstitutor getPathMacroManager(Project project) {
        PathMacroSubstitutor pathMacroSubstitutor;
        ComponentManager manager;
        Project project2 = project;
        ComponentManager componentManager = manager = project2 != null ? (ComponentManager)project2 : (ComponentManager)ApplicationManager.getApplication();
        if (componentManager == null) {
            pathMacroSubstitutor = NoopSubstitutor.INSTANCE;
        } else {
            PathMacroManager pathMacroManager = PathMacroManager.getInstance((ComponentManager)componentManager);
            Intrinsics.checkNotNullExpressionValue((Object)pathMacroManager, (String)"getInstance(...)");
            pathMacroSubstitutor = (PathMacroSubstitutor)pathMacroManager;
        }
        return pathMacroSubstitutor;
    }

    private static final void deserializeInner$lambda$9(LocalDataSource $ds, String $newName, SaveMode $mode, HierarchicalStreamReader $reader, String $newGroupName, String $newUniqueId) {
        $ds.setName($newName);
        if ($mode.includeConfig()) {
            $ds.setReadOnly(Intrinsics.areEqual((Object)$reader.getAttribute("read-only"), (Object)"true"));
            $ds.setCheckOutdated(!Intrinsics.areEqual((Object)$reader.getAttribute("check-outdated"), (Object)"false"));
            $ds.setTrackNamespaces(!Intrinsics.areEqual((Object)$reader.getAttribute("track-namespaces"), (Object)"false"));
            $ds.setSingleConnection(Intrinsics.areEqual((Object)$reader.getAttribute("single-connection"), (Object)"true"));
            $ds.setGroupName($newGroupName);
        }
        $ds.setUniqueId($newUniqueId);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u0016J\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/dataSource/LocalDataSourceSerialization$NoopSubstitutor;", "Lcom/intellij/openapi/components/PathMacroSubstitutor;", "<init>", "()V", "expandPath", "", "text", "collapsePath", "recursively", "", "expandPaths", "", "element", "Lorg/jdom/Element;", "collapsePaths", "intellij.database.core.impl"})
    private static final class NoopSubstitutor
    implements PathMacroSubstitutor {
        @NotNull
        public static final NoopSubstitutor INSTANCE = new NoopSubstitutor();

        private NoopSubstitutor() {
        }

        @Nullable
        public String expandPath(@Nullable String text2) {
            return text2;
        }

        @Nullable
        public String collapsePath(@Nullable String text2, boolean recursively) {
            return text2;
        }

        public void expandPaths(@NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        }

        public void collapsePaths(@NotNull Element element, boolean recursively) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\nJ\u0006\u0010\f\u001a\u00020\nJ\u0006\u0010\r\u001a\u00020\nj\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/dataSource/LocalDataSourceSerialization$SaveMode;", "", "<init>", "(Ljava/lang/String;I)V", "ALL", "CONFIG", "LOCAL_CONFIG", "WITHOUT_SCHEMA", "SCHEMA", "includeSchema", "", "includeConfig", "includeLocalConfig", "includeDatabaseInfo", "intellij.database.core.impl"})
    public static final class SaveMode
    extends Enum<SaveMode> {
        public static final /* enum */ SaveMode ALL = new SaveMode();
        public static final /* enum */ SaveMode CONFIG = new SaveMode();
        public static final /* enum */ SaveMode LOCAL_CONFIG = new SaveMode();
        public static final /* enum */ SaveMode WITHOUT_SCHEMA = new SaveMode();
        public static final /* enum */ SaveMode SCHEMA = new SaveMode();
        private static final /* synthetic */ SaveMode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public final boolean includeSchema() {
            return this == ALL || this == SCHEMA;
        }

        public final boolean includeConfig() {
            return this == ALL || this == CONFIG || this == WITHOUT_SCHEMA;
        }

        public final boolean includeLocalConfig() {
            return this == ALL || this == LOCAL_CONFIG || this == WITHOUT_SCHEMA;
        }

        public final boolean includeDatabaseInfo() {
            return this.includeSchema() || this.includeLocalConfig();
        }

        public static SaveMode[] values() {
            return (SaveMode[])$VALUES.clone();
        }

        public static SaveMode valueOf(String value) {
            return Enum.valueOf(SaveMode.class, value);
        }

        @NotNull
        public static EnumEntries<SaveMode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = saveModeArray = new SaveMode[]{SaveMode.ALL, SaveMode.CONFIG, SaveMode.LOCAL_CONFIG, SaveMode.WITHOUT_SCHEMA, SaveMode.SCHEMA};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

