/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors.tz;

import com.intellij.database.Dbms;
import com.intellij.database.extractors.FormatterCreator;
import com.intellij.database.extractors.tz.TimeZonedValue;
import com.intellij.database.remote.jdbc.JdbcInjection;
import com.intellij.database.run.ui.grid.editors.BoundaryValueResolver;
import com.intellij.database.run.ui.grid.editors.CompositeFormatter;
import com.intellij.database.run.ui.grid.editors.DataGridFormattersUtilCore;
import com.intellij.database.run.ui.grid.editors.DatabaseBoundaryValueResolver;
import com.intellij.database.run.ui.grid.editors.FormatsCache;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.openapi.util.Comparing;
import java.text.ParsePosition;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class TimeZonedTimestamp
extends TimeZonedValue<OffsetDateTime> {
    public TimeZonedTimestamp(@NotNull OffsetDateTime timestamp) {
        if (timestamp == null) {
            TimeZonedTimestamp.$$$reportNull$$$0(0);
        }
        super(timestamp);
    }

    public boolean equals(Object obj2) {
        if (!(obj2 instanceof TimeZonedTimestamp)) {
            return false;
        }
        TimeZonedTimestamp tstz = (TimeZonedTimestamp)obj2;
        return Comparing.equal((Object)((OffsetDateTime)tstz.getValue()), (Object)((OffsetDateTime)this.getValue()));
    }

    @Override
    @NotNull
    public JdbcInjection injection(@NotNull Dbms family, @NotNull FormatsCache formatsCache, @NotNull FormatterCreator formatterCreator) {
        if (family == null) {
            TimeZonedTimestamp.$$$reportNull$$$0(1);
        }
        if (formatsCache == null) {
            TimeZonedTimestamp.$$$reportNull$$$0(2);
        }
        if (formatterCreator == null) {
            TimeZonedTimestamp.$$$reportNull$$$0(3);
        }
        if (family.isVertica() || family == Dbms.REDSHIFT) {
            return new JdbcInjection.UtcTimestampInjection(DataGridFormattersUtilCore.fromOffsetDateTime((OffsetDateTime)((OffsetDateTime)this.getValue()), (FormatsCache)formatsCache, (FormatterCreator)formatterCreator, null));
        }
        if (family == Dbms.SNOWFLAKE) {
            return new JdbcInjection.SFlakeTimestampInjection(DataGridFormattersUtilCore.fromOffsetDateTime((OffsetDateTime)((OffsetDateTime)this.getValue()), (FormatsCache)formatsCache, (FormatterCreator)formatterCreator, null));
        }
        MyConverter converter = family.in(Dbms.POSTGRES_LIKE) ? new PgConverter(formatsCache, formatterCreator) : (family.is(Dbms.ORACLE) ? OraConverter.INSTANCE : (family.in(Dbms.MSSQL_LIKE) ? new MsConverter(formatsCache, formatterCreator) : new DefaultConverter(family, formatsCache, formatterCreator)));
        String timestamp = converter.getFormatter().format((Object)this);
        JdbcInjection jdbcInjection = converter.injection(timestamp);
        if (jdbcInjection == null) {
            TimeZonedTimestamp.$$$reportNull$$$0(4);
        }
        return jdbcInjection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timestamp";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "family";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatsCache";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatterCreator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extractors/tz/TimeZonedTimestamp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extractors/tz/TimeZonedTimestamp";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "injection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "injection";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    private static class PgConverter
    implements MyConverter {
        private final Formatter myFormatter;

        PgConverter(@NotNull FormatsCache formatsCache, @NotNull FormatterCreator formatterCreator) {
            if (formatsCache == null) {
                PgConverter.$$$reportNull$$$0(0);
            }
            if (formatterCreator == null) {
                PgConverter.$$$reportNull$$$0(1);
            }
            this.myFormatter = formatterCreator.newZonedTimestampFormat((BoundaryValueResolver)DatabaseBoundaryValueResolver.TIMESTAMP_TZ, 9, formatsCache, null);
        }

        @Override
        @NotNull
        public JdbcInjection injection(@NotNull String timestamp) {
            if (timestamp == null) {
                PgConverter.$$$reportNull$$$0(2);
            }
            return new JdbcInjection.DefaultTimestampInjection(timestamp);
        }

        @Override
        @NotNull
        public Formatter getFormatter() {
            Formatter formatter = this.myFormatter;
            if (formatter == null) {
                PgConverter.$$$reportNull$$$0(3);
            }
            return formatter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "formatsCache";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "formatterCreator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "timestamp";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/extractors/tz/TimeZonedTimestamp$PgConverter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/extractors/tz/TimeZonedTimestamp$PgConverter";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFormatter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "injection";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    private static final class OraConverter
    implements MyConverter {
        private static final OraConverter INSTANCE = new OraConverter();

        private OraConverter() {
        }

        @Override
        @NotNull
        public JdbcInjection injection(@NotNull String timestamp) {
            if (timestamp == null) {
                OraConverter.$$$reportNull$$$0(0);
            }
            return new JdbcInjection.OraTimestampInjection(timestamp);
        }

        @Override
        @NotNull
        public Formatter getFormatter() {
            Formatter formatter = MyFormatter.INSTANCE;
            if (formatter == null) {
                OraConverter.$$$reportNull$$$0(1);
            }
            return formatter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "timestamp";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/extractors/tz/TimeZonedTimestamp$OraConverter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/extractors/tz/TimeZonedTimestamp$OraConverter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFormatter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "injection";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }

        private static final class MyFormatter
        implements Formatter {
            private static final Formatter INSTANCE = new MyFormatter();
            private static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 4, SignStyle.NEVER).appendLiteral("-").appendValue(ChronoField.MONTH_OF_YEAR, 2, 2, SignStyle.NEVER).appendLiteral("-").appendValue(ChronoField.DAY_OF_MONTH, 2, 2, SignStyle.NEVER).appendLiteral(" ").appendValue(ChronoField.HOUR_OF_DAY, 2, 2, SignStyle.NEVER).appendLiteral(":").appendValue(ChronoField.MINUTE_OF_HOUR, 2, 2, SignStyle.NEVER).appendLiteral(":").appendValue(ChronoField.SECOND_OF_MINUTE, 2, 2, SignStyle.NEVER).appendLiteral(".").appendValue(ChronoField.NANO_OF_SECOND, 1, 9, SignStyle.NEVER).appendLiteral(" ").appendPattern("xxx").toFormatter(Locale.US);

            private MyFormatter() {
            }

            public Object parse(@NotNull String value) {
                if (value == null) {
                    MyFormatter.$$$reportNull$$$0(0);
                }
                throw new UnsupportedOperationException();
            }

            public Object parse(@NotNull String value, ParsePosition position) {
                if (value == null) {
                    MyFormatter.$$$reportNull$$$0(1);
                }
                throw new UnsupportedOperationException();
            }

            public String format(Object value) {
                OffsetDateTime offsetDateTime = (OffsetDateTime)((TimeZonedTimestamp)value).getValue();
                String stringValue = FORMATTER.format(offsetDateTime);
                int era = offsetDateTime.get(ChronoField.ERA);
                return (era == 0 ? "-" : "") + stringValue;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/extractors/tz/TimeZonedTimestamp$OraConverter$MyFormatter", "parse"));
            }
        }
    }

    private static class MsConverter
    implements MyConverter {
        private final Formatter myFormatter;

        MsConverter(FormatsCache formatsCache, @NotNull FormatterCreator formatterCreator) {
            if (formatterCreator == null) {
                MsConverter.$$$reportNull$$$0(0);
            }
            this.myFormatter = formatterCreator.newZonedTimestampFormat(DatabaseBoundaryValueResolver.getResolver(Dbms.MSSQL, null), 6, formatsCache, null);
        }

        @Override
        @NotNull
        public JdbcInjection injection(@NotNull String value) {
            if (value == null) {
                MsConverter.$$$reportNull$$$0(1);
            }
            return new JdbcInjection.MsDateTimeOffsetInjection(value);
        }

        @Override
        @NotNull
        public Formatter getFormatter() {
            Formatter formatter = this.myFormatter;
            if (formatter == null) {
                MsConverter.$$$reportNull$$$0(2);
            }
            return formatter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "formatterCreator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/extractors/tz/TimeZonedTimestamp$MsConverter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/extractors/tz/TimeZonedTimestamp$MsConverter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFormatter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "injection";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class DefaultConverter
    implements MyConverter {
        private final CompositeFormatter myFormatter;

        private DefaultConverter(@NotNull Dbms dbms, @NotNull FormatsCache formatsCache, @NotNull FormatterCreator formatterCreator) {
            if (dbms == null) {
                DefaultConverter.$$$reportNull$$$0(0);
            }
            if (formatsCache == null) {
                DefaultConverter.$$$reportNull$$$0(1);
            }
            if (formatterCreator == null) {
                DefaultConverter.$$$reportNull$$$0(2);
            }
            this.myFormatter = formatterCreator.newZonedTimestampFormat(DatabaseBoundaryValueResolver.getResolver(dbms, null), dbms.is(Dbms.H2) ? 9 : 6, formatsCache, null);
        }

        @Override
        @NotNull
        public JdbcInjection injection(@NotNull String value) {
            if (value == null) {
                DefaultConverter.$$$reportNull$$$0(3);
            }
            return new JdbcInjection.DefaultTimestampInjection(value);
        }

        @Override
        @NotNull
        public Formatter getFormatter() {
            CompositeFormatter compositeFormatter = this.myFormatter;
            if (compositeFormatter == null) {
                DefaultConverter.$$$reportNull$$$0(4);
            }
            return compositeFormatter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "formatsCache";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "formatterCreator";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/extractors/tz/TimeZonedTimestamp$DefaultConverter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/extractors/tz/TimeZonedTimestamp$DefaultConverter";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFormatter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "injection";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    private static interface MyConverter {
        @NotNull
        public JdbcInjection injection(@NotNull String var1);

        @NotNull
        public Formatter getFormatter();
    }
}

