/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.properties.references;

import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.meta.BasicMetaReferenceDesc;
import com.intellij.database.model.meta.BasicResolveAssistant;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.util.BasicPaths;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicResolvedReference
implements BasicReference {
    public final BasicElement myTarget;

    public BasicResolvedReference(@NotNull BasicElement target2) {
        if (target2 == null) {
            BasicResolvedReference.$$$reportNull$$$0(0);
        }
        this.myTarget = target2;
    }

    @Override
    @Nullable
    public String getName() {
        return this.myTarget.getName();
    }

    @Override
    public boolean isPlain() {
        return !BasicPaths.isQuoted(this.myTarget);
    }

    @Override
    @NotNull
    public ObjectKind getKind(@NotNull BasicMetaReferenceDesc<?, ?> meta) {
        if (meta == null) {
            BasicResolvedReference.$$$reportNull$$$0(1);
        }
        ObjectKind objectKind = this.myTarget.getKind();
        if (objectKind == null) {
            BasicResolvedReference.$$$reportNull$$$0(2);
        }
        return objectKind;
    }

    @Override
    public long getObjectId() {
        BasicIdentifiedElement identifiedElement = (BasicIdentifiedElement)ObjectUtils.tryCast((Object)this.myTarget, BasicIdentifiedElement.class);
        return identifiedElement != null ? identifiedElement.getObjectId() : Long.MIN_VALUE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BasicResolvedReference)) {
            return false;
        }
        BasicResolvedReference reference = (BasicResolvedReference)o;
        return this.myTarget.equals(reference.myTarget);
    }

    public int hashCode() {
        return this.myTarget.hashCode();
    }

    @Override
    @Nullable
    public <S extends BasicElement, T extends BasicElement> T resolve(@NotNull S source, @NotNull BasicMetaReferenceDesc<S, T> meta, @NotNull BasicResolveAssistant assistant) {
        if (source == null) {
            BasicResolvedReference.$$$reportNull$$$0(3);
        }
        if (meta == null) {
            BasicResolvedReference.$$$reportNull$$$0(4);
        }
        if (assistant == null) {
            BasicResolvedReference.$$$reportNull$$$0(5);
        }
        return meta.tryCast(this.myTarget);
    }

    @Override
    public <S extends BasicElement, T extends BasicElement> boolean matches(@NotNull S source, @NotNull BasicMetaReferenceDesc<S, T> meta, @NotNull T target2) {
        if (source == null) {
            BasicResolvedReference.$$$reportNull$$$0(6);
        }
        if (meta == null) {
            BasicResolvedReference.$$$reportNull$$$0(7);
        }
        if (target2 == null) {
            BasicResolvedReference.$$$reportNull$$$0(8);
        }
        return this.myTarget.equals(target2);
    }

    @Override
    @NotNull
    public <S extends BasicElement, T extends BasicElement> JBIterable<T> multiResolve(@NotNull S source, @NotNull BasicMetaReferenceDesc<S, T> meta, @NotNull BasicResolveAssistant assistant) {
        if (source == null) {
            BasicResolvedReference.$$$reportNull$$$0(9);
        }
        if (meta == null) {
            BasicResolvedReference.$$$reportNull$$$0(10);
        }
        if (assistant == null) {
            BasicResolvedReference.$$$reportNull$$$0(11);
        }
        JBIterable jBIterable = JBIterable.of(this.resolve(source, meta, assistant));
        if (jBIterable == null) {
            BasicResolvedReference.$$$reportNull$$$0(12);
        }
        return jBIterable;
    }

    @Override
    public void exportProperties(@NotNull NameValueConsumer<? super String> consumer) {
        if (consumer == null) {
            BasicResolvedReference.$$$reportNull$$$0(13);
        }
        throw new UnsupportedOperationException("Resolved refs are not serializable");
    }

    @Override
    public boolean isEquivalent(BasicReference ref) {
        return StringUtil.equals((CharSequence)this.getName(), (CharSequence)ref.getName());
    }

    public String toString() {
        return "resolved=" + String.valueOf(this.myTarget);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/properties/references/BasicResolvedReference";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assistant";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/properties/references/BasicResolvedReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getKind";
                break;
            }
            case 2: 
            case 12: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "multiResolve";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 12 -> new IllegalStateException(string);
        };
    }
}

