/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.serialization;

import com.intellij.database.Dbms;
import com.intellij.database.model.BaseModel;
import com.intellij.database.model.ModelEntityStorage;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.NameValueGetter;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicHierarchicalObject;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.serialization.FixHierarchicalStreamReader;
import com.intellij.database.model.serialization.ImportException;
import com.intellij.database.model.serialization.ModelConverters;
import com.intellij.database.model.serialization.ModelElementMem;
import com.intellij.database.model.serialization.ModelMem;
import com.intellij.database.model.serialization.ModelSerializationFun;
import com.intellij.database.model.serialization.ModelSerializationVersions;
import com.intellij.database.model.serialization.MutableNameAndValue;
import com.intellij.database.model.serialization.PropertiesTracker;
import com.intellij.database.model.serialization.converters.Converter_4_44;
import com.intellij.database.model.serialization.converters.Converter_4_53;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbUtil;
import com.intellij.database.util.Version;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.FactoryMap;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.ErrorWriter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModelImporter {
    private static final Logger LOG = Logger.getInstance(ModelImporter.class);
    @NotNull
    private final ModelFactory myModelFactory;
    public Set<String> myUnconsumedProperties;
    @NotNull
    public Version expectedVersion;
    public final Version[] versionRange;
    public boolean currentFormat;
    public boolean wasMigrated;
    public boolean triedLoadFast;
    public boolean loadedFast;
    private final Map<String, Version> myVersionCache;

    public ModelImporter(@NotNull ModelFactory modelFactory) {
        if (modelFactory == null) {
            ModelImporter.$$$reportNull$$$0(0);
        }
        this.myUnconsumedProperties = null;
        this.expectedVersion = Version.INFINITY;
        this.versionRange = new Version[]{Version.ZERO, Version.INFINITY};
        this.myVersionCache = FactoryMap.create(Version::of);
        this.myModelFactory = modelFactory;
    }

    public BasicModModel deserialize(@NotNull HierarchicalStreamReader reader, @Nullable String dataSourceName) {
        if (reader == null) {
            ModelImporter.$$$reportNull$$$0(1);
        }
        FixHierarchicalStreamReader fReader = new FixHierarchicalStreamReader(reader);
        ModelMem modelMem = this.deserializeModelHeader(reader, dataSourceName);
        if (ModelSerializationVersions.CURRENT_VERSION.equals(modelMem.getVersion())) {
            this.triedLoadFast = true;
            return this.deserializeFast(fReader, dataSourceName, modelMem);
        }
        this.triedLoadFast = false;
        this.wasMigrated = true;
        LOG.warn("Reading from xml because of version: " + dataSourceName);
        this.deserializeModelHierarchy(fReader, dataSourceName, modelMem);
        return this.importModel(modelMem);
    }

    public BasicModModel restoreFromStorageOnly() {
        ModelEntityStorage.Backend storage = this.myModelFactory.getTextStorage().createEntityStorage();
        if (!storage.isPersistent()) {
            return null;
        }
        ModelEntityStorage.Info info = storage.loadInfo();
        Dbms dbms = Dbms.byName(info == null ? null : info.dbms);
        Disposer.dispose((Disposable)((Disposable)storage));
        if (dbms == null) {
            return null;
        }
        BasicModModel model = this.myModelFactory.createModel(dbms, true);
        BaseModel.restoreFromStorage(model);
        return model;
    }

    @NotNull
    private BasicModModel deserializeFast(FixHierarchicalStreamReader fReader, @Nullable String dataSourceName, ModelMem modelMem) {
        boolean restored;
        BasicModModel model = this.myModelFactory.createModel(modelMem.getDbms(), true);
        try {
            restored = BaseModel.restoreFromStorage(model);
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (Throwable th) {
            LOG.warn(th);
            model.clearModel();
            restored = false;
        }
        this.loadedFast = restored;
        if (!restored) {
            if (BaseModel.isPersistent(model)) {
                LOG.warn("Reading from xml: " + dataSourceName);
            }
            try {
                this.deserializeModelHierarchy(fReader, dataSourceName, modelMem);
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    Converter_4_44.INSTANCE.convertMem(modelMem);
                    Converter_4_53.INSTANCE.convertMem(modelMem);
                }
                this.importToModel(modelMem, model);
            }
            catch (Throwable th) {
                model.shelve(false);
                throw th;
            }
        }
        BasicModModel basicModModel = model;
        if (basicModModel == null) {
            ModelImporter.$$$reportNull$$$0(2);
        }
        return basicModModel;
    }

    @NotNull
    public ModelMem deserializeModel(@NotNull HierarchicalStreamReader reader, @Nullable String dataSourceName) throws ImportException {
        if (reader == null) {
            ModelImporter.$$$reportNull$$$0(3);
        }
        ModelMem mm = this.deserializeModelHeader(reader, dataSourceName);
        this.deserializeModelHierarchy(reader, dataSourceName, mm);
        ModelMem modelMem = mm;
        if (modelMem == null) {
            ModelImporter.$$$reportNull$$$0(4);
        }
        return modelMem;
    }

    public void deserializeModelHierarchy(@NotNull HierarchicalStreamReader reader, @Nullable String dataSourceName, ModelMem mm) {
        if (reader == null) {
            ModelImporter.$$$reportNull$$$0(5);
        }
        if (mm.getVersion().compareTo(ModelSerializationVersions.MIN_VERSION) < 0 || mm.getVersion().compareTo(ModelSerializationVersions.CURRENT_VERSION) > 0) {
            String message = ModelImporter.getProblemPrefix(dataSourceName) + "Unsupported format version " + String.valueOf(mm.getVersion()) + " (the " + String.valueOf(ModelSerializationVersions.CURRENT_VERSION) + " is expected)";
            reader.appendErrors((ErrorWriter)new ConversionException(message));
        } else {
            ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                if (indicator != null) {
                    indicator.checkCanceled();
                }
                this.deserializeObject(reader, null, mm.getNodes());
                reader.moveUp();
            }
        }
    }

    @NotNull
    public ModelMem deserializeModelHeader(@NotNull HierarchicalStreamReader reader, @Nullable String dataSourceName) {
        Version formatVersion;
        Dbms dbms;
        String rootNodeName;
        if (reader == null) {
            ModelImporter.$$$reportNull$$$0(6);
        }
        if (!(rootNodeName = reader.getNodeName()).equalsIgnoreCase("database-model")) {
            throw new ImportException(ModelImporter.getProblemPrefix(dataSourceName) + "The root node of the database model must be database-model, but found " + rootNodeName);
        }
        String dbmsStr = (String)ObjectUtils.chooseNotNull((Object)reader.getAttribute("dbms"), (Object)reader.getAttribute("family-id"));
        if (dbmsStr != null) {
            dbms = Dbms.byName(dbmsStr);
            if (dbms == null) {
                throw new ImportException(ModelImporter.getProblemPrefix(dataSourceName) + "Unknown dbms: " + dbmsStr);
            }
        } else {
            String rdbmsCode = reader.getAttribute("rdbms");
            if (rdbmsCode != null) {
                String code = rdbmsCode.equalsIgnoreCase("POSTGRE") ? (rdbmsCode = "POSTGRES") : rdbmsCode;
                dbms = Dbms.byName(StringUtil.toUpperCase((String)code));
                if (dbms == null) {
                    throw new ImportException(ModelImporter.getProblemPrefix(dataSourceName) + "Unknown rdbms: " + rdbmsCode);
                }
            } else {
                throw new ImportException(ModelImporter.getProblemPrefix(dataSourceName) + "Dbms is not specified");
            }
        }
        try {
            String formatVersionString = reader.getAttribute("format-version");
            formatVersion = formatVersionString == null ? (this.currentFormat ? ModelSerializationVersions.CURRENT_VERSION : Version.ZERO) : Version.of(formatVersionString);
        }
        catch (Exception e) {
            throw new ImportException(ModelImporter.getProblemPrefix(dataSourceName) + "Error reading format version: " + e.getMessage(), e);
        }
        ModelMem mm = new ModelMem();
        mm.setDbms(dbms);
        mm.setVersion(formatVersion);
        int n = reader.getAttributeCount();
        for (int i2 = 0; i2 < n; ++i2) {
            String attrValue;
            String attrName = reader.getAttributeName(i2);
            if (attrName.equalsIgnoreCase("dbms") || attrName.equalsIgnoreCase("family-id") || attrName.equalsIgnoreCase("serializer") || attrName.equalsIgnoreCase("rdbms") || attrName.equalsIgnoreCase("format-version") || (attrValue = reader.getAttribute(i2)) == null || attrValue.isEmpty()) continue;
            mm.getProperties().put(attrName, attrValue);
        }
        ModelMem modelMem = mm;
        if (modelMem == null) {
            ModelImporter.$$$reportNull$$$0(7);
        }
        return modelMem;
    }

    @NotNull
    private static String getProblemPrefix(@Nullable String dataSourceName) {
        return dataSourceName != null ? "Problem occurred when reading data source " + dataSourceName + ": " : "";
    }

    void deserializeObject(@NotNull HierarchicalStreamReader reader, ModelElementMem parent, List<ModelElementMem> output) throws ImportException {
        Integer parentId;
        if (reader == null) {
            ModelImporter.$$$reportNull$$$0(8);
        }
        String kind = reader.getNodeName();
        Integer id = ModelImporter.parseId(reader);
        Integer n = parentId = parent != null ? parent.getId() : ModelImporter.parseParentId(reader);
        if (id == null) {
            String fromVerStr = reader.getAttribute("from-version");
            String toVerStr = reader.getAttribute("to-version");
            if (fromVerStr != null || toVerStr != null) {
                Version toVer;
                Version fromVer = fromVerStr == null ? Version.ZERO : this.myVersionCache.get(fromVerStr);
                Version version = toVer = toVerStr == null ? Version.INFINITY : this.myVersionCache.get(toVerStr);
                if (!this.expectedVersion.isOrGreater(fromVer)) {
                    if (!fromVer.isOrGreater(this.versionRange[1])) {
                        this.versionRange[1] = fromVer;
                    }
                    return;
                }
                if (toVer != Version.INFINITY && this.expectedVersion.isOrGreater(toVer)) {
                    if (!this.versionRange[0].isOrGreater(toVer)) {
                        this.versionRange[0] = toVer;
                    }
                    return;
                }
                if (!this.versionRange[0].isOrGreater(fromVer)) {
                    this.versionRange[0] = fromVer;
                }
                if (!toVer.isOrGreater(this.versionRange[1])) {
                    this.versionRange[1] = toVer;
                }
            }
            id = output.size() + 1;
        }
        String name2 = DbUtil.intern2(StringUtil.nullize((String)reader.getAttribute("name")));
        ModelElementMem em = new ModelElementMem();
        output.add(em);
        em.setKind(kind);
        em.setId(id);
        em.setParentId(parentId);
        em.setName(name2);
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String key2 = reader.getNodeName();
            ObjectKind ok = ObjectKind.getKind(key2);
            if (ok != null && ObjectKind.isDatabaseKind(ok)) {
                this.deserializeObject(reader, em, output);
            } else {
                key2 = ModelSerializationFun.normalize(key2);
                key2 = DbUtil.intern2(key2);
                String value = reader.getValue();
                value = ModelSerializationFun.normalize(value);
                value = DbUtil.intern2(value);
                if (key2 != null && value != null && !key2.equalsIgnoreCase("name") && this.acceptsProperty(em, key2)) {
                    em.getProperties().add(new MutableNameAndValue(key2, value));
                }
            }
            reader.moveUp();
        }
    }

    protected boolean acceptsProperty(ModelElementMem em, String name2) {
        return true;
    }

    private static Integer parseId(@NotNull HierarchicalStreamReader reader) throws ImportException {
        String str;
        if (reader == null) {
            ModelImporter.$$$reportNull$$$0(9);
        }
        if (StringUtil.isEmpty((String)(str = reader.getAttribute("id")))) {
            return null;
        }
        try {
            return Integer.valueOf(str.trim());
        }
        catch (NumberFormatException nfe) {
            throw new ImportException("Failed to parse id", nfe);
        }
    }

    private static Integer parseParentId(@NotNull HierarchicalStreamReader reader) throws ImportException {
        String str;
        if (reader == null) {
            ModelImporter.$$$reportNull$$$0(10);
        }
        if (StringUtil.isEmpty((String)(str = reader.getAttribute("parent")))) {
            return null;
        }
        try {
            return Integer.valueOf(str.trim());
        }
        catch (NumberFormatException nfe) {
            throw new ImportException("Failed to parse parent id", nfe);
        }
    }

    public BasicModModel importModel(@NotNull ModelMem modelMem) throws ImportException {
        if (modelMem == null) {
            ModelImporter.$$$reportNull$$$0(11);
        }
        Holder.CONVERTERS.convertMem(modelMem);
        BasicModModel model = this.myModelFactory.createModel(modelMem.getDbms());
        this.importToModel(modelMem, model);
        return model;
    }

    private void importToModel(@NotNull ModelMem modelMem, BasicModModel model) {
        if (modelMem == null) {
            ModelImporter.$$$reportNull$$$0(12);
        }
        BaseModel baseModel = (BaseModel)model;
        baseModel.modify(model.getRoot(), BasicModRoot.class, true, root -> {
            baseModel.clearModel();
            this.populateModel(modelMem, (BasicModRoot)root);
        });
        Holder.CONVERTERS.convertModel(model, modelMem.getVersion());
    }

    private void populateModel(@NotNull ModelMem modelMem, @NotNull BasicModRoot root) {
        if (modelMem == null) {
            ModelImporter.$$$reportNull$$$0(13);
        }
        if (root == null) {
            ModelImporter.$$$reportNull$$$0(14);
        }
        HashMap<Integer, BasicHierarchicalObject> elements = new HashMap<Integer, BasicHierarchicalObject>(modelMem.getNodes().size());
        TreeMap<String, String> propertiesMap = new TreeMap<String, String>();
        NameValueGetter.FromMap<String> getter = this.myUnconsumedProperties == null ? new NameValueGetter.FromMap<String>(propertiesMap) : new PropertiesTracker(propertiesMap);
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        ModelImporter.sortHierarchically(modelMem.getNodes());
        BulkAppender appender = new BulkAppender((m, e) -> elements.put(m.getId(), (BasicHierarchicalObject)e));
        for (ModelElementMem mem : modelMem.getNodes()) {
            BasicModElement element;
            if (indicator != null) {
                indicator.checkCanceled();
            }
            if (mem.getParentId() == null) {
                ObjectKind kind = ModelImporter.findKind(mem);
                if (kind == null) continue;
                if (kind != ObjectKind.ROOT) {
                    throw new ImportException("Only a root object can be a root of the tree. However, found " + mem.getKind() + " without a parent");
                }
                elements.put(mem.getId(), (BasicHierarchicalObject)((Object)root));
                element = root;
            } else {
                if (!appender.check(mem)) {
                    Family family;
                    appender.commit();
                    BasicHierarchicalObject parent = (BasicHierarchicalObject)elements.get(mem.getParentId());
                    if (parent == null) {
                        throw new ImportException("Object " + mem.getId() + " references parent " + mem.getParentId() + " that is not found or not processed yet");
                    }
                    ObjectKind kind = ModelImporter.findKind(mem);
                    Family family2 = family = kind == null ? null : parent.familyOf(kind);
                    if (family == null) {
                        LOG.error(String.valueOf(mem) + "'s family not in parent");
                    }
                    appender.next(mem, (ModFamily<?>)family);
                }
                if ((element = appender.create(mem)) == null) continue;
            }
            ModelImporter.populateObject(element, mem, propertiesMap, getter, this.myUnconsumedProperties);
        }
        appender.commit();
        Holder.CONVERTERS.applyMem(modelMem, (BasicModModel)root.getModel(), (Function1<? super ModelElementMem, ? extends BasicHierarchicalObject>)((Function1)m -> (BasicHierarchicalObject)elements.get(m.getId())));
    }

    private static void sortHierarchically(final List<ModelElementMem> nodes) {
        Int2IntOpenHashMap id2depth = new Int2IntOpenHashMap();
        id2depth.defaultReturnValue(-1);
        new Object((Int2IntMap)id2depth){
            private final Int2IntMap id2idx = new Int2IntOpenHashMap();
            final /* synthetic */ Int2IntMap val$id2depth;
            {
                this.val$id2depth = int2IntMap;
            }

            void fill() {
                for (int i2 = 0; i2 < nodes.size(); ++i2) {
                    this.id2idx.put(Objects.requireNonNull(((ModelElementMem)nodes.get(i2)).getId()).intValue(), i2);
                }
                for (ModelElementMem node : nodes) {
                    this.fillDepth(Objects.requireNonNull(node.getId()), node);
                }
            }

            private int fillDepth(int id, @Nullable ModelElementMem node) {
                Integer parentId;
                int depth = this.val$id2depth.get(id);
                if (depth != -1) {
                    return depth;
                }
                if (node == null) {
                    node = (ModelElementMem)nodes.get(this.id2idx.get(id));
                }
                depth = (parentId = node.getParentId()) == null ? 0 : this.fillDepth(parentId, null);
                this.val$id2depth.put(id, depth);
                return depth;
            }
        }.fill();
        nodes.sort(Comparator.comparing(arg_0 -> ModelImporter.lambda$sortHierarchically$3((Int2IntMap)id2depth, arg_0)).thenComparing(ModelElementMem::getParentId, Comparator.nullsFirst(Comparator.naturalOrder())));
    }

    @Nullable
    private static ObjectKind findKind(ModelElementMem mem) {
        ObjectKind kind = ObjectKind.getKind(mem.getKind());
        if (kind == null) {
            LOG.warn("ObjectKind " + mem.getKind() + " not found");
            return null;
        }
        return kind;
    }

    public static void populateObject(BasicModElement element, ModelElementMem mem, Map<String, String> propertiesMap, NameValueGetter<String> getter, Set<String> unconsumedProperties) {
        propertiesMap.clear();
        PropertiesTracker tracker = (PropertiesTracker)ObjectUtils.tryCast(getter, PropertiesTracker.class);
        if (tracker != null) {
            tracker.getConsumed().clear();
        }
        for (MutableNameAndValue p2 : mem.getProperties()) {
            propertiesMap.put(p2.getName(), p2.getValue());
        }
        if (StringUtil.isNotEmpty((String)mem.getName())) {
            propertiesMap.put("Name", mem.getName());
        }
        ModelImporter.importElementProperties(element, getter);
        if (tracker != null) {
            for (String prop : tracker.getConsumed()) {
                propertiesMap.remove(prop);
            }
            if (!propertiesMap.isEmpty()) {
                BasicMetaObject<?> meta = element.getMetaObject();
                BasicMetaModel<?> model = meta.getModel();
                String className = model.apiClass.getSimpleName() + "." + meta.apiClass.getSimpleName() + ".";
                for (String propName : propertiesMap.keySet()) {
                    unconsumedProperties.add(className + propName);
                }
            }
        }
    }

    private static void importElementProperties(@NotNull BasicModElement element, @NotNull NameValueGetter<String> properties2) {
        if (element == null) {
            ModelImporter.$$$reportNull$$$0(15);
        }
        if (properties2 == null) {
            ModelImporter.$$$reportNull$$$0(16);
        }
        try {
            element.importProperties(properties2);
        }
        catch (Exception e) {
            Dbms dbms = DbImplUtilCore.getDbms(element);
            String message = String.format("Importing %s model: failed to import element %s: %s: %s", dbms.getName(), element.getClass().getSimpleName(), e.getClass().getSimpleName(), e.getMessage());
            if (LOG.isDebugEnabled()) {
                LOG.warn(message, (Throwable)e);
            }
            LOG.warn(message);
        }
    }

    public void setUnconsumedProperties(Set<String> unconsumedProperties) {
        this.myUnconsumedProperties = unconsumedProperties;
    }

    private static /* synthetic */ Integer lambda$sortHierarchically$3(Int2IntMap id2depth, ModelElementMem n) {
        return id2depth.get(Objects.requireNonNull(n.getId()).intValue());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelFactory";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/serialization/ModelImporter";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelMem";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/serialization/ModelImporter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "deserializeFast";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "deserializeModel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "deserializeModelHeader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "deserializeModel";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deserializeModelHierarchy";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "deserializeModelHeader";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "deserializeObject";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseId";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseParentId";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "importModel";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "importToModel";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "populateModel";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "importElementProperties";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 7 -> new IllegalStateException(string);
        };
    }

    private static final class Holder {
        static final ModelConverters CONVERTERS = new ModelConverters();

        private Holder() {
        }
    }

    private static class BulkAppender {
        private Integer myParentId;
        private String myKind;
        private ModFamily<?> myFamily;
        private final List<ModelElementMem> myMems;
        private final List<BasicElement> myObjects;
        private final BiConsumer<ModelElementMem, BasicHierarchicalObject> myConsumer;

        private BulkAppender(@NotNull BiConsumer<ModelElementMem, BasicHierarchicalObject> consumer) {
            if (consumer == null) {
                BulkAppender.$$$reportNull$$$0(0);
            }
            this.myParentId = null;
            this.myKind = null;
            this.myMems = new ArrayList<ModelElementMem>();
            this.myObjects = new ArrayList<BasicElement>();
            this.myConsumer = consumer;
        }

        boolean check(@NotNull ModelElementMem mem) {
            if (mem == null) {
                BulkAppender.$$$reportNull$$$0(1);
            }
            return Objects.equals(this.myParentId, mem.getParentId()) && Objects.equals(this.myKind, mem.getKind());
        }

        void next(@NotNull ModelElementMem mem, @Nullable ModFamily<?> family) {
            if (mem == null) {
                BulkAppender.$$$reportNull$$$0(2);
            }
            this.myParentId = mem.getParentId();
            this.myKind = mem.getKind();
            this.myFamily = family;
        }

        void commit() {
            if (this.myFamily == null) {
                return;
            }
            List<BasicElement> elements = BaseModel.createBulk(this.myFamily, this.myObjects);
            for (int i2 = 0; i2 < elements.size(); ++i2) {
                this.myConsumer.accept(this.myMems.get(i2), (BasicHierarchicalObject)elements.get(i2));
            }
            this.myMems.clear();
            this.myObjects.clear();
            this.myParentId = null;
            this.myKind = null;
            this.myFamily = null;
        }

        @Nullable
        BasicModElement create(@NotNull ModelElementMem mem) {
            if (mem == null) {
                BulkAppender.$$$reportNull$$$0(3);
            }
            if (this.myFamily == null) {
                return null;
            }
            BasicModElement res = (BasicModElement)BasicMetaUtils.getMetaObject(this.myFamily).newDataObject();
            this.myObjects.add(res);
            this.myMems.add(mem);
            return res;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mem";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/model/serialization/ModelImporter$BulkAppender";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "check";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "next";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

