/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.script;

import com.intellij.database.script.translator.TranslateException;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ScriptModel<E>
implements Disposable {
    public abstract boolean isActual();

    public abstract ScriptModel<E> subModel(@Nullable TextRange var1);

    public abstract JBIterable<E> everything();

    public abstract JBIterable<? extends StatementIt<E>> statements();

    public abstract JBIterable<? extends ParamIt<E>> parameters();

    public abstract JBIterable<? extends ExternalIt<E>> externals();

    public abstract VirtualFile getVirtualFile();

    public abstract TextRange getTextRange();

    @NotNull
    public abstract Language getLanguage();

    public abstract <EE> ScriptModel<EE> rawTransform(Function<? super SyntaxTraverser<E>, ? extends SyntaxTraverser<EE>> var1);

    public void dispose() {
    }

    public String toString() {
        return "ScriptModel{range=" + String.valueOf(this.getTextRange()) + ", file=" + String.valueOf(this.getVirtualFile()) + "}";
    }

    public static final class ChosenRange
    extends TextRange {
        public ChosenRange(TextRange range) {
            super(range.getStartOffset(), range.getEndOffset(), true);
        }
    }

    public static final class PositionRange
    extends TextRange {
        public PositionRange(int position) {
            super(position, position, true);
        }

        public PositionRange(TextRange range) {
            super(range.getStartOffset(), range.getEndOffset(), true);
        }
    }

    public static final class StrictRange
    extends TextRange {
        public StrictRange(@NotNull TextRange range) {
            if (range == null) {
                StrictRange.$$$reportNull$$$0(0);
            }
            super(range.getStartOffset(), range.getEndOffset(), true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/database/script/ScriptModel$StrictRange", "<init>"));
        }
    }

    public static final class SmartRange
    extends TextRange {
        public SmartRange(@NotNull TextRange range) {
            if (range == null) {
                SmartRange.$$$reportNull$$$0(0);
            }
            super(range.getStartOffset(), range.getEndOffset(), true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/database/script/ScriptModel$SmartRange", "<init>"));
        }
    }

    public static abstract class ModelItBase<E, Self extends ModelItBase<E, Self>>
    extends JBIterator<E>
    implements ModelIt<E> {
        protected SyntaxTraverser<E> traverser;

        @Override
        public long rangeOffset() {
            return 0L;
        }

        @Override
        public final E object() {
            return (E)this.current();
        }

        @Override
        public final String text() {
            return this.traverser.api.textOf(this.current()).toString();
        }

        @Override
        public final TextRange range() {
            return this.traverser.api.rangeOf(this.current());
        }

        @Override
        public final IElementType type() {
            return this.traverser.api.typeOf(this.current());
        }

        @Override
        public SyntaxTraverser.Api<E> api() {
            return this.traverser.api;
        }

        public final JBIterable<Self> cursor() {
            return JBIterator.cursor((JBIterator)this);
        }
    }

    public static abstract class PStorage
    implements Iterable<Object> {
        @Nullable
        public abstract Object getValue(@NotNull Object var1);

        @Nullable
        public abstract Object putValue(@NotNull Object var1, Object var2);

        @NotNull
        public static PStorage newStorage() {
            return new PStorage(){
                Map<Object, Object> map = new HashMap<Object, Object>();

                @Override
                public Object getValue(@NotNull Object p2) {
                    if (p2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return this.map.get(p2);
                }

                @Override
                public Object putValue(@NotNull Object p2, Object v) {
                    if (p2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return this.map.put(p2, v);
                }

                @Override
                @NotNull
                public Iterator<Object> iterator() {
                    Iterator<Object> iterator = this.map.keySet().iterator();
                    if (iterator == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return iterator;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 2 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "p";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/database/script/ScriptModel$PStorage$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/database/script/ScriptModel$PStorage$1";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "iterator";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getValue";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray;
                            objectArray[2] = "putValue";
                            break;
                        }
                        case 2: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 2 -> new IllegalStateException(string);
                    };
                }
            };
        }
    }

    public static interface ExternalIt<E>
    extends ModelIt<E> {
    }

    public static interface ParamIt<E>
    extends ModelIt<E> {
        public String name();

        public Iterable<String> description();
    }

    public static interface StatementIt<E>
    extends ModelIt<E> {
        public String query();

        public String consoleQuery(PStorage var1, Condition<? super ParamIt<E>> var2) throws TranslateException;

        public JBIterable<? extends ParamIt<E>> parameters();

        public JBIterable<? extends ExternalIt<E>> externals();
    }

    public static interface ModelIt<E> {
        public String text();

        public TextRange range();

        public IElementType type();

        public SyntaxTraverser.Api<E> api();

        public long rangeOffset();

        public E object();
    }
}

