/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.script.generator;

import com.intellij.database.dataSource.srcStorage.PersistentMarkup;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.util.common.StringFun;
import com.intellij.openapi.util.text.StringUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\f\n\u0002\b\u000f\u0018\u00002\u00020\u0001:\u0002KLB\u0013\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001a\u001a\u00020\u0007H\u0016J\u0012\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001b\u001a\u00020\u0007H\u0007J\u0006\u0010\u001d\u001a\u00020\u001cJ\u001c\u0010\u001e\u001a\u00020\u001c2\u000e\b\u0004\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001c0 H\u0086\b\u00f8\u0001\u0000J\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\"J#\u0010%\u001a\u00020\u001c2\u0016\u0010&\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00140'\"\u0004\u0018\u00010\u0014\u00a2\u0006\u0002\u0010(J\u000e\u0010)\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u0014J0\u0010*\u001a\u00020\u001c2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\b\u0002\u0010+\u001a\u00020,2\b\b\u0002\u0010-\u001a\u00020.2\n\b\u0002\u0010/\u001a\u0004\u0018\u00010\u0007J\u0006\u00100\u001a\u00020\u001cJ$\u00101\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010+\u001a\u00020,2\n\b\u0002\u0010/\u001a\u0004\u0018\u00010\u0007J\u0010\u0010*\u001a\u00020\u001c2\b\u00102\u001a\u0004\u0018\u000103J\u000e\u0010*\u001a\u00020\u001c2\u0006\u00104\u001a\u000205J\u0010\u00106\u001a\u00020\u001c2\b\b\u0002\u00107\u001a\u00020,J\u001a\u00108\u001a\u00020\u001c2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001c0 H\u0086\b\u00f8\u0001\u0000J\u0006\u00109\u001a\u00020\u001cJ\u0012\u0010:\u001a\u00020\u001c2\n\b\u0002\u00107\u001a\u0004\u0018\u00010,J\u000e\u0010;\u001a\u00020\u001c2\u0006\u0010<\u001a\u00020\u0007J\u000e\u0010=\u001a\u00020\u001c2\u0006\u0010<\u001a\u00020>J\u0011\u0010?\u001a\u00020.2\u0006\u0010<\u001a\u00020\u0014H\u0086\u0004J\u0011\u0010?\u001a\u00020.2\u0006\u0010@\u001a\u00020>H\u0086\u0004J\u0011\u0010A\u001a\u00020.2\u0006\u0010<\u001a\u00020\u0014H\u0086\u0004J\u0006\u0010B\u001a\u00020.J\u0006\u0010C\u001a\u00020.J\u0006\u0010D\u001a\u00020\u001cJ\u001c\u0010H\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020,2\n\b\u0002\u0010/\u001a\u0004\u0018\u00010\u0007H\u0002J\u0006\u0010H\u001a\u00020\u001cJ\b\u0010I\u001a\u00020\u001cH\u0002J\u0006\u0010J\u001a\u000205R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00060\fj\u0002`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000e\u001a\f\u0012\b\u0012\u00060\u0010R\u00020\u00000\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010E\u001a\b\u0018\u00010\u0010R\u00020\u00008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bF\u0010G\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006M"}, d2={"Lcom/intellij/database/script/generator/CodeTextBuilder;", "", "capacity", "", "<init>", "(I)V", "indentation", "", "currentIndent", "indentStack", "Ljava/util/LinkedList;", "buf", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "fragments", "", "Lcom/intellij/database/script/generator/CodeTextBuilder$Fragment;", "getFragments", "()Ljava/util/List;", "text", "", "getText", "()Ljava/lang/CharSequence;", "length", "getLength", "()I", "toString", "indent", "", "unindent", "indenting", "block", "Lkotlin/Function0;", "getCurrentIndentationState", "Lcom/intellij/database/script/generator/CodeTextBuilder$IndentationState;", "returnToIndentation", "state", "phrase", "words", "", "([Ljava/lang/CharSequence;)V", "appendErrorComment", "append", "kind", "Lcom/intellij/database/model/properties/CompositeText$Kind;", "eoln", "", "error", "appendIndent", "appendSimple", "fragment", "Lcom/intellij/database/model/properties/CompositeText$Fragment;", "composite", "Lcom/intellij/database/model/properties/CompositeText;", "ensureEoln", "fragmentKind", "remapToContent", "appendContentMark", "ensureBlankLine", "addSuffixToTheLastLine", "suffix", "removeSuffixFromTheLastLine", "", "endsWith", "character", "endsWithIgnoreSpace", "isEmpty", "isNotEmpty", "clearAll", "currentFragment", "getCurrentFragment", "()Lcom/intellij/database/script/generator/CodeTextBuilder$Fragment;", "adjustLastFragment", "removeLastFragmentIfEmpty", "build", "IndentationState", "Fragment", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nCodeTextBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeTextBuilder.kt\ncom/intellij/database/script/generator/CodeTextBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,322:1\n1#2:323\n1878#3,3:324\n*S KotlinDebug\n*F\n+ 1 CodeTextBuilder.kt\ncom/intellij/database/script/generator/CodeTextBuilder\n*L\n318#1:324,3\n*E\n"})
public final class CodeTextBuilder {
    @NotNull
    private String indentation;
    @NotNull
    private String currentIndent;
    @NotNull
    private final LinkedList<String> indentStack;
    @NotNull
    private final StringBuilder buf;
    @NotNull
    private final List<Fragment> fragments;

    @NotNull
    public final List<Fragment> getFragments() {
        return this.fragments;
    }

    @NotNull
    public final CharSequence getText() {
        return this.buf;
    }

    public final int getLength() {
        return this.buf.length();
    }

    @NotNull
    public String toString() {
        return ((Object)this.getText()).toString();
    }

    public CodeTextBuilder(int capacity) {
        this.indentation = "\t";
        this.currentIndent = "";
        this.indentStack = new LinkedList();
        this.fragments = new ArrayList();
        this.buf = new StringBuilder(capacity);
        this.clearAll();
    }

    public /* synthetic */ CodeTextBuilder(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 1024;
        }
        this(n);
    }

    @JvmOverloads
    public final void indent(@NotNull String indent) {
        Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
        this.indentStack.push(this.currentIndent);
        this.currentIndent = this.currentIndent + indent;
    }

    public static /* synthetic */ void indent$default(CodeTextBuilder codeTextBuilder, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = codeTextBuilder.indentation;
        }
        codeTextBuilder.indent(string);
    }

    public final void unindent() {
        if (this.indentStack.isEmpty()) {
            throw new IllegalStateException("Unmatched unindent.");
        }
        String string = this.indentStack.pop();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pop(...)");
        this.currentIndent = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void indenting(@NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$indenting = false;
        CodeTextBuilder.indent$default(this, null, 1, null);
        try {
            block.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.unindent();
            InlineMarker.finallyEnd((int)1);
        }
    }

    @NotNull
    public final IndentationState getCurrentIndentationState() {
        return new IndentationState(this.indentStack.size(), this.currentIndent);
    }

    public final void returnToIndentation(@NotNull IndentationState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        int d = this.indentStack.size() - state.getStackPosition();
        if (d > 0) {
            int i2 = 1;
            if (i2 <= d) {
                while (true) {
                    this.indentStack.pop();
                    if (i2 == d) break;
                    ++i2;
                }
            }
            this.currentIndent = state.getCurrentIndent();
        }
        if (d < 0) {
            throw new IllegalStateException("Unmatched return-to-indentation operation");
        }
    }

    public final void phrase(CharSequence ... words) {
        Intrinsics.checkNotNullParameter((Object)words, (String)"words");
        if (words.length == 0) {
            return;
        }
        StringBuilder b = new StringBuilder();
        for (CharSequence word : words) {
            if (word == null) continue;
            if (((CharSequence)b).length() > 0) {
                b.append(' ');
            }
            b.append(word);
        }
        if (((CharSequence)b).length() > 0) {
            CodeTextBuilder.append$default(this, b, null, true, null, 10, null);
        }
    }

    public final void appendErrorComment(@NotNull CharSequence text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        CodeTextBuilder.append$default(this, "-- " + text2, null, false, ((Object)text2).toString(), 6, null);
    }

    public final void append(@Nullable CharSequence text2, @NotNull CompositeText.Kind kind, boolean eoln, @Nullable String error) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        if (text2 == null) {
            return;
        }
        if (!Intrinsics.areEqual((Object)text2, (Object)"\n")) {
            this.appendIndent();
        }
        CharSequence charSequence = text2;
        Object object = new Regex("\\r\\n?");
        String string = "\n";
        this.buf.append(object.replace(charSequence, string));
        this.adjustLastFragment(kind, error);
        if (eoln) {
            Character c2 = StringFun.getLastChar(this.buf);
            char c3 = '\n';
            if (c2 == null || c2.charValue() != c3) {
                this.buf.append('\n');
            }
        }
        CodeTextBuilder.adjustLastFragment$default(this, kind, null, 2, null);
        boolean bl2 = bl = ((Fragment)CollectionsKt.last(this.fragments)).getEnd() == this.buf.length();
        if (_Assertions.ENABLED && !bl) {
            object = "Assertion failed";
            throw new AssertionError(object);
        }
    }

    public static /* synthetic */ void append$default(CodeTextBuilder codeTextBuilder, CharSequence charSequence, CompositeText.Kind kind, boolean bl, String string, int n, Object object) {
        if ((n & 2) != 0) {
            kind = CompositeText.Kind.PLAIN_TEXT;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            string = null;
        }
        codeTextBuilder.append(charSequence, kind, bl, string);
    }

    public final void appendIndent() {
        CodeTextBuilder.appendSimple$default(this, this.currentIndent, null, null, 6, null);
    }

    public final void appendSimple(@NotNull CharSequence text2, @NotNull CompositeText.Kind kind, @Nullable String error) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        if (text2.length() == 0 && !kind.getContent()) {
            return;
        }
        this.buf.append(text2);
        this.adjustLastFragment(kind, error);
        boolean bl2 = bl = ((Fragment)CollectionsKt.last(this.fragments)).getEnd() == this.buf.length();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    public static /* synthetic */ void appendSimple$default(CodeTextBuilder codeTextBuilder, CharSequence charSequence, CompositeText.Kind kind, String string, int n, Object object) {
        if ((n & 2) != 0) {
            kind = CompositeText.Kind.PLAIN_TEXT;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        codeTextBuilder.appendSimple(charSequence, kind, string);
    }

    public final void append(@Nullable CompositeText.Fragment fragment) {
        boolean bl;
        if (fragment == null) {
            return;
        }
        CharSequence txt = fragment.getText();
        if (txt.length() == 0) {
            boolean bl2;
            Fragment fragment2 = (Fragment)CollectionsKt.lastOrNull(this.fragments);
            if (fragment2 != null) {
                Fragment $this$append_u24lambda_u240 = fragment2;
                boolean bl3 = false;
                bl2 = $this$append_u24lambda_u240.getKind() == fragment.getKind();
            } else {
                bl2 = false;
            }
            if (bl2) {
                return;
            }
        }
        int p2 = this.buf.length();
        this.buf.append(txt);
        this.fragments.add(new Fragment(this, p2, p2 + txt.length(), fragment.getKind(), fragment.getError()));
        boolean bl4 = bl = ((Fragment)CollectionsKt.last(this.fragments)).getEnd() == this.buf.length();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    public final void append(@NotNull CompositeText composite) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)composite, (String)"composite");
        int p2 = this.buf.length();
        this.buf.append(composite.getText());
        for (CompositeText.Fragment f : composite.getFragments()) {
            this.fragments.add(new Fragment(this, p2 + f.getBegin(), p2 + f.getEnd(), f.getKind(), f.getError()));
        }
        boolean bl2 = bl = ((Fragment)CollectionsKt.last(this.fragments)).getEnd() == this.buf.length();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    public final void ensureEoln(@NotNull CompositeText.Kind fragmentKind) {
        Intrinsics.checkNotNullParameter((Object)((Object)fragmentKind), (String)"fragmentKind");
        if (((CharSequence)this.buf).length() == 0) {
            return;
        }
        Character c2 = StringFun.getLastChar(this.buf);
        char c3 = '\n';
        if (c2 != null && c2.charValue() == c3) {
            return;
        }
        Fragment fragment = this.getCurrentFragment();
        if ((fragment != null ? fragment.getKind() : null) == fragmentKind) {
            this.buf.append('\n');
            CodeTextBuilder.adjustLastFragment$default(this, fragmentKind, null, 2, null);
        } else {
            CodeTextBuilder.append$default(this, "\n", fragmentKind, false, null, 8, null);
        }
    }

    public static /* synthetic */ void ensureEoln$default(CodeTextBuilder codeTextBuilder, CompositeText.Kind kind, int n, Object object) {
        if ((n & 1) != 0) {
            kind = CompositeText.Kind.PLAIN_TEXT;
        }
        codeTextBuilder.ensureEoln(kind);
    }

    public final void remapToContent(@NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$remapToContent = false;
        this.appendContentMark();
        block.invoke();
        this.appendContentMark();
    }

    public final void appendContentMark() {
        this.adjustLastFragment(CompositeText.Kind.DECOMPILED_TEXT, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void ensureBlankLine(@Nullable CompositeText.Kind fragmentKind) {
        if (((CharSequence)this.buf).length() == 0) {
            return;
        }
        boolean bl = false;
        if (bl) {
            return;
        }
        if (StringsKt.endsWith$default((CharSequence)this.buf, (CharSequence)"\n\n", (boolean)false, (int)2, null)) {
            return;
        }
        Character c2 = StringFun.getLastChar(this.buf);
        char c3 = '\n';
        StringBuilder stringBuilder = c2 != null && c2.charValue() == c3 ? this.buf.append('\n') : this.buf.append('\n').append('\n');
        if (fragmentKind != null) {
            Fragment fragment = this.getCurrentFragment();
            if ((fragment != null ? fragment.getKind() : null) != fragmentKind) {
                CodeTextBuilder.adjustLastFragment$default(this, fragmentKind, null, 2, null);
                return;
            }
        }
        this.adjustLastFragment();
    }

    public static /* synthetic */ void ensureBlankLine$default(CodeTextBuilder codeTextBuilder, CompositeText.Kind kind, int n, Object object) {
        if ((n & 1) != 0) {
            kind = null;
        }
        codeTextBuilder.ensureBlankLine(kind);
    }

    public final void addSuffixToTheLastLine(@NotNull String suffix) {
        int k;
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        Fragment fragment = this.getCurrentFragment();
        if (fragment == null) {
            throw new IllegalStateException("No Fragments");
        }
        Fragment cf = fragment;
        for (k = this.buf.length(); k > 0 && CharsKt.isWhitespace((char)this.buf.charAt(k - 1)); --k) {
        }
        this.buf.insert(k, suffix);
        int n = cf.getEnd();
        cf.setEnd(n + 1);
    }

    public final void removeSuffixFromTheLastLine(char suffix) {
        int k;
        Fragment fragment = this.getCurrentFragment();
        if (fragment == null) {
            throw new IllegalStateException("No Fragments");
        }
        Fragment cf = fragment;
        for (k = this.buf.length() - 1; k >= 0 && CharsKt.isWhitespace((char)this.buf.charAt(k)); --k) {
        }
        if (k >= 0 && this.buf.charAt(k) == suffix) {
            this.buf.delete(k, k + 1);
            int n = cf.getEnd();
            cf.setEnd(n + -1);
            this.removeLastFragmentIfEmpty();
        }
    }

    public final boolean endsWith(@NotNull CharSequence suffix) {
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        return StringsKt.endsWith$default((CharSequence)this.buf, (CharSequence)suffix, (boolean)false, (int)2, null);
    }

    public final boolean endsWith(char character) {
        return StringsKt.endsWith$default((CharSequence)this.buf, (char)character, (boolean)false, (int)2, null);
    }

    public final boolean endsWithIgnoreSpace(@NotNull CharSequence suffix) {
        int n;
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        int m = suffix.length();
        if (n < m) {
            return false;
        }
        for (n = this.buf.length(); n > 0 && CharsKt.isWhitespace((char)this.buf.charAt(n - 1)); --n) {
        }
        if (n < m) {
            return false;
        }
        return StringUtil.equalsIgnoreCase((CharSequence)this.buf.subSequence(n - m, n), (CharSequence)suffix);
    }

    public final boolean isEmpty() {
        return ((CharSequence)this.buf).length() == 0;
    }

    public final boolean isNotEmpty() {
        return ((CharSequence)this.buf).length() > 0;
    }

    public final void clearAll() {
        this.indentStack.clear();
        this.currentIndent = "";
        this.buf.delete(0, this.buf.length());
        this.fragments.clear();
    }

    private final Fragment getCurrentFragment() {
        return (Fragment)CollectionsKt.lastOrNull(this.fragments);
    }

    private final void adjustLastFragment(CompositeText.Kind kind, String error) {
        int p2 = this.buf.length();
        Fragment cf = this.getCurrentFragment();
        if (cf == null) {
            this.fragments.add(new Fragment(this, 0, p2, kind, error));
        } else if (cf.getEnd() != p2 || kind.getContent()) {
            if (cf.getEnd() <= p2 && cf.getKind() == kind && Intrinsics.areEqual((Object)cf.getError(), (Object)error)) {
                cf.setEnd(p2);
            } else if (cf.getEnd() < p2 || kind.getContent()) {
                this.fragments.add(new Fragment(this, cf.getEnd(), p2, kind, error));
            }
        }
    }

    static /* synthetic */ void adjustLastFragment$default(CodeTextBuilder codeTextBuilder, CompositeText.Kind kind, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        codeTextBuilder.adjustLastFragment(kind, string);
    }

    public final void adjustLastFragment() {
        int p2 = this.buf.length();
        if (p2 == 0) {
            return;
        }
        Fragment cf = this.getCurrentFragment();
        if (cf == null) {
            throw new IllegalStateException("No fragments");
        }
        if (cf.getEnd() != p2 && cf.getEnd() < p2) {
            cf.setEnd(p2);
        }
    }

    private final void removeLastFragmentIfEmpty() {
        Fragment fragment = this.getCurrentFragment();
        if (fragment == null) {
            return;
        }
        Fragment cf = fragment;
        if (cf.getLength() == 0) {
            this.fragments.remove(this.fragments.size() - 1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CompositeText build() {
        Int2ObjectOpenHashMap int2ObjectOpenHashMap;
        int n = 0;
        int n2 = this.fragments.size();
        int[] nArray = new int[n2];
        while (n < n2) {
            int n3 = n++;
            nArray[n3] = this.fragments.get(n3).getEnd();
        }
        int[] offsets = nArray;
        n2 = 0;
        int n4 = this.fragments.size();
        char[] cArray = new char[n4];
        while (n2 < n4) {
            int n5 = n2++;
            cArray[n5] = this.fragments.get(n5).getKind().getCode();
        }
        char[] kinds = cArray;
        Int2ObjectOpenHashMap $this$build_u24lambda_u242 = int2ObjectOpenHashMap = new Int2ObjectOpenHashMap();
        boolean bl = false;
        Iterable $this$forEachIndexed$iv = this.fragments;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void f;
            int n6;
            if ((n6 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Fragment fragment = (Fragment)item$iv;
            int i2 = n6;
            boolean bl2 = false;
            if (f.getError() == null) continue;
            $this$build_u24lambda_u242.put(i2, (Object)f.getError());
        }
        Int2ObjectOpenHashMap errors = int2ObjectOpenHashMap;
        return new PersistentMarkup(((Object)this.getText()).toString(), offsets, kinds, (Int2ObjectMap<String>)((Int2ObjectMap)errors));
    }

    @JvmOverloads
    public final void indent() {
        CodeTextBuilder.indent$default(this, null, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\r\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B/\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nR\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u0004\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\f\"\u0004\b\u0010\u0010\u000eR\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/script/generator/CodeTextBuilder$Fragment;", "Lcom/intellij/database/model/properties/CompositeText$Fragment;", "begin", "", "end", "kind", "Lcom/intellij/database/model/properties/CompositeText$Kind;", "error", "", "<init>", "(Lcom/intellij/database/script/generator/CodeTextBuilder;IILcom/intellij/database/model/properties/CompositeText$Kind;Ljava/lang/String;)V", "getBegin", "()I", "setBegin", "(I)V", "getEnd", "setEnd", "getKind", "()Lcom/intellij/database/model/properties/CompositeText$Kind;", "setKind", "(Lcom/intellij/database/model/properties/CompositeText$Kind;)V", "getError", "()Ljava/lang/String;", "text", "", "getText", "()Ljava/lang/CharSequence;", "intellij.database.core.impl"})
    public final class Fragment
    implements CompositeText.Fragment {
        private int begin;
        private int end;
        @NotNull
        private CompositeText.Kind kind;
        @Nullable
        private final String error;
        final /* synthetic */ CodeTextBuilder this$0;

        public Fragment(CodeTextBuilder this$0, int begin, @NotNull int end, @Nullable CompositeText.Kind kind, String error) {
            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
            this.this$0 = this$0;
            this.begin = begin;
            this.end = end;
            this.kind = kind;
            this.error = error;
        }

        public /* synthetic */ Fragment(CodeTextBuilder codeTextBuilder, int n, int n2, CompositeText.Kind kind, String string, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 4) != 0) {
                kind = CompositeText.Kind.PLAIN_TEXT;
            }
            if ((n3 & 8) != 0) {
                string = null;
            }
            this(codeTextBuilder, n, n2, kind, string);
        }

        @Override
        public int getBegin() {
            return this.begin;
        }

        public void setBegin(int n) {
            this.begin = n;
        }

        @Override
        public int getEnd() {
            return this.end;
        }

        public void setEnd(int n) {
            this.end = n;
        }

        @Override
        @NotNull
        public CompositeText.Kind getKind() {
            return this.kind;
        }

        public void setKind(@NotNull CompositeText.Kind kind) {
            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"<set-?>");
            this.kind = kind;
        }

        @Override
        @Nullable
        public String getError() {
            return this.error;
        }

        @Override
        @NotNull
        public CharSequence getText() {
            CharSequence charSequence = this.this$0.buf.subSequence(this.getBegin(), this.getEnd());
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"subSequence(...)");
            return charSequence;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/script/generator/CodeTextBuilder$IndentationState;", "", "stackPosition", "", "currentIndent", "", "<init>", "(ILjava/lang/String;)V", "getStackPosition", "()I", "getCurrentIndent", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "intellij.database.core.impl"})
    public static final class IndentationState {
        private final int stackPosition;
        @NotNull
        private final String currentIndent;

        public IndentationState(int stackPosition, @NotNull String currentIndent) {
            Intrinsics.checkNotNullParameter((Object)currentIndent, (String)"currentIndent");
            this.stackPosition = stackPosition;
            this.currentIndent = currentIndent;
        }

        public final int getStackPosition() {
            return this.stackPosition;
        }

        @NotNull
        public final String getCurrentIndent() {
            return this.currentIndent;
        }

        public final int component1() {
            return this.stackPosition;
        }

        @NotNull
        public final String component2() {
            return this.currentIndent;
        }

        @NotNull
        public final IndentationState copy(int stackPosition, @NotNull String currentIndent) {
            Intrinsics.checkNotNullParameter((Object)currentIndent, (String)"currentIndent");
            return new IndentationState(stackPosition, currentIndent);
        }

        public static /* synthetic */ IndentationState copy$default(IndentationState indentationState, int n, String string, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = indentationState.stackPosition;
            }
            if ((n2 & 2) != 0) {
                string = indentationState.currentIndent;
            }
            return indentationState.copy(n, string);
        }

        @NotNull
        public String toString() {
            return "IndentationState(stackPosition=" + this.stackPosition + ", currentIndent=" + this.currentIndent + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.stackPosition);
            result2 = result2 * 31 + this.currentIndent.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IndentationState)) {
                return false;
            }
            IndentationState indentationState = (IndentationState)other;
            if (this.stackPosition != indentationState.stackPosition) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.currentIndent, (Object)indentationState.currentIndent);
        }
    }
}

