/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.util.Case;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.formatter.Change;
import com.intellij.sql.formatter.SqlPreFormatHelper;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlToken;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\"\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\b\u0010:\u001a\u0004\u0018\u0001092\b\u0010;\u001a\u0004\u0018\u000109J\u0010\u0010<\u001a\u0002072\u0006\u0010=\u001a\u000209H\u0002J\u0010\u0010>\u001a\u0002072\u0006\u0010=\u001a\u000209H\u0002J\u0010\u0010?\u001a\u0002072\u0006\u00108\u001a\u000209H\u0002J\u0010\u0010@\u001a\u0002072\u0006\u00108\u001a\u000209H\u0002J\u001a\u0010A\u001a\u0002072\u0006\u0010B\u001a\u00020C2\b\u0010D\u001a\u0004\u0018\u00010EH\u0002J$\u0010F\u001a\u0002072\u0006\u0010B\u001a\u00020C2\b\u0010D\u001a\u0004\u0018\u00010E2\b\u0010G\u001a\u0004\u0018\u00010HH\u0002J\u0018\u0010I\u001a\u0002072\u0006\u0010J\u001a\u0002092\u0006\u0010K\u001a\u00020!H\u0002J\f\u0010L\u001a\u00020\t*\u000209H\u0002J\f\u0010M\u001a\u00020\t*\u000209H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u00100\u001a\t\u0018\u000101\u00a2\u0006\u0002\b2X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lcom/intellij/sql/formatter/SqlCasePreFormatter;", "", "dbms", "Lcom/intellij/database/Dbms;", "settings", "Lcom/intellij/sql/formatter/settings/SqlCodeStyleSettings;", "document", "Lcom/intellij/openapi/editor/Document;", "allowResolving", "", "readOnlyFragments", "", "Lcom/intellij/openapi/util/TextRange;", "changes", "", "Lcom/intellij/sql/formatter/Change;", "<init>", "(Lcom/intellij/database/Dbms;Lcom/intellij/sql/formatter/settings/SqlCodeStyleSettings;Lcom/intellij/openapi/editor/Document;ZLjava/util/List;Ljava/util/Collection;)V", "text", "", "sqlDialect", "Lcom/intellij/sql/dialects/SqlLanguageDialect;", "dbDialect", "Lcom/intellij/database/dialects/DatabaseDialectEx;", "namingService", "Lcom/intellij/database/script/generator/NamingService;", "builtInIsSensitive", "typeIsSensitive", "plainIsSensitive", "quotedIsSensitive", "isTransactSql", "quotationDependsOnKind", "keywordCase", "Lcom/intellij/database/util/Case;", "keywordCaseToChange", "identifierCase", "identifierCaseToChange", "identifierCaseOrigin", "identifierToQuote", "identifierToUnquote", "builtInTypeCase", "builtInTypeCaseToChange", "customTypeCase", "customTypeCaseToChange", "builtInCase", "builtInCaseToChange", "quotedCase", "quotedCaseToChange", "quotesPriority", "", "Lorg/jetbrains/annotations/Nullable;", "useWordAS", "", "toChangeSomething", "processElement", "", "element", "Lcom/intellij/psi/PsiElement;", "pa", "grandpa", "processKeyword", "keyword", "processKeywordType", "processCustomType", "processBuiltIn", "processIdentifier", "identifier", "Lcom/intellij/sql/psi/SqlIdentifier;", "kind", "Lcom/intellij/database/model/ObjectKind;", "processQuotedIdentifier", "parentElementType", "Lcom/intellij/psi/tree/IElementType;", "changeCase", "word", "case", "isQuoted", "intersectsWithReadOnlyFragments", "intellij.database.sql.core.impl"})
public final class SqlCasePreFormatter {
    private final boolean allowResolving;
    @Nullable
    private final List<TextRange> readOnlyFragments;
    @NotNull
    private final Collection<Change> changes;
    @NotNull
    private final CharSequence text;
    @NotNull
    private final SqlLanguageDialect sqlDialect;
    @NotNull
    private final DatabaseDialectEx dbDialect;
    @NotNull
    private final NamingService namingService;
    private final boolean builtInIsSensitive;
    private final boolean typeIsSensitive;
    private final boolean plainIsSensitive;
    private final boolean quotedIsSensitive;
    private final boolean isTransactSql;
    private final boolean quotationDependsOnKind;
    @NotNull
    private final Case keywordCase;
    private final boolean keywordCaseToChange;
    @NotNull
    private final Case identifierCase;
    private final boolean identifierCaseToChange;
    private final boolean identifierCaseOrigin;
    private final boolean identifierToQuote;
    private final boolean identifierToUnquote;
    @NotNull
    private final Case builtInTypeCase;
    private final boolean builtInTypeCaseToChange;
    @NotNull
    private final Case customTypeCase;
    private final boolean customTypeCaseToChange;
    @NotNull
    private final Case builtInCase;
    private final boolean builtInCaseToChange;
    @NotNull
    private final Case quotedCase;
    private final boolean quotedCaseToChange;
    @Nullable
    private final String quotesPriority;
    private final int useWordAS;
    private final boolean toChangeSomething;

    public SqlCasePreFormatter(@NotNull Dbms dbms, @NotNull SqlCodeStyleSettings settings, @NotNull Document document, boolean allowResolving, @Nullable List<? extends TextRange> readOnlyFragments, @NotNull Collection<Change> changes) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        this.allowResolving = allowResolving;
        this.readOnlyFragments = readOnlyFragments;
        this.changes = changes;
        CharSequence charSequence = document.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        this.text = charSequence;
        SqlLanguageDialect sqlLanguageDialect = DbSqlUtilCore.getSqlDialect(dbms);
        Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialect, (String)"getSqlDialect(...)");
        this.sqlDialect = sqlLanguageDialect;
        DatabaseDialectEx databaseDialectEx = DbImplUtilCore.getDatabaseDialect(dbms);
        Intrinsics.checkNotNullExpressionValue((Object)databaseDialectEx, (String)"getDatabaseDialect(...)");
        this.dbDialect = databaseDialectEx;
        this.namingService = NamingServices.getNamingService$default(dbms, null, null, 6, null);
        this.builtInIsSensitive = Intrinsics.areEqual((Object)dbms, (Object)Dbms.CLICKHOUSE);
        this.typeIsSensitive = Intrinsics.areEqual((Object)dbms, (Object)Dbms.CLICKHOUSE);
        this.plainIsSensitive = this.namingService.getDefaultCasing().plain.sensitive;
        this.quotedIsSensitive = this.namingService.getDefaultCasing().quoted.sensitive;
        this.quotationDependsOnKind = this.isTransactSql = dbms.isTransactSql();
        Case case_ = settings.getKeywordCase();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)case_), (String)"getKeywordCase(...)");
        this.keywordCase = case_;
        this.keywordCaseToChange = SqlPreFormatHelper.getToChange(this.keywordCase);
        Case case_2 = settings.getIdentifierCase();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)case_2), (String)"getIdentifierCase(...)");
        this.identifierCase = case_2;
        this.identifierCaseToChange = SqlPreFormatHelper.getToChange(this.identifierCase) && !this.plainIsSensitive;
        this.identifierCaseOrigin = settings.ORIGINAL_CASE && this.allowResolving;
        this.identifierToQuote = settings.QUOTE_IDENTIFIER == 2 && this.allowResolving;
        this.identifierToUnquote = settings.QUOTE_IDENTIFIER == 1 && this.allowResolving;
        Case case_3 = settings.getBuiltInTypeCase();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)case_3), (String)"getBuiltInTypeCase(...)");
        this.builtInTypeCase = case_3;
        this.builtInTypeCaseToChange = SqlPreFormatHelper.getToChange(this.builtInTypeCase) && !this.typeIsSensitive;
        Case case_4 = settings.getCustomTypeCase();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)case_4), (String)"getCustomTypeCase(...)");
        this.customTypeCase = case_4;
        this.customTypeCaseToChange = SqlPreFormatHelper.getToChange(this.customTypeCase) && !this.typeIsSensitive;
        Case case_5 = settings.getBuiltInCase();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)case_5), (String)"getBuiltInCase(...)");
        this.builtInCase = case_5;
        this.builtInCaseToChange = SqlPreFormatHelper.getToChange(this.builtInCase) && !this.builtInIsSensitive;
        Case case_6 = settings.getQuotedIdentifierCase();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)case_6), (String)"getQuotedIdentifierCase(...)");
        this.quotedCase = case_6;
        this.quotedCaseToChange = SqlPreFormatHelper.getToChange(this.quotedCase) && !this.quotedIsSensitive;
        this.quotesPriority = settings.getQuotesPriority();
        this.useWordAS = settings.SELECT_USE_AS_WORD;
        this.toChangeSomething = this.keywordCaseToChange || this.identifierCaseToChange || this.builtInTypeCaseToChange || this.builtInCaseToChange || this.quotedCaseToChange || this.quotedCaseToChange || this.identifierToQuote || this.identifierToUnquote;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final void processElement(@NotNull PsiElement element, @Nullable PsiElement pa, @Nullable PsiElement grandpa) {
        block19: {
            block20: {
                block18: {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    if (!this.toChangeSomething) {
                        return;
                    }
                    v0 = PsiTreeUtilKt.getElementType((PsiElement)element);
                    if (v0 == null) {
                        return;
                    }
                    et = v0;
                    v1 = pa;
                    v2 /* !! */  = pet = v1 != null ? PsiTreeUtilKt.getElementType((PsiElement)v1) : null;
                    if (pet == SqlCompositeElementTypes.SQL_PARAMETER_REFERENCE) {
                        return;
                    }
                    if (pet == GeneratedParserUtilBase.DUMMY_BLOCK && this.sqlDialect.isSyntheticKeyword(et)) {
                        return;
                    }
                    if (element.textMatches((CharSequence)"*")) {
                        return;
                    }
                    if (this.intersectsWithReadOnlyFragments(element)) {
                        return;
                    }
                    isRemapped = pa instanceof SqlIdentifier;
                    isInsideSpecialLiteral = Intrinsics.areEqual((Object)pet, (Object)SqlCompositeElementTypes.SQL_SPECIAL_LITERAL) != false && StringUtil.equalsIgnoreCase((CharSequence)element.getText(), (CharSequence)"null") == false;
                    isKeyword = et instanceof SqlKeywordTokenType != false && isRemapped == false && isInsideSpecialLiteral == false;
                    identifier = element instanceof SqlIdentifier != false ? (SqlIdentifier)element : null;
                    if (!isKeyword) break block18;
                    if (pa instanceof SqlTypeElement || grandpa instanceof SqlTypeElement) {
                        this.processKeywordType(element);
                    } else {
                        this.processKeyword(element);
                    }
                    break block19;
                }
                if (identifier == null) break block19;
                v3 = kind = this.allowResolving != false && this.quotationDependsOnKind != false ? SqlImplUtil.getIdentifierKind(identifier) : null;
                if (!this.isQuoted(element)) break block20;
                this.processQuotedIdentifier((SqlIdentifier)element, kind, pet);
                break block19;
            }
            isReferencePart = pa instanceof SqlReferenceExpression;
            if (!isReferencePart) ** GOTO lbl-1000
            var14_12 = new Class[]{SqlToken.class};
            v4 = (SqlToken)SqlImplUtil.getSiblingToTheLeftOfType(element, false, var14_12);
            if (Intrinsics.areEqual((Object)(v4 != null ? PsiTreeUtilKt.getElementType((PsiElement)((PsiElement)v4)) : null), (Object)SqlCommonTokens.SQL_PERIOD)) {
                v5 = true;
            } else lbl-1000:
            // 2 sources

            {
                v5 = false;
            }
            isSecond = v5;
            isBuiltIn = isSecond == false && SqlPreFormatHelper.identifierIsBuiltInFunction(pa) != false;
            if (isBuiltIn) {
                this.processBuiltIn(element);
            } else if (grandpa instanceof SqlTypeElement) {
                this.processCustomType(element);
            } else if (pa instanceof SqlTypeElement || pet == SqlCompositeElementTypes.SQL_TYPE_REFERENCE) {
                this.processCustomType(element);
            } else if (pet == SqlCompositeElementTypes.SQL_ALIAS_TYPE_REFERENCE || pet == SqlCompositeElementTypes.SQL_TABLE_TYPE_REFERENCE || pet == SqlCompositeElementTypes.SQL_COLLECTION_TYPE_REFERENCE) {
                this.processCustomType(element);
            } else {
                this.processIdentifier((SqlIdentifier)element, kind);
            }
        }
    }

    private final void processKeyword(PsiElement keyword) {
        if (this.keywordCaseToChange) {
            this.changeCase(keyword, this.keywordCase);
        }
    }

    private final void processKeywordType(PsiElement keyword) {
        if (this.builtInTypeCaseToChange) {
            this.changeCase(keyword, this.builtInTypeCase);
        }
    }

    private final void processCustomType(PsiElement element) {
        if (this.customTypeCaseToChange) {
            this.changeCase(element, this.customTypeCase);
        }
    }

    private final void processBuiltIn(PsiElement element) {
        if (this.builtInCaseToChange) {
            this.changeCase(element, this.builtInCase);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void processIdentifier(SqlIdentifier identifier, ObjectKind kind) {
        oldWord = identifier.getText();
        var4_4 = oldWord;
        if (var4_4 == null || StringsKt.isBlank((CharSequence)var4_4) != false) {
            return;
        }
        newWord = null;
        if (!this.identifierToQuote) ** GOTO lbl-1000
        if (!this.isTransactSql) ** GOTO lbl-1000
        v0 = identifier.getName();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getName(...)");
        if (!StringsKt.startsWith$default((String)v0, (String)"@", (boolean)false, (int)2, null)) lbl-1000:
        // 2 sources

        {
            prefix = identifier.getNamePrefix();
            v1 = identifier.getName();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getName(...)");
            newWord = this.namingService.enquote(v1, kind, this.quotesPriority);
            var6_6 = prefix;
            if (!(var6_6 == null || var6_6.length() == 0)) {
                newWord = prefix + (String)newWord;
            }
        } else lbl-1000:
        // 2 sources

        {
            if (this.identifierCaseOrigin) {
                newWord = SqlPreFormatHelper.obtainOriginalCase(identifier);
            }
            if (this.identifierCaseToChange && newWord == null) {
                newWord = this.identifierCase.apply(oldWord);
            }
        }
        if (newWord != null && !Intrinsics.areEqual((Object)newWord, (Object)oldWord)) {
            v2 = identifier.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getTextRange(...)");
            change = Change.Companion.replace(v2, (String)newWord);
            this.changes.add(change);
        }
    }

    private final void processQuotedIdentifier(SqlIdentifier identifier, ObjectKind kind, IElementType parentElementType) {
        String string = identifier.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String oldName = string;
        String oldWord = identifier.getText();
        String newWord = null;
        if (this.identifierToUnquote) {
            boolean canUnquote = false;
            if (parentElementType == SqlCompositeElementTypes.SQL_AS_EXPRESSION) {
                Class[] classArray = new Class[]{LeafPsiElement.class};
                LeafPsiElement followedToken = (LeafPsiElement)SqlImplUtil.getSiblingToTheLeftOfType((PsiElement)identifier, true, classArray);
                boolean afterAS = switch (this.useWordAS) {
                    case 1 -> true;
                    case 2 -> false;
                    default -> followedToken != null && SqlImplUtil.getElementType((PsiElement)followedToken) == SqlCommonKeywords.SQL_AS;
                };
                canUnquote = this.dbDialect.canUnquoteAlias(oldName, kind, afterAS);
            } else {
                canUnquote = SqlImplUtil.canUnquote(oldName, kind, this.namingService);
            }
            newWord = canUnquote ? this.identifierCase.apply(oldName) : this.quotedCase.apply(oldWord);
        } else if (this.quotedCaseToChange) {
            newWord = this.quotedCase.apply(oldWord);
        }
        if (newWord != null && !Intrinsics.areEqual((Object)newWord, (Object)oldWord)) {
            TextRange textRange = identifier.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            Change change = Change.Companion.replace(textRange, newWord);
            this.changes.add(change);
        }
    }

    private final void changeCase(PsiElement word, Case case_) {
        String newWord;
        int e;
        int b = word.getTextOffset();
        String oldWord = ((Object)this.text.subSequence(b, e = b + word.getTextLength())).toString();
        if (!Intrinsics.areEqual((Object)oldWord, (Object)(newWord = case_.apply(oldWord)))) {
            Intrinsics.checkNotNull((Object)newWord);
            Change change = Change.Companion.replace(b, e, newWord);
            this.changes.add(change);
        }
    }

    private final boolean isQuoted(PsiElement $this$isQuoted) {
        boolean bl;
        if ($this$isQuoted instanceof SqlNameElement) {
            bl = ((SqlNameElement)$this$isQuoted).isQuotedIdentifier();
        } else {
            String string = $this$isQuoted.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            bl = this.namingService.isQuoted(string);
        }
        return bl;
    }

    private final boolean intersectsWithReadOnlyFragments(PsiElement $this$intersectsWithReadOnlyFragments) {
        if (this.readOnlyFragments == null) {
            return false;
        }
        for (TextRange fragment : this.readOnlyFragments) {
            if (!$this$intersectsWithReadOnlyFragments.getTextRange().intersectsStrict(fragment)) continue;
            return true;
        }
        return false;
    }
}

