/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasType;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlLiteralExpression;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlExpressionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.symbols.DasSymbolUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlReferenceExpressionImpl
extends SqlExpressionImpl
implements SqlReferenceExpression,
PsiMetaData,
PsiMetaOwner {
    private volatile SqlReferenceImpl myReference;

    public SqlReferenceExpressionImpl(@NotNull IElementType elementType) {
        if (elementType == null) {
            SqlReferenceExpressionImpl.$$$reportNull$$$0(0);
        }
        super(elementType);
    }

    @Override
    public void accept(SqlVisitor visitor2) {
        visitor2.visitSqlReferenceExpression(this);
    }

    public void clearCaches() {
        super.clearCaches();
        this.myReference = null;
    }

    @Override
    public boolean processDeclarations(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            SqlReferenceExpressionImpl.$$$reportNull$$$0(1);
        }
        if (state == null) {
            SqlReferenceExpressionImpl.$$$reportNull$$$0(2);
        }
        if (place == null) {
            SqlReferenceExpressionImpl.$$$reportNull$$$0(3);
        }
        return !(lastParent instanceof SqlClause) || lastParent.getParent() != this || SqlImplUtil.processQualifierImpl(this, processor, state, place);
    }

    @Override
    @NotNull
    public DasType getDasType() {
        DasType dasType = this.getReference().getDasType();
        if (dasType == null) {
            SqlReferenceExpressionImpl.$$$reportNull$$$0(4);
        }
        return dasType;
    }

    @Override
    @Nullable
    public SqlExpression getQualifierExpression() {
        PsiElement parent = this.getParent();
        PsiElement parentFirst = parent.getFirstChild();
        PsiElement parentLast = parent.getLastChild();
        if (parentFirst == this && parentLast instanceof SqlReferenceExpression && ((SqlReferenceExpression)parentLast).getReferenceElementType().getTargetKind() == ObjectKind.DB_LINK) {
            return (SqlReferenceExpression)parentLast;
        }
        return this.findChildByClass(SqlExpression.class);
    }

    @Override
    @Nullable
    public SqlIdentifier getIdentifier() {
        SqlIdentifier identifier = this.findChildByClass(SqlIdentifier.class);
        if (identifier == null) {
            PsiElement lastChild = this.getLastChild();
            if (this.getFirstChild() == lastChild && lastChild instanceof SqlReferenceExpression) {
                SqlReferenceExpression ref = (SqlReferenceExpression)lastChild;
                if (this.getReferenceElementType().getTargetKind() == ObjectKind.BODY) {
                    identifier = ref.getIdentifier();
                }
            }
        }
        return identifier;
    }

    public PsiElement getDeclaration() {
        return this.resolve();
    }

    public String getName(PsiElement context) {
        return this.getName();
    }

    @Override
    @NotNull
    public String getName() {
        if (SqlImplUtil.isAsteriskRef((PsiElement)this)) {
            return "*";
        }
        SqlIdentifier identifier = this.getIdentifier();
        if (identifier != null) {
            String string = identifier.getName();
            if (string == null) {
                SqlReferenceExpressionImpl.$$$reportNull$$$0(5);
            }
            return string;
        }
        if (this.getReferenceElementType() == SqlCompositeElementTypes.SQL_PROCEDURE_REFERENCE) {
            PsiElement child = this.getLastChild();
            if (child instanceof SqlLiteralExpression) {
                String string = child.getText();
                if (string == null) {
                    SqlReferenceExpressionImpl.$$$reportNull$$$0(6);
                }
                return string;
            }
            PsiElement first2 = this.getFirstChild();
            if (first2 == child && child instanceof SqlReferenceExpression) {
                return "";
            }
        }
        String string = this.getText();
        if (string == null) {
            SqlReferenceExpressionImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    public void init(PsiElement element) {
    }

    @Override
    public boolean isPlainIdentifier() {
        SqlIdentifier identifier = this.getIdentifier();
        return identifier != null && identifier.isPlainIdentifier();
    }

    @Override
    public boolean isQuotedIdentifier() {
        SqlIdentifier identifier = this.getIdentifier();
        return identifier != null && identifier.isQuotedIdentifier();
    }

    @Override
    public SqlNameElement setName(@NotNull String newElementName) throws IncorrectOperationException {
        SqlIdentifier identifier;
        if (newElementName == null) {
            SqlReferenceExpressionImpl.$$$reportNull$$$0(8);
        }
        if ((identifier = this.getIdentifier()) != null) {
            identifier.setName(newElementName);
        }
        return this;
    }

    @Override
    @NotNull
    public SqlReferenceImpl getReference() {
        if (this.myReference == null) {
            this.myReference = new SqlReferenceImpl(this){

                @Override
                @Nullable
                public SqlExpression getQualifierExpression() {
                    return SqlReferenceExpressionImpl.this.getQualifierExpression();
                }

                @Override
                @NotNull
                public String getReferenceName() {
                    String string = SqlReferenceExpressionImpl.this.getName();
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                @Override
                protected boolean shouldProcessFunctionVariants() {
                    return SqlReferenceExpressionImpl.this.getIdentifier() != null;
                }

                @NotNull
                public TextRange getRangeInElement() {
                    Object anchor;
                    SqlReferenceExpressionImpl expr = SqlReferenceExpressionImpl.this;
                    Object object = anchor = SqlImplUtil.isRefWithDblink((PsiElement)expr) ? PsiTreeUtil.getChildOfType((PsiElement)expr, SqlReferenceExpression.class) : SqlReferenceExpressionImpl.this.getIdentifier();
                    if (anchor != null) {
                        TextRange textRange = TextRange.from((int)anchor.getStartOffsetInParent(), (int)anchor.getTextLength());
                        if (textRange == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return textRange;
                    }
                    PsiElement element = SqlReferenceExpressionImpl.this.findPsiChildByType(SqlCommonTokens.SQL_PERIOD);
                    return new TextRange(element != null ? element.getStartOffsetInParent() + 1 : 0, SqlReferenceExpressionImpl.this.getTextLength());
                }

                public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
                    if (newElementName == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return SqlReferenceExpressionImpl.this.setName(newElementName);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 2;
                        case 2 -> 3;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/sql/psi/impl/SqlReferenceExpressionImpl$1";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "newElementName";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getReferenceName";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getRangeInElement";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/sql/psi/impl/SqlReferenceExpressionImpl$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "handleElementRename";
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalStateException(string);
                        case 2 -> new IllegalArgumentException(string);
                    };
                }
            };
        }
        SqlReferenceImpl sqlReferenceImpl = this.myReference;
        if (sqlReferenceImpl == null) {
            SqlReferenceExpressionImpl.$$$reportNull$$$0(9);
        }
        return sqlReferenceImpl;
    }

    @NotNull
    public @NotNull Collection<? extends @NotNull PsiSymbolReference> getOwnReferences() {
        List<SqlReferenceImpl> list = Collections.singletonList(this.getReference());
        if (list == null) {
            SqlReferenceExpressionImpl.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Override
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        return this.getReference().multiResolve(incompleteCode);
    }

    @Override
    public ResolveResult resolveSingle() {
        return this.getReference().resolveSingle();
    }

    @Override
    @Nullable
    public PsiElement resolve() {
        return this.getReference().resolve();
    }

    @Override
    @Nullable
    public DasSymbol resolveSymbol() {
        return DasSymbolUtil.getSymbol(this.resolveSingle());
    }

    @Override
    public DasSymbol[] multiResolveSymbol() {
        return (DasSymbol[])ContainerUtil.map((Object[])this.multiResolve(false), DasSymbolUtil::getSymbol, (Object[])new DasSymbol[0]);
    }

    @Override
    @NotNull
    public SqlReferenceElementType getReferenceElementType() {
        SqlReferenceElementType sqlReferenceElementType = this.getReference().getReferenceElementType();
        if (sqlReferenceElementType == null) {
            SqlReferenceExpressionImpl.$$$reportNull$$$0(11);
        }
        return sqlReferenceElementType;
    }

    @Override
    @NotNull
    public String getReferencePart(@NotNull ObjectKind kind) {
        if (kind == null) {
            SqlReferenceExpressionImpl.$$$reportNull$$$0(12);
        }
        String string = SqlImplUtil.getCasedPart(this, kind);
        if (string == null) {
            SqlReferenceExpressionImpl.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Nullable
    public PsiMetaData getMetaData() {
        return this;
    }

    @Override
    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = this.getReferenceElementType().getTargetKind();
        if (objectKind == null) {
            SqlReferenceExpressionImpl.$$$reportNull$$$0(14);
        }
        return objectKind;
    }

    @Override
    public boolean isQuoted() {
        return this.isQuotedIdentifier();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 9, 10, 11, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlReferenceExpressionImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlReferenceExpressionImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDasType";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getReference";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnReferences";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceElementType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencePart";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getReferencePart";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 9, 10, 11, 13, 14 -> new IllegalStateException(string);
        };
    }
}

