/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.stubs;

import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlInheritedTableDefinition;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableDefinition;
import com.intellij.sql.psi.stubs.SqlDefinitionExStubElementType;
import com.intellij.sql.psi.stubs.SqlTableStub;
import com.intellij.util.NotNullFunction;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlTableElementType<S extends SqlTableStub>
extends SqlDefinitionExStubElementType<S, SqlTableDefinition> {
    public static NotNullFunction<String, SqlTableElementType<?>> factory(@NotNull SqlReferenceElementType refType) {
        if (refType == null) {
            SqlTableElementType.$$$reportNull$$$0(0);
        }
        return name2 -> new SqlTableElementType((String)name2, refType);
    }

    public SqlTableElementType(@NonNls @NotNull String debugName, @NotNull SqlReferenceElementType refType) {
        if (debugName == null) {
            SqlTableElementType.$$$reportNull$$$0(1);
        }
        if (refType == null) {
            SqlTableElementType.$$$reportNull$$$0(2);
        }
        super(debugName, refType);
    }

    protected StringRef[][] getAncestorRefs(@NotNull SqlTableDefinition psi) {
        if (psi == null) {
            SqlTableElementType.$$$reportNull$$$0(3);
        }
        StringRef[][] ancestorRefs = null;
        if (psi instanceof SqlInheritedTableDefinition) {
            SqlInheritedTableDefinition inherited = (SqlInheritedTableDefinition)psi;
            Object[] methods = inherited.getInheritanceMethods();
            ancestorRefs = new StringRef[methods.length][];
            for (int i2 = 0; i2 < methods.length; ++i2) {
                List<SqlReferenceExpression> ancestors = inherited.getAncestors(methods[i2]);
                ancestorRefs[i2] = ancestors.isEmpty() ? StringRef.EMPTY_ARRAY : new StringRef[ancestors.size()];
                for (int j = 0; j < ancestors.size(); ++j) {
                    ancestorRefs[i2][j] = StringRef.fromString((String)ancestors.get(j).getText());
                }
            }
        }
        return ancestorRefs;
    }

    @Override
    @NotNull
    public S createStub(@NotNull SqlTableDefinition psi, StubElement parentStub) {
        if (psi == null) {
            SqlTableElementType.$$$reportNull$$$0(4);
        }
        SqlExpression expression = psi.getQueryExpression();
        return (S)((Object)new SqlTableStub(parentStub, this, SqlTableElementType.asStringRef((PsiElement)psi.getNameElement()), SqlTableElementType.buildProperties(psi), expression == null ? null : StringRef.fromString((String)expression.getText()), this.getAncestorRefs(psi)));
    }

    @Override
    public void serialize(@NotNull S stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            SqlTableElementType.$$$reportNull$$$0(5);
        }
        if (dataStream == null) {
            SqlTableElementType.$$$reportNull$$$0(6);
        }
        super.serialize(stub, dataStream);
        dataStream.writeName(((SqlTableStub)((Object)stub)).getExpressionText());
        SqlTableElementType.writeStringsArray(dataStream, ((SqlTableStub)((Object)stub)).getAncestorTextRefs());
    }

    @Override
    @NotNull
    public S deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            SqlTableElementType.$$$reportNull$$$0(7);
        }
        return (S)((Object)new SqlTableStub(parentStub, this, dataStream.readName(), SqlTableElementType.loadProperties(parentStub, dataStream), dataStream.readName(), SqlTableElementType.readStringsArray(dataStream)));
    }

    private static void writeStringsArray(@NotNull StubOutputStream dataStream, StringRef[] @Nullable [] refs) throws IOException {
        if (dataStream == null) {
            SqlTableElementType.$$$reportNull$$$0(8);
        }
        if (refs == null) {
            dataStream.writeVarInt(0);
        } else {
            dataStream.writeVarInt(refs.length);
            for (StringRef[] ref : refs) {
                SqlTableElementType.writeStrings(dataStream, ref);
            }
        }
    }

    private static void writeStrings(@NotNull StubOutputStream dataStream, StringRef @NotNull [] refs) throws IOException {
        if (dataStream == null) {
            SqlTableElementType.$$$reportNull$$$0(9);
        }
        if (refs == null) {
            SqlTableElementType.$$$reportNull$$$0(10);
        }
        dataStream.writeVarInt(refs.length);
        for (StringRef ref : refs) {
            dataStream.writeName(ref.getString());
        }
    }

    private static StringRef @NotNull [] readStrings(@NotNull StubInputStream dataStream) throws IOException {
        int len;
        if (dataStream == null) {
            SqlTableElementType.$$$reportNull$$$0(11);
        }
        if ((len = dataStream.readVarInt()) == 0) {
            if (StringRef.EMPTY_ARRAY == null) {
                SqlTableElementType.$$$reportNull$$$0(12);
            }
            return StringRef.EMPTY_ARRAY;
        }
        StringRef[] res = new StringRef[len];
        for (int i2 = 0; i2 < res.length; ++i2) {
            res[i2] = dataStream.readName();
        }
        if (res == null) {
            SqlTableElementType.$$$reportNull$$$0(13);
        }
        return res;
    }

    protected static StringRef[] @Nullable [] readStringsArray(@NotNull StubInputStream dataStream) throws IOException {
        int len;
        if (dataStream == null) {
            SqlTableElementType.$$$reportNull$$$0(14);
        }
        if ((len = dataStream.readVarInt()) == 0) {
            return null;
        }
        StringRef[][] res = new StringRef[len][];
        for (int i2 = 0; i2 < res.length; ++i2) {
            res[i2] = SqlTableElementType.readStrings(dataStream);
        }
        return res;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/stubs/SqlTableElementType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/stubs/SqlTableElementType";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "readStrings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "factory";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAncestorRefs";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createStub";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "writeStringsArray";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "writeStrings";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "readStrings";
                break;
            }
            case 12: 
            case 13: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "readStringsArray";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 13 -> new IllegalStateException(string);
        };
    }
}

