/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.edgegraph;

import java.util.Collection;
import org.locationtech.jts.edgegraph.EdgeGraph;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.LineString;

public class EdgeGraphBuilder {
    private EdgeGraph graph = new EdgeGraph();

    public static EdgeGraph build(Collection geoms) {
        EdgeGraphBuilder builder = new EdgeGraphBuilder();
        builder.add(geoms);
        return builder.getGraph();
    }

    public EdgeGraph getGraph() {
        return this.graph;
    }

    public void add(Geometry geometry) {
        geometry.apply(new GeometryComponentFilter(){

            @Override
            public void filter(Geometry component) {
                if (component instanceof LineString) {
                    EdgeGraphBuilder.this.add((LineString)component);
                }
            }
        });
    }

    public void add(Collection geometries) {
        for (Geometry geometry : geometries) {
            this.add(geometry);
        }
    }

    private void add(LineString lineString) {
        CoordinateSequence seq = lineString.getCoordinateSequence();
        for (int i2 = 1; i2 < seq.size(); ++i2) {
            this.graph.addEdge(seq.getCoordinate(i2 - 1), seq.getCoordinate(i2));
        }
    }
}

