/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.triangulate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.triangulate.DelaunayTriangulationBuilder;
import org.locationtech.jts.triangulate.IncrementalDelaunayTriangulator;
import org.locationtech.jts.triangulate.quadedge.QuadEdgeSubdivision;

public class VoronoiDiagramBuilder {
    private Collection siteCoords;
    private double tolerance = 0.0;
    private QuadEdgeSubdivision subdiv = null;
    private Envelope clipEnv = null;
    private Envelope diagramEnv = null;

    public void setSites(Geometry geom) {
        this.siteCoords = DelaunayTriangulationBuilder.extractUniqueCoordinates(geom);
    }

    public void setSites(Collection coords) {
        this.siteCoords = DelaunayTriangulationBuilder.unique(CoordinateArrays.toCoordinateArray(coords));
    }

    public void setClipEnvelope(Envelope clipEnv) {
        this.clipEnv = clipEnv;
    }

    public void setTolerance(double tolerance) {
        this.tolerance = tolerance;
    }

    private void create() {
        if (this.subdiv != null) {
            return;
        }
        this.diagramEnv = this.clipEnv;
        if (this.diagramEnv == null) {
            this.diagramEnv = DelaunayTriangulationBuilder.envelope(this.siteCoords);
            double expandBy = this.diagramEnv.getDiameter();
            this.diagramEnv.expandBy(expandBy);
        }
        List vertices = DelaunayTriangulationBuilder.toVertices(this.siteCoords);
        this.subdiv = new QuadEdgeSubdivision(this.diagramEnv, this.tolerance);
        IncrementalDelaunayTriangulator triangulator = new IncrementalDelaunayTriangulator(this.subdiv);
        triangulator.insertSites(vertices);
    }

    public QuadEdgeSubdivision getSubdivision() {
        this.create();
        return this.subdiv;
    }

    public Geometry getDiagram(GeometryFactory geomFact) {
        this.create();
        Geometry polys = this.subdiv.getVoronoiDiagram(geomFact);
        return VoronoiDiagramBuilder.clipGeometryCollection(polys, this.diagramEnv);
    }

    private static Geometry clipGeometryCollection(Geometry geom, Envelope clipEnv) {
        Geometry clipPoly = geom.getFactory().toGeometry(clipEnv);
        ArrayList<Geometry> clipped = new ArrayList<Geometry>();
        for (int i2 = 0; i2 < geom.getNumGeometries(); ++i2) {
            Geometry g = geom.getGeometryN(i2);
            Geometry result2 = null;
            if (clipEnv.contains(g.getEnvelopeInternal())) {
                result2 = g;
            } else if (clipEnv.intersects(g.getEnvelopeInternal())) {
                result2 = clipPoly.intersection(g);
                result2.setUserData(g.getUserData());
            }
            if (result2 == null || result2.isEmpty()) continue;
            clipped.add(result2);
        }
        return geom.getFactory().createGeometryCollection(GeometryFactory.toGeometryArray(clipped));
    }
}

