/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.geodesic;

import org.locationtech.proj4j.geodesic.GeoMath;
import org.locationtech.proj4j.geodesic.GeodesicData;
import org.locationtech.proj4j.geodesic.GeodesicLine;
import org.locationtech.proj4j.geodesic.GeographicErr;
import org.locationtech.proj4j.geodesic.Pair;

public class Geodesic {
    protected static final int GEOGRAPHICLIB_GEODESIC_ORDER = 6;
    protected static final int nA1_ = 6;
    protected static final int nC1_ = 6;
    protected static final int nC1p_ = 6;
    protected static final int nA2_ = 6;
    protected static final int nC2_ = 6;
    protected static final int nA3_ = 6;
    protected static final int nA3x_ = 6;
    protected static final int nC3_ = 6;
    protected static final int nC3x_ = 15;
    protected static final int nC4_ = 6;
    protected static final int nC4x_ = 21;
    private static final int maxit1_ = 20;
    private static final int maxit2_ = 83;
    protected static final double tiny_ = Math.sqrt(Double.MIN_NORMAL);
    private static final double tol0_ = Math.ulp(1.0);
    private static final double tol1_ = 200.0 * tol0_;
    private static final double tol2_ = Math.sqrt(tol0_);
    private static final double tolb_ = tol0_;
    private static final double xthresh_ = 1000.0 * tol2_;
    protected double _a;
    protected double _f;
    protected double _f1;
    protected double _e2;
    protected double _ep2;
    protected double _b;
    protected double _c2;
    private double _n;
    private double _etol2;
    private double[] _A3x;
    private double[] _C3x;
    private double[] _C4x;
    public static final Geodesic WGS84 = new Geodesic(6378137.0, 0.0033528106647474805);

    public Geodesic(double a, double f) {
        this._a = a;
        this._f = f;
        this._f1 = 1.0 - this._f;
        this._e2 = this._f * (2.0 - this._f);
        this._ep2 = this._e2 / GeoMath.sq(this._f1);
        this._n = this._f / (2.0 - this._f);
        this._b = this._a * this._f1;
        this._c2 = (GeoMath.sq(this._a) + GeoMath.sq(this._b) * (this._e2 == 0.0 ? 1.0 : (this._e2 > 0.0 ? GeoMath.atanh(Math.sqrt(this._e2)) : Math.atan(Math.sqrt(-this._e2))) / Math.sqrt(Math.abs(this._e2)))) / 2.0;
        this._etol2 = 0.1 * tol2_ / Math.sqrt(Math.max(0.001, Math.abs(this._f)) * Math.min(1.0, 1.0 - this._f / 2.0) / 2.0);
        if (!Double.isFinite(this._a) || !(this._a > 0.0)) {
            throw new GeographicErr("Equatorial radius is not positive");
        }
        if (!Double.isFinite(this._b) || !(this._b > 0.0)) {
            throw new GeographicErr("Polar semi-axis is not positive");
        }
        this._A3x = new double[6];
        this._C3x = new double[15];
        this._C4x = new double[21];
        this.A3coeff();
        this.C3coeff();
        this.C4coeff();
    }

    public GeodesicData Direct(double lat1, double lon1, double azi1, double s12) {
        return this.Direct(lat1, lon1, azi1, false, s12, 1929);
    }

    public GeodesicData Direct(double lat1, double lon1, double azi1, double s12, int outmask) {
        return this.Direct(lat1, lon1, azi1, false, s12, outmask);
    }

    public GeodesicData ArcDirect(double lat1, double lon1, double azi1, double a12) {
        return this.Direct(lat1, lon1, azi1, true, a12, 1929);
    }

    public GeodesicData ArcDirect(double lat1, double lon1, double azi1, double a12, int outmask) {
        return this.Direct(lat1, lon1, azi1, true, a12, outmask);
    }

    public GeodesicData Direct(double lat1, double lon1, double azi1, boolean arcmode, double s12_a12, int outmask) {
        if (!arcmode) {
            outmask |= 0x803;
        }
        return new GeodesicLine(this, lat1, lon1, azi1, outmask).Position(arcmode, s12_a12, outmask);
    }

    public GeodesicLine DirectLine(double lat1, double lon1, double azi1, double s12) {
        return this.DirectLine(lat1, lon1, azi1, s12, 32671);
    }

    public GeodesicLine DirectLine(double lat1, double lon1, double azi1, double s12, int caps) {
        return this.GenDirectLine(lat1, lon1, azi1, false, s12, caps);
    }

    public GeodesicLine ArcDirectLine(double lat1, double lon1, double azi1, double a12) {
        return this.ArcDirectLine(lat1, lon1, azi1, a12, 32671);
    }

    public GeodesicLine ArcDirectLine(double lat1, double lon1, double azi1, double a12, int caps) {
        return this.GenDirectLine(lat1, lon1, azi1, true, a12, caps);
    }

    public GeodesicLine GenDirectLine(double lat1, double lon1, double azi1, boolean arcmode, double s12_a12, int caps) {
        azi1 = GeoMath.AngNormalize(azi1);
        Pair p2 = new Pair();
        GeoMath.sincosd(p2, GeoMath.AngRound(azi1));
        double salp1 = p2.first;
        double calp1 = p2.second;
        if (!arcmode) {
            caps |= 0x803;
        }
        return new GeodesicLine(this, lat1, lon1, azi1, salp1, calp1, caps, arcmode, s12_a12);
    }

    public GeodesicData Inverse(double lat1, double lon1, double lat2, double lon2) {
        return this.Inverse(lat1, lon1, lat2, lon2, 1929);
    }

    /*
     * Unable to fully structure code
     */
    private InverseData InverseInt(double lat1, double lon1, double lat2, double lon2, int outmask) {
        block34: {
            block35: {
                block33: {
                    result = new InverseData();
                    p = new Pair();
                    r = InverseData.access$100(result);
                    r.lat1 = lat1 = GeoMath.LatFix(lat1);
                    r.lat2 = lat2 = GeoMath.LatFix(lat2);
                    lat1 = GeoMath.AngRound(lat1);
                    lat2 = GeoMath.AngRound(lat2);
                    GeoMath.AngDiff(p, lon1, lon2);
                    lon12 = p.first;
                    lon12s = p.second;
                    if ((outmask & 32768) != 0) {
                        r.lon1 = lon1;
                        r.lon2 = lon1 + lon12 + lon12s;
                    } else {
                        r.lon1 = GeoMath.AngNormalize(lon1);
                        r.lon2 = GeoMath.AngNormalize(lon2);
                    }
                    lonsign = (int)Math.copySign(1.0, lon12);
                    lam12 = Math.toRadians(lon12 *= (double)lonsign);
                    GeoMath.sincosde(p, lon12, lon12s *= (double)lonsign);
                    slam12 = p.first;
                    clam12 = p.second;
                    lon12s = 180.0 - lon12 - lon12s;
                    v0 = swapp = Math.abs(lat1) < Math.abs(lat2) || lat2 != lat2 ? -1 : 1;
                    if (swapp < 0) {
                        lonsign *= -1;
                        t = lat1;
                        lat1 = lat2;
                        lat2 = t;
                    }
                    latsign = (int)Math.copySign(1.0, -lat1);
                    lat2 *= (double)latsign;
                    m12x = NaN;
                    s12x = NaN;
                    GeoMath.sincosd(p, lat1 *= (double)latsign);
                    sbet1 = this._f1 * p.first;
                    cbet1 = p.second;
                    GeoMath.norm(p, sbet1, cbet1);
                    sbet1 = p.first;
                    cbet1 = p.second;
                    cbet1 = Math.max(Geodesic.tiny_, cbet1);
                    GeoMath.sincosd(p, lat2);
                    sbet2 = this._f1 * p.first;
                    cbet2 = p.second;
                    GeoMath.norm(p, sbet2, cbet2);
                    sbet2 = p.first;
                    cbet2 = p.second;
                    cbet2 = Math.max(Geodesic.tiny_, cbet2);
                    if (cbet1 < -sbet1) {
                        if (cbet2 == cbet1) {
                            sbet2 = Math.copySign(sbet1, sbet2);
                        }
                    } else if (Math.abs(sbet2) == -sbet1) {
                        cbet2 = cbet1;
                    }
                    dn1 = Math.sqrt(1.0 + this._ep2 * GeoMath.sq(sbet1));
                    dn2 = Math.sqrt(1.0 + this._ep2 * GeoMath.sq(sbet2));
                    salp2 = NaN;
                    calp2 = NaN;
                    salp1 = NaN;
                    calp1 = NaN;
                    sig12 = NaN;
                    a12 = NaN;
                    C1a = new double[7];
                    C2a = new double[7];
                    C3a = new double[6];
                    meridian = lat1 == -90.0 || slam12 == 0.0;
                    v = new LengthsV();
                    if (meridian) {
                        calp1 = clam12;
                        salp1 = slam12;
                        calp2 = 1.0;
                        salp2 = 0.0;
                        ssig1 = sbet1;
                        csig1 = calp1 * cbet1;
                        ssig2 = sbet2;
                        csig2 = calp2 * cbet2;
                        sig12 = Math.atan2(Math.max(0.0, csig1 * ssig2 - ssig1 * csig2), csig1 * csig2 + ssig1 * ssig2);
                        this.Lengths(v, this._n, sig12, ssig1, csig1, dn1, ssig2, csig2, dn2, cbet1, cbet2, outmask | 1025 | 4101, C1a, C2a);
                        s12x = LengthsV.access$300(v);
                        m12x = LengthsV.access$400(v);
                        if ((outmask & 8197) != 0) {
                            r.M12 = LengthsV.access$500(v);
                            r.M21 = LengthsV.access$600(v);
                        }
                        if (sig12 < 1.0 || m12x >= 0.0) {
                            if (sig12 < 3.0 * Geodesic.tiny_ || sig12 < Geodesic.tol0_ && (s12x < 0.0 || m12x < 0.0)) {
                                s12x = 0.0;
                                m12x = 0.0;
                                sig12 = 0.0;
                            }
                            m12x *= this._b;
                            s12x *= this._b;
                            a12 = Math.toDegrees(sig12);
                        } else {
                            meridian = false;
                        }
                    }
                    omg12 = NaN;
                    somg12 = 2.0;
                    comg12 = NaN;
                    if (meridian || sbet1 != 0.0 || !(this._f <= 0.0) && !(lon12s >= this._f * 180.0)) break block33;
                    calp2 = 0.0;
                    calp1 = 0.0;
                    salp2 = 1.0;
                    salp1 = 1.0;
                    s12x = this._a * lam12;
                    sig12 = omg12 = lam12 / this._f1;
                    m12x = this._b * Math.sin(sig12);
                    if ((outmask & 8197) != 0) {
                        r.M12 = r.M21 = Math.cos(sig12);
                    }
                    a12 = lon12 / this._f1;
                    break block34;
                }
                if (meridian) break block34;
                s = this.InverseStart(sbet1, cbet1, dn1, sbet2, cbet2, dn2, lam12, slam12, clam12, C1a, C2a, p, v);
                sig12 = InverseStartV.access$700(s);
                salp1 = InverseStartV.access$800(s);
                calp1 = InverseStartV.access$900(s);
                salp2 = InverseStartV.access$1000(s);
                calp2 = InverseStartV.access$1100(s);
                dnm = InverseStartV.access$1200(s);
                if (!(sig12 >= 0.0)) break block35;
                s12x = sig12 * this._b * dnm;
                m12x = GeoMath.sq(dnm) * this._b * Math.sin(sig12 / dnm);
                if ((outmask & 8197) != 0) {
                    r.M12 = r.M21 = Math.cos(sig12 / dnm);
                }
                a12 = Math.toDegrees(sig12);
                omg12 = lam12 / (this._f1 * dnm);
                break block34;
            }
            domg12 = NaN;
            eps = NaN;
            csig2 = NaN;
            ssig2 = NaN;
            csig1 = NaN;
            ssig1 = NaN;
            numit = 0;
            salp1a = Geodesic.tiny_;
            calp1a = 1.0;
            salp1b = Geodesic.tiny_;
            calp1b = -1.0;
            w = new Lambda12V();
            tripn = false;
            tripb = false;
            while (true) {
                this.Lambda12(w, sbet1, cbet1, dn1, sbet2, cbet2, dn2, salp1, calp1, slam12, clam12, numit < 20, C1a, C2a, C3a, p, v);
                V = Lambda12V.access$1400(w);
                salp2 = Lambda12V.access$1500(w);
                calp2 = Lambda12V.access$1600(w);
                sig12 = Lambda12V.access$1700(w);
                ssig1 = Lambda12V.access$1800(w);
                csig1 = Lambda12V.access$1900(w);
                ssig2 = Lambda12V.access$2000(w);
                csig2 = Lambda12V.access$2100(w);
                eps = Lambda12V.access$2200(w);
                domg12 = Lambda12V.access$2300(w);
                dV = Lambda12V.access$2400(w);
                if (tripb) break;
                v1 = Math.abs(V);
                v2 = tripn != false ? 8 : 1;
                if (!(v1 >= (double)v2 * Geodesic.tol0_) || numit == 83) break;
                if (V > 0.0 && (numit > 20 || calp1 / salp1 > calp1b / salp1b)) {
                    salp1b = salp1;
                    calp1b = calp1;
                } else if (V < 0.0 && (numit > 20 || calp1 / salp1 < calp1a / salp1a)) {
                    salp1a = salp1;
                    calp1a = calp1;
                }
                if (numit >= 20 || !(dV > 0.0) || !(Math.abs(dalp1 = -V / dV) < 3.141592653589793)) ** GOTO lbl-1000
                sdalp1 = Math.sin(dalp1);
                cdalp1 = Math.cos(dalp1);
                nsalp1 = salp1 * cdalp1 + calp1 * sdalp1;
                if (nsalp1 > 0.0) {
                    calp1 = calp1 * cdalp1 - salp1 * sdalp1;
                    salp1 = nsalp1;
                    GeoMath.norm(p, salp1, calp1);
                    salp1 = p.first;
                    calp1 = p.second;
                    tripn = Math.abs(V) <= 16.0 * Geodesic.tol0_;
                } else lbl-1000:
                // 2 sources

                {
                    salp1 = (salp1a + salp1b) / 2.0;
                    calp1 = (calp1a + calp1b) / 2.0;
                    GeoMath.norm(p, salp1, calp1);
                    salp1 = p.first;
                    calp1 = p.second;
                    tripn = false;
                    tripb = Math.abs(salp1a - salp1) + (calp1a - calp1) < Geodesic.tolb_ || Math.abs(salp1 - salp1b) + (calp1 - calp1b) < Geodesic.tolb_;
                }
                ++numit;
            }
            lengthmask = outmask | ((outmask & 12293) != 0 ? 1025 : 0);
            this.Lengths(v, eps, sig12, ssig1, csig1, dn1, ssig2, csig2, dn2, cbet1, cbet2, lengthmask, C1a, C2a);
            s12x = LengthsV.access$300(v);
            m12x = LengthsV.access$400(v);
            if ((outmask & 8197) != 0) {
                r.M12 = LengthsV.access$500(v);
                r.M21 = LengthsV.access$600(v);
            }
            m12x *= this._b;
            s12x *= this._b;
            a12 = Math.toDegrees(sig12);
            if ((outmask & 16400) != 0) {
                sdomg12 = Math.sin(domg12);
                cdomg12 = Math.cos(domg12);
                somg12 = slam12 * cdomg12 - clam12 * sdomg12;
                comg12 = clam12 * cdomg12 + slam12 * sdomg12;
            }
        }
        if ((outmask & 1025) != 0) {
            r.s12 = 0.0 + s12x;
        }
        if ((outmask & 4101) != 0) {
            r.m12 = 0.0 + m12x;
        }
        if ((outmask & 16400) != 0) {
            salp0 = salp1 * cbet1;
            calp0 = Math.hypot(calp1, salp1 * sbet1);
            if (calp0 != 0.0 && salp0 != 0.0) {
                ssig1 = sbet1;
                csig1 = calp1 * cbet1;
                ssig2 = sbet2;
                csig2 = calp2 * cbet2;
                k2 = GeoMath.sq(calp0) * this._ep2;
                eps = k2 / (2.0 * (1.0 + Math.sqrt(1.0 + k2)) + k2);
                A4 = GeoMath.sq(this._a) * calp0 * salp0 * this._e2;
                GeoMath.norm(p, ssig1, csig1);
                ssig1 = p.first;
                csig1 = p.second;
                GeoMath.norm(p, ssig2, csig2);
                ssig2 = p.first;
                csig2 = p.second;
                C4a = new double[6];
                this.C4f(eps, C4a);
                B41 = Geodesic.SinCosSeries(false, ssig1, csig1, C4a);
                B42 = Geodesic.SinCosSeries(false, ssig2, csig2, C4a);
                r.S12 = A4 * (B42 - B41);
            } else {
                r.S12 = 0.0;
            }
            if (!meridian && somg12 == 2.0) {
                somg12 = Math.sin(omg12);
                comg12 = Math.cos(omg12);
            }
            if (!meridian && comg12 > -0.7071 && sbet2 - sbet1 < 1.75) {
                domg12 = 1.0 + comg12;
                dbet1 = 1.0 + cbet1;
                dbet2 = 1.0 + cbet2;
                alp12 = 2.0 * Math.atan2(somg12 * (sbet1 * dbet2 + sbet2 * dbet1), domg12 * (sbet1 * sbet2 + dbet1 * dbet2));
            } else {
                salp12 = salp2 * calp1 - calp2 * salp1;
                calp12 = calp2 * calp1 + salp2 * salp1;
                if (salp12 == 0.0 && calp12 < 0.0) {
                    salp12 = Geodesic.tiny_ * calp1;
                    calp12 = -1.0;
                }
                alp12 = Math.atan2(salp12, calp12);
            }
            r.S12 += this._c2 * alp12;
            r.S12 *= (double)(swapp * lonsign * latsign);
            r.S12 += 0.0;
        }
        if (swapp < 0) {
            t = salp1;
            salp1 = salp2;
            salp2 = t;
            t = calp1;
            calp1 = calp2;
            calp2 = t;
            if ((outmask & 8197) != 0) {
                t = r.M12;
                r.M12 = r.M21;
                r.M21 = t;
            }
        }
        calp1 *= (double)(swapp * latsign);
        salp2 *= (double)(swapp * lonsign);
        calp2 *= (double)(swapp * latsign);
        r.a12 = a12;
        InverseData.access$2502(result, salp1 *= (double)(swapp * lonsign));
        InverseData.access$2602(result, calp1);
        InverseData.access$2702(result, salp2);
        InverseData.access$2802(result, calp2);
        return result;
    }

    public GeodesicData Inverse(double lat1, double lon1, double lat2, double lon2, int outmask) {
        InverseData result2 = this.InverseInt(lat1, lon1, lat2, lon2, outmask &= 0xFF80);
        GeodesicData r = result2.g;
        if ((outmask & 0x200) != 0) {
            r.azi1 = GeoMath.atan2d(result2.salp1, result2.calp1);
            r.azi2 = GeoMath.atan2d(result2.salp2, result2.calp2);
        }
        return r;
    }

    public GeodesicLine InverseLine(double lat1, double lon1, double lat2, double lon2) {
        return this.InverseLine(lat1, lon1, lat2, lon2, 32671);
    }

    public GeodesicLine InverseLine(double lat1, double lon1, double lat2, double lon2, int caps) {
        InverseData result2 = this.InverseInt(lat1, lon1, lat2, lon2, 0);
        double salp1 = result2.salp1;
        double calp1 = result2.calp1;
        double azi1 = GeoMath.atan2d(salp1, calp1);
        double a12 = ((InverseData)result2).g.a12;
        if ((caps & 0x800) != 0) {
            caps |= 0x401;
        }
        return new GeodesicLine(this, lat1, lon1, azi1, salp1, calp1, caps, true, a12);
    }

    public GeodesicLine Line(double lat1, double lon1, double azi1) {
        return this.Line(lat1, lon1, azi1, 32671);
    }

    public GeodesicLine Line(double lat1, double lon1, double azi1, int caps) {
        return new GeodesicLine(this, lat1, lon1, azi1, caps);
    }

    public double EquatorialRadius() {
        return this._a;
    }

    public double Flattening() {
        return this._f;
    }

    public double EllipsoidArea() {
        return Math.PI * 4 * this._c2;
    }

    protected static double SinCosSeries(boolean sinp, double sinx, double cosx, double[] c2) {
        int k = c2.length;
        int n = k - (sinp ? 1 : 0);
        double ar = 2.0 * (cosx - sinx) * (cosx + sinx);
        double y0 = (n & 1) != 0 ? c2[--k] : 0.0;
        double y1 = 0.0;
        n /= 2;
        while (n-- != 0) {
            y1 = ar * y0 - y1 + c2[--k];
            y0 = ar * y1 - y0 + c2[--k];
        }
        return sinp ? 2.0 * sinx * cosx * y0 : cosx * (y0 - y1);
    }

    private void Lengths(LengthsV v, double eps, double sig12, double ssig1, double csig1, double dn1, double ssig2, double csig2, double dn2, double cbet1, double cbet2, int outmask, double[] C1a, double[] C2a) {
        double m0x = 0.0;
        double J12 = 0.0;
        double A1 = 0.0;
        double A2 = 0.0;
        if (((outmask &= 0xFF80) & 0x3405) != 0) {
            A1 = Geodesic.A1m1f(eps);
            Geodesic.C1f(eps, C1a);
            if ((outmask & 0x3005) != 0) {
                A2 = Geodesic.A2m1f(eps);
                Geodesic.C2f(eps, C2a);
                m0x = A1 - A2;
                A2 = 1.0 + A2;
            }
            A1 = 1.0 + A1;
        }
        if ((outmask & 0x401) != 0) {
            double B1 = Geodesic.SinCosSeries(true, ssig2, csig2, C1a) - Geodesic.SinCosSeries(true, ssig1, csig1, C1a);
            v.s12b = A1 * (sig12 + B1);
            if ((outmask & 0x3005) != 0) {
                double B2 = Geodesic.SinCosSeries(true, ssig2, csig2, C2a) - Geodesic.SinCosSeries(true, ssig1, csig1, C2a);
                J12 = m0x * sig12 + (A1 * B1 - A2 * B2);
            }
        } else if ((outmask & 0x3005) != 0) {
            for (int l = 1; l <= 6; ++l) {
                C2a[l] = A1 * C1a[l] - A2 * C2a[l];
            }
            J12 = m0x * sig12 + (Geodesic.SinCosSeries(true, ssig2, csig2, C2a) - Geodesic.SinCosSeries(true, ssig1, csig1, C2a));
        }
        if ((outmask & 0x1005) != 0) {
            v.m0 = m0x;
            v.m12b = dn2 * (csig1 * ssig2) - dn1 * (ssig1 * csig2) - csig1 * csig2 * J12;
        }
        if ((outmask & 0x2005) != 0) {
            double csig12 = csig1 * csig2 + ssig1 * ssig2;
            double t = this._ep2 * (cbet1 - cbet2) * (cbet1 + cbet2) / (dn1 + dn2);
            v.M12 = csig12 + (t * ssig2 - csig2 * J12) * ssig1 / dn1;
            v.M21 = csig12 - (t * ssig1 - csig1 * J12) * ssig2 / dn2;
        }
    }

    private static double Astroid(double x, double y) {
        double k;
        double p2 = GeoMath.sq(x);
        double q = GeoMath.sq(y);
        double r = (p2 + q - 1.0) / 6.0;
        if (q != 0.0 || !(r <= 0.0)) {
            double S = p2 * q / 4.0;
            double r2 = GeoMath.sq(r);
            double r3 = r * r2;
            double disc = S * (S + 2.0 * r3);
            double u = r;
            if (disc >= 0.0) {
                double T3;
                double T = Math.cbrt(T3 += (T3 = S + r3) < 0.0 ? -Math.sqrt(disc) : Math.sqrt(disc));
                u += T + (T != 0.0 ? r2 / T : 0.0);
            } else {
                double ang = Math.atan2(Math.sqrt(-disc), -(S + r3));
                u += 2.0 * r * Math.cos(ang / 3.0);
            }
            double v = Math.sqrt(GeoMath.sq(u) + q);
            double uv = u < 0.0 ? q / (v - u) : u + v;
            double w = (uv - q) / (2.0 * v);
            k = uv / (Math.sqrt(uv + GeoMath.sq(w)) + w);
        } else {
            k = 0.0;
        }
        return k;
    }

    private InverseStartV InverseStart(double sbet1, double cbet1, double dn1, double sbet2, double cbet2, double dn2, double lam12, double slam12, double clam12, double[] C1a, double[] C2a, Pair p2, LengthsV v) {
        double comg12;
        double somg12;
        boolean shortline;
        InverseStartV w = new InverseStartV();
        w.sig12 = -1.0;
        double sbet12 = sbet2 * cbet1 - cbet2 * sbet1;
        double cbet12 = cbet2 * cbet1 + sbet2 * sbet1;
        double sbet12a = sbet2 * cbet1 + cbet2 * sbet1;
        boolean bl = shortline = cbet12 >= 0.0 && sbet12 < 0.5 && cbet2 * lam12 < 0.5;
        if (shortline) {
            double sbetm2 = GeoMath.sq(sbet1 + sbet2);
            sbetm2 /= sbetm2 + GeoMath.sq(cbet1 + cbet2);
            w.dnm = Math.sqrt(1.0 + this._ep2 * sbetm2);
            double omg12 = lam12 / (this._f1 * w.dnm);
            somg12 = Math.sin(omg12);
            comg12 = Math.cos(omg12);
        } else {
            somg12 = slam12;
            comg12 = clam12;
        }
        w.salp1 = cbet2 * somg12;
        w.calp1 = comg12 >= 0.0 ? sbet12 + cbet2 * sbet1 * GeoMath.sq(somg12) / (1.0 + comg12) : sbet12a - cbet2 * sbet1 * GeoMath.sq(somg12) / (1.0 - comg12);
        double ssig12 = Math.hypot(w.salp1, w.calp1);
        double csig12 = sbet1 * sbet2 + cbet1 * cbet2 * comg12;
        if (shortline && ssig12 < this._etol2) {
            w.salp2 = cbet1 * somg12;
            w.calp2 = sbet12 - cbet1 * sbet2 * (comg12 >= 0.0 ? GeoMath.sq(somg12) / (1.0 + comg12) : 1.0 - comg12);
            GeoMath.norm(p2, w.salp2, w.calp2);
            w.salp2 = p2.first;
            w.calp2 = p2.second;
            w.sig12 = Math.atan2(ssig12, csig12);
        } else if (!(Math.abs(this._n) > 0.1 || csig12 >= 0.0 || ssig12 >= 6.0 * Math.abs(this._n) * Math.PI * GeoMath.sq(cbet1))) {
            double y;
            double x;
            double lamscale;
            double lam12x = Math.atan2(-slam12, -clam12);
            if (this._f >= 0.0) {
                double k2 = GeoMath.sq(sbet1) * this._ep2;
                double eps = k2 / (2.0 * (1.0 + Math.sqrt(1.0 + k2)) + k2);
                lamscale = this._f * cbet1 * this.A3f(eps) * Math.PI;
                double betscale = lamscale * cbet1;
                x = lam12x / lamscale;
                y = sbet12a / betscale;
            } else {
                double cbet12a = cbet2 * cbet1 - sbet2 * sbet1;
                double bet12a = Math.atan2(sbet12a, cbet12a);
                this.Lengths(v, this._n, Math.PI + bet12a, sbet1, -cbet1, dn1, sbet2, cbet2, dn2, cbet1, cbet2, 4101, C1a, C2a);
                double m12b = v.m12b;
                double m0 = v.m0;
                x = -1.0 + m12b / (cbet1 * cbet2 * m0 * Math.PI);
                double betscale = x < -0.01 ? sbet12a / x : -this._f * GeoMath.sq(cbet1) * Math.PI;
                lamscale = betscale / cbet1;
                y = lam12x / lamscale;
            }
            if (y > -tol1_ && x > -1.0 - xthresh_) {
                if (this._f >= 0.0) {
                    w.salp1 = Math.min(1.0, -x);
                    w.calp1 = -Math.sqrt(1.0 - GeoMath.sq(w.salp1));
                } else {
                    w.calp1 = Math.max(x > -Geodesic.tol1_ ? 0.0 : -1.0, x);
                    w.salp1 = Math.sqrt(1.0 - GeoMath.sq(w.calp1));
                }
            } else {
                double k = Geodesic.Astroid(x, y);
                double omg12a = lamscale * (this._f >= 0.0 ? -x * k / (1.0 + k) : -y * (1.0 + k) / k);
                somg12 = Math.sin(omg12a);
                comg12 = -Math.cos(omg12a);
                w.salp1 = cbet2 * somg12;
                w.calp1 = sbet12a - cbet2 * sbet1 * GeoMath.sq(somg12) / (1.0 - comg12);
            }
        }
        if (!(w.salp1 <= 0.0)) {
            GeoMath.norm(p2, w.salp1, w.calp1);
            w.salp1 = p2.first;
            w.calp1 = p2.second;
        } else {
            w.salp1 = 1.0;
            w.calp1 = 0.0;
        }
        return w;
    }

    private void Lambda12(Lambda12V w, double sbet1, double cbet1, double dn1, double sbet2, double cbet2, double dn2, double salp1, double calp1, double slam120, double clam120, boolean diffp, double[] C1a, double[] C2a, double[] C3a, Pair p2, LengthsV v) {
        if (sbet1 == 0.0 && calp1 == 0.0) {
            calp1 = -tiny_;
        }
        double salp0 = salp1 * cbet1;
        double calp0 = Math.hypot(calp1, salp1 * sbet1);
        w.ssig1 = sbet1;
        double somg1 = salp0 * sbet1;
        double comg1 = calp1 * cbet1;
        w.csig1 = comg1;
        GeoMath.norm(p2, w.ssig1, w.csig1);
        w.ssig1 = p2.first;
        w.csig1 = p2.second;
        w.salp2 = cbet2 != cbet1 ? salp0 / cbet2 : salp1;
        w.calp2 = cbet2 != cbet1 || Math.abs(sbet2) != -sbet1 ? Math.sqrt(GeoMath.sq(calp1 * cbet1) + (cbet1 < -sbet1 ? (cbet2 - cbet1) * (cbet1 + cbet2) : (sbet1 - sbet2) * (sbet1 + sbet2))) / cbet2 : Math.abs(calp1);
        w.ssig2 = sbet2;
        double somg2 = salp0 * sbet2;
        double comg2 = w.calp2 * cbet2;
        w.csig2 = comg2;
        GeoMath.norm(p2, w.ssig2, w.csig2);
        w.ssig2 = p2.first;
        w.csig2 = p2.second;
        w.sig12 = Math.atan2(Math.max(0.0, w.csig1 * w.ssig2 - w.ssig1 * w.csig2), w.csig1 * w.csig2 + w.ssig1 * w.ssig2);
        double somg12 = Math.max(0.0, comg1 * somg2 - somg1 * comg2);
        double comg12 = comg1 * comg2 + somg1 * somg2;
        double eta = Math.atan2(somg12 * clam120 - comg12 * slam120, comg12 * clam120 + somg12 * slam120);
        double k2 = GeoMath.sq(calp0) * this._ep2;
        w.eps = k2 / (2.0 * (1.0 + Math.sqrt(1.0 + k2)) + k2);
        this.C3f(w.eps, C3a);
        double B312 = Geodesic.SinCosSeries(true, w.ssig2, w.csig2, C3a) - Geodesic.SinCosSeries(true, w.ssig1, w.csig1, C3a);
        w.domg12 = -this._f * this.A3f(w.eps) * salp0 * (w.sig12 + B312);
        w.lam12 = eta + w.domg12;
        if (diffp) {
            if (w.calp2 == 0.0) {
                w.dlam12 = -2.0 * this._f1 * dn1 / sbet1;
            } else {
                this.Lengths(v, w.eps, w.sig12, w.ssig1, w.csig1, dn1, w.ssig2, w.csig2, dn2, cbet1, cbet2, 4101, C1a, C2a);
                w.dlam12 = v.m12b;
                Lambda12V lambda12V = w;
                lambda12V.dlam12 = lambda12V.dlam12 * (this._f1 / (w.calp2 * cbet2));
            }
        }
    }

    protected double A3f(double eps) {
        return GeoMath.polyval(5, this._A3x, 0, eps);
    }

    protected void C3f(double eps, double[] c2) {
        double mult = 1.0;
        int o = 0;
        for (int l = 1; l < 6; ++l) {
            int m = 6 - l - 1;
            c2[l] = (mult *= eps) * GeoMath.polyval(m, this._C3x, o, eps);
            o += m + 1;
        }
    }

    protected void C4f(double eps, double[] c2) {
        double mult = 1.0;
        int o = 0;
        for (int l = 0; l < 6; ++l) {
            int m = 6 - l - 1;
            c2[l] = mult * GeoMath.polyval(m, this._C4x, o, eps);
            o += m + 1;
            mult *= eps;
        }
    }

    protected static double A1m1f(double eps) {
        double[] coeff = new double[]{1.0, 4.0, 64.0, 0.0, 256.0};
        int m = 3;
        double t = GeoMath.polyval(m, coeff, 0, GeoMath.sq(eps)) / coeff[m + 1];
        return (t + eps) / (1.0 - eps);
    }

    protected static void C1f(double eps, double[] c2) {
        double[] coeff = new double[]{-1.0, 6.0, -16.0, 32.0, -9.0, 64.0, -128.0, 2048.0, 9.0, -16.0, 768.0, 3.0, -5.0, 512.0, -7.0, 1280.0, -7.0, 2048.0};
        double eps2 = GeoMath.sq(eps);
        double d = eps;
        int o = 0;
        for (int l = 1; l <= 6; ++l) {
            int m = (6 - l) / 2;
            c2[l] = d * GeoMath.polyval(m, coeff, o, eps2) / coeff[o + m + 1];
            o += m + 2;
            d *= eps;
        }
    }

    protected static void C1pf(double eps, double[] c2) {
        double[] coeff = new double[]{205.0, -432.0, 768.0, 1536.0, 4005.0, -4736.0, 3840.0, 12288.0, -225.0, 116.0, 384.0, -7173.0, 2695.0, 7680.0, 3467.0, 7680.0, 38081.0, 61440.0};
        double eps2 = GeoMath.sq(eps);
        double d = eps;
        int o = 0;
        for (int l = 1; l <= 6; ++l) {
            int m = (6 - l) / 2;
            c2[l] = d * GeoMath.polyval(m, coeff, o, eps2) / coeff[o + m + 1];
            o += m + 2;
            d *= eps;
        }
    }

    protected static double A2m1f(double eps) {
        double[] coeff = new double[]{-11.0, -28.0, -192.0, 0.0, 256.0};
        int m = 3;
        double t = GeoMath.polyval(m, coeff, 0, GeoMath.sq(eps)) / coeff[m + 1];
        return (t - eps) / (1.0 + eps);
    }

    protected static void C2f(double eps, double[] c2) {
        double[] coeff = new double[]{1.0, 2.0, 16.0, 32.0, 35.0, 64.0, 384.0, 2048.0, 15.0, 80.0, 768.0, 7.0, 35.0, 512.0, 63.0, 1280.0, 77.0, 2048.0};
        double eps2 = GeoMath.sq(eps);
        double d = eps;
        int o = 0;
        for (int l = 1; l <= 6; ++l) {
            int m = (6 - l) / 2;
            c2[l] = d * GeoMath.polyval(m, coeff, o, eps2) / coeff[o + m + 1];
            o += m + 2;
            d *= eps;
        }
    }

    protected void A3coeff() {
        double[] coeff = new double[]{-3.0, 128.0, -2.0, -3.0, 64.0, -1.0, -3.0, -1.0, 16.0, 3.0, -1.0, -2.0, 8.0, 1.0, -1.0, 2.0, 1.0, 1.0};
        int o = 0;
        int k = 0;
        for (int j = 5; j >= 0; --j) {
            int m = Math.min(6 - j - 1, j);
            this._A3x[k++] = GeoMath.polyval(m, coeff, o, this._n) / coeff[o + m + 1];
            o += m + 2;
        }
    }

    protected void C3coeff() {
        double[] coeff = new double[]{3.0, 128.0, 2.0, 5.0, 128.0, -1.0, 3.0, 3.0, 64.0, -1.0, 0.0, 1.0, 8.0, -1.0, 1.0, 4.0, 5.0, 256.0, 1.0, 3.0, 128.0, -3.0, -2.0, 3.0, 64.0, 1.0, -3.0, 2.0, 32.0, 7.0, 512.0, -10.0, 9.0, 384.0, 5.0, -9.0, 5.0, 192.0, 7.0, 512.0, -14.0, 7.0, 512.0, 21.0, 2560.0};
        int o = 0;
        int k = 0;
        for (int l = 1; l < 6; ++l) {
            for (int j = 5; j >= l; --j) {
                int m = Math.min(6 - j - 1, j);
                this._C3x[k++] = GeoMath.polyval(m, coeff, o, this._n) / coeff[o + m + 1];
                o += m + 2;
            }
        }
    }

    protected void C4coeff() {
        double[] coeff = new double[]{97.0, 15015.0, 1088.0, 156.0, 45045.0, -224.0, -4784.0, 1573.0, 45045.0, -10656.0, 14144.0, -4576.0, -858.0, 45045.0, 64.0, 624.0, -4576.0, 6864.0, -3003.0, 15015.0, 100.0, 208.0, 572.0, 3432.0, -12012.0, 30030.0, 45045.0, 1.0, 9009.0, -2944.0, 468.0, 135135.0, 5792.0, 1040.0, -1287.0, 135135.0, 5952.0, -11648.0, 9152.0, -2574.0, 135135.0, -64.0, -624.0, 4576.0, -6864.0, 3003.0, 135135.0, 8.0, 10725.0, 1856.0, -936.0, 225225.0, -8448.0, 4992.0, -1144.0, 225225.0, -1440.0, 4160.0, -4576.0, 1716.0, 225225.0, -136.0, 63063.0, 1024.0, -208.0, 105105.0, 3584.0, -3328.0, 1144.0, 315315.0, -128.0, 135135.0, -2560.0, 832.0, 405405.0, 128.0, 99099.0};
        int o = 0;
        int k = 0;
        for (int l = 0; l < 6; ++l) {
            for (int j = 5; j >= l; --j) {
                int m = 6 - j - 1;
                this._C4x[k++] = GeoMath.polyval(m, coeff, o, this._n) / coeff[o + m + 1];
                o += m + 2;
            }
        }
    }

    private class Lambda12V {
        private double lam12;
        private double salp2;
        private double calp2;
        private double sig12;
        private double ssig1;
        private double csig1;
        private double ssig2;
        private double csig2;
        private double eps;
        private double domg12;
        private double dlam12 = Double.NaN;

        private Lambda12V() {
            this.domg12 = Double.NaN;
            this.eps = Double.NaN;
            this.csig2 = Double.NaN;
            this.ssig2 = Double.NaN;
            this.csig1 = Double.NaN;
            this.ssig1 = Double.NaN;
            this.sig12 = Double.NaN;
            this.calp2 = Double.NaN;
            this.salp2 = Double.NaN;
            this.lam12 = Double.NaN;
        }

        static /* synthetic */ double access$1400(Lambda12V x0) {
            return x0.lam12;
        }

        static /* synthetic */ double access$1500(Lambda12V x0) {
            return x0.salp2;
        }
    }

    private class InverseStartV {
        private double sig12;
        private double salp1;
        private double calp1;
        private double salp2;
        private double calp2;
        private double dnm = Double.NaN;

        private InverseStartV() {
            this.calp2 = Double.NaN;
            this.salp2 = Double.NaN;
            this.calp1 = Double.NaN;
            this.salp1 = Double.NaN;
            this.sig12 = Double.NaN;
        }

        static /* synthetic */ double access$700(InverseStartV x0) {
            return x0.sig12;
        }
    }

    private class LengthsV {
        private double s12b;
        private double m12b;
        private double m0;
        private double M12;
        private double M21 = Double.NaN;

        private LengthsV() {
            this.M12 = Double.NaN;
            this.m0 = Double.NaN;
            this.m12b = Double.NaN;
            this.s12b = Double.NaN;
        }

        static /* synthetic */ double access$300(LengthsV x0) {
            return x0.s12b;
        }

        static /* synthetic */ double access$500(LengthsV x0) {
            return x0.M12;
        }

        static /* synthetic */ double access$600(LengthsV x0) {
            return x0.M21;
        }
    }

    private class InverseData {
        private GeodesicData g = new GeodesicData();
        private double salp1;
        private double calp1;
        private double salp2;
        private double calp2 = Double.NaN;

        private InverseData() {
            this.salp2 = Double.NaN;
            this.calp1 = Double.NaN;
            this.salp1 = Double.NaN;
        }

        static /* synthetic */ double access$2502(InverseData x0, double x1) {
            x0.salp1 = x1;
            return x0.salp1;
        }

        static /* synthetic */ double access$2602(InverseData x0, double x1) {
            x0.calp1 = x1;
            return x0.calp1;
        }

        static /* synthetic */ double access$2702(InverseData x0, double x1) {
            x0.salp2 = x1;
            return x0.salp2;
        }

        static /* synthetic */ double access$2802(InverseData x0, double x1) {
            x0.calp2 = x1;
            return x0.calp2;
        }
    }
}

