/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.proj;

import org.locationtech.proj4j.ProjCoordinate;
import org.locationtech.proj4j.ProjectionException;
import org.locationtech.proj4j.proj.Projection;
import org.locationtech.proj4j.util.ProjectionMath;

public class FoucautSinusoidalProjection
extends Projection {
    private double n;
    private double n1;
    private static final int MAX_ITER = 10;
    private static final double LOOP_TOL = 1.0E-7;

    @Override
    public ProjCoordinate project(double lplam, double lpphi, ProjCoordinate out) {
        double t = Math.cos(lpphi);
        out.x = lplam * t / (this.n + this.n1 * t);
        out.y = this.n * lpphi + this.n1 * Math.sin(lpphi);
        return out;
    }

    @Override
    public ProjCoordinate projectInverse(double xyx, double xyy, ProjCoordinate out) {
        double V;
        if (this.n != 0.0) {
            int i2;
            out.y = xyy;
            for (i2 = 10; i2 > 0; --i2) {
                V = (this.n * out.y + this.n1 * Math.sin(out.y) - xyy) / (this.n + this.n1 * Math.cos(out.y));
                out.y -= V;
                if (Math.abs(V) < 1.0E-7) break;
            }
            if (i2 == 0) {
                out.y = xyy < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
            }
        } else {
            out.y = ProjectionMath.asin(xyy);
        }
        V = Math.cos(out.y);
        out.x = xyx * (this.n + this.n1 * V) / V;
        return out;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.n < 0.0 || this.n > 1.0) {
            throw new ProjectionException("-99");
        }
        this.n1 = 1.0 - this.n;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Foucaut Sinusoidal";
    }
}

