/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.swagger.core.SwSpecificationDetectionKt;
import com.intellij.swagger.core.SwSpecificationType;
import com.intellij.swagger.core.model.SwSpecificationSchemaStorage;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/swagger/core/actions/SwOpenJsonSchemaAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwOpenJsonSchemaAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwOpenJsonSchemaAction.kt\ncom/intellij/swagger/core/actions/SwOpenJsonSchemaAction\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,33:1\n30#2,2:34\n*S KotlinDebug\n*F\n+ 1 SwOpenJsonSchemaAction.kt\ncom/intellij/swagger/core/actions/SwOpenJsonSchemaAction\n*L\n19#1:34,2\n*E\n"})
public final class SwOpenJsonSchemaAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (psiFile == null) {
            return;
        }
        PsiFile psiFile2 = psiFile;
        SwSpecificationType specificationType = SwSpecificationDetectionKt.detectSpecificationType(psiFile2);
        ComponentManager $this$service$iv = (ComponentManager)project2;
        boolean $i$f$service = false;
        Class<SwSpecificationSchemaStorage> serviceClass$iv = SwSpecificationSchemaStorage.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        Pair<VirtualFile, JsonSchemaObject> pair = ((SwSpecificationSchemaStorage)object).getSchemaFor(specificationType);
        if (pair == null) {
            return;
        }
        VirtualFile virtualFile = (VirtualFile)pair.component1();
        FileEditorManager.getInstance((Project)project2).openFile(virtualFile);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (psiFile == null) {
            return;
        }
        PsiFile psiFile2 = psiFile;
        e.getPresentation().setEnabledAndVisible(ApplicationManager.getApplication().isInternal() && !(SwSpecificationDetectionKt.detectSpecificationType(psiFile2) instanceof SwSpecificationType.UNKNOWN));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }
}

