/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.documentation;

import com.intellij.json.psi.JsonProperty;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.psi.PsiElement;
import com.intellij.swagger.core.SwSpecificationType;
import com.intellij.swagger.core.documentation.SwDocumentationUtilsKt;
import com.intellij.swagger.core.documentation.SwUrlFakeElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.YAMLKeyValue;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0007J\b\u0010\b\u001a\u00020\u0007H\u0003J\b\u0010\t\u001a\u00020\nH\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/swagger/core/documentation/SwDocumentation;", "", "swElement", "Lcom/intellij/swagger/core/documentation/SwUrlFakeElement;", "<init>", "(Lcom/intellij/swagger/core/documentation/SwUrlFakeElement;)V", "generateDoc", "", "getContent", "getSpecificationLink", "Lcom/intellij/openapi/util/text/HtmlChunk;", "Companion", "intellij.swagger.core"})
public final class SwDocumentation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SwUrlFakeElement swElement;
    @NotNull
    private static final String OPENAPI_SPECIFICATION_URL = "https://swagger.io/specification/";
    @NotNull
    private static final String SWAGGER_SPECIFICATION_URL = "https://swagger.io/specification/v2/";

    public SwDocumentation(@NotNull SwUrlFakeElement swElement) {
        Intrinsics.checkNotNullParameter((Object)((Object)swElement), (String)"swElement");
        this.swElement = swElement;
    }

    @NlsSafe
    @NotNull
    public final String generateDoc() {
        String string = new HtmlBuilder().append(this.getSpecificationLink()).append((HtmlChunk)HtmlChunk.br()).append((HtmlChunk)HtmlChunk.text((String)this.getContent()).wrapWith("pre")).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NlsSafe
    private final String getContent() {
        PsiElement parentPsi = this.swElement.getParent();
        return parentPsi instanceof JsonProperty ? SwDocumentationUtilsKt.jsonDocumentationFragment$default((JsonProperty)parentPsi, false, 2, null) : (parentPsi instanceof YAMLKeyValue ? SwDocumentationUtilsKt.yamlDocumentationFragment$default((YAMLKeyValue)parentPsi, false, 2, null) : "");
    }

    @NlsSafe
    private final HtmlChunk getSpecificationLink() {
        String string;
        SwSpecificationType swSpecificationType = this.swElement.getSpecificationType();
        if (swSpecificationType instanceof SwSpecificationType.OpenAPI3Family) {
            string = OPENAPI_SPECIFICATION_URL;
        } else if (swSpecificationType instanceof SwSpecificationType.Swagger2Family) {
            string = SWAGGER_SPECIFICATION_URL;
        } else {
            HtmlChunk htmlChunk = HtmlChunk.empty();
            Intrinsics.checkNotNullExpressionValue((Object)htmlChunk, (String)"empty(...)");
            return htmlChunk;
        }
        String specUrl = string;
        HtmlChunk.Element element = HtmlChunk.link((String)specUrl, (String)this.swElement.getSpecificationType().getPresentableName());
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"link(...)");
        return (HtmlChunk)element;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/swagger/core/documentation/SwDocumentation$Companion;", "", "<init>", "()V", "OPENAPI_SPECIFICATION_URL", "", "SWAGGER_SPECIFICATION_URL", "intellij.swagger.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

