/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.reference.definitions.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.json.JsonFileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.swagger.core.SwaggerBundle;
import com.intellij.swagger.core.SwaggerCoreIcons;
import com.intellij.swagger.core.model.api.SwDefinition;
import com.intellij.swagger.core.model.api.SwParameter;
import com.intellij.swagger.core.model.api.SwResponse;
import com.intellij.swagger.core.model.specification.SpecificationObjectDefinition;
import com.intellij.swagger.core.model.specification.SwSpecificationFile;
import com.intellij.swagger.core.reference.definitions.SwObjectCoordinates;
import com.intellij.swagger.core.reference.definitions.SwObjectDefinitionReference;
import com.intellij.swagger.core.reference.definitions.SwObjectDefinitionReferenceKt;
import com.intellij.swagger.core.reference.definitions.SwObjectDefinitionResolverKt;
import com.intellij.swagger.core.reference.definitions.completion.LocalFileCompletionProvider$completeFileSystemItems$;
import com.intellij.swagger.core.reference.definitions.completion.SwObjectDefinitionCompletionContributorKt;
import com.intellij.swagger.core.traverser.SwTreeUtil;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLFileType;
import org.jetbrains.yaml.psi.YAMLScalar;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J(\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0002J(\u0010\u0013\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0002J(\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0002J(\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0010H\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001dH\u0002J\u0018\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020 H\u0002J\u0010\u0010&\u001a\u00020 2\u0006\u0010#\u001a\u00020$H\u0002J\u0012\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\b\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010\b\u001a\u00020)H\u0002J \u0010,\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020)2\u0006\u0010-\u001a\u00020(2\u0006\u0010.\u001a\u00020 H\u0002\u00a8\u0006/"}, d2={"Lcom/intellij/swagger/core/reference/definitions/completion/LocalFileCompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "<init>", "()V", "addCompletions", "", "parameters", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "completeFileSystemItems", "element", "Lcom/intellij/psi/PsiElement;", "coordinates", "Lcom/intellij/swagger/core/reference/definitions/SwObjectCoordinates;", "caretOffsetInElement", "", "completeDefinitions", "completeFromSpecification", "psiFile", "Lcom/intellij/psi/PsiFile;", "completeDefinitionsFromSpecification", "specification", "Lcom/intellij/swagger/core/model/specification/SwSpecificationFile;", "createDefinitionLookup", "Lcom/intellij/codeInsight/lookup/LookupElement;", "objectDefinition", "Lcom/intellij/swagger/core/model/api/SwDefinition;", "definitionCoordinates", "getDefinitionHint", "", "definition", "createFileSystemItemLookup", "fileSystemItem", "Lcom/intellij/psi/PsiFileSystemItem;", "completedPathSegment", "getFileSystemItemHint", "computeReferenceRange", "Lcom/intellij/openapi/util/TextRange;", "Lcom/intellij/codeInsight/completion/InsertionContext;", "shouldQuoteEmptyReference", "", "moveCaretToInsertedFragmentEnd", "referenceRange", "replacement", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwObjectDefinitionCompletionContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwObjectDefinitionCompletionContributor.kt\ncom/intellij/swagger/core/reference/definitions/completion/LocalFileCompletionProvider\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 6 SwTreeUtil.kt\ncom/intellij/swagger/core/traverser/SwTreeUtil\n+ 7 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 8 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,186:1\n19#2:187\n19#2:202\n19#2:203\n1#3:188\n18#4:189\n477#5:190\n1321#5,2:191\n35#6,2:193\n1056#7:195\n1563#7:196\n1634#7,3:197\n1869#7,2:200\n2746#7,3:205\n1761#7,3:208\n67#8:204\n*S KotlinDebug\n*F\n+ 1 SwObjectDefinitionCompletionContributor.kt\ncom/intellij/swagger/core/reference/definitions/completion/LocalFileCompletionProvider\n*L\n46#1:187\n168#1:202\n175#1:203\n72#1:189\n73#1:190\n76#1:191,2\n96#1:193,2\n108#1:195\n109#1:196\n109#1:197,3\n110#1:200,2\n177#1:205,3\n181#1:208,3\n176#1:204\n*E\n"})
final class LocalFileCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters2, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
        YAMLScalar yAMLScalar;
        YAMLScalar originalElementOrNull;
        int caretOffsetInElement;
        YAMLScalar element;
        block12: {
            block11: {
                Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                PsiElement psiElement = parameters2.getPosition().getContainingFile().findElementAt(parameters2.getOffset());
                PsiElement $this$asSafely$iv = psiElement != null ? psiElement.getParent() : null;
                boolean $i$f$asSafely = false;
                PsiElement psiElement2 = $this$asSafely$iv;
                if (!(psiElement2 instanceof YAMLScalar)) {
                    psiElement2 = null;
                }
                YAMLScalar yAMLScalar2 = (YAMLScalar)psiElement2;
                if (yAMLScalar2 == null) {
                    return;
                }
                element = yAMLScalar2;
                caretOffsetInElement = parameters2.getOffset() - PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)element));
                originalElementOrNull = (YAMLScalar)CompletionUtil.getOriginalElement((PsiElement)((PsiElement)element));
                yAMLScalar = originalElementOrNull;
                if (yAMLScalar == null) break block11;
                PsiElement p0 = (PsiElement)yAMLScalar;
                boolean bl = false;
                TextRange textRange = ElementManipulators.getValueTextRange((PsiElement)p0);
                yAMLScalar = textRange;
                if (textRange != null) break block12;
            }
            yAMLScalar = TextRange.EMPTY_RANGE;
        }
        YAMLScalar rangeInElement = yAMLScalar;
        YAMLScalar yAMLScalar3 = originalElementOrNull;
        String string = yAMLScalar3 != null ? yAMLScalar3.getText() : null;
        if (string == null) {
            string = "";
        }
        Intrinsics.checkNotNull((Object)rangeInElement);
        SwObjectCoordinates coordinates = SwObjectDefinitionResolverKt.parseObjectCoordinates(string, (TextRange)rangeInElement);
        if (coordinates.isWebCoordinates()) {
            return;
        }
        if (coordinates.isEmpty()) {
            this.completeDefinitions((PsiElement)element, coordinates, caretOffsetInElement, result2);
            this.completeFileSystemItems((PsiElement)element, coordinates, caretOffsetInElement, result2);
        } else if (coordinates.isStorageEdited(caretOffsetInElement)) {
            this.completeFileSystemItems((PsiElement)element, coordinates, caretOffsetInElement, result2);
        } else {
            this.completeDefinitions((PsiElement)element, coordinates, caretOffsetInElement, result2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void completeFileSystemItems(PsiElement element, SwObjectCoordinates coordinates, int caretOffsetInElement, CompletionResultSet result2) {
        void $this$forEach$iv;
        Sequence $this$filterIsInstance$iv;
        Pair<String, String> pair = coordinates.computeCompletedStorageUriSegment(caretOffsetInElement);
        if (pair == null) {
            return;
        }
        Pair<String, String> pair2 = pair;
        String completeSegment = (String)pair2.component1();
        String incompleteSegment = (String)pair2.component2();
        PsiFile psiFile = element.getContainingFile().getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getOriginalFile(...)");
        VirtualFile virtualFile = SwObjectDefinitionReferenceKt.findByRelativePath(psiFile, completeSegment);
        if (virtualFile == null) {
            return;
        }
        VirtualFile directory = virtualFile;
        PsiDirectory psiDirectory = element.getManager().findDirectory(directory);
        PsiElement[] $this$orEmpty$iv = psiDirectory != null ? psiDirectory.getChildren() : null;
        boolean $i$f$orEmpty = false;
        PsiElement[] psiElementArray = $this$orEmpty$iv;
        if ($this$orEmpty$iv == null) {
            psiElementArray = new PsiElement[]{};
        }
        $this$orEmpty$iv = ArraysKt.asSequence((Object[])psiElementArray);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)completeFileSystemItems$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        $this$filterIsInstance$iv = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)sequence, LocalFileCompletionProvider::completeFileSystemItems$lambda$0), arg_0 -> LocalFileCompletionProvider.completeFileSystemItems$lambda$1(this, completeSegment, arg_0));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LookupElement it = (LookupElement)element$iv;
            boolean bl = false;
            result2.withPrefixMatcher(incompleteSegment).consume(it);
        }
    }

    private final void completeDefinitions(PsiElement element, SwObjectCoordinates coordinates, int caretOffsetInElement, CompletionResultSet result2) {
        PsiFile psiFile = element.getContainingFile().getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getOriginalFile(...)");
        PsiFile originalFile = psiFile;
        PsiFile externalFile = SwObjectDefinitionReferenceKt.findStorageFile(originalFile, coordinates.getUriValue());
        if (externalFile == null) {
            this.completeFromSpecification(originalFile, coordinates, caretOffsetInElement, result2);
        } else {
            this.completeFromSpecification(externalFile, coordinates, caretOffsetInElement, result2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void completeFromSpecification(PsiFile psiFile, SwObjectCoordinates coordinates, int caretOffsetInElement, CompletionResultSet result2) {
        void $this$iv;
        SwTreeUtil swTreeUtil = SwTreeUtil.INSTANCE;
        PsiElement psiElement$iv = (PsiElement)psiFile;
        boolean withSelf$iv = true;
        boolean $i$f$getParentOfType = false;
        SwSpecificationFile swSpecificationFile = $this$iv.getParentOfType(psiElement$iv, SwSpecificationFile.class, withSelf$iv);
        if (swSpecificationFile == null) {
            return;
        }
        SwSpecificationFile specification = swSpecificationFile;
        this.completeDefinitionsFromSpecification(specification, coordinates, caretOffsetInElement, result2);
    }

    /*
     * WARNING - void declaration
     */
    private final void completeDefinitionsFromSpecification(SwSpecificationFile specification, SwObjectCoordinates coordinates, int caretOffsetInElement, CompletionResultSet result2) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable $this$sortedBy$iv;
        String string = coordinates.computeCompletedDefinitionSegment(caretOffsetInElement);
        if (string == null) {
            string = "";
        }
        String prefix = string;
        Iterable iterable = specification.getAllLocalObjectDefinitions();
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                SwDefinition it = (SwDefinition)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName().getValue());
                it = (SwDefinition)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName().getValue())));
            }
        });
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SwDefinition swDefinition = (SwDefinition)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.createDefinitionLookup((SwDefinition)it, coordinates));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LookupElement it = (LookupElement)element$iv;
            boolean bl = false;
            result2.withPrefixMatcher(prefix).consume(it);
        }
    }

    private final LookupElement createDefinitionLookup(SwDefinition objectDefinition, SwObjectCoordinates definitionCoordinates) {
        LookupElementBuilder it = LookupElementBuilder.create((String)objectDefinition.getElementPath()).withPresentableText(objectDefinition.getName().getValue()).withTypeText(this.getDefinitionHint(objectDefinition)).withIcon(SwaggerCoreIcons.Entity).withInsertHandler((arg_0, arg_1) -> LocalFileCompletionProvider.createDefinitionLookup$lambda$6(this, definitionCoordinates, arg_0, arg_1));
        boolean bl = false;
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)((LookupElement)it), (double)10.0);
        Intrinsics.checkNotNullExpressionValue((Object)lookupElement, (String)"let(...)");
        return lookupElement;
    }

    private final String getDefinitionHint(SwDefinition definition) {
        SwDefinition swDefinition = definition;
        return swDefinition instanceof SwResponse ? SwaggerBundle.message("object.definitions.response.hint", new Object[0]) : (swDefinition instanceof SwParameter ? SwaggerBundle.message("object.definitions.parameter.hint", new Object[0]) : (swDefinition instanceof SpecificationObjectDefinition ? SwaggerBundle.message("object.definitions.swagger.v2.definition.hint", new Object[0]) : "Unknown"));
    }

    private final LookupElement createFileSystemItemLookup(PsiFileSystemItem fileSystemItem, String completedPathSegment) {
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)fileSystemItem.getName()).withIcon(fileSystemItem.getIcon(0)).withTypeText(this.getFileSystemItemHint(fileSystemItem)).withInsertHandler((arg_0, arg_1) -> LocalFileCompletionProvider.createFileSystemItemLookup$lambda$9(this, completedPathSegment, fileSystemItem, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"withInsertHandler(...)");
        return (LookupElement)lookupElementBuilder;
    }

    private final String getFileSystemItemHint(PsiFileSystemItem fileSystemItem) {
        PsiFileSystemItem psiFileSystemItem = fileSystemItem;
        return psiFileSystemItem instanceof PsiFile ? SwaggerBundle.message("completion.file.hint", new Object[0]) : (psiFileSystemItem instanceof PsiDirectory ? SwaggerBundle.message("completion.directory.hint", new Object[0]) : "");
    }

    private final TextRange computeReferenceRange(InsertionContext context) {
        PsiReference $this$asSafely$iv = context.getFile().findReferenceAt(context.getStartOffset());
        boolean $i$f$asSafely = false;
        PsiReference psiReference = $this$asSafely$iv;
        if (!(psiReference instanceof SwObjectDefinitionReference)) {
            psiReference = null;
        }
        SwObjectDefinitionReference swObjectDefinitionReference = (SwObjectDefinitionReference)psiReference;
        if (swObjectDefinitionReference == null) {
            return null;
        }
        SwObjectDefinitionReference definitionReference = swObjectDefinitionReference;
        TextRange textRange = definitionReference.getRangeInElement();
        PsiElement psiElement = definitionReference.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
        return textRange.shiftRight(PsiTreeUtilKt.getStartOffset((PsiElement)psiElement));
    }

    /*
     * WARNING - void declaration
     */
    private final boolean shouldQuoteEmptyReference(InsertionContext context) {
        boolean bl;
        block7: {
            void $this$parentOfType$iv;
            void $this$asSafely$iv;
            if (!Intrinsics.areEqual((Object)context.getFile().getFileType(), (Object)YAMLFileType.YML)) {
                return false;
            }
            PsiReference psiReference = context.getFile().findReferenceAt(context.getStartOffset());
            boolean $i$f$asSafely22 = false;
            Object v0 = $this$asSafely$iv;
            if (!(v0 instanceof SwObjectDefinitionReference)) {
                v0 = null;
            }
            SwObjectDefinitionReference swObjectDefinitionReference = v0;
            if (swObjectDefinitionReference == null) {
                return false;
            }
            SwObjectDefinitionReference definitionReference = swObjectDefinitionReference;
            PsiElement psiElement = definitionReference.getElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
            PsiElement $i$f$asSafely22 = psiElement;
            boolean withSelf$iv = true;
            boolean $i$f$parentOfType = false;
            Object object = (YAMLScalar)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, YAMLScalar.class, (boolean)false);
            if (object == null || (object = object.getText()) == null) {
                return true;
            }
            Object elementText = object;
            Iterable $this$none$iv = SwObjectDefinitionCompletionContributorKt.access$getEXPECTED_YAML_QUOTES$p();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    String p0 = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith$default((String)elementText, (String)p0, (boolean)false, (int)2, null)) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final void moveCaretToInsertedFragmentEnd(InsertionContext context, TextRange referenceRange, String replacement) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = SwObjectDefinitionCompletionContributorKt.access$getEXPECTED_YAML_QUOTES$p();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String p0 = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.endsWith$default((String)replacement, (String)p0, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        int quoteLength = bl ? 1 : 0;
        context.getEditor().getCaretModel().moveToOffset(referenceRange.getStartOffset() + replacement.length() - quoteLength);
    }

    private static final boolean completeFileSystemItems$lambda$0(PsiFileSystemItem it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isDirectory() || it.getVirtualFile().getFileType() instanceof YAMLFileType || it.getVirtualFile().getFileType() instanceof JsonFileType;
    }

    private static final LookupElement completeFileSystemItems$lambda$1(LocalFileCompletionProvider this$0, String $completeSegment, PsiFileSystemItem it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.createFileSystemItemLookup(it, $completeSegment);
    }

    private static final void createDefinitionLookup$lambda$6(LocalFileCompletionProvider this$0, SwObjectCoordinates $definitionCoordinates, InsertionContext context, LookupElement item) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        TextRange textRange = this$0.computeReferenceRange(context);
        if (textRange == null) {
            return;
        }
        TextRange referenceRange = textRange;
        String string = $definitionCoordinates.getUriValue();
        if (string == null) {
            string = "";
        }
        String replacement = string + "#/" + item.getLookupString();
        String maybeQuotedReplacement = this$0.shouldQuoteEmptyReference(context) ? "\"" + replacement + "\"" : replacement;
        context.getDocument().replaceString(referenceRange.getStartOffset(), referenceRange.getEndOffset(), (CharSequence)maybeQuotedReplacement);
        this$0.moveCaretToInsertedFragmentEnd(context, referenceRange, maybeQuotedReplacement);
    }

    private static final void createFileSystemItemLookup$lambda$9(LocalFileCompletionProvider this$0, String $completedPathSegment, PsiFileSystemItem $fileSystemItem, InsertionContext context, LookupElement item) {
        String string;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        TextRange textRange = this$0.computeReferenceRange(context);
        if (textRange == null) {
            return;
        }
        TextRange referenceRange = textRange;
        String string2 = string = "/";
        String string3 = item.getLookupString();
        String string4 = $completedPathSegment;
        boolean bl = false;
        boolean bl2 = $fileSystemItem.isDirectory();
        String string5 = bl2 ? string : null;
        if (string5 == null) {
            string5 = "";
        }
        String replacement = string4 + "/" + string3 + string5;
        String maybeQuotedReplacement = this$0.shouldQuoteEmptyReference(context) ? "\"" + replacement + "\"" : replacement;
        context.getDocument().replaceString(referenceRange.getStartOffset(), referenceRange.getEndOffset(), (CharSequence)maybeQuotedReplacement);
        this$0.moveCaretToInsertedFragmentEnd(context, referenceRange, maybeQuotedReplacement);
    }
}

