/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslPath;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.eel.EelApi;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.EelExecApi;
import com.intellij.platform.eel.EelExecApiHelpers;
import com.intellij.platform.eel.EelExecApiHelpersKt;
import com.intellij.platform.eel.EelProcess;
import com.intellij.platform.eel.ExecuteProcessException;
import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import com.intellij.util.PathUtil;
import com.intellij.util.system.OS;
import com.jediterm.core.util.TermSize;
import com.jediterm.terminal.TtyConnector;
import com.pty4j.PtyProcess;
import java.lang.ref.WeakReference;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.AbstractTerminalRunner;
import org.jetbrains.plugins.terminal.ShellProcessHolder;
import org.jetbrains.plugins.terminal.ShellStartupOptions;
import org.jetbrains.plugins.terminal.TerminalStartupEelContext;
import org.jetbrains.plugins.terminal.TerminalStartupKt;
import org.jetbrains.plugins.terminal.TerminalStartupMoment;
import org.jetbrains.plugins.terminal.util.ShellNameUtil;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000~\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a(\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0000\u001aF\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u001a*\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0082@\u00a2\u0006\u0002\u0010\u001b\u001a\u0016\u0010\u001c\u001a\u00020\u001d2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002\u001a \u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u00112\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0000\u001a\u001e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00152\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002\u001a\u0018\u0010%\u001a\u0004\u0018\u00010\u00112\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002\u001aH\u0010&\u001a\u00020'2\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00132\u0006\u0010$\u001a\u00020(2\u0006\u0010\u0016\u001a\u00020\u0017H\u0082@\u00a2\u0006\u0002\u0010)\u001a\b\u0010*\u001a\u00020\u001dH\u0000\"\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"initStartupMomentIfNeeded", "Lorg/jetbrains/plugins/terminal/ShellStartupOptions$Builder;", "logCommonStartupInfo", "", "connector", "Lcom/jediterm/terminal/TtyConnector;", "process", "Ljava/lang/Process;", "durationBetweenStartupAndComponentResized", "Ljava/time/Duration;", "durationBetweenStartupAndConnectorCreated", "startProcess", "Lkotlin/Pair;", "Lcom/pty4j/PtyProcess;", "Lorg/jetbrains/plugins/terminal/ShellProcessHolder;", "command", "", "", "envs", "", "initialWorkingDirectory", "Ljava/nio/file/Path;", "initialTermSize", "Lcom/jediterm/core/util/TermSize;", "convertCommandToRemote", "eelApi", "Lcom/intellij/platform/eel/EelApi;", "(Lcom/intellij/platform/eel/EelApi;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isWslCommand", "", "findEelDescriptor", "Lcom/intellij/platform/eel/EelDescriptor;", "workingDir", "shellCommand", "buildStartupEelContext", "Lorg/jetbrains/plugins/terminal/TerminalStartupEelContext;", "workingDirectory", "getWslDistributionNameFromCommand", "doStartProcess", "Lcom/intellij/platform/eel/EelProcess;", "Lcom/intellij/platform/eel/path/EelPath;", "(Lcom/intellij/platform/eel/EelApi;Ljava/util/List;Ljava/util/Map;Lcom/intellij/platform/eel/path/EelPath;Lcom/jediterm/core/util/TermSize;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "shouldUseEelApi", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nterminalStartup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 terminalStartup.kt\norg/jetbrains/plugins/terminal/TerminalStartupKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,224:1\n14#2:225\n*S KotlinDebug\n*F\n+ 1 terminalStartup.kt\norg/jetbrains/plugins/terminal/TerminalStartupKt\n*L\n223#1:225\n*E\n"})
public final class TerminalStartupKt {
    @NotNull
    private static final Logger log;

    @NotNull
    public static final ShellStartupOptions.Builder initStartupMomentIfNeeded(@NotNull ShellStartupOptions.Builder $this$initStartupMomentIfNeeded) {
        ShellStartupOptions.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$initStartupMomentIfNeeded, (String)"<this>");
        ShellStartupOptions.Builder $this$initStartupMomentIfNeeded_u24lambda_u240 = builder = $this$initStartupMomentIfNeeded;
        boolean bl = false;
        TerminalStartupMoment terminalStartupMoment = $this$initStartupMomentIfNeeded_u24lambda_u240.getStartupMoment$intellij_terminal();
        if (terminalStartupMoment == null) {
            terminalStartupMoment = new TerminalStartupMoment();
        }
        $this$initStartupMomentIfNeeded_u24lambda_u240.startupMoment(terminalStartupMoment);
        return builder;
    }

    public static final void logCommonStartupInfo(@NotNull TtyConnector connector, @NotNull Process process, @NotNull Duration durationBetweenStartupAndComponentResized, @NotNull Duration durationBetweenStartupAndConnectorCreated) {
        Intrinsics.checkNotNullParameter((Object)connector, (String)"connector");
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        Intrinsics.checkNotNullParameter((Object)durationBetweenStartupAndComponentResized, (String)"durationBetweenStartupAndComponentResized");
        Intrinsics.checkNotNullParameter((Object)durationBetweenStartupAndConnectorCreated, (String)"durationBetweenStartupAndConnectorCreated");
        log.info("Terminal started with " + connector.getClass().getName() + " (" + process.getClass().getName() + "), time to UI laid out: " + durationBetweenStartupAndComponentResized.toMillis() + " ms, time to process created: " + durationBetweenStartupAndConnectorCreated.toMillis() + " ms");
    }

    @NotNull
    public static final Pair<PtyProcess, ShellProcessHolder> startProcess(@NotNull List<String> command2, @NotNull Map<String, String> envs, @NotNull Path initialWorkingDirectory, @NotNull TermSize initialTermSize) throws ExecuteProcessException {
        Intrinsics.checkNotNullParameter(command2, (String)"command");
        Intrinsics.checkNotNullParameter(envs, (String)"envs");
        Intrinsics.checkNotNullParameter((Object)initialWorkingDirectory, (String)"initialWorkingDirectory");
        Intrinsics.checkNotNullParameter((Object)initialTermSize, (String)"initialTermSize");
        return (Pair)CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Pair<? extends PtyProcess, ? extends ShellProcessHolder>>, Object>(initialWorkingDirectory, command2, envs, initialTermSize, null){
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            int label;
            final /* synthetic */ Path $initialWorkingDirectory;
            final /* synthetic */ List<String> $command;
            final /* synthetic */ Map<String, String> $envs;
            final /* synthetic */ TermSize $initialTermSize;
            {
                this.$initialWorkingDirectory = $initialWorkingDirectory;
                this.$command = $command;
                this.$envs = $envs;
                this.$initialTermSize = $initialTermSize;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        context = TerminalStartupKt.access$buildStartupEelContext(this.$initialWorkingDirectory, this.$command);
                        this.L$0 = context;
                        this.label = 1;
                        v0 = context.getEelDescriptor().toEelApi((Continuation)this);
                        if (v0 == var8_2) {
                            return var8_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        context = (TerminalStartupEelContext)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        eelApi = (EelApi)v0;
                        this.L$0 = context;
                        this.L$1 = eelApi;
                        this.label = 2;
                        v1 = TerminalStartupKt.access$convertCommandToRemote(eelApi, this.$command, (Continuation)this);
                        if (v1 == var8_2) {
                            return var8_2;
                        }
                        ** GOTO lbl29
                    }
                    case 2: {
                        eelApi = (EelApi)this.L$1;
                        context = (TerminalStartupEelContext)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl29:
                        // 2 sources

                        remoteCommand = (List)v1;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)context);
                        this.L$1 = eelApi;
                        this.L$2 = remoteCommand;
                        this.label = 3;
                        v2 = context.getWorkingDirectoryProvider().invoke((Object)eelApi, (Object)this);
                        if (v2 == var8_2) {
                            return var8_2;
                        }
                        ** GOTO lbl44
                    }
                    case 3: {
                        remoteCommand = (List)this.L$2;
                        eelApi = (EelApi)this.L$1;
                        context = (TerminalStartupEelContext)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl44:
                        // 2 sources

                        workingDirectory = (EelPath)v2;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)context);
                        this.L$1 = eelApi;
                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)remoteCommand);
                        this.L$3 = SpillingKt.nullOutSpilledVariable((Object)workingDirectory);
                        this.label = 4;
                        v3 = TerminalStartupKt.access$doStartProcess(eelApi, remoteCommand, this.$envs, workingDirectory, this.$initialTermSize, (Continuation)this);
                        if (v3 == var8_2) {
                            return var8_2;
                        }
                        ** GOTO lbl61
                    }
                    case 4: {
                        workingDirectory = (EelPath)this.L$3;
                        remoteCommand = (List)this.L$2;
                        eelApi = (EelApi)this.L$1;
                        context = (TerminalStartupEelContext)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl61:
                        // 2 sources

                        process = (EelProcess)v3;
                        v4 = process.convertToJavaProcess();
                        Intrinsics.checkNotNull((Object)v4, (String)"null cannot be cast to non-null type com.pty4j.PtyProcess");
                        ptyProcess = (PtyProcess)v4;
                        return TuplesKt.to((Object)ptyProcess, (Object)new ShellProcessHolder(process.getPid(), new WeakReference<PtyProcess>(ptyProcess), eelApi));
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Pair<? extends PtyProcess, ShellProcessHolder>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    /*
     * Unable to fully structure code
     */
    private static final Object convertCommandToRemote(EelApi eelApi, List<String> command, Continuation<? super List<String>> $completion) {
        if (!($completion instanceof convertCommandToRemote.1)) ** GOTO lbl-1000
        var6_3 = $completion;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return TerminalStartupKt.access$convertCommandToRemote(null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (Intrinsics.areEqual((Object)eelApi.getDescriptor(), (Object)LocalEelDescriptor.INSTANCE) || !TerminalStartupKt.isWslCommand(command)) break;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)eelApi);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)command);
                $continuation.label = 1;
                v0 = eelApi.getExec().fetchLoginShellEnvVariables((Continuation)$continuation);
                if (v0 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl25
            }
            case 1: {
                command = (List)$continuation.L$1;
                eelApi = (EelApi)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                if ((v1 = (String)((Map)v0).get("SHELL")) == null) {
                    v1 = "/bin/sh";
                }
                shell = v1;
                var4_7 = new String[]{shell, "--login", "-i"};
                return CollectionsKt.listOf((Object[])var4_7);
            }
        }
        return command;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final boolean isWslCommand(List<String> command2) {
        if (SystemInfo.isWindows) {
            String string = (String)CollectionsKt.getOrNull(command2, (int)0);
            if (string == null) {
                return false;
            }
            String exePath = string;
            String string2 = PathUtil.getFileName((String)exePath);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFileName(...)");
            String exeFileName = string2;
            return StringsKt.equals((String)exeFileName, (String)"wsl.exe", (boolean)true) || StringsKt.equals((String)exeFileName, (String)"wsl", (boolean)true);
        }
        return false;
    }

    @NotNull
    public static final EelDescriptor findEelDescriptor(@Nullable String workingDir, @NotNull List<String> shellCommand) {
        Path path;
        Intrinsics.checkNotNullParameter(shellCommand, (String)"shellCommand");
        if (!TerminalStartupKt.shouldUseEelApi()) {
            return (EelDescriptor)LocalEelDescriptor.INSTANCE;
        }
        CharSequence charSequence = workingDir;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            log.info("Cannot find EelDescriptor due to empty working directory. Fallback to LocalEelDescriptor.");
            return (EelDescriptor)LocalEelDescriptor.INSTANCE;
        }
        try {
            path = Path.of(workingDir, new String[0]);
            Intrinsics.checkNotNull((Object)path);
        }
        catch (InvalidPathException e) {
            log.warn("Cannot find EelDescriptor due to invalid working directory (" + workingDir + "). Fallback to LocalEelDescriptor", (Throwable)e);
            return (EelDescriptor)LocalEelDescriptor.INSTANCE;
        }
        Path workingDirectoryNioPath = path;
        try {
            path = TerminalStartupKt.buildStartupEelContext(workingDirectoryNioPath, shellCommand).getEelDescriptor();
        }
        catch (Exception e) {
            log.warn("Cannot find EelDescriptor: " + e.getMessage());
            path = (EelDescriptor)LocalEelDescriptor.INSTANCE;
        }
        return path;
    }

    private static final TerminalStartupEelContext buildStartupEelContext(Path workingDirectory, List<String> shellCommand) {
        String executable = (String)CollectionsKt.firstOrNull(shellCommand);
        if (OS.CURRENT == OS.Windows && executable != null && (ShellNameUtil.isPowerShell(executable) || OSAgnosticPathUtil.isAbsoluteDosPath((String)executable))) {
            return new TerminalStartupEelContext((EelDescriptor)LocalEelDescriptor.INSTANCE, (Function2<? super EelApi, ? super Continuation<? super EelPath>, ? extends Object>)((Function2)new Function2<EelApi, Continuation<? super EelPath>, Object>(workingDirectory, null){
                int label;
                final /* synthetic */ Path $workingDirectory;
                {
                    this.$workingDirectory = $workingDirectory;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            return EelPath.Companion.parse(((Object)this.$workingDirectory).toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(EelApi p1, Continuation<? super EelPath> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }
        String wslDistribNameFromCommandline = TerminalStartupKt.getWslDistributionNameFromCommand(shellCommand);
        if (wslDistribNameFromCommandline != null) {
            String wslDistribNameFromWorkingDirectory;
            WslPath wslPath = WslPath.Companion.parseWindowsUncPath(((Object)workingDirectory).toString());
            String string = wslDistribNameFromWorkingDirectory = wslPath != null ? wslPath.getDistributionId() : null;
            if (!Intrinsics.areEqual((Object)wslDistribNameFromCommandline, (Object)wslDistribNameFromWorkingDirectory)) {
                Path path = new WSLDistribution(wslDistribNameFromCommandline).getUNCRootPath();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getUNCRootPath(...)");
                Path wslRootPath = path;
                EelDescriptor eelDescriptor = EelProviderUtil.getEelDescriptor((Path)wslRootPath);
                if (!Intrinsics.areEqual((Object)eelDescriptor, (Object)LocalEelDescriptor.INSTANCE)) {
                    return new TerminalStartupEelContext(eelDescriptor, (Function2<? super EelApi, ? super Continuation<? super EelPath>, ? extends Object>)((Function2)new Function2<EelApi, Continuation<? super EelPath>, Object>(null){
                        int label;
                        /* synthetic */ Object L$0;

                        /*
                         * WARNING - void declaration
                         */
                        public final Object invokeSuspend(Object $result) {
                            EelApi eelApi = (EelApi)this.L$0;
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    void eelApi2;
                                    ResultKt.throwOnFailure((Object)$result);
                                    return eelApi2.getUserInfo().getHome();
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            var var3_3 = new /* invalid duplicate definition of identical inner class */;
                            var3_3.L$0 = value;
                            return (Continuation)var3_3;
                        }

                        public final Object invoke(EelApi p1, Continuation<? super EelPath> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }));
                }
            }
        }
        EelPath workingDirectoryEelPath = EelNioBridgeServiceKt.asEelPath((Path)workingDirectory);
        return new TerminalStartupEelContext(workingDirectoryEelPath.getDescriptor(), (Function2<? super EelApi, ? super Continuation<? super EelPath>, ? extends Object>)((Function2)new Function2<EelApi, Continuation<? super EelPath>, Object>(workingDirectoryEelPath, null){
            int label;
            final /* synthetic */ EelPath $workingDirectoryEelPath;
            {
                this.$workingDirectoryEelPath = $workingDirectoryEelPath;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        return this.$workingDirectoryEelPath;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(EelApi p1, Continuation<? super EelPath> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private static final String getWslDistributionNameFromCommand(List<String> command2) {
        String distributionOptionName;
        if (TerminalStartupKt.isWslCommand(command2) && (Intrinsics.areEqual((Object)(distributionOptionName = (String)CollectionsKt.getOrNull(command2, (int)1)), (Object)"-d") || Intrinsics.areEqual((Object)distributionOptionName, (Object)"--distribution"))) {
            return (String)CollectionsKt.getOrNull(command2, (int)2);
        }
        return null;
    }

    private static final Object doStartProcess(EelApi eelApi, List<String> command2, Map<String, String> envs, EelPath workingDirectory, TermSize initialTermSize, Continuation<? super EelProcess> $completion) throws ExecuteProcessException {
        EelExecApiHelpers.SpawnProcess execOptions = EelExecApiHelpersKt.spawnProcess((EelExecApi)eelApi.getExec(), (String)((String)CollectionsKt.first(command2))).args(CollectionsKt.takeLast(command2, (int)(command2.size() - 1))).env(envs).workingDirectory(workingDirectory).interactionOptions((EelExecApi.InteractionOptions)new EelExecApi.Pty(initialTermSize.getColumns(), initialTermSize.getRows(), true));
        return execOptions.eelIt($completion);
    }

    public static final boolean shouldUseEelApi() {
        return Registry.Companion.is("terminal.use.EelApi", true);
    }

    public static final /* synthetic */ Logger access$getLog$p() {
        return log;
    }

    public static final /* synthetic */ TerminalStartupEelContext access$buildStartupEelContext(Path workingDirectory, List shellCommand) {
        return TerminalStartupKt.buildStartupEelContext(workingDirectory, shellCommand);
    }

    public static final /* synthetic */ Object access$convertCommandToRemote(EelApi eelApi, List command2, Continuation $completion) {
        return TerminalStartupKt.convertCommandToRemote(eelApi, command2, (Continuation<? super List<String>>)$completion);
    }

    public static final /* synthetic */ Object access$doStartProcess(EelApi eelApi, List command2, Map envs, EelPath workingDirectory, TermSize initialTermSize, Continuation $completion) {
        return TerminalStartupKt.doStartProcess(eelApi, command2, envs, workingDirectory, initialTermSize, (Continuation<? super EelProcess>)$completion);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AbstractTerminalRunner.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
    }
}

