/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.psi.mixins;

import com.intellij.lang.ASTNode;
import com.intellij.lang.puppet.psi.PsiPuppetDataTypeParametersBlock;
import com.intellij.lang.puppet.psi.PuppetDataType;
import com.intellij.lang.puppet.psi.PuppetDataTypeParameterInfo;
import com.intellij.lang.puppet.psi.PuppetDataTypes;
import com.intellij.lang.puppet.psi.PuppetTypeHolder;
import com.intellij.lang.puppet.psi.impl.PuppetCompositePsiElementBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PuppetDataTypeMixin
extends PuppetCompositePsiElementBase
implements PuppetDataType {
    private static final Set<String> TYPES_DELEGATING_TO_FIRST_PARAMETER = Set.of(LOWERCASE_TYPE_TYPE_NAME, LOWERCASE_RESOURCE_TYPE_NAME);

    public PuppetDataTypeMixin(@NotNull ASTNode node) {
        if (node == null) {
            PuppetDataTypeMixin.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Override
    @Nullable
    public String getEffectiveTypeName() {
        String qualifyingTypeName = this.getQualifyingTypeName();
        if (StringUtil.isEmpty((String)qualifyingTypeName)) {
            return null;
        }
        List<PsiElement> list = this.getParametersList();
        if (list == null) {
            return qualifyingTypeName;
        }
        if (list.isEmpty()) {
            return null;
        }
        PsiElement firstParameter = list.get(0);
        assert (!StringUtil.hasUpperCaseChar((String)qualifyingTypeName));
        if (TYPES_DELEGATING_TO_FIRST_PARAMETER.contains(qualifyingTypeName) && firstParameter instanceof PuppetTypeHolder) {
            return ((PuppetTypeHolder)firstParameter).getEffectiveTypeName();
        }
        return qualifyingTypeName;
    }

    @Override
    @Nullable
    public String getQualifyingTypeName() {
        PsiElement child = this.getFirstChild();
        return child == null ? null : StringUtil.toLowerCase((String)child.getText());
    }

    @Override
    @Nullable
    public List<PsiElement> getParametersList() {
        PsiPuppetDataTypeParametersBlock block = this.getDataTypeParametersBlock();
        return block == null ? null : Arrays.asList(block.getChildren());
    }

    @Override
    @Nullable
    public String getEffectiveClassName() {
        String typeName = this.getQualifyingTypeName();
        if (!StringUtil.equals((CharSequence)LOWERCASE_CLASS_TYPE_NAME, (CharSequence)typeName)) {
            return null;
        }
        PsiElement firstParameter = this.getParameterElement(0);
        return firstParameter instanceof PuppetTypeHolder ? ((PuppetTypeHolder)firstParameter).getEffectiveTypeName() : null;
    }

    @Override
    @Nullable
    public PsiElement getParameterElement(int parameterIndex) {
        List<PsiElement> parametersList = this.getParametersList();
        if (parametersList == null || parameterIndex < 0 || parametersList.size() - 1 < parameterIndex) {
            return null;
        }
        return parametersList.get(parameterIndex);
    }

    @Override
    @Nullable
    public PuppetDataTypeParameterInfo getParameterInfo(@NotNull PsiElement parameterElement) {
        List<PsiElement> list;
        if (parameterElement == null) {
            PuppetDataTypeMixin.$$$reportNull$$$0(1);
        }
        if ((list = this.getParametersList()) == null || list.isEmpty()) {
            return null;
        }
        int parameterIndex = list.lastIndexOf(parameterElement);
        if (parameterIndex == -1) {
            return null;
        }
        String typeName = this.getQualifyingTypeName();
        if (StringUtil.equalsIgnoreCase((CharSequence)typeName, (CharSequence)"Resource")) {
            if (parameterIndex == 0) {
                return PuppetDataTypeParameterInfo.forResourceType();
            }
            PsiElement typeSpecifier = this.getParameterElement(0);
            if (typeSpecifier instanceof PuppetTypeHolder) {
                return PuppetDataTypeParameterInfo.forResourceInstance(((PuppetTypeHolder)typeSpecifier).getEffectiveTypeName());
            }
        } else {
            if (StringUtil.equalsIgnoreCase((CharSequence)typeName, (CharSequence)"Class")) {
                return PuppetDataTypeParameterInfo.forClass();
            }
            if (StringUtil.equalsIgnoreCase((CharSequence)typeName, (CharSequence)"Type")) {
                return PuppetDataTypeParameterInfo.forAnyType();
            }
            if (StringUtil.equalsIgnoreCase((CharSequence)typeName, (CharSequence)"Variant")) {
                return PuppetDataTypeParameterInfo.forAnyType();
            }
            if (!PuppetDataTypes.ALL_LOWERCASED_DATA_TYPES.contains(typeName)) {
                return PuppetDataTypeParameterInfo.forResourceInstance(this.getEffectiveTypeName());
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterElement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/puppet/psi/mixins/PuppetDataTypeMixin";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getParameterInfo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

