/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.PgGPlumJdbcHelperBase;
import java.sql.Connection;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GPlumJdbcHelper
extends PgGPlumJdbcHelperBase {
    private static final Pattern GPLUM_VERSION_PATTERN = Pattern.compile("greenplum database\\s+" + JdbcNativeUtil.DEFAULT_VERSION_PATTERN, 2);

    public GPlumJdbcHelper() {
        this(null, null, null);
    }

    private GPlumJdbcHelper(@Nullable String version, @Nullable Connection connection, @Nullable ClassLoader jdbcClassLoader) {
        super("GREENPLUM", version, connection, jdbcClassLoader);
    }

    private GPlumJdbcHelper(@NotNull GPlumJdbcHelper helper, @NotNull ClassLoader jdbcClassLoader) {
        if (helper == null) {
            GPlumJdbcHelper.$$$reportNull$$$0(0);
        }
        if (jdbcClassLoader == null) {
            GPlumJdbcHelper.$$$reportNull$$$0(1);
        }
        super(helper, jdbcClassLoader);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return GPlumJdbcHelper.extractVersion(version);
    }

    @Override
    public JdbcHelperImpl create(@Nullable String version, @Nullable Connection connection, @Nullable ClassLoader jdbcClassLoader) {
        return new GPlumJdbcHelper(version, connection, jdbcClassLoader);
    }

    @Override
    public JdbcHelperImpl bindClassLoader(@NotNull ClassLoader jdbcClassLoader) {
        if (jdbcClassLoader == null) {
            GPlumJdbcHelper.$$$reportNull$$$0(2);
        }
        return new GPlumJdbcHelper(this, jdbcClassLoader);
    }

    @NotNull
    static JdbcHelperImpl create(@Nullable Connection delegate, @Nullable String version, @Nullable ClassLoader jdbcClassLoader) {
        return new GPlumJdbcHelper(GPlumJdbcHelper.extractVersion(version), delegate, jdbcClassLoader);
    }

    @Nullable
    private static String extractVersion(@Nullable String version) {
        return JdbcNativeUtil.findVersion(version, GPLUM_VERSION_PATTERN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdbcClassLoader";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/GPlumJdbcHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "bindClassLoader";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

