/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.desktop;

import com.intellij.desktop.DesktopActionsHandler;
import java.awt.Desktop;
import java.awt.peer.DesktopPeer;
import java.io.File;
import java.io.IOException;
import java.net.URI;

public class DesktopActionsPeer
implements DesktopPeer {
    private static volatile DesktopActionsHandler ourHandler;

    @Override
    public boolean isSupported(Desktop.Action action) {
        DesktopActionsHandler handler = ourHandler;
        return handler != null && handler.isSupported(action);
    }

    private static DesktopActionsHandler getHandlerIfSet() {
        DesktopActionsHandler handler = ourHandler;
        if (handler == null) {
            throw new UnsupportedOperationException("No handler");
        }
        return handler;
    }

    @Override
    public void open(File file) throws IOException {
        DesktopActionsPeer.getHandlerIfSet().open(file);
    }

    @Override
    public void edit(File file) throws IOException {
        DesktopActionsPeer.getHandlerIfSet().edit(file);
    }

    @Override
    public void print(File file) throws IOException {
        DesktopActionsPeer.getHandlerIfSet().print(file);
    }

    @Override
    public void mail(URI mailtoURL) throws IOException {
        DesktopActionsPeer.getHandlerIfSet().mail(mailtoURL);
    }

    @Override
    public void browse(URI uri) throws IOException {
        DesktopActionsPeer.getHandlerIfSet().browse(uri);
    }

    public static void setHandler(DesktopActionsHandler handler) {
        ourHandler = handler;
    }
}

