/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.async;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.profiler.ultimate.async.extractor.AsyncProfilerExtractor;
import com.intellij.testFramework.ProfilerForTests;
import java.io.IOException;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import one.profiler.AsyncProfiler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0007H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/profiler/ultimate/async/AsyncProfilerForTests;", "Lcom/intellij/testFramework/ProfilerForTests;", "<init>", "()V", "instance", "Lone/profiler/AsyncProfiler;", "startProfiling", "", "logDir", "Ljava/nio/file/Path;", "fileName", "", "stopProfiling", "intellij.profiler.ultimate.ideaAsyncProfiler"})
public final class AsyncProfilerForTests
implements ProfilerForTests {
    @Nullable
    private final AsyncProfiler instance = !SystemInfo.isWindows ? AsyncProfilerExtractor.INSTANCE.getAsyncProfilerInstance() : null;

    public void startProfiling(@NotNull Path logDir, @NotNull String fileName) throws IOException {
        Intrinsics.checkNotNullParameter((Object)logDir, (String)"logDir");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        if (this.instance == null) {
            return;
        }
        Path path = logDir.resolve(fileName + ".jfr");
        this.instance.execute("start,interval=5ms,event=wall,jfr,file=" + path + ",loglevel=DEBUG,log=" + logDir.resolve(fileName + ".log"));
        System.out.println((Object)("Started profiling, filePath: " + path));
    }

    public void stopProfiling() throws IOException {
        block0: {
            AsyncProfiler asyncProfiler = this.instance;
            if (asyncProfiler == null) break block0;
            asyncProfiler.execute("stop");
        }
    }
}

