/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request;

import com.intellij.httpClient.http.request.HttpRequestPsiFactory;
import com.intellij.httpClient.http.request.HttpRequestPsiFile;
import com.intellij.httpClient.http.request.HttpRequestPsiUtils;
import com.intellij.httpClient.http.request.psi.HttpDynamicVariable;
import com.intellij.httpClient.http.request.psi.HttpDynamicVariableExpr;
import com.intellij.httpClient.http.request.psi.HttpDynamicVariableReference;
import com.intellij.httpClient.http.request.psi.HttpRequestElementTypes;
import com.intellij.httpClient.http.request.psi.HttpRequestTokenTypeSets;
import com.intellij.httpClient.http.request.run.dynamicVariables.HttpClientDynamicVariablesDocumentation;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpRequestVariableDocumentationProvider
implements DocumentationProvider {
    @NlsSafe
    public static final String DYNAMIC_SIGN_TEXT = HttpRequestElementTypes.DYNAMIC_SIGN.toString();

    @Nullable
    @Nls
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        HttpDynamicVariable variable;
        HttpDynamicVariableReference reference;
        PsiElement identifier;
        if (element instanceof HttpDynamicVariableReference && (identifier = (reference = (HttpDynamicVariableReference)element).getNameIdentifier()) != null) {
            String description = HttpClientDynamicVariablesDocumentation.getDynamicVariableDescription(identifier.getText());
            return description != null ? HttpRequestVariableDocumentationProvider.getDocumentation(identifier.getText(), description) : null;
        }
        if (element instanceof HttpDynamicVariable && (identifier = (variable = (HttpDynamicVariable)element).getNameIdentifier()) != null) {
            String description = HttpClientDynamicVariablesDocumentation.getDynamicVariableDescription(identifier.getText());
            return description != null ? HttpRequestVariableDocumentationProvider.getDocumentation(identifier.getText(), description) : null;
        }
        return null;
    }

    @Nullable
    public PsiElement getCustomDocumentationElement(@NotNull Editor editor2, @NotNull PsiFile file, @Nullable PsiElement contextElement, int targetOffset) {
        if (editor2 == null) {
            HttpRequestVariableDocumentationProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            HttpRequestVariableDocumentationProvider.$$$reportNull$$$0(1);
        }
        if (file instanceof HttpRequestPsiFile) {
            if (contextElement != null && HttpRequestPsiUtils.isOfType(contextElement, HttpRequestElementTypes.MESSAGE_TEXT)) {
                String bodyText = contextElement.getText();
                int bodyStartOffset = contextElement.getTextOffset();
                TextRange variableRange = (TextRange)ContainerUtil.find(HttpRequestPsiUtils.collectVariablesRangesInMessageBody(bodyText), range -> range.containsOffset(targetOffset - bodyStartOffset));
                if (variableRange != null) {
                    TextRange dynamicVariable = HttpRequestPsiUtils.getDynamicVariableNameRange(bodyText, variableRange);
                    return dynamicVariable != null ? HttpRequestVariableDocumentationProvider.makeDummyPsiDynamicVariable(editor2.getProject(), dynamicVariable.substring(bodyText)) : null;
                }
            }
            if ((contextElement == null || contextElement instanceof PsiWhiteSpace) && targetOffset < file.getTextLength()) {
                int newOffset = StringUtil.skipWhitespaceBackward((CharSequence)file.getText(), (int)targetOffset);
                contextElement = file.findElementAt(newOffset > 0 ? newOffset - 1 : 0);
            }
            if (contextElement != null && HttpRequestPsiUtils.isOfTypes(contextElement, HttpRequestTokenTypeSets.DYNAMIC_VARIABLE_PARTS)) {
                HttpDynamicVariableExpr expr;
                HttpDynamicVariable variable = (HttpDynamicVariable)PsiTreeUtil.getParentOfType((PsiElement)contextElement, HttpDynamicVariable.class);
                if (variable != null && (expr = variable.getDynamicVariableExpr()) != null) {
                    return expr.getDynamicVariableReference();
                }
                return contextElement.getParent();
            }
        }
        return null;
    }

    @Nullable
    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        if (object instanceof String) {
            String text2 = (String)object;
            if (element instanceof HttpDynamicVariableReference && StringUtil.equals((CharSequence)text2, (CharSequence)element.getText())) {
                return element;
            }
            Project project = psiManager != null ? psiManager.getProject() : null;
            return HttpRequestVariableDocumentationProvider.makeDummyPsiDynamicVariable(project, text2);
        }
        return null;
    }

    @Contract(value="null, _ -> null")
    @Nullable
    private static PsiElement makeDummyPsiDynamicVariable(@Nullable Project project, @NotNull String name) {
        HttpRequestPsiFile file;
        PsiElement leafElement;
        if (name == null) {
            HttpRequestVariableDocumentationProvider.$$$reportNull$$$0(2);
        }
        if (project != null && StringUtil.isNotEmpty((String)name) && (leafElement = (file = HttpRequestPsiFactory.createDummyFile(project, HttpRequestVariableDocumentationProvider.makeDummyDynamicVariableText(name))).findElementAt(0)) != null && HttpRequestPsiUtils.isOfType(leafElement, HttpRequestElementTypes.LBRACES)) {
            return leafElement.getParent();
        }
        return null;
    }

    @NotNull
    private static String makeDummyDynamicVariableText(@NotNull String text2) {
        if (text2 == null) {
            HttpRequestVariableDocumentationProvider.$$$reportNull$$$0(3);
        }
        String string = (text2.startsWith(DYNAMIC_SIGN_TEXT) ? "{{" : "{{$") + text2 + "}}";
        if (string == null) {
            HttpRequestVariableDocumentationProvider.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NlsContexts.DetailedDescription
    @NotNull
    private static String getDocumentation(@NotNull @NlsSafe String identifier, @NlsContexts.DetailedDescription @NotNull String description) {
        if (identifier == null) {
            HttpRequestVariableDocumentationProvider.$$$reportNull$$$0(5);
        }
        if (description == null) {
            HttpRequestVariableDocumentationProvider.$$$reportNull$$$0(6);
        }
        String string = "<div class='definition'><pre>" + DYNAMIC_SIGN_TEXT + identifier + "</pre></div>" + description;
        if (string == null) {
            HttpRequestVariableDocumentationProvider.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/HttpRequestVariableDocumentationProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/HttpRequestVariableDocumentationProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "makeDummyDynamicVariableText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCustomDocumentationElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "makeDummyPsiDynamicVariable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "makeDummyDynamicVariableText";
                break;
            }
            case 4: 
            case 7: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 7 -> new IllegalStateException(string);
        };
    }
}

