/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run.console;

import com.intellij.httpClient.execution.common.CommonClientRequest;
import com.intellij.httpClient.execution.common.RequestContext;
import com.intellij.httpClient.execution.common.RequestConverter;
import com.intellij.httpClient.execution.common.RequestExecutionSupport;
import com.intellij.httpClient.http.request.HttpRequestExecutionEnvironment;
import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutor;
import com.intellij.httpClient.http.request.run.info.HttpRunRequestInfo;
import com.intellij.httpClient.http.request.substitution.HttpRequestListVariableSubstitutor;
import com.intellij.httpClient.http.request.substitution.HttpRequestVariableRootSubstitutor;
import com.intellij.httpClient.http.request.substitution.HttpRequestVariableSessionSubstitutorImpl;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a*\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00060\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0001H\u0000\u00a8\u0006\u000b"}, d2={"getPresentableForm", "", "info", "Lcom/intellij/httpClient/http/request/run/info/HttpRunRequestInfo;", "collectVariablesRanges", "", "Lkotlin/Pair;", "Lcom/intellij/openapi/util/TextRange;", "substitutor", "Lcom/intellij/httpClient/http/request/HttpRequestVariableSubstitutor;", "presentableForm", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nHttpClientConsoleUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpClientConsoleUtil.kt\ncom/intellij/httpClient/http/request/run/console/HttpClientConsoleUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n1869#2,2:66\n1011#2,2:68\n1563#2:70\n1634#2,3:71\n*S KotlinDebug\n*F\n+ 1 HttpClientConsoleUtil.kt\ncom/intellij/httpClient/http/request/run/console/HttpClientConsoleUtilKt\n*L\n33#1:66,2\n48#1:68,2\n64#1:70\n64#1:71,3\n*E\n"})
public final class HttpClientConsoleUtilKt {
    @Nullable
    public static final String getPresentableForm(@NotNull HttpRunRequestInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        RequestExecutionSupport<?> requestExecutionSupport = RequestExecutionSupport.All.forContext(new RequestContext(info.getRequestMethod(), false, info.getRequestScheme()));
        if (requestExecutionSupport == null) {
            return null;
        }
        RequestExecutionSupport<?> support = requestExecutionSupport;
        RequestConverter<?> requestConverter = support.getRequestConverter();
        HttpRequestVariableSubstitutor httpRequestVariableSubstitutor = info.getVariableSubstitutor().invalidVariablesAware(false);
        Intrinsics.checkNotNullExpressionValue((Object)httpRequestVariableSubstitutor, (String)"invalidVariablesAware(...)");
        HttpRequestVariableSubstitutor substitutor2 = httpRequestVariableSubstitutor;
        Object commonClientRequest = requestConverter.psiToCommonRequest(info.getRequestPointer(), substitutor2);
        return requestConverter.toExternalForm((CommonClientRequest)commonClientRequest, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Pair<TextRange, String>> collectVariablesRanges(@NotNull HttpRequestVariableSubstitutor substitutor2, @NotNull String presentableForm) {
        void $this$mapTo$iv$iv;
        Iterable last;
        List<HttpRequestExecutionEnvironment.VariableInfo> list2;
        Intrinsics.checkNotNullParameter((Object)substitutor2, (String)"substitutor");
        Intrinsics.checkNotNullParameter((Object)presentableForm, (String)"presentableForm");
        List variables2 = new ArrayList();
        HttpRequestVariableSubstitutor httpRequestVariableSubstitutor = substitutor2;
        if (httpRequestVariableSubstitutor instanceof HttpRequestVariableSessionSubstitutorImpl) {
            List<HttpRequestExecutionEnvironment.VariableInfo> list3 = ((HttpRequestVariableSessionSubstitutorImpl)substitutor2).getEnvironment().getAllVariables();
            list2 = list3;
            Intrinsics.checkNotNullExpressionValue(list3, (String)"getAllVariables(...)");
        } else if (httpRequestVariableSubstitutor instanceof HttpRequestVariableRootSubstitutor) {
            List<HttpRequestExecutionEnvironment.VariableInfo> list4 = ((HttpRequestVariableRootSubstitutor)substitutor2).getContext().getEnvironment().getAllVariables();
            list2 = list4;
            Intrinsics.checkNotNullExpressionValue(list4, (String)"getAllVariables(...)");
        } else {
            list2 = httpRequestVariableSubstitutor instanceof HttpRequestListVariableSubstitutor ? ((HttpRequestListVariableSubstitutor)substitutor2).getAllEnvVariables() : CollectionsKt.emptyList();
        }
        List<HttpRequestExecutionEnvironment.VariableInfo> allVariables = list2;
        Iterable $this$forEach$iv = allVariables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HttpRequestExecutionEnvironment.VariableInfo variable = (HttpRequestExecutionEnvironment.VariableInfo)element$iv;
            boolean bl = false;
            if (!variable.isPrivate()) continue;
            String string = variable.value();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value(...)");
            if (StringsKt.isBlank((CharSequence)string)) continue;
            int index = 0;
            do {
                CharSequence charSequence = presentableForm;
                String string2 = variable.value();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"value(...)");
                index = StringsKt.indexOf$default((CharSequence)charSequence, (String)string2, (int)index, (boolean)false, (int)4, null);
                if (index == -1) continue;
                variables2.add(TuplesKt.to((Object)TextRange.create((int)index, (int)(index + variable.value().length())), (Object)variable.name()));
                index += variable.value().length();
            } while (index != -1);
        }
        List $this$sortBy$iv = variables2;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Pair it = (Pair)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(((TextRange)it.getFirst()).getStartOffset());
                    it = (Pair)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(((TextRange)it.getFirst()).getStartOffset()));
                }
            });
        }
        List collapsedVariables = new ArrayList();
        for (Pair variable : variables2) {
            Collection newLast;
            last = (Pair)CollectionsKt.lastOrNull((List)collapsedVariables);
            if (last != null && ((TextRange)last.getFirst()).intersects((TextRange)variable.getFirst())) {
                ((Collection)last.getSecond()).add(variable.getSecond());
                newLast = TuplesKt.to((Object)((TextRange)last.getFirst()).union((TextRange)variable.getFirst()), (Object)last.getSecond());
                CollectionsKt.removeLast((List)collapsedVariables);
                ((Collection)collapsedVariables).add(newLast);
                continue;
            }
            newLast = collapsedVariables;
            Object[] bl = new String[]{variable.getSecond()};
            newLast.add(TuplesKt.to((Object)variable.getFirst(), (Object)SetsKt.mutableSetOf((Object[])bl)));
        }
        Iterable $this$map$iv = collapsedVariables;
        boolean $i$f$map = false;
        last = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            TextRange range = (TextRange)pair.component1();
            Set names = (Set)pair.component2();
            collection.add(TuplesKt.to((Object)range, (Object)CollectionsKt.joinToString$default((Iterable)names, null, null, null, (int)0, null, HttpClientConsoleUtilKt::collectVariablesRanges$lambda$3$lambda$2, (int)31, null)));
        }
        return (List)destination$iv$iv;
    }

    private static final CharSequence collectVariablesRanges$lambda$3$lambda$2(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }
}

