/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run.controller;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.httpClient.execution.RestClientRequest;
import com.intellij.httpClient.http.request.cookies.CookieStorageInvalidFileException;
import com.intellij.httpClient.http.request.cookies.HttpRequestCookiesStorage;
import com.intellij.httpClient.http.request.run.HttpClientRequestProcessHandler;
import com.intellij.httpClient.http.request.run.HttpClientResponseHandler;
import com.intellij.httpClient.http.request.run.HttpRequestCompositePostProcessor;
import com.intellij.httpClient.http.request.run.HttpRequestPostProcessor;
import com.intellij.httpClient.http.request.run.HttpRequestValidationException;
import com.intellij.httpClient.http.request.run.config.HttpRequestRunConfiguration;
import com.intellij.httpClient.http.request.run.console.HttpResponseConsole;
import com.intellij.httpClient.http.request.run.controller.HttpClientExecutionController;
import com.intellij.httpClient.http.request.run.controller.HttpRequestConsolePostProcessor;
import com.intellij.httpClient.http.request.run.info.HttpRunRequestInfo;
import com.intellij.httpClient.http.request.run.test.HttpClientTestLocations;
import com.intellij.httpClient.http.request.substitution.HttpRequestListVariableSubstitutor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000p\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004\u001a\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0010\u0010\u0012\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0018\u00010\u0013\u001a\u0018\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000bH\u0007\u001a\u0016\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b\u001aH\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020&H\u0007\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "createProcessor", "Lcom/intellij/httpClient/http/request/run/HttpRequestPostProcessor;", "requestId", "", "console", "Lcom/intellij/httpClient/http/request/run/console/HttpResponseConsole;", "processor", "isInterrupted", "", "handler", "Lcom/intellij/execution/process/ProcessHandler;", "saveCookiesToJar", "", "project", "Lcom/intellij/openapi/project/Project;", "cookies", "", "Lcom/intellij/httpClient/execution/RestClientRequest$Biscuit;", "toRequestId", "requestInfo", "Lcom/intellij/httpClient/http/request/run/info/HttpRunRequestInfo;", "addMethod", "loadCookiesFromJar", "request", "Lcom/intellij/httpClient/execution/RestClientRequest;", "createHttpExecutionController", "Lcom/intellij/httpClient/http/request/run/controller/HttpClientExecutionController;", "info", "processHandler", "Lcom/intellij/httpClient/http/request/run/HttpClientRequestProcessHandler;", "showResponseInplace", "settings", "Lcom/intellij/httpClient/http/request/run/config/HttpRequestRunConfiguration$Settings;", "debugMode", "onRequestFinished", "Ljava/lang/Runnable;", "intellij.restClient"})
public final class HttpClientExecutionControllerKt {
    @NotNull
    private static final Logger log;

    @NotNull
    public static final HttpRequestPostProcessor createProcessor(@NotNull String requestId, @NotNull HttpResponseConsole console2, @NotNull HttpRequestPostProcessor processor) {
        Intrinsics.checkNotNullParameter((Object)requestId, (String)"requestId");
        Intrinsics.checkNotNullParameter((Object)console2, (String)"console");
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        HttpRequestPostProcessor[] httpRequestPostProcessorArray = new HttpRequestPostProcessor[]{processor, new HttpRequestConsolePostProcessor(requestId, console2)};
        return new HttpRequestCompositePostProcessor(httpRequestPostProcessorArray);
    }

    public static final boolean isInterrupted(@NotNull ProcessHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Integer code = handler.getExitCode();
        return code != null && code != 0;
    }

    public static final void saveCookiesToJar(@NotNull Project project, @Nullable Collection<RestClientRequest.Biscuit> cookies) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        try {
            HttpRequestCookiesStorage.getInstance(project).setCookies(cookies);
        }
        catch (CookieStorageInvalidFileException e) {
            log.warn("Failed saving cookies, " + e.getMessage());
        }
    }

    @RequiresReadLock
    @NotNull
    public static final String toRequestId(@NotNull HttpRunRequestInfo requestInfo, boolean addMethod) {
        String id;
        Intrinsics.checkNotNullParameter((Object)requestInfo, (String)"requestInfo");
        if (!(requestInfo.getVariableSubstitutor() instanceof HttpRequestListVariableSubstitutor) && (id = HttpClientTestLocations.getRequestId(requestInfo.getRequestPointer())) != null) {
            return id;
        }
        String unknownRequestId = "<unknown>";
        return (String)(addMethod ? requestInfo.getRequestMethod() + " " : "") + StringUtil.notNullize((String)requestInfo.getRequestURL(), (String)unknownRequestId);
    }

    public static final void loadCookiesFromJar(@NotNull Project project, @NotNull RestClientRequest request) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            if (request.config.isSaveCookies()) {
                HttpRequestCookiesStorage.getInstance(project).saveToRequest(request);
            }
        }
        catch (CookieStorageInvalidFileException e) {
            log.warn("Failed loading cookies, " + e.getMessage());
        }
    }

    @RequiresReadLock
    @NotNull
    public static final HttpClientExecutionController createHttpExecutionController(@NotNull Project project, @NotNull HttpRunRequestInfo info, @NotNull HttpClientRequestProcessHandler processHandler, @NotNull HttpResponseConsole console2, boolean showResponseInplace, @NotNull HttpRequestRunConfiguration.Settings settings, boolean debugMode, @NotNull Runnable onRequestFinished) throws HttpRequestValidationException {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)((Object)processHandler), (String)"processHandler");
        Intrinsics.checkNotNullParameter((Object)console2, (String)"console");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)onRequestFinished, (String)"onRequestFinished");
        String id = HttpClientExecutionControllerKt.toRequestId(info, console2.showRequestMethod());
        if (log.isTraceEnabled()) {
            log.trace("Executing: " + id);
        }
        Function0 onFinished = () -> HttpClientExecutionControllerKt.createHttpExecutionController$lambda$0(console2, id, onRequestFinished);
        HttpClientResponseHandler handler = info.getResponseHandler();
        return new HttpClientExecutionController(project, info, id, info.getRequestPointer(), processHandler, console2, handler, info.getPostProcessor(), showResponseInplace, () -> HttpClientExecutionControllerKt.createHttpExecutionController$lambda$1(onFinished), info.getIgnoreMessage(), settings, debugMode);
    }

    private static final Unit createHttpExecutionController$lambda$0(HttpResponseConsole $console, String $id, Runnable $onRequestFinished) {
        $console.onRequestEnd($id);
        $onRequestFinished.run();
        return Unit.INSTANCE;
    }

    private static final void createHttpExecutionController$lambda$1(Function0 $tmp0) {
        $tmp0.invoke();
    }

    static {
        Logger logger = Logger.getInstance(HttpClientExecutionController.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
    }
}

