/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.security;

import com.google.common.net.InetAddresses;
import com.google.common.net.InternetDomainName;
import com.intellij.codeInspection.AddToInspectionOptionListFix;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.security.Http2HttpsQuickFix;
import com.intellij.httpClient.http.security.HttpUrlsUsageInspection;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.SmartList;
import com.intellij.util.text.StringTokenizer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.intellij.lang.regexp.RegExpLanguage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 ;2\u00020\u0001:\u0003;<=B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\bH\u0016J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0006H\u0002J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001b\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010\u001fJ\b\u0010 \u001a\u00020!H\u0016J2\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00052\u0006\u0010#\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020$2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020'0&H\u0002J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00052\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020\b2\u0006\u0010)\u001a\u00020*H\u0002J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00052\u0006\u0010,\u001a\u00020-H\u0002J$\u0010.\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020'0&2\u0006\u0010/\u001a\u00020\u00062\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u00100\u001a\u00020\b2\u0006\u00101\u001a\u00020$H\u0002J,\u00102\u001a\u00020\u001b2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020$2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020'0&H\u0002J \u00106\u001a\u00020\u00062\u000e\u00107\u001a\n\u0012\u0006\b\u0001\u0012\u00020*082\u0006\u00109\u001a\u00020:H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/intellij/httpClient/http/security/HttpUrlsUsageInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "defaultIgnoredUrls", "", "", "ignoreComments", "", "withTldOnly", "ignoreIpAddresses", "ignoredUrls", "", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "shouldReport", "urlFragment", "Lcom/intellij/httpClient/http/security/HttpUrlsUsageInspection$UrlFragment;", "tldIgnored", "hasNonPublicTld", "host", "isIpAddressIgnored", "findUrl", "literalFragment", "Lcom/intellij/httpClient/http/security/HttpUrlsUsageInspection$LiteralFragment;", "getQuickFixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "(Lcom/intellij/httpClient/http/security/HttpUrlsUsageInspection$UrlFragment;)[Lcom/intellij/codeInspection/LocalQuickFix;", "getOptionsPane", "Lcom/intellij/codeInspection/options/OptPane;", "splitLiterals", "literal", "Lcom/intellij/psi/PsiElement;", "offsetMap", "Lkotlin/Function1;", "", "getLiteralFragments", "injectionHost", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "hasInjectedRegexp", "xmlAttributeValue", "Lcom/intellij/psi/xml/XmlAttributeValue;", "getOffsetMapper", "attributeValue", "mayContainHttpSchema", "element", "nextLinkLiteral", "tokenizer", "Lcom/intellij/util/text/StringTokenizer;", "psiElement", "decodeLiteralValue", "escaper", "Lcom/intellij/psi/LiteralTextEscaper;", "wholeRange", "Lcom/intellij/openapi/util/TextRange;", "Companion", "LiteralFragment", "UrlFragment", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nHttpUrlsUsageInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpUrlsUsageInspection.kt\ncom/intellij/httpClient/http/security/HttpUrlsUsageInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,259:1\n2746#2,3:260\n1761#2,3:263\n785#2:268\n796#2:269\n1878#2,2:270\n797#2,2:272\n1880#2:274\n799#2:275\n66#3,2:266\n*S KotlinDebug\n*F\n+ 1 HttpUrlsUsageInspection.kt\ncom/intellij/httpClient/http/security/HttpUrlsUsageInspection\n*L\n100#1:260,3\n184#1:263,3\n214#1:268\n214#1:269\n214#1:270,2\n214#1:272,2\n214#1:274\n214#1:275\n201#1:266,2\n*E\n"})
public final class HttpUrlsUsageInspection
extends LocalInspectionTool {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> defaultIgnoredUrls;
    @JvmField
    public boolean ignoreComments;
    @JvmField
    public boolean withTldOnly;
    @JvmField
    public boolean ignoreIpAddresses;
    @JvmField
    @NotNull
    public final List<String> ignoredUrls;
    @NotNull
    public static final String HTTP_PREFIX = "http://";
    @NotNull
    public static final String HTTPS_PREFIX = "https://";

    public HttpUrlsUsageInspection() {
        Object[] objectArray = new String[]{"http://localhost", "http://127.0.0.1", "http://0.0.0.0", "http://www.w3.org/", "http://json-schema.org/draft", "http://java.sun.com/", "http://xmlns.jcp.org/", "http://javafx.com/javafx/", "http://javafx.com/fxml", "http://maven.apache.org/xsd/", "http://maven.apache.org/POM/", "http://www.springframework.org/schema/", "http://www.springframework.org/tags", "http://www.springframework.org/security/tags", "http://www.thymeleaf.org", "http://www.jboss.org/j2ee/schema/", "http://www.jboss.com/xml/ns/", "http://www.ibm.com/webservices/xsd", "http://activemq.apache.org/schema/", "http://schema.cloudfoundry.org/spring/", "http://schemas.xmlsoap.org/", "http://cxf.apache.org/schemas/", "http://primefaces.org/ui", "http://tiles.apache.org/"};
        this.defaultIgnoredUrls = CollectionsKt.listOf((Object[])objectArray);
        this.ignoreComments = true;
        this.withTldOnly = true;
        this.ignoreIpAddresses = true;
        this.ignoredUrls = new ArrayList(this.defaultIgnoredUrls);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new PsiElementVisitor(this, holder){
            final /* synthetic */ HttpUrlsUsageInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            /*
             * WARNING - void declaration
             */
            public void visitElement(PsiElement element) {
                void $this$forEach$iv;
                List list2;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (this.this$0.ignoreComments && element instanceof PsiComment) {
                    return;
                }
                if (element.getLanguage().isKindOf((Language)RegExpLanguage.INSTANCE)) {
                    return;
                }
                PsiElement psiElement = element;
                if (psiElement instanceof XmlAttributeValue) {
                    list2 = HttpUrlsUsageInspection.access$getLiteralFragments(this.this$0, (XmlAttributeValue)element);
                } else if (psiElement instanceof PsiLanguageInjectionHost) {
                    list2 = HttpUrlsUsageInspection.access$getLiteralFragments(this.this$0, (PsiLanguageInjectionHost)element);
                } else {
                    return;
                }
                List literals = list2;
                psiElement = SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)literals), arg_0 -> buildVisitor.1.visitElement$lambda$0(this.this$0, arg_0)), arg_0 -> buildVisitor.1.visitElement$lambda$1(this.this$0, arg_0));
                ProblemsHolder problemsHolder = this.$holder;
                HttpUrlsUsageInspection httpUrlsUsageInspection = this.this$0;
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    UrlFragment it = (UrlFragment)element$iv;
                    boolean bl = false;
                    LocalQuickFix[] localQuickFixArray = HttpUrlsUsageInspection.access$getQuickFixes(httpUrlsUsageInspection, it);
                    problemsHolder.registerProblem(it.getHostElement(), it.getSchemaRangeInHost(), RestClientBundle.message("inspection.template", new Object[0]), Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
                }
            }

            private static final UrlFragment visitElement$lambda$0(HttpUrlsUsageInspection this$0, LiteralFragment it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return HttpUrlsUsageInspection.access$findUrl(this$0, it);
            }

            private static final boolean visitElement$lambda$1(HttpUrlsUsageInspection this$0, UrlFragment it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return HttpUrlsUsageInspection.access$shouldReport(this$0, it);
            }
        };
    }

    private final boolean shouldReport(UrlFragment urlFragment) {
        boolean bl;
        block3: {
            Iterable $this$none$iv = this.ignoredUrls;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith$default((String)urlFragment.getWholeUrl(), (String)it, (boolean)false, (int)2, null)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl && !this.tldIgnored(urlFragment) && !this.isIpAddressIgnored(urlFragment);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean tldIgnored(UrlFragment urlFragment) {
        if (!this.withTldOnly) return false;
        URL uRL = urlFragment.getUrl();
        if (uRL == null) return false;
        String string = uRL.getHost();
        if (string == null) return false;
        String string2 = urlFragment.getUrl().getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getHost(...)");
        if (!this.hasNonPublicTld(string2)) return false;
        return true;
    }

    private final boolean hasNonPublicTld(String host) {
        try {
            return !InternetDomainName.from((String)host).hasPublicSuffix();
        }
        catch (IllegalArgumentException ie) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isIpAddressIgnored(UrlFragment urlFragment) {
        if (!this.ignoreIpAddresses) return false;
        URL uRL = urlFragment.getUrl();
        if (uRL == null) return false;
        String string = uRL.getHost();
        if (string == null) return false;
        if (!InetAddresses.isUriInetAddress((String)urlFragment.getUrl().getHost())) return false;
        return true;
    }

    private final UrlFragment findUrl(LiteralFragment literalFragment) {
        int urlStart = StringsKt.indexOf$default((CharSequence)literalFragment.getValue(), (String)HTTP_PREFIX, (int)0, (boolean)false, (int)6, null);
        if (urlStart == -1) {
            return null;
        }
        int schemaRangeStart = urlStart + literalFragment.getDecodedRange().getStartOffset();
        LiteralFragment $this$findUrl_u24lambda_u241 = literalFragment;
        boolean bl = false;
        TextRange textRange = TextRange.create((int)((Number)$this$findUrl_u24lambda_u241.getOffsetMap().invoke((Object)schemaRangeStart)).intValue(), (int)((Number)$this$findUrl_u24lambda_u241.getOffsetMap().invoke((Object)(schemaRangeStart + 7))).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"with(...)");
        TextRange schemaRange = textRange;
        String string = literalFragment.getValue().substring(urlStart);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return new UrlFragment(string, schemaRange, literalFragment.getElement());
    }

    private final LocalQuickFix[] getQuickFixes(UrlFragment urlFragment) {
        URL url = urlFragment.getUrl();
        if (url == null) {
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new Http2HttpsQuickFix()};
            return localQuickFixArray;
        }
        String ignoreUrl = HTTP_PREFIX + url.getHost();
        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[2];
        localQuickFixArray[0] = new Http2HttpsQuickFix();
        Object[] objectArray = new Object[]{ignoreUrl};
        localQuickFixArray[1] = new AddToInspectionOptionListFix((InspectionProfileEntry)this, RestClientBundle.message("quickfix.ignore.url.family.name", objectArray), ignoreUrl, HttpUrlsUsageInspection::getQuickFixes$lambda$2);
        return localQuickFixArray;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptRegularComponent[] optRegularComponentArray = new OptRegularComponent[]{OptPane.checkbox((String)"ignoreComments", (String)RestClientBundle.message("checkbox.ignore.comments", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"withTldOnly", (String)RestClientBundle.message("checkbox.ignore.tldOnly", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"ignoreIpAddresses", (String)RestClientBundle.message("checkbox.ignore.ip", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.stringList((String)"ignoredUrls", (String)RestClientBundle.message("column.name.ignored.urls.label", new Object[0]))};
        OptPane optPane = OptPane.pane((OptRegularComponent[])optRegularComponentArray);
        Intrinsics.checkNotNullExpressionValue((Object)optPane, (String)"pane(...)");
        return optPane;
    }

    private final List<LiteralFragment> splitLiterals(String literal, PsiElement host, Function1<? super Integer, Integer> offsetMap) {
        StringTokenizer tokenizer = new StringTokenizer(literal, " \t\n\r\f'\"");
        SmartList literals = new SmartList();
        while (tokenizer.hasMoreTokens()) {
            LiteralFragment linkLiteral = this.nextLinkLiteral(tokenizer, host, offsetMap);
            literals.add((Object)linkLiteral);
        }
        return (List)literals;
    }

    private final List<LiteralFragment> getLiteralFragments(PsiLanguageInjectionHost injectionHost) {
        if (!injectionHost.isValidHost()) {
            return CollectionsKt.emptyList();
        }
        if (!this.mayContainHttpSchema((PsiElement)injectionHost)) {
            return CollectionsKt.emptyList();
        }
        if (this.hasInjectedRegexp(injectionHost)) {
            return CollectionsKt.emptyList();
        }
        LiteralTextEscaper literalTextEscaper = injectionHost.createLiteralTextEscaper();
        Intrinsics.checkNotNullExpressionValue((Object)literalTextEscaper, (String)"createLiteralTextEscaper(...)");
        LiteralTextEscaper escaper = literalTextEscaper;
        TextRange textRange = escaper.getRelevantTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getRelevantTextRange(...)");
        TextRange wholeRange = textRange;
        String literalValue = this.decodeLiteralValue((LiteralTextEscaper<? extends PsiLanguageInjectionHost>)escaper, wholeRange);
        return this.splitLiterals(literalValue, (PsiElement)injectionHost, (Function1<? super Integer, Integer>)((Function1)arg_0 -> HttpUrlsUsageInspection.getLiteralFragments$lambda$3(escaper, wholeRange, arg_0)));
    }

    private final boolean hasInjectedRegexp(PsiLanguageInjectionHost injectionHost) {
        boolean bl;
        block4: {
            InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)injectionHost.getProject());
            List list2 = injectedLanguageManager.getInjectedPsiFiles((PsiElement)injectionHost);
            if (list2 == null) {
                return false;
            }
            List files = list2;
            Iterable $this$any$iv = files;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Pair it = (Pair)element$iv;
                    boolean bl2 = false;
                    if (!((PsiElement)it.first).getLanguage().isKindOf((Language)RegExpLanguage.INSTANCE)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final List<LiteralFragment> getLiteralFragments(XmlAttributeValue xmlAttributeValue) {
        KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(XmlAttribute.class)};
        XmlAttribute xmlAttribute = (XmlAttribute)PsiTreeUtilKt.parentOfTypes$default((PsiElement)((PsiElement)xmlAttributeValue), (KClass[])kClassArray, (boolean)false, (int)2, null);
        if (xmlAttribute == null) {
            return CollectionsKt.emptyList();
        }
        XmlAttribute attribute = xmlAttribute;
        if (!this.mayContainHttpSchema((PsiElement)xmlAttributeValue)) {
            return CollectionsKt.emptyList();
        }
        String string = xmlAttributeValue.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
        String attributeValue = string;
        Function1<Integer, Integer> offsetMap = this.getOffsetMapper(attributeValue, xmlAttributeValue);
        List<LiteralFragment> literals = this.splitLiterals(attributeValue, (PsiElement)xmlAttributeValue, offsetMap);
        if (attribute.isNamespaceDeclaration()) {
            return CollectionsKt.emptyList();
        }
        if (Intrinsics.areEqual((Object)attribute.getLocalName(), (Object)"targetNamespace")) {
            PsiElement $this$parentOfType_u24default$iv = (PsiElement)xmlAttributeValue;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            XmlTag parentTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, XmlTag.class, (boolean)true);
            if (parentTag != null && Intrinsics.areEqual((Object)parentTag.getLocalName(), (Object)"schema") && parentTag.getParentTag() == null) {
                return CollectionsKt.emptyList();
            }
        }
        if (Intrinsics.areEqual((Object)attribute.getNamespace(), (Object)"http://www.w3.org/2001/XMLSchema-instance")) {
            String string2 = attribute.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            if (Intrinsics.areEqual((Object)StringsKt.replace$default((String)string2, (String)(attribute.getNamespacePrefix() + ":"), (String)"", (boolean)false, (int)4, null), (Object)"schemaLocation")) {
                void $this$filterIndexedTo$iv$iv;
                Iterable $this$filterIndexed$iv = literals;
                boolean $i$f$filterIndexed = false;
                Iterable withSelf$iv = $this$filterIndexed$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIndexedTo = false;
                void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
                boolean $i$f$forEachIndexed = false;
                int index$iv$iv$iv = 0;
                for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                    void element$iv$iv;
                    int n;
                    if ((n = index$iv$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Object t = item$iv$iv$iv;
                    int index$iv$iv = n;
                    boolean bl = false;
                    LiteralFragment cfr_ignored_0 = (LiteralFragment)element$iv$iv;
                    int index = index$iv$iv;
                    boolean bl2 = false;
                    if (!(index % 2 == 1)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        }
        return literals;
    }

    private final Function1<Integer, Integer> getOffsetMapper(String attributeValue, XmlAttributeValue xmlAttributeValue) {
        return attributeValue.length() == xmlAttributeValue.getTextRange().getLength() ? HttpUrlsUsageInspection::getOffsetMapper$lambda$6 : (Function1)getOffsetMapper.2.INSTANCE;
    }

    private final boolean mayContainHttpSchema(PsiElement element) {
        return element.textContains(':');
    }

    private final LiteralFragment nextLinkLiteral(StringTokenizer tokenizer, PsiElement psiElement, Function1<? super Integer, Integer> offsetMap) {
        String string = tokenizer.nextToken();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nextToken(...)");
        String value2 = string;
        int endPosition = tokenizer.getCurrentPosition();
        int startPosition = endPosition - value2.length();
        return new LiteralFragment(value2, new TextRange(startPosition, endPosition), psiElement, offsetMap);
    }

    private final String decodeLiteralValue(LiteralTextEscaper<? extends PsiLanguageInjectionHost> escaper, TextRange wholeRange) {
        StringBuilder stringBuilder = new StringBuilder();
        escaper.decode(wholeRange, stringBuilder);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final List getQuickFixes$lambda$2(HttpUrlsUsageInspection tool) {
        Intrinsics.checkNotNullParameter((Object)((Object)tool), (String)"tool");
        return tool.ignoredUrls;
    }

    private static final int getLiteralFragments$lambda$3(LiteralTextEscaper $escaper, TextRange $wholeRange, int it) {
        return $escaper.getOffsetInHost(it, $wholeRange);
    }

    private static final int getOffsetMapper$lambda$6(int it) {
        return it;
    }

    public static final /* synthetic */ List access$getLiteralFragments(HttpUrlsUsageInspection $this, XmlAttributeValue xmlAttributeValue) {
        return $this.getLiteralFragments(xmlAttributeValue);
    }

    public static final /* synthetic */ List access$getLiteralFragments(HttpUrlsUsageInspection $this, PsiLanguageInjectionHost injectionHost) {
        return $this.getLiteralFragments(injectionHost);
    }

    public static final /* synthetic */ UrlFragment access$findUrl(HttpUrlsUsageInspection $this, LiteralFragment literalFragment) {
        return $this.findUrl(literalFragment);
    }

    public static final /* synthetic */ boolean access$shouldReport(HttpUrlsUsageInspection $this, UrlFragment urlFragment) {
        return $this.shouldReport(urlFragment);
    }

    public static final /* synthetic */ LocalQuickFix[] access$getQuickFixes(HttpUrlsUsageInspection $this, UrlFragment urlFragment) {
        return $this.getQuickFixes(urlFragment);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/httpClient/http/security/HttpUrlsUsageInspection$Companion;", "", "<init>", "()V", "HTTP_PREFIX", "", "HTTPS_PREFIX", "intellij.restClient"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J\u0015\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J=\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\nH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001f"}, d2={"Lcom/intellij/httpClient/http/security/HttpUrlsUsageInspection$LiteralFragment;", "", "value", "", "decodedRange", "Lcom/intellij/openapi/util/TextRange;", "element", "Lcom/intellij/psi/PsiElement;", "offsetMap", "Lkotlin/Function1;", "", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/util/TextRange;Lcom/intellij/psi/PsiElement;Lkotlin/jvm/functions/Function1;)V", "getValue", "()Ljava/lang/String;", "getDecodedRange", "()Lcom/intellij/openapi/util/TextRange;", "getElement", "()Lcom/intellij/psi/PsiElement;", "getOffsetMap", "()Lkotlin/jvm/functions/Function1;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "intellij.restClient"})
    private static final class LiteralFragment {
        @NotNull
        private final String value;
        @NotNull
        private final TextRange decodedRange;
        @NotNull
        private final PsiElement element;
        @NotNull
        private final Function1<Integer, Integer> offsetMap;

        public LiteralFragment(@NotNull String value2, @NotNull TextRange decodedRange, @NotNull PsiElement element, @NotNull Function1<? super Integer, Integer> offsetMap) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Intrinsics.checkNotNullParameter((Object)decodedRange, (String)"decodedRange");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter(offsetMap, (String)"offsetMap");
            this.value = value2;
            this.decodedRange = decodedRange;
            this.element = element;
            this.offsetMap = offsetMap;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @NotNull
        public final TextRange getDecodedRange() {
            return this.decodedRange;
        }

        @NotNull
        public final PsiElement getElement() {
            return this.element;
        }

        @NotNull
        public final Function1<Integer, Integer> getOffsetMap() {
            return this.offsetMap;
        }

        @NotNull
        public final String component1() {
            return this.value;
        }

        @NotNull
        public final TextRange component2() {
            return this.decodedRange;
        }

        @NotNull
        public final PsiElement component3() {
            return this.element;
        }

        @NotNull
        public final Function1<Integer, Integer> component4() {
            return this.offsetMap;
        }

        @NotNull
        public final LiteralFragment copy(@NotNull String value2, @NotNull TextRange decodedRange, @NotNull PsiElement element, @NotNull Function1<? super Integer, Integer> offsetMap) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Intrinsics.checkNotNullParameter((Object)decodedRange, (String)"decodedRange");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter(offsetMap, (String)"offsetMap");
            return new LiteralFragment(value2, decodedRange, element, offsetMap);
        }

        public static /* synthetic */ LiteralFragment copy$default(LiteralFragment literalFragment, String string, TextRange textRange, PsiElement psiElement, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                string = literalFragment.value;
            }
            if ((n & 2) != 0) {
                textRange = literalFragment.decodedRange;
            }
            if ((n & 4) != 0) {
                psiElement = literalFragment.element;
            }
            if ((n & 8) != 0) {
                function1 = literalFragment.offsetMap;
            }
            return literalFragment.copy(string, textRange, psiElement, function1);
        }

        @NotNull
        public String toString() {
            return "LiteralFragment(value=" + this.value + ", decodedRange=" + this.decodedRange + ", element=" + this.element + ", offsetMap=" + this.offsetMap + ")";
        }

        public int hashCode() {
            int result2 = this.value.hashCode();
            result2 = result2 * 31 + this.decodedRange.hashCode();
            result2 = result2 * 31 + this.element.hashCode();
            result2 = result2 * 31 + this.offsetMap.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LiteralFragment)) {
                return false;
            }
            LiteralFragment literalFragment = (LiteralFragment)other;
            if (!Intrinsics.areEqual((Object)this.value, (Object)literalFragment.value)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.decodedRange, (Object)literalFragment.decodedRange)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.element, (Object)literalFragment.element)) {
                return false;
            }
            return Intrinsics.areEqual(this.offsetMap, literalFragment.offsetMap);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J)\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lcom/intellij/httpClient/http/security/HttpUrlsUsageInspection$UrlFragment;", "", "wholeUrl", "", "schemaRangeInHost", "Lcom/intellij/openapi/util/TextRange;", "hostElement", "Lcom/intellij/psi/PsiElement;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/util/TextRange;Lcom/intellij/psi/PsiElement;)V", "getWholeUrl", "()Ljava/lang/String;", "getSchemaRangeInHost", "()Lcom/intellij/openapi/util/TextRange;", "getHostElement", "()Lcom/intellij/psi/PsiElement;", "url", "Ljava/net/URL;", "getUrl", "()Ljava/net/URL;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.restClient"})
    private static final class UrlFragment {
        @NotNull
        private final String wholeUrl;
        @Nullable
        private final TextRange schemaRangeInHost;
        @NotNull
        private final PsiElement hostElement;
        @Nullable
        private final URL url;

        public UrlFragment(@NotNull String wholeUrl, @Nullable TextRange schemaRangeInHost, @NotNull PsiElement hostElement) {
            URL uRL;
            UrlFragment urlFragment;
            Intrinsics.checkNotNullParameter((Object)wholeUrl, (String)"wholeUrl");
            Intrinsics.checkNotNullParameter((Object)hostElement, (String)"hostElement");
            this.wholeUrl = wholeUrl;
            this.schemaRangeInHost = schemaRangeInHost;
            this.hostElement = hostElement;
            UrlFragment urlFragment2 = this;
            try {
                urlFragment = urlFragment2;
                uRL = new URL(this.wholeUrl);
            }
            catch (MalformedURLException malformedURLException) {
                urlFragment = urlFragment2;
                uRL = null;
            }
            urlFragment.url = uRL;
        }

        @NotNull
        public final String getWholeUrl() {
            return this.wholeUrl;
        }

        @Nullable
        public final TextRange getSchemaRangeInHost() {
            return this.schemaRangeInHost;
        }

        @NotNull
        public final PsiElement getHostElement() {
            return this.hostElement;
        }

        @Nullable
        public final URL getUrl() {
            return this.url;
        }

        @NotNull
        public final String component1() {
            return this.wholeUrl;
        }

        @Nullable
        public final TextRange component2() {
            return this.schemaRangeInHost;
        }

        @NotNull
        public final PsiElement component3() {
            return this.hostElement;
        }

        @NotNull
        public final UrlFragment copy(@NotNull String wholeUrl, @Nullable TextRange schemaRangeInHost, @NotNull PsiElement hostElement) {
            Intrinsics.checkNotNullParameter((Object)wholeUrl, (String)"wholeUrl");
            Intrinsics.checkNotNullParameter((Object)hostElement, (String)"hostElement");
            return new UrlFragment(wholeUrl, schemaRangeInHost, hostElement);
        }

        public static /* synthetic */ UrlFragment copy$default(UrlFragment urlFragment, String string, TextRange textRange, PsiElement psiElement, int n, Object object) {
            if ((n & 1) != 0) {
                string = urlFragment.wholeUrl;
            }
            if ((n & 2) != 0) {
                textRange = urlFragment.schemaRangeInHost;
            }
            if ((n & 4) != 0) {
                psiElement = urlFragment.hostElement;
            }
            return urlFragment.copy(string, textRange, psiElement);
        }

        @NotNull
        public String toString() {
            return "UrlFragment(wholeUrl=" + this.wholeUrl + ", schemaRangeInHost=" + this.schemaRangeInHost + ", hostElement=" + this.hostElement + ")";
        }

        public int hashCode() {
            int result2 = this.wholeUrl.hashCode();
            result2 = result2 * 31 + (this.schemaRangeInHost == null ? 0 : this.schemaRangeInHost.hashCode());
            result2 = result2 * 31 + this.hostElement.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UrlFragment)) {
                return false;
            }
            UrlFragment urlFragment = (UrlFragment)other;
            if (!Intrinsics.areEqual((Object)this.wholeUrl, (Object)urlFragment.wholeUrl)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.schemaRangeInHost, (Object)urlFragment.schemaRangeInHost)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.hostElement, (Object)urlFragment.hostElement);
        }
    }
}

