/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.parsing;

import com.intellij.codeWithMe.ClientId;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.javascript.parsing.JSParsingContextService;
import com.intellij.lang.javascript.parsing.modifiers.JSModifiersStructure;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0018\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J$\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u001e\u0010\u0019\u001a\u00020\f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u000f\u001a\u00020\u0010H\u0007R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0007\u001a\u0015\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00068\u0006X\u0087D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/lang/javascript/parsing/JSParsingContextUtil;", "", "<init>", "()V", "ASYNC_METHOD_KEY", "Lcom/intellij/openapi/util/Key;", "", "IS_GENERATOR_FUNCTION_KEY", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "IS_TOP_LEVEL_ASYNC", "fillBuilderData", "", "context", "Lcom/intellij/psi/PsiElement;", "builder", "Lcom/intellij/lang/PsiBuilder;", "isAsyncContext", "isGeneratorContext", "setIsGenerator", "isGenerator", "saveAndUpdateParsingContext", "Ljava/util/EnumSet;", "Lcom/intellij/lang/javascript/parsing/modifiers/JSModifiersStructure$JSModifiersParseResult;", "newContext", "restoreParsingContext", "savedContext", "intellij.javascript.parser"})
@SourceDebugExtension(value={"SMAP\nJSParsingContextUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSParsingContextUtil.kt\ncom/intellij/lang/javascript/parsing/JSParsingContextUtil\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,74:1\n40#2,3:75\n*S KotlinDebug\n*F\n+ 1 JSParsingContextUtil.kt\ncom/intellij/lang/javascript/parsing/JSParsingContextUtil\n*L\n23#1:75,3\n*E\n"})
public final class JSParsingContextUtil {
    @NotNull
    public static final JSParsingContextUtil INSTANCE = new JSParsingContextUtil();
    @JvmField
    @NotNull
    public static final Key<Boolean> ASYNC_METHOD_KEY;
    @NotNull
    private static final Key<Boolean> IS_GENERATOR_FUNCTION_KEY;
    @JvmField
    public static final boolean IS_TOP_LEVEL_ASYNC;

    private JSParsingContextUtil() {
    }

    @JvmStatic
    public static final void fillBuilderData(@NotNull PsiElement context, @NotNull PsiBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        boolean $i$f$service = false;
        Class<JSParsingContextService> serviceClass$iv = JSParsingContextService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        ((JSParsingContextService)object).fillBuilderData(context, builder);
    }

    @JvmStatic
    public static final boolean isAsyncContext(@NotNull PsiBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Boolean bl = (Boolean)builder.getUserData(ASYNC_METHOD_KEY);
        return bl != null ? bl : IS_TOP_LEVEL_ASYNC;
    }

    @JvmStatic
    public static final boolean isGeneratorContext(@NotNull PsiBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Boolean bl = (Boolean)builder.getUserData(IS_GENERATOR_FUNCTION_KEY);
        return bl != null ? bl : false;
    }

    @JvmStatic
    public static final void setIsGenerator(boolean isGenerator, @NotNull PsiBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.putUserData(IS_GENERATOR_FUNCTION_KEY, (Object)isGenerator);
    }

    @JvmStatic
    @NotNull
    public static final EnumSet<JSModifiersStructure.JSModifiersParseResult> saveAndUpdateParsingContext(@NotNull EnumSet<JSModifiersStructure.JSModifiersParseResult> newContext, @NotNull PsiBuilder builder) {
        EnumSet<Enum> enumSet;
        Intrinsics.checkNotNullParameter(newContext, (String)"newContext");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        boolean wasGeneratorContext = JSParsingContextUtil.isGeneratorContext(builder);
        boolean wasAsyncContext = JSParsingContextUtil.isAsyncContext(builder);
        JSParsingContextUtil.restoreParsingContext(newContext, builder);
        if (wasGeneratorContext) {
            EnumSet<Enum> enumSet2 = wasAsyncContext ? EnumSet.of((Enum)JSModifiersStructure.JSModifiersParseResult.MULT_FOUND, (Enum)JSModifiersStructure.JSModifiersParseResult.ASYNC_FOUND) : EnumSet.of((Enum)JSModifiersStructure.JSModifiersParseResult.MULT_FOUND);
            Intrinsics.checkNotNull(enumSet2);
            enumSet = enumSet2;
        } else if (wasAsyncContext) {
            EnumSet<Enum> enumSet3 = EnumSet.of((Enum)JSModifiersStructure.JSModifiersParseResult.ASYNC_FOUND);
            enumSet = enumSet3;
            Intrinsics.checkNotNullExpressionValue(enumSet3, (String)"of(...)");
        } else {
            EnumSet<JSModifiersStructure.JSModifiersParseResult> enumSet4 = EnumSet.noneOf(JSModifiersStructure.JSModifiersParseResult.class);
            enumSet = enumSet4;
            Intrinsics.checkNotNullExpressionValue(enumSet4, (String)"noneOf(...)");
        }
        return enumSet;
    }

    @JvmStatic
    public static final void restoreParsingContext(@NotNull EnumSet<JSModifiersStructure.JSModifiersParseResult> savedContext, @NotNull PsiBuilder builder) {
        Intrinsics.checkNotNullParameter(savedContext, (String)"savedContext");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        JSParsingContextUtil.setIsGenerator(savedContext.contains((Object)JSModifiersStructure.JSModifiersParseResult.MULT_FOUND), builder);
        builder.putUserData(ASYNC_METHOD_KEY, (Object)savedContext.contains((Object)JSModifiersStructure.JSModifiersParseResult.ASYNC_FOUND));
    }

    static {
        Key key = Key.create((String)"js.asyncMethod");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        ASYNC_METHOD_KEY = key;
        Key key2 = Key.create((String)"js.generator.Function");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        IS_GENERATOR_FUNCTION_KEY = key2;
        IS_TOP_LEVEL_ASYNC = true;
    }
}

