/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.gson.stream.JsonReader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.webcore.util.JsonUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NodeCoreModulesCatalog {
    private static final Logger LOG;
    private static final String FILE_NAME = "node-core-modules-catalog.json";
    public static final NodeCoreModulesCatalog INSTANCE;
    private final Set<String> myPublicAllCoreModules;
    private final Set<String> myPublicExcludedCoreModules;
    private final Set<String> myPrivateIncludedCoreModules;
    private final Map<String, String> myPublicReplacementMap;

    private NodeCoreModulesCatalog(@NotNull List<String> publicAllCoreModules, @NotNull List<String> publicExcludedCoreModules, @NotNull List<String> privateIncludedCoreModules, @NotNull Map<String, String> publicReplacementMap) {
        if (publicAllCoreModules == null) {
            NodeCoreModulesCatalog.$$$reportNull$$$0(0);
        }
        if (publicExcludedCoreModules == null) {
            NodeCoreModulesCatalog.$$$reportNull$$$0(1);
        }
        if (privateIncludedCoreModules == null) {
            NodeCoreModulesCatalog.$$$reportNull$$$0(2);
        }
        if (publicReplacementMap == null) {
            NodeCoreModulesCatalog.$$$reportNull$$$0(3);
        }
        this.myPublicAllCoreModules = ImmutableSet.copyOf(publicAllCoreModules);
        this.myPublicExcludedCoreModules = ImmutableSet.copyOf(publicExcludedCoreModules);
        this.myPrivateIncludedCoreModules = ImmutableSet.copyOf(privateIncludedCoreModules);
        this.myPublicReplacementMap = Map.copyOf(publicReplacementMap);
    }

    @NotNull
    public ImmutableList<String> getPublicCoreModules() {
        ImmutableList immutableList = ImmutableList.copyOf(this.myPublicAllCoreModules);
        if (immutableList == null) {
            NodeCoreModulesCatalog.$$$reportNull$$$0(4);
        }
        return immutableList;
    }

    public boolean isPublicCoreModule(@Nullable String name) {
        return this.myPublicAllCoreModules.contains(name);
    }

    public boolean isIncludedCoreModule(String name) {
        if (this.myPublicAllCoreModules.contains(name) && !this.myPublicExcludedCoreModules.contains(name)) {
            return true;
        }
        return this.myPrivateIncludedCoreModules.contains(name);
    }

    public boolean isPublicExcludedCoreModule(String name) {
        return this.myPublicExcludedCoreModules.contains(name);
    }

    public boolean isPrivateIncludedCoreModule(String name) {
        return this.myPrivateIncludedCoreModules.contains(name);
    }

    @Nullable
    public String getPublicReplacementName(@NotNull String path2) {
        if (path2 == null) {
            NodeCoreModulesCatalog.$$$reportNull$$$0(5);
        }
        return this.myPublicReplacementMap.get(path2);
    }

    @NotNull
    private static NodeCoreModulesCatalog parse() throws IOException {
        InputStream stream = NodeCoreModulesCatalog.class.getResourceAsStream(FILE_NAME);
        if (stream == null) {
            throw new IOException("NodeJS plugin installation is possibly broken. Cannot find node-core-modules-catalog.json");
        }
        NodeCoreModulesCatalog nodeCoreModulesCatalog = NodeCoreModulesCatalog.doParse(stream);
        NodeCoreModulesCatalog nodeCoreModulesCatalog2 = nodeCoreModulesCatalog;
        if (nodeCoreModulesCatalog2 == null) {
            NodeCoreModulesCatalog.$$$reportNull$$$0(6);
        }
        return nodeCoreModulesCatalog2;
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    LOG.error("Failed to close stream", (Throwable)e);
                }
            }
        }
    }

    @NotNull
    private static NodeCoreModulesCatalog doParse(@NotNull InputStream stream) throws IOException {
        if (stream == null) {
            NodeCoreModulesCatalog.$$$reportNull$$$0(7);
        }
        JsonReader reader = new JsonReader((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8));
        reader.beginObject();
        List publicAllNames = Collections.emptyList();
        List publicExcludedNames = Collections.emptyList();
        List privateIncludedNames = Collections.emptyList();
        Map<String, String> publicReplacement = Collections.emptyMap();
        while (reader.hasNext()) {
            String type2 = reader.nextName();
            if ("public-all".equals(type2)) {
                publicAllNames = JsonUtil.nextStringList((JsonReader)reader);
                continue;
            }
            if ("public-excluded".equals(type2)) {
                publicExcludedNames = JsonUtil.nextStringList((JsonReader)reader);
                continue;
            }
            if ("private-included".equals(type2)) {
                privateIncludedNames = JsonUtil.nextStringList((JsonReader)reader);
                continue;
            }
            if (!"public-replacement".equals(type2)) continue;
            Map map2 = JsonUtil.nextMap((JsonReader)reader);
            publicReplacement = new HashMap<String, String>();
            for (Map.Entry entry : map2.entrySet()) {
                publicReplacement.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        reader.endObject();
        return new NodeCoreModulesCatalog(publicAllNames, publicExcludedNames, privateIncludedNames, publicReplacement);
    }

    static {
        NodeCoreModulesCatalog catalog;
        LOG = Logger.getInstance(NodeCoreModulesCatalog.class);
        try {
            catalog = NodeCoreModulesCatalog.parse();
        }
        catch (IOException e) {
            LOG.error("Failed to list core modules", (Throwable)e);
            List<String> empty2 = Collections.emptyList();
            catalog = new NodeCoreModulesCatalog(empty2, empty2, empty2, Collections.emptyMap());
        }
        INSTANCE = catalog;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "publicAllCoreModules";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "publicExcludedCoreModules";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "privateIncludedCoreModules";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "publicReplacementMap";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/core/NodeCoreModulesCatalog";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/core/NodeCoreModulesCatalog";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPublicCoreModules";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPublicReplacementName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doParse";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6 -> new IllegalStateException(string);
        };
    }
}

