/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.base;

import com.google.common.collect.ImmutableList;
import com.intellij.lang.javascript.buildTools.base.JsbtFileStructure;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JsbtTaskSet {
    private final JsbtFileStructure myStructure;
    private final List<@NlsSafe String> myTaskNames;
    private String myArguments;

    public JsbtTaskSet(@NotNull JsbtFileStructure structure, @NotNull List<@NlsSafe String> taskNames) {
        if (structure == null) {
            JsbtTaskSet.$$$reportNull$$$0(0);
        }
        if (taskNames == null) {
            JsbtTaskSet.$$$reportNull$$$0(1);
        }
        this.myArguments = "";
        this.myStructure = structure;
        if (taskNames.isEmpty()) {
            throw new AssertionError((Object)"Not empty task name list expected");
        }
        this.myTaskNames = ImmutableList.copyOf(taskNames);
    }

    @NotNull
    @Nls
    public String getName() {
        String string = StringUtil.join(this.myTaskNames, (String)", ");
        if (string == null) {
            JsbtTaskSet.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public JsbtFileStructure getStructure() {
        JsbtFileStructure jsbtFileStructure = this.myStructure;
        if (jsbtFileStructure == null) {
            JsbtTaskSet.$$$reportNull$$$0(3);
        }
        return jsbtFileStructure;
    }

    @NotNull
    public List<String> getTaskNames() {
        List<String> list = this.myTaskNames;
        if (list == null) {
            JsbtTaskSet.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public String getArguments() {
        String string = this.myArguments;
        if (string == null) {
            JsbtTaskSet.$$$reportNull$$$0(5);
        }
        return string;
    }

    public void setArguments(@NotNull String arguments) {
        if (arguments == null) {
            JsbtTaskSet.$$$reportNull$$$0(6);
        }
        this.myArguments = arguments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsbtTaskSet set = (JsbtTaskSet)o;
        return Objects.equals(this.myStructure.getBuildfile(), set.myStructure.getBuildfile()) && Objects.equals(this.myTaskNames, set.myTaskNames);
    }

    public int hashCode() {
        return Objects.hash(this.myStructure.getBuildfile(), this.myTaskNames);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structure";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskNames";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/base/JsbtTaskSet";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/base/JsbtTaskSet";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStructure";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTaskNames";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setArguments";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

