/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.grunt;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.lang.javascript.buildTools.base.JsbtFileStructure;
import com.intellij.lang.javascript.buildTools.base.JsbtTree;
import com.intellij.lang.javascript.buildTools.grunt.GruntAliasTask;
import com.intellij.lang.javascript.buildTools.grunt.GruntCoreTask;
import com.intellij.lang.javascript.buildTools.grunt.GruntTargetTask;
import com.intellij.lang.javascript.buildTools.grunt.GruntTask;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GruntfileStructure
extends JsbtFileStructure {
    private List<GruntAliasTask> myAliasTasks;
    private List<GruntCoreTask> myCoreTasks;
    private Map<String, GruntTask> myTaskByNameMap;

    public GruntfileStructure(@NotNull VirtualFile buildfile) {
        if (buildfile == null) {
            GruntfileStructure.$$$reportNull$$$0(0);
        }
        super(buildfile);
        this.myAliasTasks = ImmutableList.of();
        this.myCoreTasks = ImmutableList.of();
        this.myTaskByNameMap = ImmutableMap.of();
    }

    @Override
    @NotNull
    public List<String> getTaskNames() {
        ImmutableList immutableList = ImmutableList.copyOf(this.myTaskByNameMap.keySet());
        if (immutableList == null) {
            GruntfileStructure.$$$reportNull$$$0(1);
        }
        return immutableList;
    }

    @NotNull
    public List<GruntAliasTask> getAliasTasks() {
        List<GruntAliasTask> list = this.myAliasTasks;
        if (list == null) {
            GruntfileStructure.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public List<GruntCoreTask> getCoreTasks() {
        List<GruntCoreTask> list = this.myCoreTasks;
        if (list == null) {
            GruntfileStructure.$$$reportNull$$$0(3);
        }
        return list;
    }

    public void setTasks(@NotNull List<GruntAliasTask> aliasTasks, @NotNull List<GruntCoreTask> coreTasks) {
        if (aliasTasks == null) {
            GruntfileStructure.$$$reportNull$$$0(4);
        }
        if (coreTasks == null) {
            GruntfileStructure.$$$reportNull$$$0(5);
        }
        this.myAliasTasks = ImmutableList.copyOf(aliasTasks);
        this.myCoreTasks = ImmutableList.copyOf(coreTasks);
        LinkedHashMap<String, GruntTask> taskByNameMap = new LinkedHashMap<String, GruntTask>();
        for (GruntAliasTask aliasTask : aliasTasks) {
            taskByNameMap.put(aliasTask.getName(), aliasTask);
        }
        for (GruntCoreTask coreTask : coreTasks) {
            taskByNameMap.put(coreTask.getName(), coreTask);
            for (GruntTargetTask targetTask : coreTask.getTargetTasks()) {
                taskByNameMap.put(targetTask.getName(), targetTask);
            }
        }
        this.myTaskByNameMap = ImmutableMap.copyOf(taskByNameMap);
    }

    @Nullable
    public GruntTask findTaskByName(@NotNull String name) {
        if (name == null) {
            GruntfileStructure.$$$reportNull$$$0(6);
        }
        return this.myTaskByNameMap.get(name);
    }

    @Nullable
    public static GruntfileStructure getUserObject(@Nullable DefaultMutableTreeNode node) {
        return JsbtTree.getUserObject(node, GruntfileStructure.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildfile";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/grunt/GruntfileStructure";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aliasTasks";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coreTasks";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/grunt/GruntfileStructure";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTaskNames";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAliasTasks";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoreTasks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setTasks";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findTaskByName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

