/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.json.psi.JsonProperty;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.base.JsbtFileStructure;
import com.intellij.lang.javascript.buildTools.base.JsbtSortingMode;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskSet;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskTreeView;
import com.intellij.lang.javascript.buildTools.npm.NpmScript;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsService;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsStructure;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import icons.JavaScriptLanguageIcons;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public final class NpmTaskTreeView
extends JsbtTaskTreeView {
    @PropertyKey(resourceBundle="messages.JavaScriptBundle")
    private static final @PropertyKey(resourceBundle="messages.JavaScriptBundle") String NO_SCRIPTS_FOUND_KEY = "npm.no.scripts.found";

    public NpmTaskTreeView(@NotNull NpmScriptsService service, @NotNull Project project, @Nullable String layoutPlace) {
        if (service == null) {
            NpmTaskTreeView.$$$reportNull$$$0(0);
        }
        if (project == null) {
            NpmTaskTreeView.$$$reportNull$$$0(1);
        }
        super(service, project, layoutPlace);
    }

    @Override
    protected void addBuildfileChildren(@NotNull DefaultMutableTreeNode buildfileTreeNode, @NotNull JsbtFileStructure _structure) {
        if (buildfileTreeNode == null) {
            NpmTaskTreeView.$$$reportNull$$$0(2);
        }
        if (_structure == null) {
            NpmTaskTreeView.$$$reportNull$$$0(3);
        }
        NpmScriptsStructure structure = (NpmScriptsStructure)_structure;
        for (NpmScript script : structure.getScripts()) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(script, false);
            buildfileTreeNode.add(node);
        }
        if (structure.getScripts().isEmpty()) {
            buildfileTreeNode.add(new DefaultMutableTreeNode(JavaScriptBundle.message(NO_SCRIPTS_FOUND_KEY, new Object[0]), false));
        }
    }

    @Override
    protected int compareNodes(@NotNull DefaultMutableTreeNode node1, @NotNull DefaultMutableTreeNode node2, @NotNull JsbtSortingMode sortingMode) {
        if (node1 == null) {
            NpmTaskTreeView.$$$reportNull$$$0(4);
        }
        if (node2 == null) {
            NpmTaskTreeView.$$$reportNull$$$0(5);
        }
        if (sortingMode == null) {
            NpmTaskTreeView.$$$reportNull$$$0(6);
        }
        NpmScript script1 = NpmScript.getUserObject(node1);
        NpmScript script2 = NpmScript.getUserObject(node2);
        if (script1 == null || script2 == null) {
            if (script1 == null && script2 == null) {
                return 0;
            }
            return script1 == null ? 1 : -1;
        }
        if (sortingMode == JsbtSortingMode.NAME) {
            return script1.getName().compareTo(script2.getName());
        }
        return NpmTaskTreeView.getPosition(script1) - NpmTaskTreeView.getPosition(script2);
    }

    private static int getPosition(@NotNull NpmScript script) {
        if (script == null) {
            NpmTaskTreeView.$$$reportNull$$$0(7);
        }
        return script.getStructure().getScripts().indexOf(script);
    }

    @Override
    protected boolean hasTaskNodes(@NotNull DefaultMutableTreeNode packageJsonTreeNode) {
        if (packageJsonTreeNode == null) {
            NpmTaskTreeView.$$$reportNull$$$0(8);
        }
        int childCount = packageJsonTreeNode.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)ObjectUtils.tryCast((Object)packageJsonTreeNode.getChildAt(i), DefaultMutableTreeNode.class);
            NpmScript task = NpmScript.getUserObject(child);
            if (task == null) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void customizeCell(@NotNull Project project, @NotNull ColoredTreeCellRenderer renderer, @NotNull DefaultMutableTreeNode node) {
        NpmScriptsStructure structure;
        if (project == null) {
            NpmTaskTreeView.$$$reportNull$$$0(9);
        }
        if (renderer == null) {
            NpmTaskTreeView.$$$reportNull$$$0(10);
        }
        if (node == null) {
            NpmTaskTreeView.$$$reportNull$$$0(11);
        }
        if ((structure = NpmScriptsStructure.getUserObject(node)) != null) {
            renderer.setIcon(JavaScriptLanguageIcons.BuildTools.Npm.Npm_16);
            renderer.setIconOnTheRight(false);
            renderer.append(structure.getPresentablePath());
            return;
        }
        if (JavaScriptBundle.message(NO_SCRIPTS_FOUND_KEY, new Object[0]).equals(node.getUserObject())) {
            renderer.append(JavaScriptBundle.message(NO_SCRIPTS_FOUND_KEY, new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            return;
        }
        NpmScript script = NpmScript.getUserObject(node);
        if (script != null) {
            renderer.setIcon(IconManager.getInstance().getPlatformIcon(PlatformIcons.Local));
            renderer.append(script.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }

    @Override
    @Nullable
    protected String getPersistentId(@NotNull DefaultMutableTreeNode node) {
        NpmScriptsStructure structure;
        if (node == null) {
            NpmTaskTreeView.$$$reportNull$$$0(12);
        }
        if ((structure = NpmScriptsStructure.getUserObject(node)) != null) {
            return structure.getBuildfile().getPath();
        }
        NpmScript script = NpmScript.getUserObject(node);
        return script != null ? script.getName() : null;
    }

    @Override
    protected String getPresentableTaskName(@NotNull DefaultMutableTreeNode node) {
        NpmScript script;
        if (node == null) {
            NpmTaskTreeView.$$$reportNull$$$0(13);
        }
        return (script = NpmScript.getUserObject(node)) != null ? script.getName() : null;
    }

    @Override
    @Nullable
    protected JsbtTaskSet createTaskSetFromSelectedNodes() {
        List<DefaultMutableTreeNode> nodes = this.getSelectedNodes();
        if (nodes.isEmpty()) {
            return null;
        }
        NpmScriptsStructure resultStructure = null;
        SmartList taskNames = new SmartList();
        for (DefaultMutableTreeNode node : nodes) {
            NpmScript script = NpmScript.getUserObject(node);
            if (script == null) {
                return null;
            }
            NpmScriptsStructure structure = script.getStructure();
            if (resultStructure != null && !resultStructure.equals(structure)) {
                return null;
            }
            resultStructure = structure;
            taskNames.add(script.getName());
        }
        if (resultStructure == null) {
            return null;
        }
        return new JsbtTaskSet(resultStructure, (List<String>)taskNames);
    }

    @Override
    @Nullable
    protected Navigatable createJumpToSourceDescriptor(@NotNull Project project, @NotNull DefaultMutableTreeNode node) {
        Location location;
        VirtualFile virtualPackageJson;
        JsonProperty property;
        NpmScript script;
        if (project == null) {
            NpmTaskTreeView.$$$reportNull$$$0(14);
        }
        if (node == null) {
            NpmTaskTreeView.$$$reportNull$$$0(15);
        }
        if ((script = NpmScript.getUserObject(node)) != null && (property = NpmScriptsUtil.findScriptProperty(project, virtualPackageJson = script.getStructure().getBuildfile(), script.getName())) != null && (location = PsiLocation.fromPsiElement((PsiElement)property)) != null) {
            return location.getOpenFileDescriptor();
        }
        return null;
    }

    @Override
    protected boolean shouldShowSettingMenuItem() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 1: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildfileTreeNode";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_structure";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node1";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node2";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sortingMode";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "script";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJsonTreeNode";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/buildTools/npm/NpmTaskTreeView";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addBuildfileChildren";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "compareNodes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getPosition";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "hasTaskNodes";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "customizeCell";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getPersistentId";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getPresentableTaskName";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "createJumpToSourceDescriptor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

