/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm.rc;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonProperty;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsService;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmConfigurationType;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfiguration;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunSettings;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NpmRunConfigurationProducer
extends LazyRunConfigurationProducer<NpmRunConfiguration> {
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        ConfigurationFactory configurationFactory = (ConfigurationFactory)ConfigurationTypeUtil.findConfigurationType(NpmConfigurationType.class);
        if (configurationFactory == null) {
            NpmRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        return configurationFactory;
    }

    protected boolean setupConfigurationFromContext(@NotNull NpmRunConfiguration configuration, @NotNull ConfigurationContext context2, @NotNull Ref<PsiElement> sourceElement) {
        NpmRunSettings runSettings;
        if (configuration == null) {
            NpmRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (context2 == null) {
            NpmRunConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (sourceElement == null) {
            NpmRunConfigurationProducer.$$$reportNull$$$0(3);
        }
        if ((runSettings = NpmRunConfigurationProducer.createRunSettingsFromContext(configuration.getRunSettings(), context2, sourceElement)) == null) {
            return false;
        }
        NpmRunConfigurationProducer.setupConfigurationFromSettings(configuration, runSettings);
        return true;
    }

    public boolean isConfigurationFromContext(@NotNull NpmRunConfiguration configuration, @NotNull ConfigurationContext context2) {
        NpmRunSettings thisRunSettings;
        if (configuration == null) {
            NpmRunConfigurationProducer.$$$reportNull$$$0(4);
        }
        if (context2 == null) {
            NpmRunConfigurationProducer.$$$reportNull$$$0(5);
        }
        if ((thisRunSettings = NpmRunConfigurationProducer.createRunSettingsFromContext(configuration.getRunSettings(), context2, null)) == null) {
            return false;
        }
        return NpmScriptsService.getInstance(configuration.getProject()).isConfigurationMatched((RunConfiguration)configuration, thisRunSettings);
    }

    public static void setupConfigurationFromSettings(@NotNull NpmRunConfiguration configuration, @NotNull NpmRunSettings runSettings) {
        if (configuration == null) {
            NpmRunConfigurationProducer.$$$reportNull$$$0(6);
        }
        if (runSettings == null) {
            NpmRunConfigurationProducer.$$$reportNull$$$0(7);
        }
        configuration.setRunSettings(runSettings);
        configuration.setGeneratedName();
    }

    @Nullable
    private static NpmRunSettings createRunSettingsFromContext(@NotNull NpmRunSettings templateRunSettings, @NotNull ConfigurationContext context2, @Nullable Ref<PsiElement> sourceElement) {
        PsiElement element2;
        if (templateRunSettings == null) {
            NpmRunConfigurationProducer.$$$reportNull$$$0(8);
        }
        if (context2 == null) {
            NpmRunConfigurationProducer.$$$reportNull$$$0(9);
        }
        if ((element2 = NpmRunConfigurationProducer.getElement(context2)) == null || !element2.isValid()) {
            return null;
        }
        JsonFile psiPackageJson = PackageJsonUtil.getContainingPackageJsonFile(element2);
        if (psiPackageJson == null) {
            return null;
        }
        VirtualFile virtualPackageJson = psiPackageJson.getVirtualFile();
        if (virtualPackageJson == null) {
            return null;
        }
        JsonProperty scriptProperty = NpmRunConfigurationProducer.findContainingScriptProperty(element2);
        if (scriptProperty == null) {
            return null;
        }
        NpmRunSettings.Builder builder2 = templateRunSettings.toBuilder();
        builder2.setPackageJsonPath(virtualPackageJson.getPath());
        builder2.setCommand(NpmCommand.RUN_SCRIPT);
        builder2.setScriptNames(Collections.singletonList(scriptProperty.getName()));
        if (sourceElement != null) {
            sourceElement.set((Object)scriptProperty);
        }
        return builder2.build();
    }

    @Nullable
    private static PsiElement getElement(@NotNull ConfigurationContext context2) {
        Location location;
        if (context2 == null) {
            NpmRunConfigurationProducer.$$$reportNull$$$0(10);
        }
        return (location = context2.getLocation()) != null ? location.getPsiElement() : null;
    }

    @Nullable
    private static JsonProperty findContainingScriptProperty(@NotNull PsiElement element2) {
        JsonProperty scriptProperty;
        JsonProperty scriptsProperty;
        if (element2 == null) {
            NpmRunConfigurationProducer.$$$reportNull$$$0(11);
        }
        if ((scriptsProperty = PackageJsonUtil.findContainingTopLevelProperty((PsiElement)(scriptProperty = PackageJsonUtil.findContainingProperty(element2)))) != null && "scripts".equals(scriptsProperty.getName()) && scriptProperty != scriptsProperty) {
            return scriptProperty;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfigurationProducer";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runSettings";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateRunSettings";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfigurationProducer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromContext";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromContext";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromSettings";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createRunSettingsFromContext";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getElement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findContainingScriptProperty";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> new IllegalArgumentException(string);
        };
    }
}

