/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.editing;

import com.intellij.codeInsight.hints.declarative.HintFontSize;
import com.intellij.codeInsight.hints.declarative.HintFormat;
import com.intellij.codeInsight.hints.declarative.HintMarginPadding;
import com.intellij.codeInsight.hints.declarative.InlayHintsCollector;
import com.intellij.codeInsight.hints.declarative.InlayHintsProvider;
import com.intellij.codeInsight.hints.declarative.InlayPosition;
import com.intellij.codeInsight.hints.declarative.InlayTreeSink;
import com.intellij.codeInsight.hints.declarative.InlineInlayPosition;
import com.intellij.codeInsight.hints.declarative.PresentationTreeBuilder;
import com.intellij.codeInsight.hints.declarative.SharedBypassCollector;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.editing.JSDeclarativeTypeHintsFactory;
import com.intellij.lang.javascript.hints.JSCodeVisionLocations;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSFunctionReturnWrapperType;
import com.intellij.lang.javascript.psi.types.JSIntersectionType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyType;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.refactoring.util.JSFunctionsRefactoringUtil;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 \u001e2\u00020\u0001:\u0004\u001e\u001f !B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\"\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u000b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d\u00a8\u0006\""}, d2={"Lcom/intellij/lang/javascript/editing/JSDeclarativeTypeHintsInlayProvider;", "Lcom/intellij/codeInsight/hints/declarative/InlayHintsProvider;", "<init>", "()V", "createCollector", "Lcom/intellij/codeInsight/hints/declarative/InlayHintsCollector;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isLanguageSupported", "", "language", "Lcom/intellij/lang/Language;", "isSupportedDialect", "dialectOfElement", "Lcom/intellij/lang/javascript/DialectOptionHolder;", "getLanguageServiceUsage", "Lcom/intellij/lang/javascript/editing/JSDeclarativeTypeHintsInlayProvider$LanguageServiceUsage;", "getTypeFromService", "", "element", "Lcom/intellij/lang/javascript/psi/JSElement;", "kind", "Lcom/intellij/lang/javascript/editing/JSDeclarativeTypeHintsInlayProvider$HintFromServiceKind;", "serviceTimeoutMs", "", "isSuitableType", "jsType", "Lcom/intellij/lang/javascript/psi/JSType;", "Companion", "HintFromServiceKind", "LanguageServiceUsage", "Collector", "intellij.javascript.impl"})
public class JSDeclarativeTypeHintsInlayProvider
implements InlayHintsProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PROVIDER_ID = "ts.type.hints";
    @NotNull
    public static final String SHOW_FOR_SHORTHAND_FUNCTIONS = "non.paren.single.param";
    @NotNull
    public static final String SHOW_FOR_INFERRED_PARAMETERS = "parameters.in.parens";
    @NotNull
    public static final String SHOW_FOR_VARIABLES_AND_FIELDS = "variables.and.fields";
    @NotNull
    public static final String SHOW_FOR_FUNCTIONS = "function.returns";

    @Nullable
    public InlayHintsCollector createCollector(@NotNull PsiFile file, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Language language = file.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        if (!this.isLanguageSupported(language)) {
            return null;
        }
        if (!this.isSupportedDialect(DialectDetector.dialectOfElement((PsiElement)file))) {
            return null;
        }
        if (!JSCodeVisionLocations.INSTANCE.acceptsFileContent(file)) {
            return null;
        }
        return (InlayHintsCollector)new Collector();
    }

    public boolean isLanguageSupported(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return true;
    }

    protected boolean isSupportedDialect(@Nullable DialectOptionHolder dialectOfElement) {
        return dialectOfElement != null && dialectOfElement.isJavaScript() && !dialectOfElement.isQML;
    }

    @NotNull
    public LanguageServiceUsage getLanguageServiceUsage() {
        return LanguageServiceUsage.ONLY_INTERNAL;
    }

    @Nullable
    public String getTypeFromService(@NotNull JSElement element2, @NotNull HintFromServiceKind kind, long serviceTimeoutMs) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        return null;
    }

    public final boolean isSuitableType(@Nullable JSType jsType) {
        return jsType == null ? false : (JSTypeUtils.isAnyType(jsType) ? false : (jsType instanceof JSNamedType && ((JSNamedType)jsType).getTypeContext() == JSTypeContext.STATIC ? false : (jsType instanceof JSIntersectionType && ((JSIntersectionType)jsType).getTypes().size() == 2 && ((JSIntersectionType)jsType).getTypes().get(0) instanceof JSAnyType ? this.isSuitableType(((JSIntersectionType)jsType).getTypes().get(1)) : (jsType instanceof JSIntersectionType && ((JSIntersectionType)jsType).getTypes().size() == 2 && ((JSIntersectionType)jsType).getTypes().get(1) instanceof JSAnyType ? this.isSuitableType(((JSIntersectionType)jsType).getTypes().get(0)) : !(jsType instanceof JSFunctionType)))));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J0\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J\"\u0010\u001b\u001a\u00020\u00052\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u001a\u0010\u001e\u001a\u00020\u00142\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/lang/javascript/editing/JSDeclarativeTypeHintsInlayProvider$Collector;", "Lcom/intellij/codeInsight/hints/declarative/SharedBypassCollector;", "<init>", "(Lcom/intellij/lang/javascript/editing/JSDeclarativeTypeHintsInlayProvider;)V", "collectFromElement", "", "element", "Lcom/intellij/psi/PsiElement;", "sink", "Lcom/intellij/codeInsight/hints/declarative/InlayTreeSink;", "collectFromElementForActions", "doCollectFromElement", "serviceTimeoutMs", "", "addFieldOrVariableHint", "Lcom/intellij/lang/javascript/psi/JSNamedElement;", "addFunctionReturnTypeHint", "func", "Lcom/intellij/lang/javascript/psi/JSFunction;", "addHintFromLanguageService", "", "Lcom/intellij/lang/javascript/psi/JSElement;", "anchor", "hintKind", "Lcom/intellij/lang/javascript/editing/JSDeclarativeTypeHintsInlayProvider$HintFromServiceKind;", "hintFormat", "Lcom/intellij/codeInsight/hints/declarative/HintFormat;", "addJsTypeHint", "jsType", "Lcom/intellij/lang/javascript/psi/JSType;", "isFrameworkDefinedType", "intellij.javascript.impl"})
    private final class Collector
    implements SharedBypassCollector {
        @NotNull
        private final HintFormat hintFormat = HintFormat.Companion.getDefault().withFontSize(HintFontSize.ABitSmallerThanInEditor).withHorizontalMargin(HintMarginPadding.MarginAndSmallerPadding);

        public void collectFromElement(@NotNull PsiElement element2, @NotNull InlayTreeSink sink) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            this.doCollectFromElement(element2, sink, JSLanguageServiceUtil.getTimeout());
        }

        public void collectFromElementForActions(@NotNull PsiElement element2, @NotNull InlayTreeSink sink) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            this.doCollectFromElement(element2, sink, JSLanguageServiceUtil.getShortTimeout());
        }

        private final void doCollectFromElement(PsiElement element2, InlayTreeSink sink, long serviceTimeoutMs) {
            if (element2 instanceof JSTypeDeclarationOwner && ((JSTypeDeclarationOwner)element2).getTypeElement() == null && element2 instanceof JSNamedElement && !(element2 instanceof TypeScriptEnumField)) {
                if (element2 instanceof JSParameter) {
                    boolean isShorthand;
                    PsiElement parent = ((JSParameter)element2).getParent();
                    boolean bl = isShorthand = parent instanceof JSParameterList && JSFunctionsRefactoringUtil.noBracesAroundSingleParameter((JSParameterList)parent);
                    if (isShorthand) {
                        sink.whenOptionEnabled(JSDeclarativeTypeHintsInlayProvider.SHOW_FOR_SHORTHAND_FUNCTIONS, () -> Collector.doCollectFromElement$lambda$0(this, element2, sink, serviceTimeoutMs));
                    } else {
                        sink.whenOptionEnabled(JSDeclarativeTypeHintsInlayProvider.SHOW_FOR_INFERRED_PARAMETERS, () -> Collector.doCollectFromElement$lambda$1(this, element2, sink, serviceTimeoutMs));
                    }
                } else {
                    sink.whenOptionEnabled(JSDeclarativeTypeHintsInlayProvider.SHOW_FOR_VARIABLES_AND_FIELDS, () -> Collector.doCollectFromElement$lambda$2(this, element2, sink, serviceTimeoutMs));
                }
            } else if (element2 instanceof JSFunction && ((JSFunction)element2).getReturnTypeElement() == null) {
                sink.whenOptionEnabled(JSDeclarativeTypeHintsInlayProvider.SHOW_FOR_FUNCTIONS, () -> Collector.doCollectFromElement$lambda$3(this, element2, sink, serviceTimeoutMs));
            }
        }

        private final void addFieldOrVariableHint(JSNamedElement element2, InlayTreeSink sink, long serviceTimeoutMs) {
            PsiElement nameIdentifier;
            PsiElement elementParent = element2.getParent();
            while (JSDestructuringUtil.isDestructuring(elementParent)) {
                if (elementParent instanceof JSTypeDeclarationOwner && ((JSTypeDeclarationOwner)elementParent).getTypeElement() != null) {
                    return;
                }
                elementParent = elementParent.getParent();
            }
            PsiElement psiElement = element2.getNameIdentifier();
            if (psiElement == null) {
                return;
            }
            PsiElement anchor = nameIdentifier = psiElement;
            PsiElement nextElement = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)nameIdentifier);
            IElementType elementType = PsiUtilCore.getElementType((PsiElement)nextElement);
            if (nextElement != null && (Intrinsics.areEqual((Object)elementType, (Object)JSTokenTypes.QUEST) || Intrinsics.areEqual((Object)elementType, (Object)JSTokenTypes.EXCL))) {
                anchor = nextElement;
            }
            if (this.addHintFromLanguageService(element2, anchor, HintFromServiceKind.FIELD_OR_VAR_TYPE, sink, serviceTimeoutMs)) {
                return;
            }
            JSType jsType = JSResolveUtil.getElementJSType((PsiElement)element2);
            if (this.isFrameworkDefinedType(jsType, (PsiElement)element2)) {
                return;
            }
            this.addJsTypeHint(jsType, anchor, sink);
        }

        private final void addFunctionReturnTypeHint(JSFunction func, InlayTreeSink sink, long serviceTimeoutMs) {
            if (func.isSetProperty() || func.isConstructor()) {
                return;
            }
            JSParameterList jSParameterList = func.getParameterList();
            if (jSParameterList == null) {
                return;
            }
            JSParameterList parameterList = jSParameterList;
            PsiElement firstChild = parameterList.getFirstChild();
            if (!Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)firstChild), (Object)JSTokenTypes.LPAR)) {
                return;
            }
            if (this.addHintFromLanguageService(func, (PsiElement)parameterList, HintFromServiceKind.FUNCTION_RETURN_TYPE, sink, serviceTimeoutMs)) {
                return;
            }
            this.addJsTypeHint(func.getReturnType(), (PsiElement)parameterList, sink);
        }

        private final boolean addHintFromLanguageService(JSElement element2, PsiElement anchor, HintFromServiceKind hintKind, InlayTreeSink sink, long serviceTimeoutMs) {
            if (JSDeclarativeTypeHintsInlayProvider.this.getLanguageServiceUsage() == LanguageServiceUsage.ONLY_INTERNAL) {
                return false;
            }
            String typeStr = JSDeclarativeTypeHintsInlayProvider.this.getTypeFromService(element2, hintKind, serviceTimeoutMs);
            if (!element2.isValid()) {
                return true;
            }
            if (typeStr != null) {
                if (!StringsKt.isBlank((CharSequence)typeStr)) {
                    InlayTreeSink.addPresentation$default((InlayTreeSink)sink, (InlayPosition)((InlayPosition)new InlineInlayPosition(anchor.getTextRange().getEndOffset(), true, 0, 4, null)), null, null, (HintFormat)this.hintFormat, arg_0 -> Collector.addHintFromLanguageService$lambda$4(typeStr, arg_0), (int)6, null);
                }
                return true;
            }
            return JSDeclarativeTypeHintsInlayProvider.this.getLanguageServiceUsage() == LanguageServiceUsage.ONLY_SERVICE;
        }

        private final void addJsTypeHint(JSType jsType, PsiElement anchor, InlayTreeSink sink) {
            Ref.ObjectRef presentableType = new Ref.ObjectRef();
            presentableType.element = jsType;
            if (jsType instanceof JSFunctionReturnWrapperType || jsType instanceof JSEvaluableOnlyType) {
                presentableType.element = ((JSEvaluableOnlyType)jsType).substitute(anchor);
            }
            if (presentableType.element != null && !JSTypeUtils.isAnyType((JSType)presentableType.element) && JSDeclarativeTypeHintsInlayProvider.this.isSuitableType((JSType)presentableType.element)) {
                InlayTreeSink.addPresentation$default((InlayTreeSink)sink, (InlayPosition)((InlayPosition)new InlineInlayPosition(anchor.getTextRange().getEndOffset(), true, 0, 4, null)), null, null, (HintFormat)this.hintFormat, arg_0 -> Collector.addJsTypeHint$lambda$5(presentableType, arg_0), (int)6, null);
            }
        }

        private final boolean isFrameworkDefinedType(JSType jsType, PsiElement element2) {
            return jsType != null && Intrinsics.areEqual((Object)jsType.getSourceElement(), (Object)element2);
        }

        private static final Unit doCollectFromElement$lambda$0(Collector this$0, PsiElement $element, InlayTreeSink $sink, long $serviceTimeoutMs) {
            this$0.addFieldOrVariableHint((JSNamedElement)$element, $sink, $serviceTimeoutMs);
            return Unit.INSTANCE;
        }

        private static final Unit doCollectFromElement$lambda$1(Collector this$0, PsiElement $element, InlayTreeSink $sink, long $serviceTimeoutMs) {
            this$0.addFieldOrVariableHint((JSNamedElement)$element, $sink, $serviceTimeoutMs);
            return Unit.INSTANCE;
        }

        private static final Unit doCollectFromElement$lambda$2(Collector this$0, PsiElement $element, InlayTreeSink $sink, long $serviceTimeoutMs) {
            this$0.addFieldOrVariableHint((JSNamedElement)$element, $sink, $serviceTimeoutMs);
            return Unit.INSTANCE;
        }

        private static final Unit doCollectFromElement$lambda$3(Collector this$0, PsiElement $element, InlayTreeSink $sink, long $serviceTimeoutMs) {
            this$0.addFunctionReturnTypeHint((JSFunction)$element, $sink, $serviceTimeoutMs);
            return Unit.INSTANCE;
        }

        private static final Unit addHintFromLanguageService$lambda$4(String $typeStr, PresentationTreeBuilder $this$addPresentation) {
            Intrinsics.checkNotNullParameter((Object)$this$addPresentation, (String)"$this$addPresentation");
            PresentationTreeBuilder.text$default((PresentationTreeBuilder)$this$addPresentation, (String)": ", null, (int)2, null);
            PresentationTreeBuilder.text$default((PresentationTreeBuilder)$this$addPresentation, (String)$typeStr, null, (int)2, null);
            return Unit.INSTANCE;
        }

        private static final Unit addJsTypeHint$lambda$5(Ref.ObjectRef $presentableType, PresentationTreeBuilder $this$addPresentation) {
            Intrinsics.checkNotNullParameter((Object)$this$addPresentation, (String)"$this$addPresentation");
            PresentationTreeBuilder.text$default((PresentationTreeBuilder)$this$addPresentation, (String)": ", null, (int)2, null);
            JSDeclarativeTypeHintsFactory.INSTANCE.typeHint((JSType)$presentableType.element, $this$addPresentation);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/lang/javascript/editing/JSDeclarativeTypeHintsInlayProvider$Companion;", "", "<init>", "()V", "PROVIDER_ID", "", "SHOW_FOR_SHORTHAND_FUNCTIONS", "SHOW_FOR_INFERRED_PARAMETERS", "SHOW_FOR_VARIABLES_AND_FIELDS", "SHOW_FOR_FUNCTIONS", "intellij.javascript.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/lang/javascript/editing/JSDeclarativeTypeHintsInlayProvider$HintFromServiceKind;", "", "<init>", "(Ljava/lang/String;I)V", "FIELD_OR_VAR_TYPE", "FUNCTION_RETURN_TYPE", "intellij.javascript.impl"})
    public static final class HintFromServiceKind
    extends Enum<HintFromServiceKind> {
        public static final /* enum */ HintFromServiceKind FIELD_OR_VAR_TYPE = new HintFromServiceKind();
        public static final /* enum */ HintFromServiceKind FUNCTION_RETURN_TYPE = new HintFromServiceKind();
        private static final /* synthetic */ HintFromServiceKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static HintFromServiceKind[] values() {
            return (HintFromServiceKind[])$VALUES.clone();
        }

        public static HintFromServiceKind valueOf(String value) {
            return Enum.valueOf(HintFromServiceKind.class, value);
        }

        @NotNull
        public static EnumEntries<HintFromServiceKind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = hintFromServiceKindArray = new HintFromServiceKind[]{HintFromServiceKind.FIELD_OR_VAR_TYPE, HintFromServiceKind.FUNCTION_RETURN_TYPE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/lang/javascript/editing/JSDeclarativeTypeHintsInlayProvider$LanguageServiceUsage;", "", "<init>", "(Ljava/lang/String;I)V", "SERVICE_THEN_INTERNAL", "ONLY_SERVICE", "ONLY_INTERNAL", "intellij.javascript.impl"})
    public static final class LanguageServiceUsage
    extends Enum<LanguageServiceUsage> {
        public static final /* enum */ LanguageServiceUsage SERVICE_THEN_INTERNAL = new LanguageServiceUsage();
        public static final /* enum */ LanguageServiceUsage ONLY_SERVICE = new LanguageServiceUsage();
        public static final /* enum */ LanguageServiceUsage ONLY_INTERNAL = new LanguageServiceUsage();
        private static final /* synthetic */ LanguageServiceUsage[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static LanguageServiceUsage[] values() {
            return (LanguageServiceUsage[])$VALUES.clone();
        }

        public static LanguageServiceUsage valueOf(String value) {
            return Enum.valueOf(LanguageServiceUsage.class, value);
        }

        @NotNull
        public static EnumEntries<LanguageServiceUsage> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = languageServiceUsageArray = new LanguageServiceUsage[]{LanguageServiceUsage.SERVICE_THEN_INTERNAL, LanguageServiceUsage.ONLY_SERVICE, LanguageServiceUsage.ONLY_INTERNAL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

