/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.index.JSIdAndTodoScanner;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class JSStringLiteralWordsIndex
extends FileBasedIndexExtension<String, Integer> {
    public static final ID<String, Integer> INDEX_ID = ID.create((String)"js.string.literal.words.index");
    private static final int OCCURRENCES_LIMIT_PER_FILE = 1000;
    private final DataIndexer<String, Integer, FileContent> myIndexer = new DataIndexer<String, Integer, FileContent>(){

        @NotNull
        public Map<String, Integer> map(@NotNull FileContent inputData) {
            if (inputData == null) {
                1.$$$reportNull$$$0(0);
            }
            if (!JavaScriptIndex.isAcceptableFile(inputData.getFile())) {
                Map<String, Integer> map2 = Collections.emptyMap();
                if (map2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return map2;
            }
            Map<String, Integer> words = JSIdAndTodoScanner.calcStringLiteralWords(inputData);
            Map<String, Integer> map3 = words.isEmpty() || words.size() > 1000 ? Collections.emptyMap() : words;
            if (map3 == null) {
                1.$$$reportNull$$$0(2);
            }
            return map3;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputData";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/index/JSStringLiteralWordsIndex$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/index/JSStringLiteralWordsIndex$1";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "map";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "map";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    };
    private final DefaultFileTypeSpecificInputFilter myInputFilter = new DefaultFileTypeSpecificInputFilter((FileType[])ArrayUtil.mergeArrays((Object[])DialectDetector.JAVASCRIPT_FILE_TYPES_ARRAY, (Object[])TypeScriptUtil.TYPESCRIPT_FILE_TYPES_ARRAY)){

        public boolean acceptInput(@NotNull VirtualFile file) {
            if (file == null) {
                2.$$$reportNull$$$0(0);
            }
            return JavaScriptIndex.isAcceptableFile(file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/index/JSStringLiteralWordsIndex$2", "acceptInput"));
        }
    };

    @NotNull
    public ID<String, Integer> getName() {
        ID<String, Integer> iD = INDEX_ID;
        if (iD == null) {
            JSStringLiteralWordsIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DefaultFileTypeSpecificInputFilter defaultFileTypeSpecificInputFilter = this.myInputFilter;
        if (defaultFileTypeSpecificInputFilter == null) {
            JSStringLiteralWordsIndex.$$$reportNull$$$0(1);
        }
        return defaultFileTypeSpecificInputFilter;
    }

    @NotNull
    public DataIndexer<String, Integer, FileContent> getIndexer() {
        DataIndexer<String, Integer, FileContent> dataIndexer = this.myIndexer;
        if (dataIndexer == null) {
            JSStringLiteralWordsIndex.$$$reportNull$$$0(2);
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            JSStringLiteralWordsIndex.$$$reportNull$$$0(3);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<Integer> getValueExternalizer() {
        EnumeratorIntegerDescriptor enumeratorIntegerDescriptor = EnumeratorIntegerDescriptor.INSTANCE;
        if (enumeratorIntegerDescriptor == null) {
            JSStringLiteralWordsIndex.$$$reportNull$$$0(4);
        }
        return enumeratorIntegerDescriptor;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 4;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/index/JSStringLiteralWordsIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

