/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSSwitchVariableDeclarationIssueInspection
extends JSInspection {
    public boolean ignoreNonBlockScope = false;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreNonBlockScope", (String)JavaScriptBundle.message("js.variable.problems.ignore.desc", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            JSSwitchVariableDeclarationIssueInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSSwitchVariableDeclarationIssueInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            JSSwitchVariableDeclarationIssueInspection.$$$reportNull$$$0(2);
        }
        return new JSElementVisitor(){

            @Override
            public void visitJSSwitchStatement(@NotNull JSSwitchStatement node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                HashSet<String> varNames = new HashSet<String>();
                MultiMap declaredVars = MultiMap.createSet();
                for (JSCaseClause clause : node.getCaseClauses()) {
                    List<JSVariable> variables = this.collectDeclaredVars(clause, node);
                    for (JSVariable variable : variables) {
                        varNames.add(variable.getName());
                    }
                    declaredVars.put((Object)clause, variables);
                }
                for (JSCaseClause clause : node.getCaseClauses()) {
                    Set<JSVariable> usedVars = 1.collectUsedVars(clause, varNames);
                    usedVars.removeAll(declaredVars.get((Object)clause));
                    if (usedVars.isEmpty()) continue;
                    for (JSVariable variable : usedVars) {
                        PsiElement nameIdentifier = variable.getNameIdentifier();
                        assert (nameIdentifier != null);
                        JSCaseClause clauseWhereDeclared = declaredVars.entrySet().stream().filter(e -> ((Collection)e.getValue()).contains(variable)).map(e -> (JSCaseClause)e.getKey()).findFirst().orElse(null);
                        if (clauseWhereDeclared == null) continue;
                        Object desc = JavaScriptBundle.message("js.variable.problems.inspection.desc", variable.getName(), 1.getDesc(clauseWhereDeclared), 1.getDesc(clause));
                        if (variable.hasBlockScope()) {
                            desc = (String)desc + ". " + JavaScriptBundle.message("js.variable.problems.inspection.desc.ref.error", new Object[0]);
                        }
                        holder.registerProblem(nameIdentifier, (String)desc, new LocalQuickFix[0]);
                    }
                }
            }

            private static String getDesc(@Nullable JSCaseClause declared) {
                if (declared == null) {
                    return "???";
                }
                if (declared.isDefault()) {
                    return "default";
                }
                JSExpression expression = declared.getCaseExpression();
                return expression == null ? "???" : "case " + expression.getText();
            }

            private static Set<JSVariable> collectUsedVars(JSCaseClause clause, Set<String> varNames) {
                HashSet<JSVariable> set = new HashSet<JSVariable>();
                for (JSSourceElement statement : clause.getStatementListItems()) {
                    SyntaxTraverser.psiTraverser((PsiElement)statement).filter(JSReferenceExpression.class).filter(e -> e.getQualifier() == null).filter(e -> varNames.contains(e.getReferenceName())).map(e -> e.resolve()).filter(JSVariable.class).forEach(set::add);
                }
                return set;
            }

            private List<JSVariable> collectDeclaredVars(JSCaseClause clause, JSSwitchStatement switchStatement) {
                ArrayList<JSVariable> allVars = new ArrayList<JSVariable>();
                for (JSSourceElement statement : clause.getStatementListItems()) {
                    List variables = ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)statement).forceIgnore(Conditions.instanceOf(JSFunction.class))).filter(JSVariable.class).toList();
                    for (JSVariable variable : variables) {
                        if (!variable.hasBlockScope()) {
                            if (JSSwitchVariableDeclarationIssueInspection.this.ignoreNonBlockScope) continue;
                            allVars.add(variable);
                            continue;
                        }
                        PsiElement declarationScope = variable.getDeclarationScope();
                        if (declarationScope != switchStatement) continue;
                        allVars.add(variable);
                    }
                }
                return allVars;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/inspections/JSSwitchVariableDeclarationIssueInspection$1", "visitJSSwitchStatement"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSSwitchVariableDeclarationIssueInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSSwitchVariableDeclarationIssueInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

