/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.json;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.json.JSJsonLikePsiWalker;
import com.intellij.lang.javascript.json.JsonSchemaInJavaScriptProvider;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCommaExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public abstract class JSJsonSchemaProviderBase
implements JsonSchemaInJavaScriptProvider {
    protected static boolean isInTopLevelObject(@NotNull PsiElement element2) {
        PsiElement current;
        if (element2 == null) {
            JSJsonSchemaProviderBase.$$$reportNull$$$0(0);
        }
        for (current = element2; !(current == null || JSJsonLikePsiWalker.isTerminalInStatement(current) || current instanceof PsiFile || current instanceof JSEmbeddedContent); current = current.getParent()) {
            if (current instanceof JSProperty || current instanceof JSLiteralExpression || current instanceof JSObjectLiteralExpression || current instanceof JSArrayLiteralExpression || current instanceof JSReferenceExpression || current instanceof LeafPsiElement) {
                continue;
            }
            return false;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)current, JSObjectLiteralExpression.class) == null;
    }

    protected static VirtualFile loadFile(Class baseClass, @NotNull String resourcePath) {
        if (resourcePath == null) {
            JSJsonSchemaProviderBase.$$$reportNull$$$0(1);
        }
        return JsonSchemaProviderFactory.getResourceFile((Class)baseClass, (String)resourcePath);
    }

    protected static boolean isInSupportedArea(@NotNull PsiElement element2, Function<? super PsiFile, ? extends List<TextRange>> getRanges) {
        PsiFile file;
        if (element2 == null) {
            JSJsonSchemaProviderBase.$$$reportNull$$$0(2);
        }
        if ((file = (PsiFile)ReadAction.compute(() -> {
            PsiFile containingFile = element2.getContainingFile();
            if (containingFile == null || !element2.isValid() || !containingFile.isValid()) {
                return null;
            }
            ASTNode node = element2.getNode();
            if (node == null || JSTokenTypes.STRING_LITERAL.equals(node.getElementType())) {
                return null;
            }
            return containingFile;
        })) == null) {
            return false;
        }
        List ranges = (List)CachedValuesManager.getCachedValue((PsiElement)file, () -> CachedValueProvider.Result.create((Object)((List)getRanges.apply(file)), (Object[])new Object[]{file}));
        return ContainerUtil.or((Iterable)ranges, range -> range.contains(element2.getTextRange()));
    }

    protected static JSExpression getModuleExportsAssignmentInitializer(JSAssignmentExpression element2) {
        JSExpression expression;
        JSDefinitionExpression definitionExpression;
        PsiElement parent = element2.getParent();
        if ((parent instanceof JSStatement || parent instanceof JSCommaExpression) && (definitionExpression = element2.getDefinitionExpression()) != null && (expression = definitionExpression.getExpression()) instanceof JSReferenceExpression && JSSymbolUtil.isExplicitExportReference((JSReferenceExpression)expression)) {
            return definitionExpression.getInitializer();
        }
        return null;
    }

    @NotNull
    protected static List<TextRange> computeDefaultModuleExportsAreas(@NotNull PsiFile file) {
        if (file == null) {
            JSJsonSchemaProviderBase.$$$reportNull$$$0(3);
        }
        List list = ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)file).forceIgnore(Conditions.instanceOf(JSFunction.class))).filter(JSAssignmentExpression.class).map(JSJsonSchemaProviderBase::getModuleExportsAssignmentInitializer).map(JSJsonSchemaProviderBase::computeDefaultInitializer).filter(JSObjectLiteralExpression.class).map(PsiElement::getTextRange).sort(Comparator.comparingInt(TextRange::getStartOffset)).toList();
        if (list == null) {
            JSJsonSchemaProviderBase.$$$reportNull$$$0(4);
        }
        return list;
    }

    protected static JSExpression computeDefaultInitializer(JSExpression expression) {
        PsiElement resolved;
        if (expression instanceof JSReferenceExpression && (resolved = ((JSReferenceExpression)expression).resolve()) instanceof JSVariable && resolved.isValid()) {
            return ((JSVariable)resolved).getInitializer();
        }
        return expression;
    }

    protected static JBIterable<JSExpression> computeInitializersFromFunction(JSFunction initializer) {
        JSElement body = JSPsiImplUtils.getFunctionBody(initializer);
        if (body instanceof JSStatement) {
            return ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)body).forceIgnore(Conditions.instanceOf(JSFunction.class))).filter(JSReturnStatement.class).map(r -> r.getExpression());
        }
        if (body instanceof JSExpression) {
            return JBIterable.of((Object)((JSExpression)body));
        }
        return JBIterable.empty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourcePath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/json/JSJsonSchemaProviderBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/json/JSJsonSchemaProviderBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDefaultModuleExportsAreas";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isInTopLevelObject";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isInSupportedArea";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "computeDefaultModuleExportsAreas";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

