/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventId;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.linter.AutodetectLinterPackage;
import com.intellij.lang.javascript.linter.ExtendedLinterState;
import com.intellij.lang.javascript.linter.eslint.EslintConfiguration;
import com.intellij.lang.javascript.linter.eslint.EslintState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class EslintOptionsUsageCollector
extends ProjectUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("js.eslint.options", 4);
    private static final EventId ENABLED = GROUP.registerEvent("enabled");
    private static final EventId NODE_PACKAGE_AUTODETECT = GROUP.registerEvent("node.package.autodetect");
    private static final EventId NODE_PACKAGE_CUSTOM_PACKAGE = GROUP.registerEvent("node.package.custom.package");
    private static final EventId COMMAND_LINE_OPTIONS_SPECIFIED = GROUP.registerEvent("command.line.options.specified");
    private static final EventId ADDITIONAL_RULES_SPECIFIED = GROUP.registerEvent("additional.rules.specified");
    private static final EventId CUSTOM_CONFIG_SPECIFIED = GROUP.registerEvent("custom.config.specified");
    private static final EventId ESLINT_FIX_ON_SAVE = GROUP.registerEvent("eslint.fix.on.save");

    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    public Set<MetricEvent> getMetrics(@NotNull Project project) {
        NodePackage constantPackage;
        ExtendedLinterState extendedState;
        if (project == null) {
            EslintOptionsUsageCollector.$$$reportNull$$$0(0);
        }
        if (!(extendedState = EslintConfiguration.getInstance(project).getExtendedState()).isEnabled()) {
            Set<MetricEvent> set = Collections.emptySet();
            if (set == null) {
                EslintOptionsUsageCollector.$$$reportNull$$$0(1);
            }
            return set;
        }
        HashSet<MetricEvent> set = new HashSet<MetricEvent>();
        set.add(ENABLED.metric());
        EslintState state = (EslintState)extendedState.getState();
        NodePackageRef nodePackageRef = state.getNodePackageRef();
        if (nodePackageRef == AutodetectLinterPackage.INSTANCE) {
            set.add(NODE_PACKAGE_AUTODETECT.metric());
        }
        if ((constantPackage = nodePackageRef.getConstantPackage()) != null && !constantPackage.isEmptyPath()) {
            set.add(NODE_PACKAGE_CUSTOM_PACKAGE.metric());
        }
        if (StringUtil.isNotEmpty((String)state.getExtraOptions())) {
            set.add(COMMAND_LINE_OPTIONS_SPECIFIED.metric());
        }
        if (StringUtil.isNotEmpty((String)state.getAdditionalRulesDirPath())) {
            set.add(ADDITIONAL_RULES_SPECIFIED.metric());
        }
        if (state.isCustomConfigFileUsed() && StringUtil.isNotEmpty((String)state.getCustomConfigFilePath())) {
            set.add(CUSTOM_CONFIG_SPECIFIED.metric());
        }
        if (state.isRunOnSave()) {
            set.add(ESLINT_FIX_ON_SAVE.metric());
        }
        HashSet<MetricEvent> hashSet = set;
        if (hashSet == null) {
            EslintOptionsUsageCollector.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/EslintOptionsUsageCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/EslintOptionsUsageCollector";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMetrics";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

