/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.imports;

import com.intellij.lang.javascript.modules.JSImportModuleFix;
import com.intellij.lang.javascript.modules.JSPlaceTail;
import com.intellij.lang.javascript.modules.imports.JSAddImportExecutor;
import com.intellij.lang.javascript.modules.imports.JSImportDescriptor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u001c\u0010\u0010\u001a\u00020\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\"\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0016\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/lang/javascript/modules/imports/JSReplaceReferenceExecutor;", "Lcom/intellij/lang/javascript/modules/imports/JSAddImportExecutor;", "executor", "tail", "Lcom/intellij/lang/javascript/modules/JSPlaceTail;", "<init>", "(Lcom/intellij/lang/javascript/modules/imports/JSAddImportExecutor;Lcom/intellij/lang/javascript/modules/JSPlaceTail;)V", "createImportOrUpdateExisting", "", "descriptor", "Lcom/intellij/lang/javascript/modules/imports/JSImportDescriptor;", "getImportStatementText", "", "correctReplaceTarget", "Lcom/intellij/psi/PsiElement;", "reference", "replaceReferences", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "replaceWithNewReference", "elementTarget", "newReferenceName", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nJSReplaceReferenceExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSReplaceReferenceExecutor.kt\ncom/intellij/lang/javascript/modules/imports/JSReplaceReferenceExecutor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,55:1\n1#2:56\n*E\n"})
public final class JSReplaceReferenceExecutor
implements JSAddImportExecutor {
    @NotNull
    private final JSAddImportExecutor executor;
    @NotNull
    private final JSPlaceTail tail;

    public JSReplaceReferenceExecutor(@NotNull JSAddImportExecutor executor, @NotNull JSPlaceTail tail) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)tail, (String)"tail");
        this.executor = executor;
        this.tail = tail;
    }

    @Override
    public void createImportOrUpdateExisting(@NotNull JSImportDescriptor descriptor) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            this.executor.createImportOrUpdateExisting(descriptor);
            PsiElement psiElement = this.tail.getTailToReplaceReference();
            if (psiElement == null) break block0;
            PsiElement it = psiElement;
            boolean bl = false;
            this.replaceReferences(it, PsiEditorUtil.findEditor((PsiElement)it));
        }
    }

    @Override
    @NotNull
    public String getImportStatementText(@NotNull JSImportDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        String string = this.executor.getImportStatementText(descriptor);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getImportStatementText(...)");
        return string;
    }

    private final PsiElement correctReplaceTarget(PsiElement reference) {
        if (reference instanceof JSReferenceExpression) {
            JSReferenceExpression replaceTarget = (JSReferenceExpression)reference;
            PsiElement target2 = this.tail.getTailToReplaceReference();
            if (target2 == null) {
                while (replaceTarget.getQualifier() instanceof JSReferenceExpression) {
                    Intrinsics.checkNotNull((Object)((JSReferenceExpression)replaceTarget.getQualifier()));
                }
            }
            return (PsiElement)replaceTarget;
        }
        return reference;
    }

    private final void replaceReferences(PsiElement element2, Editor editor) {
        block7: {
            String name;
            block6: {
                block5: {
                    if (element2 == null) break block5;
                    String[] stringArray = this.tail.getStrings();
                    Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getStrings(...)");
                    if (!(((Object[])stringArray).length == 0)) break block6;
                }
                return;
            }
            PsiElement replaceTarget = this.correctReplaceTarget(element2);
            if (!(replaceTarget instanceof JSReferenceExpression)) break block7;
            String string = name = ((JSReferenceExpression)replaceTarget).getReferenceName();
            if (string != null) {
                String it = string;
                boolean bl = false;
                this.replaceWithNewReference(replaceTarget, editor, it);
            }
        }
    }

    private final void replaceWithNewReference(PsiElement elementTarget, Editor editor, String newReferenceName) {
        block4: {
            if (!(elementTarget instanceof JSReferenceExpression)) break block4;
            if (((JSReferenceExpression)elementTarget).getQualifier() == null && Intrinsics.areEqual((Object)newReferenceName, (Object)((JSReferenceExpression)elementTarget).getReferenceName())) {
                return;
            }
            PsiFile dummy = JSImportModuleFix.createDummyFile(((JSReferenceExpression)elementTarget).getProject(), newReferenceName);
            JSReferenceExpression jSReferenceExpression = (JSReferenceExpression)PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)dummy), JSReferenceExpression.class);
            if (jSReferenceExpression == null) {
                return;
            }
            JSReferenceExpression child = jSReferenceExpression;
            JSExpression jSExpression = ((JSReferenceExpression)elementTarget).replace(child);
            if (jSExpression == null) {
                return;
            }
            PsiElement replace = (PsiElement)jSExpression;
            Editor editor2 = editor;
            if (editor2 != null && (editor2 = editor2.getCaretModel()) != null) {
                editor2.moveToOffset(replace.getTextRange().getEndOffset());
            }
        }
    }
}

