/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.impl.JSStatementImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class JSForStatementImpl
extends JSStatementImpl
implements JSForStatement {
    public JSForStatementImpl(IElementType elementType) {
        super(elementType);
    }

    @Override
    public JSVarStatement getVarDeclaration() {
        ASTNode node = this.getNode().findChildByType(JSStubElementTypes.VAR_STATEMENT);
        return (JSVarStatement)(node != null ? node.getPsi() : null);
    }

    @Override
    public JSExpression getInitialization() {
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() == JSTokenTypes.SEMICOLON) {
                return null;
            }
            if (!JSExtendedLanguagesTokenSetProvider.EXPRESSIONS.contains(child.getElementType())) continue;
            return (JSExpression)child.getPsi();
        }
        return null;
    }

    @Override
    public JSExpression getCondition() {
        int semicolonCount = 0;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() == JSTokenTypes.SEMICOLON) {
                if (++semicolonCount != 2) continue;
                return null;
            }
            if (semicolonCount != 1 || !JSExtendedLanguagesTokenSetProvider.EXPRESSIONS.contains(child.getElementType())) continue;
            return (JSExpression)child.getPsi();
        }
        return null;
    }

    @Override
    public JSExpression getUpdate() {
        int semicolonCount = 0;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() == JSTokenTypes.SEMICOLON) {
                ++semicolonCount;
                continue;
            }
            if (semicolonCount != 2 || !JSExtendedLanguagesTokenSetProvider.EXPRESSIONS.contains(child.getElementType())) continue;
            return (JSExpression)child.getPsi();
        }
        return null;
    }

    @Override
    public JSStatement getBody() {
        boolean passedRParen = false;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() == JSTokenTypes.RPAR) {
                passedRParen = true;
                continue;
            }
            if (!passedRParen || !JSExtendedLanguagesTokenSetProvider.STATEMENTS.contains(child.getElementType())) continue;
            return (JSStatement)child.getPsi();
        }
        return null;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            JSForStatementImpl.$$$reportNull$$$0(0);
        }
        if (state == null) {
            JSForStatementImpl.$$$reportNull$$$0(1);
        }
        if (place == null) {
            JSForStatementImpl.$$$reportNull$$$0(2);
        }
        if (lastParent != null) {
            JSVarStatement statement = this.getVarDeclaration();
            if (statement != null) {
                return statement.processDeclarations(processor, state, lastParent, place);
            }
            JSExpression initialization = this.getInitialization();
            if (initialization != null) {
                return initialization.processDeclarations(processor, state, null, place);
            }
        }
        return true;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSForStatementImpl.$$$reportNull$$$0(3);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSForStatement(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSForStatementImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processDeclarations";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

