/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.impl.JSExpressionImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public final class JSIndexedPropertyAccessExpressionImpl
extends JSExpressionImpl
implements JSIndexedPropertyAccessExpression {
    public JSIndexedPropertyAccessExpressionImpl(IElementType elementType) {
        super(elementType);
    }

    @Override
    public JSExpression getQualifier() {
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType type2 = child.getElementType();
            if (type2 == JSTokenTypes.LBRACKET) {
                return null;
            }
            if (!JSExtendedLanguagesTokenSetProvider.EXPRESSIONS.contains(type2)) continue;
            return (JSExpression)child.getPsi();
        }
        return null;
    }

    @Override
    public JSExpression getIndexExpression() {
        ASTNode expression = JSIndexedPropertyAccessExpressionImpl.getIndexExpression(this.getNode());
        return expression != null ? (JSExpression)expression.getPsi() : null;
    }

    @Override
    public boolean isElvis() {
        return this.getNode().findChildByType(JSTokenTypes.ELVIS) != null;
    }

    public static ASTNode getIndexExpression(@NotNull ASTNode node) {
        if (node == null) {
            JSIndexedPropertyAccessExpressionImpl.$$$reportNull$$$0(0);
        }
        assert (node.getElementType() == JSElementTypes.INDEXED_PROPERTY_ACCESS_EXPRESSION);
        boolean bracketPassed = false;
        for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType type2 = child.getElementType();
            if (type2 == JSTokenTypes.LBRACKET) {
                bracketPassed = true;
            }
            if (!bracketPassed || !JSExtendedLanguagesTokenSetProvider.EXPRESSIONS.contains(type2)) continue;
            return child;
        }
        return null;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSIndexedPropertyAccessExpressionImpl.$$$reportNull$$$0(1);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSIndexedPropertyAccessExpression(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSIndexedPropertyAccessExpressionImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getIndexExpression";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

