/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.guard.operations;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSDecoratedType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.guard.operations.JSApplyTypeOperationContext;
import com.intellij.lang.javascript.psi.types.guard.operations.JSCompositeOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSConditionalTypeOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSDecoratorsOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSInferDecoratorsContext;
import com.intellij.lang.javascript.psi.types.guard.operations.JSTypeOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSUnionOperation;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSMergeOperation
extends JSCompositeOperation {
    @NotNull
    private final Collection<JSTypeOperation> myOperations;

    @NotNull
    public static JSTypeOperation create(@NotNull Collection<JSTypeOperation> operations, JSTypeOperation whenEmpty) {
        if (operations == null) {
            JSMergeOperation.$$$reportNull$$$0(0);
        }
        if (operations.isEmpty()) {
            JSTypeOperation jSTypeOperation = whenEmpty;
            if (jSTypeOperation == null) {
                JSMergeOperation.$$$reportNull$$$0(1);
            }
            return jSTypeOperation;
        }
        int size = operations.size();
        if (size == 1) {
            JSTypeOperation jSTypeOperation = operations.iterator().next();
            if (jSTypeOperation == null) {
                JSMergeOperation.$$$reportNull$$$0(2);
            }
            return jSTypeOperation;
        }
        LinkedHashSet<JSTypeOperation> result2 = new LinkedHashSet<JSTypeOperation>();
        ArrayList<JSTypeOperation> ops = new ArrayList<JSTypeOperation>(operations);
        IntArraySet set = new IntArraySet();
        block0: for (int i = 0; i < ops.size(); ++i) {
            JSTypeOperation left = ops.get(i);
            if (set.contains(i)) continue;
            for (int j = i + 1; j < ops.size(); ++j) {
                JSTypeOperation merged;
                JSTypeOperation right = ops.get(j);
                if (set.contains(j) || (merged = JSMergeOperation.tryMergeOperations(left, right)) == null) continue;
                set.add(i);
                set.add(j);
                result2.add(merged);
                continue block0;
            }
            set.add(i);
            result2.add(left);
        }
        if (result2.size() == 1) {
            JSTypeOperation jSTypeOperation = (JSTypeOperation)result2.iterator().next();
            if (jSTypeOperation == null) {
                JSMergeOperation.$$$reportNull$$$0(3);
            }
            return jSTypeOperation;
        }
        if (result2.isEmpty()) {
            JSTypeOperation jSTypeOperation = whenEmpty;
            if (jSTypeOperation == null) {
                JSMergeOperation.$$$reportNull$$$0(4);
            }
            return jSTypeOperation;
        }
        if (result2.size() < operations.size()) {
            return JSMergeOperation.create(result2, whenEmpty);
        }
        return new JSMergeOperation(result2);
    }

    @Nullable
    private static JSTypeOperation tryMergeOperations(@NotNull JSTypeOperation first, @NotNull JSTypeOperation second) {
        JSConditionalTypeOperation conditionalOperation;
        if (first == null) {
            JSMergeOperation.$$$reportNull$$$0(5);
        }
        if (second == null) {
            JSMergeOperation.$$$reportNull$$$0(6);
        }
        Set<Object> left = Collections.emptySet();
        boolean hasDecorated = false;
        if (first instanceof JSDecoratorsOperation) {
            JSDecoratorsOperation decorated = (JSDecoratorsOperation)first;
            first = decorated.getPrev();
            left = decorated.getDecorators();
            hasDecorated = true;
        }
        Set<Object> right = Collections.emptySet();
        if (second instanceof JSDecoratorsOperation) {
            JSDecoratorsOperation decorated = (JSDecoratorsOperation)second;
            second = decorated.getPrev();
            right = decorated.getDecorators();
            hasDecorated = true;
        }
        if (first == second) {
            if (!hasDecorated) {
                return first;
            }
            Set decorators = right.isEmpty() || left.isEmpty() ? Collections.emptySet() : ContainerUtil.intersection(left, right);
            EnumSet<JSDecoratedType.TypeDecoration> resultDecorators = decorators.isEmpty() ? EnumSet.noneOf(JSDecoratedType.TypeDecoration.class) : EnumSet.copyOf(decorators);
            return JSDecoratorsOperation.create(first, resultDecorators);
        }
        if (first instanceof JSConditionalTypeOperation && (conditionalOperation = (JSConditionalTypeOperation)first).isInverse(second)) {
            return conditionalOperation.mergeCondition();
        }
        return null;
    }

    private JSMergeOperation(@NotNull Collection<JSTypeOperation> operations) {
        if (operations == null) {
            JSMergeOperation.$$$reportNull$$$0(7);
        }
        this.myOperations = operations;
    }

    @Override
    @NotNull
    public Collection<JSTypeOperation> getOperations() {
        Collection<JSTypeOperation> collection = this.myOperations;
        if (collection == null) {
            JSMergeOperation.$$$reportNull$$$0(8);
        }
        return collection;
    }

    @Override
    @NotNull
    protected JSType applyWithoutCache(@NotNull JSApplyTypeOperationContext context2, @NotNull JSType type2) {
        List<JSType> types;
        if (context2 == null) {
            JSMergeOperation.$$$reportNull$$$0(9);
        }
        if (type2 == null) {
            JSMergeOperation.$$$reportNull$$$0(10);
        }
        if ((types = JSMergeOperation.getTypeFromOperations(context2, this.myOperations, type2)).size() == 1) {
            JSType jSType = context2.isAutoArrayType() ? JSUnionOperation.processEvolvingArrays(context2, types) : types.get(0);
            if (jSType == null) {
                JSMergeOperation.$$$reportNull$$$0(11);
            }
            return jSType;
        }
        JSType jSType = TypeScriptTypeRelations.subtypeReduction(JSUnionOperation.processEvolvingArrays(context2, types), context2.getContextElement());
        if (jSType == null) {
            JSMergeOperation.$$$reportNull$$$0(12);
        }
        return jSType;
    }

    @Override
    @NotNull
    protected Set<JSDecoratedType.TypeDecoration> inferTypeDecoratorsImpl(@NotNull JSInferDecoratorsContext context2) {
        if (context2 == null) {
            JSMergeOperation.$$$reportNull$$$0(13);
        }
        Set<JSDecoratedType.TypeDecoration> decorators = Collections.emptySet();
        boolean isFirst = true;
        for (JSTypeOperation operation : this.getOperations()) {
            Set<JSDecoratedType.TypeDecoration> newDecorators = operation.inferTypeDecorators(context2);
            if (isFirst) {
                decorators = newDecorators;
                isFirst = false;
                continue;
            }
            decorators = JSMergeOperation.mergeDecorators(decorators, newDecorators);
        }
        Set<JSDecoratedType.TypeDecoration> set = decorators;
        if (set == null) {
            JSMergeOperation.$$$reportNull$$$0(14);
        }
        return set;
    }

    @NotNull
    private static Set<JSDecoratedType.TypeDecoration> mergeDecorators(@NotNull Set<JSDecoratedType.TypeDecoration> old, @NotNull Set<JSDecoratedType.TypeDecoration> newDecorators) {
        if (old == null) {
            JSMergeOperation.$$$reportNull$$$0(15);
        }
        if (newDecorators == null) {
            JSMergeOperation.$$$reportNull$$$0(16);
        }
        if (old.isEmpty() && newDecorators.isEmpty()) {
            Set<JSDecoratedType.TypeDecoration> set = Collections.emptySet();
            if (set == null) {
                JSMergeOperation.$$$reportNull$$$0(17);
            }
            return set;
        }
        EnumSet<JSDecoratedType.TypeDecoration> result2 = EnumSet.noneOf(JSDecoratedType.TypeDecoration.class);
        if (old.contains((Object)JSDecoratedType.TypeDecoration.INFERRED_POSSIBLY_NULL_OR_UNDEFINED) || newDecorators.contains((Object)JSDecoratedType.TypeDecoration.INFERRED_POSSIBLY_NULL_OR_UNDEFINED)) {
            EnumSet<JSDecoratedType.TypeDecoration> enumSet = EnumSet.of(JSDecoratedType.TypeDecoration.INFERRED_POSSIBLY_NULL_OR_UNDEFINED);
            if (enumSet == null) {
                JSMergeOperation.$$$reportNull$$$0(18);
            }
            return enumSet;
        }
        for (JSDecoratedType.TypeDecoration decoration : old) {
            if (!newDecorators.contains((Object)decoration)) continue;
            result2.add(decoration);
        }
        if (!result2.isEmpty()) {
            EnumSet<JSDecoratedType.TypeDecoration> enumSet = result2;
            if (enumSet == null) {
                JSMergeOperation.$$$reportNull$$$0(19);
            }
            return enumSet;
        }
        Set<JSDecoratedType.TypeDecoration> notEmpty = old.isEmpty() ? newDecorators : old;
        Set<JSDecoratedType.TypeDecoration> toCompare = old.isEmpty() ? old : newDecorators;
        notEmpty = JSMergeOperation.reMapToPossibly(notEmpty);
        toCompare = JSMergeOperation.reMapToPossibly(toCompare);
        if (notEmpty.contains((Object)JSDecoratedType.TypeDecoration.INFERRED_POSSIBLY_NULL_OR_UNDEFINED) || toCompare.contains((Object)JSDecoratedType.TypeDecoration.INFERRED_POSSIBLY_NULL_OR_UNDEFINED)) {
            EnumSet<JSDecoratedType.TypeDecoration> enumSet = EnumSet.of(JSDecoratedType.TypeDecoration.INFERRED_POSSIBLY_NULL_OR_UNDEFINED);
            if (enumSet == null) {
                JSMergeOperation.$$$reportNull$$$0(20);
            }
            return enumSet;
        }
        if (notEmpty.contains((Object)JSDecoratedType.TypeDecoration.INFERRED_POSSIBLY_NULL)) {
            EnumSet<JSDecoratedType.TypeDecoration> enumSet = toCompare.contains((Object)JSDecoratedType.TypeDecoration.INFERRED_POSSIBLY_UNDEFINED) ? EnumSet.of(JSDecoratedType.TypeDecoration.INFERRED_POSSIBLY_NULL_OR_UNDEFINED) : EnumSet.of(JSDecoratedType.TypeDecoration.INFERRED_POSSIBLY_NULL);
            if (enumSet == null) {
                JSMergeOperation.$$$reportNull$$$0(21);
            }
            return enumSet;
        }
        if (notEmpty.contains((Object)JSDecoratedType.TypeDecoration.INFERRED_POSSIBLY_UNDEFINED)) {
            EnumSet<JSDecoratedType.TypeDecoration> enumSet = toCompare.contains((Object)JSDecoratedType.TypeDecoration.INFERRED_POSSIBLY_NULL) ? EnumSet.of(JSDecoratedType.TypeDecoration.INFERRED_POSSIBLY_NULL_OR_UNDEFINED) : EnumSet.of(JSDecoratedType.TypeDecoration.INFERRED_POSSIBLY_NULL);
            if (enumSet == null) {
                JSMergeOperation.$$$reportNull$$$0(22);
            }
            return enumSet;
        }
        EnumSet<JSDecoratedType.TypeDecoration> enumSet = result2;
        if (enumSet == null) {
            JSMergeOperation.$$$reportNull$$$0(23);
        }
        return enumSet;
    }

    @NotNull
    private static EnumSet<JSDecoratedType.TypeDecoration> reMapToPossibly(Set<JSDecoratedType.TypeDecoration> notEmpty) {
        List result2 = ContainerUtil.mapNotNull(notEmpty, JSMergeOperation::simpleReMapToPossibly);
        EnumSet<JSDecoratedType.TypeDecoration> enumSet = result2.isEmpty() ? EnumSet.noneOf(JSDecoratedType.TypeDecoration.class) : EnumSet.copyOf(result2);
        if (enumSet == null) {
            JSMergeOperation.$$$reportNull$$$0(24);
        }
        return enumSet;
    }

    @Nullable
    private static JSDecoratedType.TypeDecoration simpleReMapToPossibly(@NotNull JSDecoratedType.TypeDecoration el) {
        if (el == null) {
            JSMergeOperation.$$$reportNull$$$0(25);
        }
        if (el == JSDecoratedType.TypeDecoration.INFERRED_NULL) {
            return JSDecoratedType.TypeDecoration.INFERRED_POSSIBLY_NULL;
        }
        if (el == JSDecoratedType.TypeDecoration.INFERRED_UNDEFINED) {
            return JSDecoratedType.TypeDecoration.INFERRED_POSSIBLY_UNDEFINED;
        }
        if (el == JSDecoratedType.TypeDecoration.INFERRED_NULL_OR_UNDEFINED) {
            return JSDecoratedType.TypeDecoration.INFERRED_POSSIBLY_NULL_OR_UNDEFINED;
        }
        if (el == JSDecoratedType.TypeDecoration.INFERRED_POSSIBLY_NULL || el == JSDecoratedType.TypeDecoration.INFERRED_POSSIBLY_UNDEFINED || el == JSDecoratedType.TypeDecoration.INFERRED_POSSIBLY_NULL_OR_UNDEFINED) {
            return el;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 8, 11, 12, 14, 17, 18, 19, 20, 21, 22, 23, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operations";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/guard/operations/JSMergeOperation";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "old";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDecorators";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/guard/operations/JSMergeOperation";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperations";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "applyWithoutCache";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "inferTypeDecoratorsImpl";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeDecorators";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "reMapToPossibly";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "tryMergeOperations";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "applyWithoutCache";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "inferTypeDecoratorsImpl";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "mergeDecorators";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "simpleReMapToPossibly";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 8, 11, 12, 14, 17, 18, 19, 20, 21, 22, 23, 24 -> new IllegalStateException(string);
        };
    }
}

