/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.refactoring.JSDefaultRenameProcessor;
import com.intellij.lang.javascript.refactoring.ui.JSRenameOptionData;
import com.intellij.lang.javascript.refactoring.ui.JSRenameTarget;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageViewTypeLocation;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J,\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000b0\rH\u0016J0\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0012\u0010\u0011\u001a\u000e\u0012\b\b\u0000\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0012H\u0002J8\u0010\u0013\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00072\u0012\u0010\u0011\u001a\u000e\u0012\b\b\u0000\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u00122\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u001a\u0010\u0017\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J*\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0010\u0010\u0011\u001a\f\u0012\b\b\u0000\u0012\u0004\u0018\u00010\u00070\u0012H\u0016J\f\u0010\u0019\u001a\u00020\t*\u00020\u0015H\u0002J\u000e\u0010\u001a\u001a\u0004\u0018\u00010\u0007*\u00020\u0015H\u0002J\f\u0010\u001b\u001a\u00020\u0007*\u00020\u0015H\u0002\u00a8\u0006\u001c"}, d2={"Lcom/intellij/lang/javascript/refactoring/JSShorthandPropertyRenameProcessor;", "Lcom/intellij/lang/javascript/refactoring/JSDefaultRenameProcessor;", "<init>", "()V", "canProcessElement", "", "element", "Lcom/intellij/psi/PsiElement;", "prepareRenaming", "", "newName", "", "allRenames", "", "substitute", "editor", "Lcom/intellij/openapi/editor/Editor;", "renameCallback", "Lcom/intellij/openapi/util/Pass;", "substituteWithPopup", "property", "Lcom/intellij/lang/javascript/psi/JSProperty;", "valueResolveResult", "isSamePropertyAtCaret", "substituteElementToRename", "expandInWriteCommandAction", "resolveValue", "resolveReference", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nJSShorthandPropertyRenameProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSShorthandPropertyRenameProcessor.kt\ncom/intellij/lang/javascript/refactoring/JSShorthandPropertyRenameProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,175:1\n1#2:176\n*E\n"})
public final class JSShorthandPropertyRenameProcessor
extends JSDefaultRenameProcessor {
    @Override
    public boolean canProcessElement(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return super.canProcessElement(element2) && element2 instanceof JSProperty && ((JSProperty)element2).isShorthanded();
    }

    public void prepareRenaming(@NotNull PsiElement element2, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter(allRenames, (String)"allRenames");
        if (!(element2 instanceof JSProperty) || !((JSProperty)element2).isShorthanded()) {
            return;
        }
        PsiElement psiElement = this.resolveValue((JSProperty)element2);
        if (psiElement == null) {
            return;
        }
        PsiElement value = psiElement;
        PsiElement property = this.resolveReference((JSProperty)element2);
        allRenames.clear();
        allRenames.put(value, newName);
        allRenames.put(property, newName);
    }

    private final PsiElement substitute(PsiElement element2, Editor editor, Pass<? super PsiElement> renameCallback) {
        JSProperty property;
        JSProperty jSProperty = property = element2 instanceof JSProperty ? (JSProperty)element2 : null;
        if (property == null || property.getValue() == null) {
            return element2;
        }
        boolean samePropertyAtCaret = this.isSamePropertyAtCaret(editor, property);
        PsiElement valueResolveResult = this.resolveValue(property);
        if (samePropertyAtCaret && valueResolveResult != null) {
            return this.substituteWithPopup(property, valueResolveResult, renameCallback, editor);
        }
        this.expandInWriteCommandAction(property);
        return (PsiElement)property;
    }

    private final PsiElement substituteWithPopup(JSProperty property, PsiElement valueResolveResult, Pass<? super PsiElement> renameCallback, Editor editor) {
        PsiElement psiElement = this.resolveReference(property);
        String string = JavaScriptBundle.message("javascript.rename.shorthand.target.option.property.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        JSRenameOptionData propertyOption = new JSRenameOptionData(psiElement, string);
        String string2 = StringUtil.capitalize((String)ElementDescriptionUtil.getElementDescription((PsiElement)valueResolveResult, (ElementDescriptionLocation)((ElementDescriptionLocation)UsageViewTypeLocation.INSTANCE)));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"capitalize(...)");
        JSRenameOptionData valueOption = new JSRenameOptionData(valueResolveResult, string2);
        if (propertyOption.getElement() == valueOption.getElement()) {
            return this.processSubstituted(propertyOption.getElement(), editor, (Consumer)renameCallback);
        }
        PsiElement psiElement2 = (PsiElement)property;
        String string3 = JavaScriptBundle.message("javascript.rename.shorthand.target.option.both.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        JSRenameOptionData bothOption = new JSRenameOptionData(psiElement2, string3);
        Object[] objectArray = new JSRenameOptionData[]{valueOption, propertyOption, bothOption};
        List options = CollectionsKt.listOf((Object[])objectArray);
        boolean needForwardExpand = Intrinsics.areEqual((Object)propertyOption.getElement(), (Object)bothOption.getElement());
        if (renameCallback == null || ApplicationManager.getApplication().isUnitTestMode()) {
            JSRenameTarget jSRenameTarget = JSRenameTarget.INSTANCE;
            Editor editor2 = editor;
            Project project = editor2 != null ? editor2.getProject() : null;
            Object[] objectArray2 = new Object[]{valueOption.getTitle()};
            String string4 = JavaScriptBundle.message("javascript.rename.shorthand.target.dialog.title", objectArray2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
            String string5 = string4;
            String string6 = JavaScriptBundle.message("javascript.rename.choose.target.message", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(...)");
            String string7 = string6;
            JSRenameOptionData jSRenameOptionData = jSRenameTarget.showDialog(project, options, string7, string5);
            if (jSRenameOptionData == null) {
                return null;
            }
            JSRenameOptionData chosenOption = jSRenameOptionData;
            if (chosenOption == propertyOption && needForwardExpand) {
                this.expandInWriteCommandAction(property);
            }
            return this.processSubstituted(chosenOption.getElement(), editor, (Consumer)renameCallback);
        }
        if (editor == null) {
            boolean bl = false;
            String string8 = "editor must be provided for inplace rename";
            throw new IllegalStateException(string8.toString());
        }
        JSRenameTarget.INSTANCE.showChooser(editor, options, (Function1<? super JSRenameOptionData, Unit>)((Function1)arg_0 -> JSShorthandPropertyRenameProcessor.substituteWithPopup$lambda$1(propertyOption, needForwardExpand, this, property, editor, renameCallback, arg_0)));
        return null;
    }

    private final boolean isSamePropertyAtCaret(Editor editor, JSProperty property) {
        PsiReference reference = editor != null ? TargetElementUtil.findReference((Editor)editor) : null;
        JSProperty propertyAtCaret = reference != null ? (JSProperty)PsiTreeUtil.getParentOfType((PsiElement)reference.getElement(), JSProperty.class, (boolean)false) : null;
        return propertyAtCaret == property;
    }

    @Override
    @Nullable
    public PsiElement substituteElementToRename(@NotNull PsiElement element2, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return this.substitute(element2, editor, null);
    }

    @Override
    public void substituteElementToRename(@NotNull PsiElement element2, @NotNull Editor editor, @NotNull Pass<? super PsiElement> renameCallback) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter(renameCallback, (String)"renameCallback");
            PsiElement psiElement = this.substitute(element2, editor, renameCallback);
            if (psiElement == null) break block0;
            PsiElement it = psiElement;
            boolean bl = false;
            renameCallback.accept((Object)it);
        }
    }

    private final void expandInWriteCommandAction(JSProperty $this$expandInWriteCommandAction) {
        WriteCommandAction.runWriteCommandAction((Project)$this$expandInWriteCommandAction.getProject(), () -> JSShorthandPropertyRenameProcessor.expandInWriteCommandAction$lambda$3($this$expandInWriteCommandAction));
    }

    private final PsiElement resolveValue(JSProperty $this$resolveValue) {
        JSReferenceExpression referenceExpression;
        JSExpression jSExpression = $this$resolveValue.getValue();
        JSReferenceExpression jSReferenceExpression = referenceExpression = jSExpression instanceof JSReferenceExpression ? (JSReferenceExpression)jSExpression : null;
        return jSReferenceExpression != null ? jSReferenceExpression.resolve() : null;
    }

    private final PsiElement resolveReference(JSProperty $this$resolveReference) {
        PsiElement psiElement = new PsiMultiReference($this$resolveReference.getReferences(), (PsiElement)$this$resolveReference).resolve();
        if (psiElement == null) {
            psiElement = (PsiElement)$this$resolveReference;
        }
        return psiElement;
    }

    private static final Unit substituteWithPopup$lambda$1(JSRenameOptionData $propertyOption, boolean $needForwardExpand, JSShorthandPropertyRenameProcessor this$0, JSProperty $property, Editor $editor, Pass $renameCallback, JSRenameOptionData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it == $propertyOption && $needForwardExpand) {
            this$0.expandInWriteCommandAction($property);
        }
        this$0.processSubstituted(it.getElement(), $editor, (Consumer)$renameCallback);
        return Unit.INSTANCE;
    }

    private static final Boolean expandInWriteCommandAction$lambda$3(JSProperty $this_expandInWriteCommandAction) {
        return $this_expandInWriteCommandAction.expandShorthand();
    }
}

