/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.memberPushDown;

import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.refactoring.memberPushDown.JSPushDownHandler;
import com.intellij.lang.javascript.refactoring.memberPushDown.JSPushDownProcessor;
import com.intellij.lang.javascript.refactoring.ui.JSMemberSelectionPanel;
import com.intellij.lang.javascript.refactoring.ui.JSMemberSelectionTable;
import com.intellij.lang.javascript.refactoring.util.JSMemberInfo;
import com.intellij.lang.javascript.refactoring.util.JSUsedByDependencyMemberInfoModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.classMembers.MemberInfoChangeListener;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.ui.DocCommentPanel;
import com.intellij.refactoring.ui.RefactoringDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Unmodifiable;

public class JSPushDownDialog
extends RefactoringDialog {
    private final JSClass mySourceClass;
    private final Collection<? extends JSClass> myTargetClasses;
    private DocCommentPanel myDocCommentPanel;
    private final @Unmodifiable List<JSMemberInfo> myMemberInfos;

    public JSPushDownDialog(Project project, List<JSMemberInfo> memberInfos, JSClass aSourceClass, Collection<? extends JSClass> targetClasses) {
        super(project, true);
        this.myMemberInfos = JSMemberInfo.sortByOffset(memberInfos);
        this.mySourceClass = aSourceClass;
        this.myTargetClasses = targetClasses;
        this.setTitle(JSPushDownHandler.getRefactoringName());
        this.init();
    }

    public int getDocCommentPolicy() {
        return this.myDocCommentPanel.getPolicy();
    }

    public JSMemberInfo[] getSelectedMemberInfos() {
        return JSMemberInfo.getSelected(this.myMemberInfos, this.mySourceClass, (Condition<? super JSMemberInfo>)Conditions.alwaysTrue());
    }

    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected JComponent createNorthPanel() {
        GridBagConstraints gbConstraints = new GridBagConstraints();
        JPanel panel = new JPanel(new GridBagLayout());
        gbConstraints.insets = new Insets(4, 0, 4, 8);
        gbConstraints.weighty = 1.0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridy = 0;
        gbConstraints.gridwidth = 0;
        gbConstraints.fill = 1;
        gbConstraints.anchor = 17;
        panel.add((Component)new JLabel(RefactoringBundle.message((String)"push.members.from.0.down.label", (Object[])new Object[]{this.mySourceClass.getQualifiedName()})), gbConstraints);
        return panel;
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        JSMemberSelectionPanel memberSelectionPanel = new JSMemberSelectionPanel(RefactoringBundle.message((String)"members.to.be.pushed.down.panel.title"), this.myMemberInfos, RefactoringBundle.message((String)"keep.abstract.column.header")){

            @Override
            protected JSMemberSelectionTable createTable(List<JSMemberInfo> memberInfos, @NlsContexts.ColumnName String abstractColumnHeader) {
                return new JSMemberSelectionTable(memberInfos, null, abstractColumnHeader){

                    @Override
                    protected boolean isAbstractColumnEditable(int rowIndex) {
                        return JSPushDownDialog.this.isAbstractColumnEditable((JSMemberInfo)((Object)this.myMemberInfos.get(rowIndex)));
                    }
                };
            }
        };
        panel.add((Component)memberSelectionPanel, "Center");
        MyMemberInfoModel memberInfoModel = new MyMemberInfoModel();
        memberInfoModel.memberInfoChanged(new MemberInfoChange(this.myMemberInfos));
        memberSelectionPanel.getTable().setMemberInfoModel((MemberInfoModel)memberInfoModel);
        memberSelectionPanel.getTable().addMemberInfoChangeListener((MemberInfoChangeListener)memberInfoModel);
        this.myDocCommentPanel = new DocCommentPanel(JavaScriptBundle.message("javascript.refactoring.asdoc.for.abstracts", new Object[0]));
        panel.add((Component)this.myDocCommentPanel, "East");
        return panel;
    }

    private boolean isAbstractColumnEditable(JSMemberInfo memberInfo) {
        if (!(memberInfo.getMember() instanceof JSFunction)) {
            return false;
        }
        if (!this.mySourceClass.isInterface()) {
            return false;
        }
        if (!memberInfo.isChecked()) {
            return false;
        }
        for (JSClass jSClass : this.myTargetClasses) {
            if (jSClass.isInterface()) continue;
            return true;
        }
        return false;
    }

    protected void doAction() {
        if (!this.isOKActionEnabled()) {
            return;
        }
        this.invokeRefactoring(new JSPushDownProcessor(this.getProject(), this.getSelectedMemberInfos(), this.mySourceClass, this.getDocCommentPolicy()));
    }

    private class MyMemberInfoModel
    extends JSUsedByDependencyMemberInfoModel {
        MyMemberInfoModel() {
            super(JSPushDownDialog.this.mySourceClass);
        }

        public boolean isAbstractEnabled(JSMemberInfo member) {
            if (!JSPushDownDialog.this.mySourceClass.isInterface()) {
                return false;
            }
            for (JSClass jSClass : JSPushDownDialog.this.myTargetClasses) {
                if (!jSClass.isInterface()) continue;
                return false;
            }
            return true;
        }
    }
}

