/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util;

import com.intellij.application.options.CodeStyle;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.codeStyle.CssCodeStyleSettings;
import com.intellij.psi.css.impl.util.CssPsiColorUtil;
import com.intellij.psi.css.index.CssSupportedFileTypesProvider;
import org.jetbrains.annotations.NotNull;

public final class CssColorUtil {
    @NotNull
    public static String formatHexColorAccordingToCodeStyle(@NotNull String colorString, @NotNull PsiElement context) {
        Language language;
        CssSupportedFileTypesProvider provider;
        if (colorString == null) {
            CssColorUtil.$$$reportNull$$$0(0);
        }
        if (context == null) {
            CssColorUtil.$$$reportNull$$$0(1);
        }
        CssSupportedFileTypesProvider cssSupportedFileTypesProvider = provider = (language = CssPsiUtil.getStylesheetLanguage(context)) == null ? null : CssSupportedFileTypesProvider.findProvider(language);
        if (provider == null) {
            String string = colorString;
            if (string == null) {
                CssColorUtil.$$$reportNull$$$0(2);
            }
            return string;
        }
        CssCodeStyleSettings cssCodeStyleSettings = (CssCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)context.getContainingFile(), provider.getCustomCodeStyleSettingsClass());
        String newColorText = colorString;
        if (cssCodeStyleSettings.HEX_COLOR_LONG_FORMAT && colorString.length() == 4) {
            newColorText = CssPsiColorUtil.normalizeHexColor(colorString);
        } else if (cssCodeStyleSettings.HEX_COLOR_SHORT_FORMAT && colorString.length() == 7) {
            newColorText = CssPsiColorUtil.toShortHexColor(colorString);
        }
        if (cssCodeStyleSettings.HEX_COLOR_UPPER_CASE) {
            newColorText = StringUtil.toUpperCase((String)newColorText);
        } else if (cssCodeStyleSettings.HEX_COLOR_LOWER_CASE) {
            newColorText = StringUtil.toLowerCase((String)newColorText);
        }
        String string = newColorText;
        if (string == null) {
            CssColorUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorString";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/util/CssColorUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/util/CssColorUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "formatHexColorAccordingToCodeStyle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "formatHexColorAccordingToCodeStyle";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

