/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util;

import java.util.Arrays;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;

public final class CssLchColorUtils {
    private static final double[] D50 = new double[]{0.9642956764295677, 1.0, 0.8251046025104602};

    public static double[] linSRgb(double @NotNull [] rgb) {
        if (rgb == null) {
            CssLchColorUtils.$$$reportNull$$$0(0);
        }
        return Arrays.stream(rgb).map(value -> {
            double abs = Math.abs(value);
            if (abs < 0.04045) {
                return value / 12.92;
            }
            return Math.signum(value) * Math.pow((abs + 0.055) / 1.055, 2.4);
        }).toArray();
    }

    public static double[] linSRgbToXyz(double @NotNull [] rgb) {
        if (rgb == null) {
            CssLchColorUtils.$$$reportNull$$$0(1);
        }
        double[][] M = new double[][]{{0.4123907992659595, 0.35758433938387796, 0.1804807884018343}, {0.21263900587151036, 0.7151686787677559, 0.07219231536073371}, {0.01933081871559185, 0.11919477979462599, 0.9505321522496606}};
        return Arrays.stream(M).mapToDouble(row -> IntStream.range(0, rgb.length).mapToDouble(i -> row[i] * rgb[i]).sum()).toArray();
    }

    public static double[] xyzToLinSRgb(double @NotNull [] xyz) {
        if (xyz == null) {
            CssLchColorUtils.$$$reportNull$$$0(2);
        }
        double[][] M = new double[][]{{3.2409699419045213, -1.5373831775700935, -0.4986107602930033}, {-0.9692436362808798, 1.8759675015077206, 0.04155505740717561}, {0.05563007969699361, -0.20397695888897657, 1.0569715142428786}};
        return Arrays.stream(M).mapToDouble(row -> IntStream.range(0, xyz.length).mapToDouble(i -> row[i] * xyz[i]).sum()).toArray();
    }

    public static double[] gamSRgb(double @NotNull [] rgb) {
        if (rgb == null) {
            CssLchColorUtils.$$$reportNull$$$0(3);
        }
        return Arrays.stream(rgb).map(value -> {
            double abs = Math.abs(value);
            if (abs > 0.0031308) {
                return Math.signum(value) * (1.055 * Math.pow(abs, 0.4166666666666667) - 0.055);
            }
            return 12.92 * value;
        }).toArray();
    }

    public static double[] d65ToD50(double @NotNull [] xyz) {
        if (xyz == null) {
            CssLchColorUtils.$$$reportNull$$$0(4);
        }
        double[][] M = new double[][]{{1.0479298208405488, 0.022946793341019088, -0.05019222954313557}, {0.029627815688159344, 0.990434484573249, -0.01707382502938514}, {-0.009243058152591178, 0.015055144896577895, 0.7518742899580008}};
        return Arrays.stream(M).mapToDouble(row -> IntStream.range(0, xyz.length).mapToDouble(i -> row[i] * xyz[i]).sum()).toArray();
    }

    public static double[] d50ToD65(double @NotNull [] xyz) {
        if (xyz == null) {
            CssLchColorUtils.$$$reportNull$$$0(5);
        }
        double[][] M = new double[][]{{0.9554734527042182, -0.023098536874261423, 0.0632593086610217}, {-0.028369706963208136, 1.0099954580058226, 0.021041398966943008}, {0.012314001688319899, -0.020507696433477912, 1.3303659366080753}};
        return Arrays.stream(M).mapToDouble(row -> IntStream.range(0, xyz.length).mapToDouble(i -> row[i] * xyz[i]).sum()).toArray();
    }

    public static double[] xyzToLab(double @NotNull [] xyz) {
        if (xyz == null) {
            CssLchColorUtils.$$$reportNull$$$0(6);
        }
        double eps = 0.008856451679035631;
        double kappa = 903.2962962962963;
        double[] xyzScaled = new double[3];
        for (int i = 0; i < 3; ++i) {
            xyzScaled[i] = xyz[i] / D50[i];
        }
        double[] f = Arrays.stream(xyzScaled).map(value -> value > eps ? Math.cbrt(value) : (kappa * value + 16.0) / 116.0).toArray();
        return new double[]{116.0 * f[1] - 16.0, 500.0 * (f[0] - f[1]), 200.0 * (f[1] - f[2])};
    }

    public static double[] labToXyz(double @NotNull [] lab) {
        if (lab == null) {
            CssLchColorUtils.$$$reportNull$$$0(7);
        }
        double eps = 0.008856451679035631;
        double kappa = 903.2962962962963;
        double[] f = new double[3];
        f[1] = (lab[0] + 16.0) / 116.0;
        f[0] = lab[1] / 500.0 + f[1];
        f[2] = f[1] - lab[2] / 200.0;
        double[] xyz = new double[]{Math.pow(f[0], 3.0) > eps ? Math.pow(f[0], 3.0) : (116.0 * f[0] - 16.0) / kappa, lab[0] > kappa * eps ? Math.pow((lab[0] + 16.0) / 116.0, 3.0) : lab[0] / kappa, Math.pow(f[2], 3.0) > eps ? Math.pow(f[2], 3.0) : (116.0 * f[2] - 16.0) / kappa};
        double[] xyzScaled = new double[3];
        for (int i = 0; i < 3; ++i) {
            xyzScaled[i] = xyz[i] * D50[i];
        }
        return xyzScaled;
    }

    public static double[] sRGBtoLCH(double @NotNull [] lab) {
        if (lab == null) {
            CssLchColorUtils.$$$reportNull$$$0(8);
        }
        double hue = Math.atan2(lab[2], lab[1]) * 180.0 / Math.PI;
        return new double[]{lab[0], Math.sqrt(Math.pow(lab[1], 2.0) + Math.pow(lab[2], 2.0)), hue >= 0.0 ? hue : hue + 360.0};
    }

    public static double[] lchToLab(double lightness, double chroma, double hue) {
        return new double[]{lightness, chroma * Math.cos(hue * Math.PI / 180.0), chroma * Math.sin(hue * Math.PI / 180.0)};
    }

    public static double[] xyzToOklab(double @NotNull [] xyz) {
        if (xyz == null) {
            CssLchColorUtils.$$$reportNull$$$0(9);
        }
        double[][] XYZtoLMS = new double[][]{{0.8190224432164319, 0.3619062562801221, -0.12887378261216414}, {0.0329836671980271, 0.9292868468965546, 0.03614466816999844}, {0.048177199566046255, 0.26423952494422764, 0.6335478258136937}};
        double[][] LMStoOKLab = new double[][]{{0.2104542553, 0.793617785, -0.0040720468}, {1.9779984951, -2.428592205, 0.4505937099}, {0.0259040371, 0.7827717662, -0.808675766}};
        double[] LMS = Arrays.stream(XYZtoLMS).mapToDouble(row -> IntStream.range(0, xyz.length).mapToDouble(i -> row[i] * xyz[i]).sum()).toArray();
        return Arrays.stream(LMStoOKLab).mapToDouble(row -> IntStream.range(0, LMS.length).mapToDouble(i -> row[i] * Math.cbrt(LMS[i])).sum()).toArray();
    }

    public static double[] oklabToXyz(double @NotNull [] oklab) {
        if (oklab == null) {
            CssLchColorUtils.$$$reportNull$$$0(10);
        }
        double[][] LMStoXYZ = new double[][]{{1.2268798733741557, -0.5578149965554813, 0.28139105017721583}, {-0.04057576262431372, 1.1122868293970594, -0.07171106666151701}, {-0.07637294974672142, -0.4214933239627914, 1.5869240244272418}};
        double[][] OKLabtoLMS = new double[][]{{0.9999999984505198, 0.39633779217376786, 0.2158037580607588}, {1.0000000088817609, -0.10556134232365635, -0.06385417477170591}, {1.0000000546724108, -0.08948418209496575, -1.2914855378640917}};
        double[] LMSnl = Arrays.stream(OKLabtoLMS).mapToDouble(row -> IntStream.range(0, oklab.length).mapToDouble(i -> row[i] * oklab[i]).sum()).toArray();
        return Arrays.stream(LMStoXYZ).mapToDouble(row -> IntStream.range(0, LMSnl.length).mapToDouble(i -> row[i] * Math.pow(LMSnl[i], 3.0)).sum()).toArray();
    }

    public static double[] oklabToOklch(double @NotNull [] oklab) {
        if (oklab == null) {
            CssLchColorUtils.$$$reportNull$$$0(11);
        }
        double hue = Math.atan2(oklab[2], oklab[1]) * 180.0 / Math.PI;
        return new double[]{oklab[0], Math.sqrt(Math.pow(oklab[1], 2.0) + Math.pow(oklab[2], 2.0)), hue >= 0.0 ? hue : hue + 360.0};
    }

    public static double[] oklchToOklab(double lightness, double chroma, double hue) {
        return new double[]{lightness, chroma * Math.cos(hue * Math.PI / 180.0), chroma * Math.sin(hue * Math.PI / 180.0)};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rgb";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xyz";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lab";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oklab";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/css/impl/util/CssLchColorUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "linSRgb";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "linSRgbToXyz";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "xyzToLinSRgb";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "gamSRgb";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "d65ToD50";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "d50ToD65";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "xyzToLab";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "labToXyz";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "sRGBtoLCH";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "xyzToOklab";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "oklabToXyz";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "oklabToOklch";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

