/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.index;

import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.psi.css.CssFileType;
import com.intellij.psi.css.codeStyle.CssCodeStyleSettings;
import com.intellij.psi.css.impl.util.CssHighlighterLexer;
import com.intellij.psi.css.index.CssSupportedFileTypesProviderEP;
import com.intellij.serviceContainer.BaseKeyedLazyInstance;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class CssSupportedFileTypesProvider {
    public static final ExtensionPointName<CssSupportedFileTypesProviderEP> EP_NAME = ExtensionPointName.create((String)"com.intellij.css.supportedFileTypesProvider");

    public static @Unmodifiable List<CssSupportedFileTypesProvider> getProviders() {
        return ContainerUtil.map((Collection)EP_NAME.getExtensionList(), BaseKeyedLazyInstance::getInstance);
    }

    @NotNull
    public abstract LanguageFileType getSupportedFileType();

    @NotNull
    public abstract Language getLanguage();

    @NotNull
    public abstract Lexer getIndexingLexer();

    @NotNull
    public abstract Class<? extends CssCodeStyleSettings> getCustomCodeStyleSettingsClass();

    @Nullable
    public static CssSupportedFileTypesProvider findProvider(@NotNull Language language) {
        if (language == null) {
            CssSupportedFileTypesProvider.$$$reportNull$$$0(0);
        }
        return (CssSupportedFileTypesProvider)ContainerUtil.find(CssSupportedFileTypesProvider.getProviders(), provider -> provider.getLanguage().equals(language));
    }

    @NotNull
    public static @NotNull FileType @NotNull [] getSupportedFileTypes() {
        FileType[] fileTypeArray = (FileType[])CssSupportedFileTypesProvider.getProviders().stream().map(CssSupportedFileTypesProvider::getSupportedFileType).toArray(FileType[]::new);
        if (fileTypeArray == null) {
            CssSupportedFileTypesProvider.$$$reportNull$$$0(1);
        }
        return fileTypeArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/index/CssSupportedFileTypesProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/index/CssSupportedFileTypesProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFileTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findProvider";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static final class Css
    extends CssSupportedFileTypesProvider {
        @Override
        @NotNull
        public LanguageFileType getSupportedFileType() {
            LanguageFileType languageFileType = CssFileType.INSTANCE;
            if (languageFileType == null) {
                Css.$$$reportNull$$$0(0);
            }
            return languageFileType;
        }

        @Override
        @NotNull
        public Language getLanguage() {
            CSSLanguage cSSLanguage = CSSLanguage.INSTANCE;
            if (cSSLanguage == null) {
                Css.$$$reportNull$$$0(1);
            }
            return cSSLanguage;
        }

        @Override
        @NotNull
        public Lexer getIndexingLexer() {
            return new CssHighlighterLexer();
        }

        @NotNull
        public Class<CssCodeStyleSettings> getCustomCodeStyleSettingsClass() {
            return CssCodeStyleSettings.class;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/psi/css/index/CssSupportedFileTypesProvider$Css";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSupportedFileType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLanguage";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

